/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.validation;

import com.ericsson.cms.epgmgmt.validation.ErrorMessages;
import com.ericsson.cms.epgmgmt.validation.IGenericValidator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;

public class GenericValidator
implements IGenericValidator {
    public static String email_pattern = "^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    public static String IPADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    public static Pattern hostPattern = Pattern.compile("^(([a-zA-Z]|[a-zA-Z][a-zA-Z0-9\\-\\_]*[a-zA-Z0-9])\\.)*([A-Za-z]|[A-Za-z][A-Za-z0-9\\-\\_]*[A-Za-z0-9])$", 2);
    protected EntityManager entityManager;

    protected void validateEmailSyntax(String emailValue, List<String> errorMessages) {
        if (emailValue != null && !emailValue.isEmpty() && emailValue != null && !emailValue.contains("@")) {
            Object[] values = new Object[]{emailValue};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.email.invalid"), values));
        }
    }

    public void validateNumberValue(String numberValue, List<String> errorMessages) {
        if (numberValue != null && !numberValue.isEmpty() && !numberValue.matches("[0-9]+")) {
            Object[] values = new Object[]{numberValue};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.number.invalid"), values));
        }
    }

    public void validateFolderPathSyntax(String path, List<String> errorMessages) {
        Pattern p;
        Matcher m;
        if (path != null && !path.isEmpty() && path.length() >= 1 && !(m = (p = Pattern.compile("[^\\@\\~#*%$#?:]+")).matcher(path)).matches()) {
            Object[] values = new Object[]{path};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.path.invalid"), values));
        }
    }

    private static String getFileOwner(String file) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec("stat -c %U " + file);
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line = reader.readLine();
        process.waitFor();
        return line;
    }

    private static String getFileGroup(String file) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec("stat -c %G " + file);
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line = reader.readLine();
        process.waitFor();
        return line;
    }

    public void validateFolderPathExistsOrCreateable(String path, List<String> errorMessages) {
        if (StringUtils.isEmpty((String)path)) {
            this.addError(new Object[]{path}, errorMessages, "epgmgmt.filename.requiredField");
            return;
        }
        boolean isLinuxOS = !System.getProperty("os.name").toLowerCase().contains("windows");
        File folder = new File(path);
        if (folder.isFile()) {
            this.addError(new Object[]{path}, errorMessages, "epgmgmt.path.existenNonDir");
            return;
        }
        if (folder.exists()) {
            if (isLinuxOS) {
                try {
                    boolean isNobody;
                    boolean bl = isNobody = GenericValidator.getFileOwner(path).equals("nobody") && GenericValidator.getFileGroup(path).equals("nobody");
                    if (!isNobody && !folder.canWrite()) {
                        this.addError(new Object[]{path}, errorMessages, "epgmgmt.path.existentDirNoPermission");
                        return;
                    }
                }
                catch (Exception e) {}
            }
        } else {
            boolean createSuccess = false;
            try {
                createSuccess = folder.mkdirs();
                folder.setWritable(true, false);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!createSuccess) {
                this.addError(new Object[]{path}, errorMessages, "epgmgmt.path.dirNonCreateable");
            }
        }
    }

    private void addError(Object[] tips, List<String> errorMessages, String key) {
        errorMessages.add(MessageFormat.format(ErrorMessages.getString(key), tips));
    }

    public void validateFileCheck(String fileCheck, List<String> errorMessages) {
        try {
            if (fileCheck != null && !fileCheck.isEmpty()) {
                Pattern.compile(fileCheck);
            }
        }
        catch (PatternSyntaxException ex) {
            Object[] values = new Object[]{fileCheck};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.fileCheck.invalid"), values));
        }
    }

    public void validateIPAddress(String ipaddress, List<String> errorMessages) {
        if (ipaddress != null && !ipaddress.isEmpty()) {
            Pattern pattern = Pattern.compile(IPADDRESS_PATTERN);
            Matcher matchIP = pattern.matcher(ipaddress);
            Matcher matchHost = hostPattern.matcher(ipaddress);
            if (!matchIP.matches() && !matchHost.matches()) {
                Object[] values = new Object[]{ipaddress};
                errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.ipaddress.invalid"), values));
            }
        }
    }

    public void validateIntegerValue(String integerValue, List<String> errorMessages) {
        Pattern p;
        Matcher m;
        if (integerValue != null && !integerValue.isEmpty() && !(m = (p = Pattern.compile("\\d+")).matcher(integerValue)).matches()) {
            Object[] values = new Object[]{integerValue};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.integer.invalid"), values));
        }
    }

    public void validateProvidernameRequiredField(String stringValue, List<String> errorMessages) {
        if (stringValue == null || stringValue.isEmpty()) {
            Object[] values = new Object[]{stringValue};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.publishername.requiredField"), values));
        }
    }

    public void validateFrequencynameRequiredField(Long longValue, List<String> errorMessages) {
        if (longValue == null || longValue <= 0L) {
            Object[] values = new Object[]{longValue};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.frequencyname.requiredField"), values));
        }
    }

    public void validateRetrievaltypeRequiredField(String stringValue, List<String> errorMessages) {
        if (stringValue == null || stringValue.isEmpty()) {
            Object[] values = new Object[]{stringValue};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.retrievaltype.requiredField"), values));
        }
    }

    public void validateFoldernameRequiredField(String stringValue, List<String> errorMessages) {
        if (stringValue == null || stringValue.isEmpty()) {
            Object[] values = new Object[]{stringValue};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.foldername.requiredField"), values));
        }
    }

    public void validateEpgformatRequiredField(String stringValue, List<String> errorMessages) {
        if (stringValue == null || stringValue.isEmpty()) {
            Object[] values = new Object[]{stringValue};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.epgformat.requiredField"), values));
        }
    }

    public void validateFilenameRequiredField(String stringValue, List<String> errorMessages) {
        if (stringValue == null || stringValue.isEmpty()) {
            Object[] values = new Object[]{stringValue};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.filename.requiredField"), values));
        }
    }

    public void validateFolderWhiteSpace(String stringValue, List<String> errorMessages) {
        if (stringValue != null && !stringValue.isEmpty() && StringUtils.isWhitespace((String)stringValue)) {
            Object[] values = new Object[]{stringValue};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.epgformat.whitespacenameFolder"), values));
        }
    }

    public void validateFileWhiteSpace(String stringValue, List<String> errorMessages) {
        if (stringValue != null && !stringValue.isEmpty() && StringUtils.isWhitespace((String)stringValue)) {
            Object[] values = new Object[]{stringValue};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.epgformat.whitespacenameFile"), values));
        }
    }

    public void validateFileCheckWhiteSpace(String stringValue, List<String> errorMessages) {
        if (stringValue != null && !stringValue.isEmpty() && StringUtils.isWhitespace((String)stringValue)) {
            Object[] values = new Object[]{stringValue};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.epgformat.whitespacenameDoneFile"), values));
        }
    }

    public boolean validateDuplicateEndPointByFolderFileName(String folderName, String fileName, String serverIp, long port, long endpointTypeId, long endpointSeqId) throws Exception {
        boolean isDuplicate = false;
        try {
            Query query = this.entityManager.createNamedQuery("Endpoint.byDuplicateFileFolderName");
            query.setParameter("ID", (Object)endpointTypeId);
            query.setParameter("FOLDER", (Object)folderName);
            query.setParameter("FILE_NAME", (Object)fileName);
            query.setParameter("PORT", (Object)port);
            query.setParameter("SERVER_IP", (Object)serverIp);
            query.setParameter("ID_ENDPOINT", (Object)endpointSeqId);
            Object returnValue = query.getSingleResult();
            if (returnValue != null && (Integer)returnValue == 1) {
                isDuplicate = true;
            }
            return isDuplicate;
        }
        catch (NoResultException nrEx) {
            return isDuplicate;
        }
        catch (Exception ex) {
            throw ex;
        }
    }
}

