/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.validation;

import com.ericsson.cms.epgmgmt.entity.EndpointDetails;
import com.ericsson.cms.epgmgmt.entity.Provider;
import com.ericsson.cms.epgmgmt.entity.enumeration.EndpointSchemeEnum;
import com.ericsson.cms.epgmgmt.service.EpgmgmtException;
import com.ericsson.cms.epgmgmt.validation.ErrorMessages;
import com.ericsson.cms.epgmgmt.validation.GenericValidator;
import com.ericsson.cms.epgmgmt.validation.IProviderValidator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;

public class ProviderValidator
extends GenericValidator
implements IProviderValidator {
    private static int default_frequency = 60;

    public ProviderValidator(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void validateProvider(Provider provider, EndpointDetails ed, boolean isUpdate) throws EpgmgmtException {
        ArrayList<String> errorMessages = new ArrayList<String>();
        super.validateProvidernameRequiredField(provider.getName(), errorMessages);
        super.validateEpgformatRequiredField(String.valueOf(provider.getEpgFormat().getId()), errorMessages);
        super.validateRetrievaltypeRequiredField(String.valueOf(provider.getRetrievalDetails().getId()), errorMessages);
        super.validateFoldernameRequiredField(provider.getRetrievalDetails().getFolder(), errorMessages);
        super.validateFilenameRequiredField(provider.getRetrievalDetails().getFileName(), errorMessages);
        super.validateEmailSyntax(provider.getEmail(), errorMessages);
        super.validateIPAddress(provider.getRetrievalDetails().getServerIp(), errorMessages);
        super.validateFolderPathSyntax(provider.getRetrievalDetails().getFolder(), errorMessages);
        if (ed.getName() == EndpointSchemeEnum.file) {
            super.validateFolderPathExistsOrCreateable(provider.getRetrievalDetails().getFolder(), errorMessages);
        }
        super.validateIntegerValue(Long.toString(provider.getRetrievalDetails().getPort()), errorMessages);
        super.validateNumberValue(Long.toString(provider.getFrequency()), errorMessages);
        this.validateFrequency(provider.getFrequency(), errorMessages);
        this.validateDuplicateFolderFileName(provider, provider.getName(), provider.getRetrievalDetails().getFolder(), provider.getRetrievalDetails().getFileName(), provider.getRetrievalDetails().getServerIp(), provider.getRetrievalDetails().getPort(), ed.getId(), errorMessages, isUpdate);
        if (!errorMessages.isEmpty()) {
            throw new EpgmgmtException(errorMessages);
        }
    }

    public void validateFrequency(long frequency, List<String> errorMessages) throws EpgmgmtException {
        if (frequency < (long)default_frequency) {
            Object[] values = new Object[]{frequency};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.frequency.default"), values));
        }
    }

    public void validateDuplicateFolderFileName(Provider provider, String providerName, String folderName, String fileName, String serverIp, long port, long endpointTypeId, List<String> errorMessages, boolean isUpdate) throws EpgmgmtException {
        boolean isDuplicate = false;
        long endpointSeqID = 0L;
        try {
            if (isUpdate) {
                endpointSeqID = provider.getRetrievalDetails().getId();
            }
            if (isDuplicate = super.validateDuplicateEndPointByFolderFileName(folderName, fileName, serverIp, port, endpointTypeId, endpointSeqID)) {
                Object[] values = new Object[]{providerName};
                errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.providerduplicateFileFolder.invalid"), values));
            }
        }
        catch (EpgmgmtException ex) {
            throw ex;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

