/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.validation;

import com.ericsson.cms.epgmgmt.entity.EndpointDetails;
import com.ericsson.cms.epgmgmt.entity.Publisher;
import com.ericsson.cms.epgmgmt.entity.enumeration.EndpointSchemeEnum;
import com.ericsson.cms.epgmgmt.service.EpgmgmtException;
import com.ericsson.cms.epgmgmt.validation.ErrorMessages;
import com.ericsson.cms.epgmgmt.validation.GenericValidator;
import com.ericsson.cms.epgmgmt.validation.IPublisherValidator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;

public class PublisherValidator
extends GenericValidator
implements IPublisherValidator {
    private static int default_frequency = 60;

    public PublisherValidator(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void validatePublisher(Publisher publisher, EndpointDetails ed, boolean isUpdate) throws EpgmgmtException {
        ArrayList<String> errorMessages = new ArrayList<String>();
        super.validateProvidernameRequiredField(publisher.getName(), errorMessages);
        super.validateEpgformatRequiredField(String.valueOf(publisher.getEpgFormat().getId()), errorMessages);
        super.validateRetrievaltypeRequiredField(String.valueOf(publisher.getPublishDetails().getId()), errorMessages);
        super.validateFrequencynameRequiredField(publisher.getFrequency(), errorMessages);
        super.validateFoldernameRequiredField(publisher.getPublishDetails().getFolder(), errorMessages);
        super.validateFilenameRequiredField(publisher.getPublishDetails().getFileName(), errorMessages);
        super.validateEmailSyntax(publisher.getEmail(), errorMessages);
        super.validateIPAddress(publisher.getPublishDetails().getServerIp(), errorMessages);
        super.validateFolderPathSyntax(publisher.getPublishDetails().getFolder(), errorMessages);
        if (ed.getName() == EndpointSchemeEnum.file) {
            super.validateFolderPathExistsOrCreateable(publisher.getPublishDetails().getFolder(), errorMessages);
        }
        super.validateIntegerValue(Long.toString(publisher.getPublishDetails().getPort()), errorMessages);
        super.validateNumberValue(Long.toString(publisher.getFrequency()), errorMessages);
        this.validateFrequency(publisher.getFrequency(), errorMessages);
        this.validateDuplicateFolderFileName(publisher, publisher.getName(), publisher.getPublishDetails().getFolder(), publisher.getPublishDetails().getFileName(), publisher.getPublishDetails().getServerIp(), publisher.getPublishDetails().getPort(), ed.getId(), errorMessages, isUpdate);
        if (!errorMessages.isEmpty()) {
            throw new EpgmgmtException(errorMessages);
        }
    }

    public void validateFrequency(long frequency, List<String> errorMessages) throws EpgmgmtException {
        if (frequency < (long)default_frequency) {
            Object[] values = new Object[]{frequency};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.frequency.default"), values));
        }
    }

    public void validateDuplicateFolderFileName(Publisher publisher, String publisherName, String folderName, String fileName, String serverIp, long port, long endpointTypeId, List<String> errorMessages, boolean isUpdate) throws EpgmgmtException {
        boolean isDuplicate = false;
        long endpointSeqID = 0L;
        try {
            if (isUpdate) {
                endpointSeqID = publisher.getPublishDetails().getId();
            }
            if (isDuplicate = super.validateDuplicateEndPointByFolderFileName(folderName, fileName, serverIp, port, endpointTypeId, endpointSeqID)) {
                Object[] values = new Object[]{publisherName};
                errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.publisherduplicateFileFolder.invalid"), values));
            }
        }
        catch (EpgmgmtException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new EpgmgmtException("Validation failed");
        }
    }
}

