/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.validationrules;

import com.ericsson.cms.epgmgmt.entity.Provider;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogSeverity;
import com.ericsson.cms.epgmgmt.entity.rule.ValidationGroup;
import com.ericsson.cms.epgmgmt.entity.rule.ValidationGroupComparator;
import com.ericsson.cms.epgmgmt.entity.rule.ValidationRule;
import com.ericsson.cms.epgmgmt.entity.rule.predicate.LogPredicate;
import com.ericsson.cms.epgmgmt.exception.ValidationRuleException;
import com.ericsson.cms.epgmgmt.service.IAlarmActivityLogManager;
import com.ericsson.cms.epgmgmt.service.IProviderManager;
import com.ericsson.cms.epgmgmt.service.IValidationGroupManager;
import com.ericsson.cms.epgmgmt.validationrules.IEPGRulesValidator;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@Local(value={IEPGRulesValidator.class})
@Stateless
public class EPGRulesValidator
implements IEPGRulesValidator {
    private static final Logger logger = Logger.getLogger(EPGRulesValidator.class);
    private static final Logger snmpLogger = Logger.getLogger((String)"com.ericsson.cms.epgmgmt.AlertLogger");
    @PersistenceContext(unitName="epgmanagerjpaunit")
    private EntityManager entityManager;
    @EJB
    private IAlarmActivityLogManager applicationLogger;
    @EJB
    private IProviderManager providerManager;
    @EJB
    private IValidationGroupManager validationGroupManager;

    private boolean needToPerform(ValidationRule vRule, long providerId) {
        Query query;
        boolean flagAction = false;
        String validationQuery = vRule.getRuleAsSqlString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("applyValidationRules(long) - Applying validation rules on provider %d - validation rule %s, query generate - %s.", providerId, vRule.getName(), validationQuery));
        }
        flagAction = StringUtils.isEmpty((String)validationQuery) ? true : ((BigDecimal)(query = this.entityManager.createNativeQuery(validationQuery)).getSingleResult()).longValue() > 0L;
        return flagAction;
    }

    @Override
    public boolean applyValidationRules(long providerId) throws ValidationRuleException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"applyValidationRules(long) - start");
        }
        boolean result = true;
        Provider provider = null;
        try {
            provider = this.providerManager.getProvider(providerId);
            if (provider == null) {
                this.applicationLogger.log(PluginLogSeverity.WARNING, PluginLogComponent.VALIDATION_RULES, String.format("Applying validation rules on provider %d - no provider found in database.", providerId));
                logger.warn((Object)String.format("applyValidationRules(long) - no provider found for given provider %d", providerId));
                return result;
            }
            ArrayList validationGrps = new ArrayList();
            validationGrps.addAll(provider.getValidationGroups());
            validationGrps.addAll(this.validationGroupManager.getAllGlobalGroups());
            if (validationGrps == null || validationGrps.size() == 0) {
                this.applicationLogger.log(PluginLogSeverity.WARNING, PluginLogComponent.VALIDATION_RULES, String.format("Applying validation rules on provider %s - no validation rule groups either configured or enabled.", provider.toString()));
                logger.warn((Object)String.format("applyValidationRules(long) - no validation rule groups found for given provider %d", providerId));
                return result;
            }
            Collections.sort(validationGrps, new ValidationGroupComparator());
            for (ValidationGroup vGrp : validationGrps) {
                if (vGrp.getEnabled().booleanValue()) {
                    List validationRules = vGrp.getRules();
                    if (validationRules == null || validationRules.size() == 0) {
                        this.applicationLogger.log(PluginLogSeverity.WARNING, PluginLogComponent.VALIDATION_RULES, String.format("Applying validation rules on provider %s - no rules configured for validation rule group %s.", provider.toString(), vGrp.getName()));
                        continue;
                    }
                    this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.VALIDATION_RULES, String.format("Applying validation rules on provider %s - started applying validation rules from group %s.", provider.toString(), vGrp.getName()));
                    logger.info((Object)String.format("Applying validation rules on provider %s - started applying validation rules from group %s.", provider.toString(), vGrp.getName()));
                    for (ValidationRule vRule : validationRules) {
                        if (!this.needToPerform(vRule, providerId)) continue;
                        switch (((LogPredicate)vRule.getPredicate()).getErrorLevel()) {
                            case INFO: {
                                this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.VALIDATION_RULES, String.format("Applying validation rules on provider %s - %s.", provider.toString(), ((LogPredicate)vRule.getPredicate()).getLogMessage()));
                                snmpLogger.info((Object)String.format("Validation rule failed for %s", provider.toString()));
                                break;
                            }
                            case WARNING: {
                                this.applicationLogger.log(PluginLogSeverity.WARNING, PluginLogComponent.VALIDATION_RULES, String.format("Applying validation rules on provider %s - %s.", provider.toString(), ((LogPredicate)vRule.getPredicate()).getLogMessage()));
                                snmpLogger.info((Object)String.format("Validation rule failed for %s", provider.toString()));
                                break;
                            }
                            case ABORT: {
                                this.applicationLogger.log(PluginLogSeverity.ERROR, PluginLogComponent.VALIDATION_RULES, String.format("Applying validation rules on provider %s - %s.", provider.toString(), ((LogPredicate)vRule.getPredicate()).getLogMessage()));
                                String errorMsg = String.format("Applying validation rules on provider %s - validation rule %s failed.", provider.toString(), vRule.getName());
                                logger.error((Object)("applyValidationRules(long) - " + errorMsg));
                                this.entityManager.flush();
                                throw new ValidationRuleException(errorMsg);
                            }
                        }
                    }
                    this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.VALIDATION_RULES, String.format("Applying validation rules on provider %s - completed applying validation rules from group %s.", provider.toString(), vGrp.getName()));
                    logger.info((Object)String.format("Applying validation rules on provider %s - completed applying validation rules from group %s.", provider.toString(), vGrp.getName()));
                    continue;
                }
                this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.VALIDATION_RULES, String.format("Applying validation rules on provider %s - validation rule group, %s,  is not enabled.", provider.toString(), vGrp.getName()));
                logger.info((Object)String.format("EPG Manager:Applying validation rules on provider %s - validation rule group, %s,  is not enabled.", provider.toString(), vGrp.getName()));
            }
        }
        catch (ValidationRuleException vEx) {
            logger.error((Object)String.format("applyValidationRules(long) - exception found while applying validation rules for given provider %d ", providerId), (Throwable)vEx);
            throw vEx;
        }
        catch (Exception ex) {
            String pDetails = provider == null ? Long.toString(providerId) : provider.toString();
            this.applicationLogger.log(PluginLogSeverity.ERROR, PluginLogComponent.VALIDATION_RULES, String.format("Applying validation rules on provider %s - error found while applying validation rules. error message - %s.", pDetails, ex.getMessage()));
            logger.error((Object)String.format("applyValidationRules(long) - exception found while applying validation rules for given provider %d ", providerId), (Throwable)ex);
            throw new ValidationRuleException(ex.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"applyValidationRules(long) - end");
        }
        return result;
    }
}

