/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.authorization;

import com.ericsson.cms.me.authorization.MELicenseProvider;
import com.ericsson.cms.me.authorization.Messages;
import com.tandbergtv.neptune.authorization.entity.BasicModule;
import com.tandbergtv.neptune.authorization.entity.BasicPermission;
import com.tandbergtv.neptune.authorization.entity.IModule;
import com.tandbergtv.neptune.authorization.service.IModuleProvider;
import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class MEModuleProvider
implements IModuleProvider {
    private static final Logger logger = Logger.getLogger(MEModuleProvider.class);
    private MELicenseProvider enhancementModule = new MELicenseProvider();

    public Collection<IModule> getModules() {
        ArrayList<IModule> modules = new ArrayList<IModule>();
        try {
            if (!this.enhancementModule.isRCSOnlyDeployment() && this.enhancementModule.isLicensed()) {
                modules.add(this.buildMetadataEnhancementModule());
            }
        }
        catch (InvalidLicenseException e) {
            logger.error((Object)("Error in obtaining the license for Metadata Enhancement " + e.getLocalizedMessage()));
        }
        return modules;
    }

    private IModule buildMetadataEnhancementModule() {
        String moduleName = "MetadataEnhancement";
        String displayName = Messages.getString("MEModule.DisplayName");
        BasicModule module = new BasicModule(moduleName, displayName);
        List permissions = module.getPermissions();
        displayName = Messages.getString("MEModule.Permissions.View");
        permissions.add(new BasicPermission("View", displayName, moduleName));
        displayName = Messages.getString("MEModule.Permissions.Create");
        permissions.add(new BasicPermission("Create", displayName, moduleName));
        displayName = Messages.getString("MEModule.Permissions.Modify");
        permissions.add(new BasicPermission("Modify", displayName, moduleName));
        displayName = Messages.getString("MEModule.Permissions.Delete");
        permissions.add(new BasicPermission("Delete", displayName, moduleName));
        displayName = Messages.getString("MEModule.Permissions.Enhance");
        permissions.add(new BasicPermission("Enhance", displayName, moduleName));
        displayName = Messages.getString("MEModule.Permissions.View_Profile_Parameter");
        permissions.add(new BasicPermission("ViewProfileParameter", displayName, moduleName));
        return module;
    }
}

