/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.actions;

import com.tandbergtv.metadatamanager.model.Field;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.log4j.Logger;

public class TimeHelper {
    private static final Logger logger = Logger.getLogger(TimeHelper.class);

    public static void addTime(String time, boolean subtract, List<Field> timeFields) {
        int totalSecondsToAdd = 0;
        int multiplier = subtract ? -1 : 1;
        try {
            totalSecondsToAdd = TimeHelper.getTimeSeconds(time) * multiplier;
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e);
            return;
        }
        for (Field field : timeFields) {
            if (field.getDataType().equals("date")) {
                if (!field.getParsable().booleanValue()) continue;
                GregorianCalendar fieldValue = new GregorianCalendar();
                fieldValue.setTime((Date)field.getTypedValue());
                fieldValue.add(13, totalSecondsToAdd);
                field.setTypedValue((Object)fieldValue.getTime());
                continue;
            }
            if (!field.getDataType().equals("time")) continue;
            try {
                try {
                    int totalSeconds = TimeHelper.getTimeSeconds(field.getValue());
                    if ((totalSeconds += totalSecondsToAdd) < 0) {
                        totalSeconds = 0;
                    }
                    int fieldHours = totalSeconds / 3600;
                    int fieldMins = totalSeconds % 3600 / 60;
                    int fieldSecs = totalSeconds % 3600 % 60;
                    field.setValue(TimeHelper.enocdeTimeDigit(fieldHours) + ":" + TimeHelper.enocdeTimeDigit(fieldMins) + ":" + TimeHelper.enocdeTimeDigit(fieldSecs));
                }
                catch (IllegalArgumentException e) {
                }
            }
            catch (NumberFormatException e) {}
        }
    }

    private static String enocdeTimeDigit(int digit) {
        if (digit < 10) {
            return "0" + digit;
        }
        return String.valueOf(digit);
    }

    public static void setTime(String time, List<Field> timeFields) {
        String[] values = time.split(":");
        if (values.length != 3) {
            logger.error((Object)("Invalid time parameter for add time: " + time));
            return;
        }
        try {
            int hours = Integer.parseInt(values[0]);
            int mins = Integer.parseInt(values[1]);
            int secs = Integer.parseInt(values[2]);
            for (Field field : timeFields) {
                if (!field.getParsable().booleanValue()) continue;
                GregorianCalendar fieldValue = new GregorianCalendar();
                fieldValue.setTime((Date)field.getTypedValue());
                fieldValue.set(11, hours);
                fieldValue.set(12, mins);
                fieldValue.set(13, secs);
                field.setTypedValue((Object)fieldValue.getTime());
            }
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Invalid time parameter for add time: " + time));
            return;
        }
    }

    public static int getTimeSeconds(String time) throws IllegalArgumentException {
        String[] values = time.split(":");
        if (values.length != 3) {
            throw new IllegalArgumentException("Invalid time parameter for add time: " + time);
        }
        try {
            int hours = Integer.parseInt(values[0]);
            int mins = Integer.parseInt(values[1]);
            int secs = Integer.parseInt(values[2]);
            return hours * 3600 + mins * 60 + secs;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid time parameter for add time: " + time);
        }
    }

    public static int getTimeFromDate(Date date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        int hours = gc.get(11);
        int mins = gc.get(12);
        int secs = gc.get(13);
        return hours * 3600 + mins * 60 + secs;
    }
}

