/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightField;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.marvin.engine.BooleanDeterminating;
import com.tandbergtv.marvin.engine.ComplexDeterminating;
import com.tandbergtv.marvin.engine.DateDeterminating;
import com.tandbergtv.marvin.engine.EvaluatorException;
import com.tandbergtv.marvin.engine.FloatDeterminating;
import com.tandbergtv.marvin.engine.IDeterminating;
import com.tandbergtv.marvin.engine.LongDeterminating;
import com.tandbergtv.marvin.engine.StringDeterminating;
import com.tandbergtv.marvin.engine.TimeDeterminating;
import com.tandbergtv.marvin.engine.TitleExt;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.IField;

public class DeterminatingFactory {
    public static IDeterminating getDeterminating(Predicate predicate, IField fieldLhs, IField fieldRhs) throws EvaluatorException {
        return DeterminatingFactory.getDeterminatingHelper(predicate, fieldLhs, fieldRhs);
    }

    public static IDeterminating getDeterminating(Predicate predicate, IField fieldLhs) throws EvaluatorException {
        return DeterminatingFactory.getDeterminatingHelper(predicate, fieldLhs, null);
    }

    public static IDeterminating getDeterminating(Predicate predicate, Asset asset) throws EvaluatorException {
        return new ComplexDeterminating(predicate, asset);
    }

    public static IDeterminating getDeterminating(Predicate predicate) throws EvaluatorException {
        return DeterminatingFactory.getDeterminatingHelper(predicate, null, null);
    }

    private static IDeterminating getDeterminatingHelper(Predicate predicate, IField fieldLhs, IField fieldRhs) throws EvaluatorException {
        if (predicate.getFieldLeft() == null || predicate.getFieldLeft().isEmpty()) {
            return new ComplexDeterminating(predicate, fieldLhs);
        }
        String xpath = predicate.getFieldLeft();
        String assetPath = predicate.getFieldLeftSectionType();
        String dataType = TitleExt.dataTypeLookup(predicate.getFieldTypeLhs(), assetPath, xpath);
        if (dataType == null && !predicate.getOperator().isMultiField() && (predicate instanceof PredicateRightValue || predicate instanceof PredicateRightField)) {
            throw new EvaluatorException("Could not get correct data type for: " + assetPath + "/" + xpath);
        }
        if (dataType == null) {
            return new ComplexDeterminating(predicate, fieldLhs);
        }
        if (dataType.equals("boolean")) {
            return new BooleanDeterminating(predicate, fieldLhs, fieldRhs);
        }
        if (dataType.equals("string")) {
            return new StringDeterminating(predicate, fieldLhs, fieldRhs);
        }
        if (dataType.equals("date")) {
            return new DateDeterminating(predicate, fieldLhs, fieldRhs);
        }
        if (dataType.equals("float")) {
            return new FloatDeterminating(predicate, fieldLhs, fieldRhs);
        }
        if (dataType.equals("integer")) {
            return new LongDeterminating(predicate, fieldLhs, fieldRhs);
        }
        if (dataType.equals("time")) {
            return new TimeDeterminating(predicate, fieldLhs, fieldRhs);
        }
        throw new EvaluatorException("unknown operator: " + dataType + " for xpath: " + xpath);
    }
}

