/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightField;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.marvin.engine.EvaluatorException;
import com.tandbergtv.marvin.engine.IDeterminating;
import com.tandbergtv.marvin.engine.IllegalOperationException;
import com.tandbergtv.metadatamanager.model.IField;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class LongDeterminating
implements IDeterminating {
    private static final Logger logger = Logger.getLogger(LongDeterminating.class);
    private Long lhs;
    private boolean parsable;
    private String unparsableLhs;
    private Predicate predicate;
    private IField fieldRhs;

    public LongDeterminating(Predicate predicate, IField fieldLhs, IField fieldRhs) {
        this.predicate = predicate;
        if (fieldLhs != null) {
            this.parsable = fieldLhs.getParsable();
            if (this.parsable) {
                this.lhs = (Long)fieldLhs.getTypedValue();
            } else {
                this.unparsableLhs = fieldLhs.getValue();
            }
        } else {
            this.parsable = true;
        }
        this.fieldRhs = fieldRhs;
    }

    public LongDeterminating(Predicate predicate, Long lhs) {
        this.predicate = predicate;
        this.lhs = lhs;
        this.parsable = true;
    }

    private Long getLongLhs() throws EvaluatorException {
        return this.lhs;
    }

    private boolean rhsContainsUnParasable() {
        return this.fieldRhs != null && this.fieldRhs.getParsable() == false;
    }

    private Long getRhsAsLong() throws EvaluatorException {
        if (this.predicate instanceof PredicateRightField && this.fieldRhs != null && this.fieldRhs.getParsable().booleanValue()) {
            return (Long)this.fieldRhs.getTypedValue();
        }
        if (this.predicate instanceof PredicateRightField) {
            return null;
        }
        List<Long> list = this.getRhsAsLongList();
        if (list.size() == 1) {
            return list.get(0);
        }
        throw new EvaluatorException("Predicate with ID and operator " + this.predicate.getOperator().name() + " has a list as a RHS.");
    }

    private String getRhsAsString() throws EvaluatorException {
        PredicateRightValue rightPredicate = (PredicateRightValue)this.predicate;
        if (rightPredicate.getValue().size() == 1) {
            return (String)rightPredicate.getValue().get(0);
        }
        throw new EvaluatorException("Predicate with ID and operator " + this.predicate.getOperator().name() + " has a list as a RHS.");
    }

    private List<Long> getRhsAsLongList() throws EvaluatorException {
        PredicateRightValue rightPredicate = (PredicateRightValue)this.predicate;
        if (rightPredicate.getValue().size() == 0) {
            throw new EvaluatorException("Predicate with ID and operator " + this.predicate.getOperator().name() + " is missing a RHS.");
        }
        try {
            ArrayList<Long> values = new ArrayList<Long>();
            for (String predVal : rightPredicate.getValue()) {
                values.add(Long.parseLong(predVal));
            }
            return values;
        }
        catch (NumberFormatException e) {
            throw new EvaluatorException("value must be a long number", e);
        }
    }

    @Override
    public boolean equal() throws EvaluatorException {
        Long lhs = this.getLongLhs();
        Long rhs = this.getRhsAsLong();
        if (this.containsUnparsable() || this.rhsContainsUnParasable()) {
            return false;
        }
        if (lhs == null && rhs == null) {
            return true;
        }
        return lhs != null && rhs != null && lhs.equals(rhs);
    }

    @Override
    public boolean greaterThan() throws EvaluatorException {
        Long lhs = this.getLongLhs();
        Long rhs = this.getRhsAsLong();
        if (this.containsUnparsable() || this.rhsContainsUnParasable()) {
            return false;
        }
        return lhs != null && rhs != null && lhs.compareTo(rhs) > 0;
    }

    @Override
    public boolean greaterThanEqual() throws EvaluatorException {
        Long lhs = this.getLongLhs();
        Long rhs = this.getRhsAsLong();
        if (this.containsUnparsable() || this.rhsContainsUnParasable()) {
            return false;
        }
        return lhs != null && rhs != null && lhs.compareTo(rhs) >= 0;
    }

    @Override
    public boolean in() throws EvaluatorException {
        Long value = this.getLongLhs();
        if (value == null) {
            return false;
        }
        for (Long compVal : this.getRhsAsLongList()) {
            if (!value.equals(compVal)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() throws IllegalOperationException {
        return this.lhs == null && this.parsable;
    }

    @Override
    public boolean isNotEmpty() throws IllegalOperationException {
        return !this.isEmpty();
    }

    @Override
    public boolean lessThan() throws EvaluatorException {
        Long lhs = this.getLongLhs();
        Long rhs = this.getRhsAsLong();
        if (this.containsUnparsable() || this.rhsContainsUnParasable()) {
            return false;
        }
        return lhs != null && rhs != null && lhs.compareTo(rhs) < 0;
    }

    @Override
    public boolean lessThanEqual() throws EvaluatorException {
        Long lhs = this.getLongLhs();
        Long rhs = this.getRhsAsLong();
        if (this.containsUnparsable() || this.rhsContainsUnParasable()) {
            return false;
        }
        return lhs != null && rhs != null && lhs.compareTo(rhs) <= 0;
    }

    @Override
    public boolean contains() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean doesNotContain() throws IllegalOperationException {
        return !this.contains();
    }

    @Override
    public boolean notEqual() throws EvaluatorException {
        return !this.equal();
    }

    @Override
    public boolean notIn() throws IllegalOperationException, EvaluatorException {
        return !this.in();
    }

    @Override
    public boolean lengthEquals() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lengthGreaterThan() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lengthLessThan() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean regex() throws EvaluatorException {
        String value = this.unparsableLhs;
        String regexStr = this.getRhsAsString();
        if (this.parsable) {
            value = this.lhs == null ? null : this.lhs.toString();
        }
        try {
            return value != null && value.matches(regexStr);
        }
        catch (Exception e) {
            logger.error((Object)("Error while checking regular expression: " + regexStr + "for value: " + value));
            return false;
        }
    }

    @Override
    public boolean startsWith() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean endsWith() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean greaterThanToday() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lessThanToday() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean containsUnparsable() {
        return !this.parsable;
    }

    @Override
    public boolean tierEquals(int tier) throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean timeEquals() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean timeGreaterThan() throws IllegalOperationException, EvaluatorException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean timeLessThan() throws IllegalOperationException, EvaluatorException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean equalToToday() throws IllegalOperationException, EvaluatorException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean validateCategory() throws IllegalOperationException {
        throw new IllegalOperationException();
    }
}

