/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.tandbergtv.cms.rules.service.RuleDeleteException;
import com.tandbergtv.cms.rules.service.category.IPackageManager;
import com.tandbergtv.cms.rules.service.category.RuleSetsAssocWJobExpception;
import com.tandbergtv.cms.rules.service.category.RuleSetsNotAssocWSiteExpception;
import com.tandbergtv.cms.rules.service.category.TreRuleSetCachable;
import com.tandbergtv.marvin.engine.IRuleManagerCache;
import com.tandbergtv.marvin.udt.TrePackage;
import com.tandbergtv.marvin.udt.TreRuleSet;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.jboss.ejb3.annotation.Depends;
import org.jboss.ejb3.annotation.Service;

@Service
@Depends(value={"jboss.j2ee:ear=cms.ear,jar=cms_rules.jar,name=PackageManagerImpl,service=EJB3"})
public class RuleManagerCache
implements IRuleManagerCache {
    private Map<String, List<TreRuleSetCachable>> rulesByPackage = new HashMap<String, List<TreRuleSetCachable>>();
    private Map<Integer, TreRuleSetCachable> rulesById = new HashMap<Integer, TreRuleSetCachable>();
    private IPackageManager packageManager = (IPackageManager)InjectionUtil.injectInstance((String)"cms/PackageManagerImpl/local", IPackageManager.class);

    public RuleManagerCache() throws Exception {
        boolean isTransactionOwner;
        TransactionManager transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
        boolean bl = isTransactionOwner = transactionManager.getTransaction() == null;
        if (!isTransactionOwner) {
            this.load();
        } else {
            transactionManager.begin();
            this.load();
            transactionManager.commit();
        }
    }

    private void load() {
        List packs = this.packageManager.getPackages();
        for (TrePackage p : packs) {
            this.loadCache(p);
        }
    }

    @Override
    public synchronized void loadCache(TrePackage pack) {
        if (this.rulesByPackage.containsKey(pack.getName())) {
            this.rulesByPackage.remove(pack.getName());
        }
        this.rulesByPackage.put(pack.getName(), new ArrayList());
        for (TreRuleSet rs : pack.getRuleSets()) {
            TreRuleSetCachable rsc = new TreRuleSetCachable(rs);
            Integer id = rs.getRuleSetId();
            this.rulesById.put(id, rsc);
            this.rulesByPackage.get(pack.getName()).add(rsc);
        }
    }

    @Override
    public void deleteRuleSet(int ruleSetId) throws RuleDeleteException {
        TreRuleSetCachable ruleSet = this.rulesById.get(ruleSetId);
        if (ruleSet == null) {
            return;
        }
        List<TreRuleSetCachable> tpack = this.rulesByPackage.get(ruleSet.getTpackage().getName());
        for (int i = 0; i < tpack.size(); ++i) {
            if (tpack.get(i).getRuleSetId() == ruleSetId) {
                tpack.remove(i);
            }
            if (i >= tpack.size()) continue;
            tpack.get(i).setOrder(i);
        }
        this.rulesById.remove(ruleSetId);
    }

    @Override
    public void deleteRuleSets(List<Integer> ruleSetIds) throws RuleDeleteException {
        for (Integer id : ruleSetIds) {
            this.deleteRuleSet(id);
        }
    }

    @Override
    public TreRuleSetCachable getRuleSet(Integer ruleSetId) {
        return this.rulesById.get(ruleSetId);
    }

    @Override
    public Collection<TreRuleSetCachable> getRuleSets(Collection<Integer> ruleSetIds) {
        LinkedList<TreRuleSetCachable> result = new LinkedList<TreRuleSetCachable>();
        for (Integer id : ruleSetIds) {
            TreRuleSetCachable rs = this.rulesById.get(id);
            if (rs == null) continue;
            boolean inserted = false;
            for (int i = 0; !inserted && i < result.size(); ++i) {
                TreRuleSetCachable current = (TreRuleSetCachable)result.get(i);
                if (current.getOrder() <= rs.getOrder()) continue;
                result.add(i, rs);
                inserted = true;
            }
            if (inserted) continue;
            result.add(rs);
        }
        return result;
    }

    @Override
    public List<TreRuleSetCachable> getRuleSetsByPackage(String packageName) {
        return this.rulesByPackage.get(packageName);
    }

    @Override
    public void disassociateRuleSetsSite(List<Integer> ruleSetIds, Integer siteId) throws RuleSetsNotAssocWSiteExpception, RuleSetsAssocWJobExpception {
        for (Integer id : ruleSetIds) {
            TreRuleSetCachable rs = this.rulesById.get(id);
            if (rs == null) continue;
            rs.getSites().remove(siteId);
        }
    }

    @Override
    public void dissociateFromSite(Integer siteId) {
        for (TreRuleSetCachable rs : this.rulesById.values()) {
            rs.getSites().remove(siteId);
        }
    }

    @Override
    public void saveRuleSet(TreRuleSet ruleSet) {
        TreRuleSetCachable rs = new TreRuleSetCachable(ruleSet);
        this.rulesById.put(rs.getRuleSetId(), rs);
        List<TreRuleSetCachable> packageList = this.rulesByPackage.get(ruleSet.getTpackage().getName());
        Integer position = rs.getOrder();
        if (position.intValue() == packageList.size()) {
            packageList.add(rs);
        } else {
            packageList.set(position, rs);
        }
    }

    @Override
    public void setRuleSetsEnabled(List<Integer> ruleSetIds, boolean enabled) {
        for (Integer id : ruleSetIds) {
            TreRuleSetCachable rs = this.rulesById.get(id);
            if (rs == null) continue;
            rs.setEnabled(enabled);
        }
    }
}

