/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.marvin.engine.EvaluatorException;
import com.tandbergtv.marvin.engine.IDeterminating;
import com.tandbergtv.marvin.engine.IllegalOperationException;
import com.tandbergtv.metadatamanager.model.IField;
import java.util.List;
import org.apache.log4j.Logger;

public class TimeDeterminating
implements IDeterminating {
    private static final Logger logger = Logger.getLogger(TimeDeterminating.class);
    private String value;
    private List<String> comparison;
    private IField fieldLhs;
    private IField fieldRhs;

    public TimeDeterminating(Predicate predicate, IField fieldLhs, IField fieldRhs) {
        this.value = this.getValue(fieldLhs);
        if (predicate instanceof PredicateRightValue) {
            this.comparison = this.getComparison((PredicateRightValue)predicate);
        }
        this.fieldLhs = fieldLhs;
        this.fieldRhs = fieldRhs;
    }

    private List<String> getComparison(PredicateRightValue predicate) {
        return predicate.getValue();
    }

    private String getValue(IField field) {
        if (!this.containsUnparsable() && field != null) {
            return field.getValue();
        }
        return null;
    }

    private String getFieldRhs() {
        if (this.comparison != null) {
            return this.comparison.get(0);
        }
        if (this.fieldRhs != null) {
            return this.fieldRhs.getValue();
        }
        return null;
    }

    @Override
    public boolean equal() {
        String rhs = this.getFieldRhs();
        if (this.fieldLhs == null && rhs == null) {
            return true;
        }
        return this.fieldLhs != null && rhs != null && this.value.equals(rhs);
    }

    @Override
    public boolean greaterThan() {
        if (this.eitherFieldIsUnbarsable()) {
            return false;
        }
        String rhs = this.getFieldRhs();
        return this.fieldLhs != null && rhs != null && this.value.compareTo(rhs) > 0;
    }

    @Override
    public boolean in() {
        for (String compVal : this.comparison) {
            if (this.fieldLhs == null || !this.value.equals(compVal)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean lessThan() {
        if (this.eitherFieldIsUnbarsable()) {
            return false;
        }
        String rhs = this.getFieldRhs();
        return this.fieldLhs != null && rhs != null && this.value.compareTo(rhs) < 0;
    }

    @Override
    public boolean contains() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean doesNotContain() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean notEqual() {
        return !this.equal();
    }

    @Override
    public boolean notIn() {
        return !this.in();
    }

    @Override
    public boolean greaterThanEqual() {
        if (this.eitherFieldIsUnbarsable()) {
            return false;
        }
        String rhs = this.getFieldRhs();
        return this.fieldLhs != null && rhs != null && this.value.compareTo(rhs) >= 0;
    }

    @Override
    public boolean isEmpty() {
        return this.fieldLhs == null || this.value.isEmpty();
    }

    @Override
    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @Override
    public boolean lessThanEqual() {
        if (this.eitherFieldIsUnbarsable()) {
            return false;
        }
        String rhs = this.getFieldRhs();
        return this.fieldLhs != null && rhs != null && this.value.compareTo(rhs) <= 0;
    }

    @Override
    public boolean lengthEquals() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lengthGreaterThan() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lengthLessThan() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean regex() throws IllegalOperationException {
        String regexStr = this.comparison.get(0);
        try {
            String value = null;
            if (this.fieldLhs != null) {
                value = this.fieldLhs.getValue();
            }
            return value != null && value.matches(regexStr);
        }
        catch (Exception e) {
            logger.error((Object)("Error while checking regular expression: " + regexStr + "for value: " + this.value));
            return false;
        }
    }

    @Override
    public boolean startsWith() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean endsWith() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean greaterThanToday() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lessThanToday() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    private boolean eitherFieldIsUnbarsable() {
        return this.containsUnparsable() || this.fieldRhs != null && this.fieldRhs.getParsable() == false;
    }

    @Override
    public boolean containsUnparsable() {
        if (this.fieldLhs == null) {
            return false;
        }
        return this.fieldLhs.getParsable() == false;
    }

    @Override
    public boolean tierEquals(int tier) throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean timeEquals() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean timeGreaterThan() throws IllegalOperationException, EvaluatorException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean timeLessThan() throws IllegalOperationException, EvaluatorException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean equalToToday() throws IllegalOperationException, EvaluatorException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean validateCategory() throws IllegalOperationException {
        throw new IllegalOperationException();
    }
}

