/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine.msopreview;

import com.ericsson.cms.sites.core.entities.mediapath.MSO;
import com.ericsson.cms.sites.core.mediapath.IMSOManager;
import com.tandbergtv.cms.rules.service.category.IRuleExecutionHandler;
import com.tandbergtv.cms.rules.service.category.IRuleManager;
import com.tandbergtv.cms.rules.service.msopreview.IMsoOverridePreviewFacade;
import com.tandbergtv.marvin.udt.NormalizationActionChange;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.marvin.udt.ShallowRuleSet;
import com.tandbergtv.marvin.udt.TreMsoOverrrideRuleSet;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;

@Stateless
public class MsoOverridePreviewFacade
implements IMsoOverridePreviewFacade {
    @EJB
    private IRuleManager ruleManager;
    @EJB
    private IRuleExecutionHandler execHandler;
    @EJB
    private ITitleManager titleManager;
    @EJB
    private IMSOManager msoManager;

    public List<ShallowRuleSet> getMsoOverrideRuleSets() {
        return this.ruleManager.getShallowRuleSetsByPackage("MSOOVERRIDE");
    }

    @TransactionAttribute
    public List<NormalizationActionChange> runSingleMsoRuleSet(long siteTitleId, int ruleSetId, int msoId) {
        Title title = this.titleManager.get(Long.valueOf(siteTitleId));
        RuleResults execResults = this.execHandler.runMsoOverrideRulerTest(title, ruleSetId);
        return execResults.getChanges();
    }

    @TransactionAttribute
    public List<NormalizationActionChange> runAllMsoRuleSets(long siteTitleId, int msoId) {
        Title title = this.titleManager.get(Long.valueOf(siteTitleId));
        RuleResults execResults = this.execHandler.runMsoOverrideRuler(title, msoId);
        return execResults.getChanges();
    }

    @TransactionAttribute
    public List<MSO> getMsos(Long siteTitleId, Integer ruleSetId) {
        if (ruleSetId != null) {
            Set msos = ((TreMsoOverrrideRuleSet)this.ruleManager.getRuleSet(ruleSetId.intValue())).getMsos();
            ArrayList<MSO> result = new ArrayList<MSO>(msos.size());
            for (MSO mso : msos) {
                result.add(mso);
            }
            return result;
        }
        return this.msoManager.getMSOsForSiteTitle(siteTitleId);
    }
}

