/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.event;

import com.tandbergtv.marvin.event.BulkActionInfo;
import com.tandbergtv.marvin.event.IBulkActionInfoDao;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

@Stateless
public class BulkExecutionDao
implements IBulkActionInfoDao {
    @PersistenceContext(unitName="rulesds")
    private EntityManager entityManager;

    @Override
    @TransactionAttribute
    public void saveState(String correlationId, Long titleId, List<Integer> ruleSetIds) {
        for (Integer ruleSetId : ruleSetIds) {
            Query q = this.entityManager.createNativeQuery("Insert into tre_bulkExecution_ContentProc(correlationId, titleId, ruleSetId) values(?, ?, ?)");
            q.setParameter(1, (Object)correlationId);
            q.setParameter(2, (Object)titleId);
            q.setParameter(3, (Object)ruleSetId);
            q.executeUpdate();
        }
    }

    @Override
    @TransactionAttribute
    public void saveState(String correlationId, String workflowRefId, List<Long> titleIds, List<Integer> contentProcessingRuleSetIds, boolean hasOtherRuleSets) {
        Query main = this.entityManager.createNativeQuery("Insert into tre_bulkExecution(correlationId, WORKFLOWREFERNCEID) values(?, ?)");
        main.setParameter(1, (Object)correlationId);
        main.setParameter(2, (Object)workflowRefId);
        main.executeUpdate();
        for (Long titleId : titleIds) {
            if (hasOtherRuleSets) {
                Query general = this.entityManager.createNativeQuery("Insert into tre_bulkExecution_General(correlationId, titleId) values(?, ?)");
                general.setParameter(1, (Object)correlationId);
                general.setParameter(2, (Object)titleId);
                general.executeUpdate();
            }
            this.saveState(correlationId, titleId, contentProcessingRuleSetIds);
        }
    }

    @Override
    @TransactionAttribute
    public BulkActionInfo getSavedState(String correlationId, String workflowRefId) {
        List refId = new ArrayList(0);
        if (workflowRefId != null) {
            Query checkRefId = this.entityManager.createNativeQuery("select correlationId from tre_bulkExecution where WORKFLOWREFERNCEID = ?");
            checkRefId.setParameter(1, (Object)workflowRefId);
            refId = checkRefId.getResultList();
        }
        if (refId.size() > 0 && !((String)refId.get(0)).equals(correlationId)) {
            return new BulkActionInfo(correlationId, true);
        }
        Query mainQuery = this.entityManager.createNativeQuery("select count(*) from tre_bulkExecution where correlationId = ?");
        mainQuery.setParameter(1, (Object)correlationId);
        Integer count = ((BigDecimal)mainQuery.getSingleResult()).intValue();
        if (count == 0) {
            return new BulkActionInfo(correlationId, false);
        }
        Query rsQuery = this.entityManager.createNativeQuery("select titleId, ruleSetId from tre_bulkExecution_ContentProc where correlationId = ?");
        rsQuery.setParameter(1, (Object)correlationId);
        List result = rsQuery.getResultList();
        HashMap<Long, List<Integer>> rssi = new HashMap<Long, List<Integer>>();
        for (Object[] row : result) {
            Long titleId = ((BigDecimal)row[0]).longValue();
            Integer ruleSetId = ((BigDecimal)row[1]).intValue();
            if (!rssi.containsKey(titleId)) {
                rssi.put(titleId, new ArrayList());
            }
            ((List)rssi.get(titleId)).add(ruleSetId);
        }
        Query titleQuery = this.entityManager.createNativeQuery("select titleId from tre_bulkExecution_General where correlationId = ?");
        titleQuery.setParameter(1, (Object)correlationId);
        List titleIdsTemp = titleQuery.getResultList();
        ArrayList<Long> titleIds = new ArrayList<Long>(titleIdsTemp.size());
        for (BigDecimal bd : titleIdsTemp) {
            titleIds.add(bd.longValue());
        }
        Query failedTitleQuery = this.entityManager.createNativeQuery("select titleId from tre_bulkExecution_FailedTitles where correlationId = ?");
        failedTitleQuery.setParameter(1, (Object)correlationId);
        List failedTitleIdsTemp = failedTitleQuery.getResultList();
        ArrayList<Long> failedTitleIds = new ArrayList<Long>(failedTitleIdsTemp.size());
        for (BigDecimal bd : failedTitleIdsTemp) {
            failedTitleIds.add(bd.longValue());
        }
        return new BulkActionInfo(true, correlationId, titleIds, rssi, failedTitleIds);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void deleteSavedStateContentProcessing(String correlationId, Long titleId, Integer ruleSetId) {
        Query delete = this.entityManager.createNativeQuery("delete from tre_bulkExecution_ContentProc where correlationId = ? and titleId = ? and ruleSetId = ?");
        delete.setParameter(1, (Object)correlationId);
        delete.setParameter(2, (Object)titleId);
        delete.setParameter(3, (Object)ruleSetId);
        delete.executeUpdate();
    }

    @Override
    @TransactionAttribute
    public void deleteSavedStateGeneral(String correlationId, Long titleId) {
        Query delete = this.entityManager.createNativeQuery("delete from tre_bulkExecution_General where correlationId = ? and titleId = ?");
        delete.setParameter(1, (Object)correlationId);
        delete.setParameter(2, (Object)titleId);
        delete.executeUpdate();
    }

    @Override
    @TransactionAttribute
    public void setFinishedSavedState(String correlationId) {
        Query update = this.entityManager.createNativeQuery("update tre_bulkExecution set finished = 1, updateDate=SYSTIMESTAMP where correlationId = ?");
        update.setParameter(1, (Object)correlationId);
        update.executeUpdate();
        Query delete1 = this.entityManager.createNativeQuery("delete from tre_bulkExecution_FailedTitles where correlationId = ?");
        delete1.setParameter(1, (Object)correlationId);
        delete1.executeUpdate();
        Query delete2 = this.entityManager.createNativeQuery("delete from tre_bulkExecution_ContentProc where correlationId = ?");
        delete2.setParameter(1, (Object)correlationId);
        delete2.executeUpdate();
        Query delete3 = this.entityManager.createNativeQuery("delete from tre_bulkExecution_General where correlationId = ?");
        delete3.setParameter(1, (Object)correlationId);
        delete3.executeUpdate();
    }

    @Override
    @TransactionAttribute
    public void purgeSavedState() {
        Query delete = this.entityManager.createNativeQuery("DELETE FROM TRE_BULKEXECUTION WHERE finished = 1 AND updatedate < SYSTIMESTAMP - 2");
        delete.executeUpdate();
    }

    @Override
    @TransactionAttribute
    public void setTitleFailed(String correlationId, Long titleId) {
        Query delete = this.entityManager.createNativeQuery("delete from tre_bulkExecution_ContentProc where correlationId = ? and titleId = ?");
        delete.setParameter(1, (Object)correlationId);
        delete.setParameter(2, (Object)titleId);
        delete.executeUpdate();
        this.deleteSavedStateGeneral(correlationId, titleId);
        Query general = this.entityManager.createNativeQuery("Insert into tre_bulkExecution_FailedTitles(correlationId, titleId) values(?, ?)");
        general.setParameter(1, (Object)correlationId);
        general.setParameter(2, (Object)titleId);
        general.executeUpdate();
    }
}

