/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.event;

import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.LogicalSite;
import com.ericsson.cms.sites.core.entities.Site;
import com.tandbergtv.cms.rules.service.category.IRuleExecutionHandler;
import com.tandbergtv.cms.rules.service.category.IRuleManager;
import com.tandbergtv.cms.rules.service.category.TreRuleSetCachable;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.title.search.entities.SiteType;
import com.tandbergtv.marvin.engine.IRuleManagerCache;
import com.tandbergtv.marvin.event.BulkActionInfo;
import com.tandbergtv.marvin.event.IBulkActionInfoDao;
import com.tandbergtv.marvin.event.MessageHelper;
import com.tandbergtv.marvin.event.RuleAsyncExecutionException;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.marvin.udt.TreEvent;
import com.tandbergtv.marvin.udt.TreRuleSet;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.watchpoint.pmm.core.TitlePersistenceException;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleActionSource;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.TitleActions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.EJBException;
import javax.ejb.MessageDriven;
import javax.ejb.MessageDrivenContext;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;

@MessageDriven(name="EventHandlerMDBean", activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="queue/EventQueue"), @ActivationConfigProperty(propertyName="acknowledgeMode", propertyValue="Auto-acknowledge")})
@TransactionManagement(value=TransactionManagementType.BEAN)
public class EventHandlerMDBean
implements MessageListener {
    private static final Logger logger = Logger.getLogger(EventHandlerMDBean.class);
    private static final int MAX_FAILURES_TOLERATED = 25;
    private static float STATUS_GRANULARITY = 0.1f;
    private static Date lastPurgeDate = EventHandlerMDBean.getOneHourAgo();
    private QueueConnection queueConnection = null;
    private QueueSession queueSession = null;
    private QueueSession replySession = null;
    @Resource
    private MessageDrivenContext context;
    @EJB
    private ITitleSearchService titleSearchService;
    @EJB
    private IRuleExecutionHandler eventHandler;
    @EJB
    private IRuleManager ruleManager;
    @EJB
    private ITitleManager titleManager;
    @EJB
    private IBulkActionInfoDao stateSaver;
    @EJB
    private IRuleManagerCache ruleCache;

    @PostConstruct
    public void initialize() {
        QueueConnectionFactory queueFactory = (QueueConnectionFactory)this.context.lookup("ConnectionFactory");
        try {
            this.queueConnection = queueFactory.createQueueConnection();
            this.queueSession = this.queueConnection.createQueueSession(true, 0);
            this.replySession = this.queueConnection.createQueueSession(false, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        try {
            String failMessage;
            String eventType = message.getStringProperty("eventType");
            String packageType = message.getStringProperty("packageType");
            String ruleSetId = message.getStringProperty("ruleSetId");
            String titleId = message.getStringProperty("titleId");
            String workflowReferenceId = message.getStringProperty("requestKey");
            List<Long> ruleSetIds = MessageHelper.unmarshallList(message.getStringProperty("ruleSetIds"));
            List<Long> titleIds = MessageHelper.unmarshallList(message.getStringProperty("titleIds"));
            Destination returnDestination = message.getJMSReplyTo();
            String correlationId = message.getJMSMessageID();
            List<Object> failedTitles = new ArrayList();
            if (packageType != null && packageType.equalsIgnoreCase("TARGETING")) {
                failMessage = "FAIL: Targeting is not supported in async call of rules.";
                this.reply(returnDestination, correlationId, false, failMessage, 0);
            }
            if (ruleSetId == null && ruleSetIds == null && titleId == null && titleIds == null) {
                failMessage = "FAIL: Must provide either ruleSetId(s) or titleId(s).";
                this.reply(returnDestination, correlationId, false, failMessage, 0);
            }
            try {
                ArrayList<Integer> contentProcessingRuleSets = new ArrayList<Integer>();
                ArrayList<Integer> otherRuleSets = new ArrayList<Integer>();
                this.getRulesets(eventType, packageType, ruleSetId, ruleSetIds, correlationId, returnDestination, contentProcessingRuleSets, otherRuleSets);
                BulkActionInfo previousState = this.stateSaver.getSavedState(correlationId, workflowReferenceId);
                if (previousState.moveOn()) {
                    logger.debug((Object)"I'm moving On. I'm seriously over you!");
                } else if (previousState.hasPreviousState()) {
                    failedTitles = previousState.getFailedTitles();
                    this.processCrashRecovery(returnDestination, correlationId, otherRuleSets, previousState);
                } else {
                    this.processNormal(returnDestination, correlationId, contentProcessingRuleSets, otherRuleSets, titleId, titleIds, failedTitles, workflowReferenceId);
                }
                logger.debug((Object)"Done!");
                if (failedTitles.size() != 0) {
                    String failMessage2 = "FAIL: The following title(s) failed during rule engine execution: " + this.getFailedTitlesString(failedTitles);
                    this.reply(returnDestination, correlationId, false, failMessage2, 0);
                } else {
                    this.reply(returnDestination, correlationId, true, "Done!", 100);
                }
            }
            catch (RuleAsyncExecutionException e) {
                this.reply(returnDestination, correlationId, false, e.getMessage(), 0);
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)"Failed execution!", (Throwable)e);
                this.reply(returnDestination, correlationId, false, "FAIL", 0);
            }
            finally {
                this.stateSaver.setFinishedSavedState(correlationId);
            }
            if (!message.getJMSRedelivered()) {
                this.purge();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed execution!", (Throwable)e);
        }
    }

    private static Date getOneHourAgo() {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(new Date());
        cal.add(10, -1);
        return cal.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purge() {
        Date date = lastPurgeDate;
        synchronized (date) {
            if (lastPurgeDate.compareTo(EventHandlerMDBean.getOneHourAgo()) < 0) {
                this.stateSaver.purgeSavedState();
                lastPurgeDate = new Date();
            }
        }
    }

    private void processCrashRecovery(Destination returnDestination, String correlationId, List<Integer> otherRuleSets, BulkActionInfo previousState) throws Exception {
        this.reply(returnDestination, correlationId, true, "Crash recovery: continuing proccessing rules for this request...", 1);
        Set<Map.Entry<Long, List<Integer>>> cpItems = previousState.getRuleSetSpecificItems().entrySet();
        List<Long> generalTitleIds = previousState.getGeneralProcessingTitleIds();
        List<List<Long>> splitTitles = this.splitTitleList(generalTitleIds);
        int complete = 0;
        for (List<Long> list : splitTitles) {
            int progress;
            if ((progress = (int)((float)complete++ * STATUS_GRANULARITY * 100.0f)) < 100 && progress > 0) {
                this.reply(returnDestination, correlationId, true, "processing ...", progress);
            }
            for (Long tId : list) {
                this.runNonCotentProcessingRules(tId, otherRuleSets, previousState.getFailedTitles(), correlationId);
            }
        }
        this.reply(returnDestination, correlationId, true, "processing content processing ...", 91);
        for (Map.Entry entry : cpItems) {
            Long titleId = (Long)entry.getKey();
            List ruleSetIds = (List)entry.getValue();
            this.runCotentProcessingRules(titleId, ruleSetIds, previousState.getFailedTitles(), correlationId);
        }
    }

    private void processNormal(Destination returnDestination, String correlationId, List<Integer> contentProcessingRuleSets, List<Integer> otherRuleSets, String titleId, List<Long> titleIds, List<Long> failedTitles, String workflowReferenceId) throws Exception {
        this.reply(returnDestination, correlationId, true, "Starting to proccess rules for this request...", 1);
        logger.debug((Object)"Starting to proccess rules for this request...");
        if (otherRuleSets.size() == 0 && contentProcessingRuleSets.size() == 0) {
            logger.info((Object)"No rule sets to run.");
            this.reply(returnDestination, correlationId, true, "No rule sets to run.", 100);
            return;
        }
        this.reply(returnDestination, correlationId, true, "Searching for titles...", 2);
        logger.debug((Object)"Searching for titles...");
        ArrayList<Integer> ruleSets = new ArrayList<Integer>(contentProcessingRuleSets.size() + otherRuleSets.size());
        ruleSets.addAll(contentProcessingRuleSets);
        ruleSets.addAll(otherRuleSets);
        List<Long> titles = this.getTitles(titleId, titleIds, ruleSets);
        this.stateSaver.saveState(correlationId, workflowReferenceId, titles, contentProcessingRuleSets, otherRuleSets.size() > 0);
        List<List<Long>> splitTitles = this.splitTitleList(titles);
        int complete = 0;
        logger.debug((Object)("Processing " + (titles == null ? 0 : titles.size()) + " titles..."));
        for (List<Long> subTitleIds : splitTitles) {
            int progress;
            if ((progress = (int)((float)complete++ * STATUS_GRANULARITY * 100.0f)) < 100 && progress > 0) {
                this.reply(returnDestination, correlationId, true, "processing...", progress);
            }
            for (Long tId : subTitleIds) {
                if (otherRuleSets.size() > 0) {
                    this.runNonCotentProcessingRules(tId, otherRuleSets, failedTitles, correlationId);
                }
                if (contentProcessingRuleSets.size() <= 0) continue;
                this.runCotentProcessingRules(tId, contentProcessingRuleSets, failedTitles, correlationId);
            }
        }
    }

    private void runNonCotentProcessingRules(Long titleId, List<Integer> ruleSetIds, List<Long> failedTitles, String correlationId) throws Exception {
        TransactionManager tm = this.getCurrentTransaction();
        try {
            ArrayList<Integer> cprsIds = new ArrayList<Integer>();
            tm.begin();
            Title title = this.titleManager.getForUpdate(titleId);
            RuleResults result = this.eventHandler.runRuler(title, ruleSetIds);
            if (result.isModified()) {
                ArrayList<TitleActions> actions = new ArrayList<TitleActions>();
                if (result.ranRuleType("NORMALIZATION")) {
                    actions.add(TitleActions.TITLE_NATIONALIZED_ACTION);
                }
                this.titleManager.save(title, (ITitleActionSource)new TitleActionSource("Rules", null, "sys"));
                List<TreRuleSetCachable> cprs = this.ruleCache.getRuleSetsByPackage("PROCESSING");
                for (TreRuleSetCachable rs : cprs) {
                    if (!rs.getEvents().contains(TreEvent.NORMALIZED)) continue;
                    cprsIds.add(rs.getRuleSetId());
                }
                this.stateSaver.saveState(correlationId, titleId, cprsIds);
            }
            this.stateSaver.deleteSavedStateGeneral(correlationId, titleId);
            tm.commit();
            this.runCotentProcessingRules(titleId, cprsIds, failedTitles, correlationId);
        }
        catch (TitlePersistenceException e) {
            this.tryRollback(tm);
            if (e.getCause() instanceof SearchException) {
                String errMsg = "There was a search exception. I hope it was because a title was deleted. Otherwise we might have done something bad.";
                logger.warn((Object)errMsg, (Throwable)e);
            } else {
                this.handleRunRulesException(titleId, correlationId, (Exception)((Object)e), failedTitles);
            }
        }
        catch (Exception ex) {
            this.tryRollback(tm);
            this.handleRunRulesException(titleId, correlationId, ex, failedTitles);
        }
    }

    private void runCotentProcessingRules(Long titleId, List<Integer> ruleSetIds, List<Long> failedTitles, String correlationId) throws Exception {
        TransactionManager tm = this.getCurrentTransaction();
        try {
            tm.begin();
            Title title = this.titleManager.get(titleId);
            for (Integer ruleSetId : ruleSetIds) {
                this.eventHandler.runRuler(title, Arrays.asList(ruleSetId));
                this.stateSaver.deleteSavedStateContentProcessing(correlationId, titleId, ruleSetId);
            }
            tm.commit();
        }
        catch (TitlePersistenceException e) {
            this.tryRollback(tm);
            if (e.getCause() instanceof SearchException) {
                String errMsg = "There was a search exception. I hope it was because a title was deleted. Otherwise we might have done something bad.";
                logger.warn((Object)errMsg, (Throwable)e);
            } else {
                this.handleRunRulesException(titleId, correlationId, (Exception)((Object)e), failedTitles);
            }
        }
        catch (Exception ex) {
            this.tryRollback(tm);
            this.handleRunRulesException(titleId, correlationId, ex, failedTitles);
        }
    }

    private void handleRunRulesException(Long titleId, String correlationId, Exception e, List<Long> failedTitles) throws RuleAsyncExecutionException {
        this.stateSaver.setTitleFailed(correlationId, titleId);
        failedTitles.add(titleId);
        if (failedTitles.size() >= 25) {
            String msg = "FAIL: Max failures tolerated reached. Failed titles: " + this.getFailedTitlesString(failedTitles);
            throw new RuleAsyncExecutionException(msg, e);
        }
        String msg = "Error while running rules. See stack trace for more info.";
        logger.error((Object)msg, (Throwable)e);
    }

    private String getFailedTitlesString(List<Long> failures) {
        StringBuffer result = new StringBuffer();
        for (Long id : failures) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(id);
        }
        return result.toString();
    }

    private void reply(Destination returnDestination, String correlationId, boolean success, String message, int percent) throws JMSException {
        if (returnDestination != null) {
            MessageProducer messageProducer = this.replySession.createProducer(returnDestination);
            Message returnMessage = this.queueSession.createMessage();
            returnMessage.setObjectProperty("status", (Object)message);
            returnMessage.setIntProperty("percent", percent);
            returnMessage.setBooleanProperty("success", success);
            returnMessage.setJMSCorrelationID(correlationId);
            messageProducer.send(returnMessage);
        }
    }

    private List<Long> getTitles(String titleId, List<Long> titleIds, Collection<Integer> ruleSetIds) throws Exception {
        if (titleIds != null) {
            return titleIds;
        }
        if (titleId != null) {
            ArrayList<Long> resultTitleIds = new ArrayList<Long>();
            resultTitleIds.add(Long.parseLong(titleId));
            return resultTitleIds;
        }
        return new ArrayList<Long>(this.getTitlesUsingTitleFilter(ruleSetIds));
    }

    private Set<Long> getTitlesUsingTitleFilter(Collection<Integer> ruleSetIds) throws Exception {
        logger.debug((Object)"loading titles from database.");
        HashSet<Long> resultTitleIds = new HashSet<Long>();
        TransactionManager tm = this.getCurrentTransaction();
        try {
            tm.begin();
            List ruleSets = this.ruleManager.getRuleSets(ruleSetIds);
            for (TreRuleSet rs : ruleSets) {
                if (!rs.getEnabled().booleanValue()) continue;
                boolean runOnGlobal = rs.isRunOnGlobal();
                Set<Integer> sites = this.getSiteIds(rs.getSites());
                if (runOnGlobal && !sites.isEmpty()) {
                    resultTitleIds.addAll(this.titleSearchService.geAllTitlesIds(rs.getFilter(), sites, SiteType.DISTRIBUTION_SITE));
                    continue;
                }
                if (runOnGlobal) {
                    resultTitleIds.addAll(this.titleSearchService.getTitleIds(rs.getFilter().getRootNode()));
                    continue;
                }
                resultTitleIds.addAll(this.titleSearchService.getSiteTitleIds(rs.getFilter().getRootNode(), sites, SiteType.DISTRIBUTION_SITE));
            }
            logger.debug((Object)"finished loading titles.");
            tm.commit();
        }
        catch (Exception e) {
            this.tryRollback(tm);
            throw e;
        }
        return resultTitleIds;
    }

    private Set<Integer> getSiteIds(Set<Site> sites) {
        HashSet<Integer> results = new HashSet<Integer>();
        if (sites == null) {
            return results;
        }
        this.addAllDistSiteIds(sites, results);
        return results;
    }

    private void addAllDistSiteIds(Collection<Site> sites, Set<Integer> siteIds) {
        for (Site site : sites) {
            if (site instanceof DistributionSite) {
                siteIds.add(site.getId());
                continue;
            }
            if (!(site instanceof LogicalSite)) continue;
            this.addAllDistSiteIds(((LogicalSite)site).getSiteChildren(), siteIds);
        }
    }

    private void tryRollback(TransactionManager tm) {
        try {
            tm.rollback();
        }
        catch (Exception ex) {
            logger.warn((Object)"Tried to rollback but was unable to do so.");
        }
    }

    private List<List<Long>> splitTitleList(List<Long> titles) {
        ArrayList<List<Long>> result = new ArrayList<List<Long>>();
        int total = titles.size();
        int m = 1;
        int start = 0;
        int end = 0;
        while (true) {
            start = end;
            end = (int)Math.floor((float)total * STATUS_GRANULARITY * (float)m);
            result.add(titles.subList(start, Math.min(end, total)));
            if (end >= total) break;
            ++m;
        }
        return result;
    }

    private void getRulesets(String eventType, String packageType, String ruleSetId, List<Long> ruleSetIds, String returnDestination, Destination correlationId, List<Integer> contentProcessingRuleSets, List<Integer> otherRuleSets) throws Exception {
        TransactionManager tm = this.getCurrentTransaction();
        try {
            TreEvent et = null;
            if (eventType != null && !eventType.isEmpty()) {
                et = TreEvent.valueOf((String)eventType);
            }
            tm.begin();
            Collection<TreRuleSetCachable> ruleSets = this.getRulesetsHelper(packageType, ruleSetId, ruleSetIds, returnDestination, correlationId);
            for (TreRuleSetCachable rs : ruleSets) {
                if (et != null && !rs.getEvents().contains(et)) continue;
                if (rs.getTpackage().getName().equals("PROCESSING")) {
                    contentProcessingRuleSets.add(rs.getRuleSetId());
                    continue;
                }
                otherRuleSets.add(rs.getRuleSetId());
            }
            tm.commit();
        }
        catch (Exception ex) {
            this.tryRollback(tm);
            throw ex;
        }
    }

    private Collection<TreRuleSetCachable> getRulesetsHelper(String packageType, String ruleSetId, List<Long> ruleSetIds, String correlationId, Destination returnDestination) throws RuleAsyncExecutionException, JMSException {
        Collection<TreRuleSetCachable> result = null;
        result = packageType != null ? this.ruleCache.getRuleSetsByPackage(packageType) : (ruleSetIds != null ? this.getRuleSetsById(ruleSetIds, returnDestination, correlationId) : (ruleSetId != null ? this.getRuleSetsById(ruleSetId, returnDestination, correlationId) : this.ruleCache.getRuleSetsByPackage("PROCESSING")));
        if (!(result != null && result.size() != 0 || ruleSetId == null && (ruleSetIds == null || ruleSetIds.isEmpty()))) {
            String msg = "There were no enabled rule sets to run";
            throw new RuleAsyncExecutionException(msg);
        }
        return result;
    }

    private Collection<TreRuleSetCachable> getRuleSetsById(String ruleSetId, Destination returnDestination, String correlationId) throws RuleAsyncExecutionException, JMSException {
        try {
            int ruleId = Integer.parseInt(ruleSetId.toString());
            ArrayList<TreRuleSetCachable> ruleSets = new ArrayList<TreRuleSetCachable>();
            TreRuleSetCachable ruleSet = this.ruleCache.getRuleSet(ruleId);
            if (ruleSet.isEnabled()) {
                ruleSets.add(ruleSet);
            } else {
                this.reply(returnDestination, correlationId, true, "Rule Set with Id: " + ruleSetId + " is not enabled.", 1);
            }
            return ruleSets;
        }
        catch (EJBException ex) {
            String msg = "Unable to run rule. Rule Set with ID " + ruleSetId + " doesn't exist";
            throw new RuleAsyncExecutionException(msg);
        }
        catch (NumberFormatException ex) {
            String msg = "RuleSetId must be a valid java integer. Value recieved: " + ruleSetId;
            throw new RuleAsyncExecutionException(msg);
        }
    }

    private Collection<TreRuleSetCachable> getRuleSetsById(List<Long> ruleSetIds, Destination returnDestination, String correlationId) throws RuleAsyncExecutionException, JMSException {
        ArrayList<TreRuleSetCachable> ruleSets = new ArrayList<TreRuleSetCachable>();
        for (Long ruleId : ruleSetIds) {
            String msg;
            try {
                int id = Integer.parseInt(ruleId.toString());
                TreRuleSetCachable ruleSet = this.ruleCache.getRuleSet(id);
                if (ruleSet.isEnabled()) {
                    ruleSets.add(ruleSet);
                    continue;
                }
                this.reply(returnDestination, correlationId, true, "Rule Set with Id: " + id + " is not enabled.", 1);
            }
            catch (EJBException ex) {
                msg = "Unable to run rule. Rule Set with ID " + ruleId + " doesn't exist";
                throw new RuleAsyncExecutionException(msg);
            }
            catch (NumberFormatException ex) {
                msg = "RuleSetId must be a valid java integer. Value recieved: " + ruleId;
                throw new RuleAsyncExecutionException(msg);
            }
        }
        return ruleSets;
    }

    private TransactionManager getCurrentTransaction() {
        TransactionManager transactionManager = null;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get current transaction manager", (Throwable)e);
        }
        return transactionManager;
    }
}

