/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.scheduler;

import com.ericsson.cms.scheduler.IRecoveryService;
import com.ericsson.cms.scheduler.ISchedulerCallback;
import com.tandbergtv.marvin.event.MessageHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;

public class RuleSetSchedulerCallback
implements ISchedulerCallback {
    private static final Logger logger = Logger.getLogger(RuleSetSchedulerCallback.class);
    private static final String ASSOCIATED_ENTITY_TYPE_RULESET = "ruleset";
    private static final String JMS_CONNECTION_FACTORY_NAME = "ConnectionFactory";
    private static final String RULESET_QUEUE_NAME = "queue/EventQueue";
    private static final String RULESET_IDS_PROPERTY_NAME = "ruleSetIds";

    public void performAction(long jobId, String associatedEntityType, Set<Long> associatedEntityIds, String filterName, Date filterValue, Date execDate, IRecoveryService rs) {
        logger.info((Object)("performAction() called with jobId : " + jobId + ", associatedEntityType : " + associatedEntityType + ", associatedEntityIds : " + associatedEntityIds + ", filterName : " + filterName + ", filterValue : " + filterValue + ", execDate : " + execDate));
        if (ASSOCIATED_ENTITY_TYPE_RULESET.equals(associatedEntityType)) {
            ArrayList<Long> associatedEntityIdsList = new ArrayList<Long>();
            associatedEntityIdsList.addAll(associatedEntityIds);
            String ruleSetIds = MessageHelper.marshallList(associatedEntityIdsList);
            TransactionManager transactionManager = null;
            try {
                transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
                transactionManager.begin();
                this.sendMessage(ruleSetIds);
                rs.markDone();
                transactionManager.commit();
            }
            catch (Exception e) {
                logger.error((Object)"Exception occurred while sending JMS message", (Throwable)e);
                try {
                    if (transactionManager.getTransaction() != null) {
                        transactionManager.rollback();
                    }
                }
                catch (Exception e1) {
                    logger.error((Object)"Could not rollback transaction: ", (Throwable)e1);
                }
            }
        } else {
            logger.warn((Object)"Associated entityType other than ruleset is not handled by RuleSetSchedulerCallback.");
        }
    }

    private void sendMessage(String ruleSetIds) {
        QueueSession session = null;
        QueueSender sender = null;
        QueueConnection connection = null;
        logger.debug((Object)"Calling rule engine");
        try {
            InitialContext context = new InitialContext();
            QueueConnectionFactory queueFactory = (QueueConnectionFactory)context.lookup(JMS_CONNECTION_FACTORY_NAME);
            connection = queueFactory.createQueueConnection();
            session = connection.createQueueSession(false, 1);
            Queue queue = (Queue)context.lookup(RULESET_QUEUE_NAME);
            sender = session.createSender(queue);
            ObjectMessage message = session.createObjectMessage();
            message.setStringProperty(RULESET_IDS_PROPERTY_NAME, ruleSetIds);
            sender.send(queue, (Message)message);
        }
        catch (Exception e) {
            logger.warn((Object)("Exception sending JMS message to Rule Engine for ruleSetIds : " + ruleSetIds + " : " + e), (Throwable)e);
        }
    }
}

