/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.services;

import com.ericsson.cms.scheduler.IScheduler;
import com.ericsson.cms.scheduler.entities.Job;
import com.ericsson.cms.scheduler.entities.ScheduleRule;
import com.ericsson.cms.sites.core.entities.Site;
import com.tandbergtv.cms.rules.service.RuleDeleteException;
import com.tandbergtv.cms.rules.service.RuleServiceStatus;
import com.tandbergtv.cms.rules.service.category.EventRetrivalException;
import com.tandbergtv.cms.rules.service.category.IRuleManager;
import com.tandbergtv.cms.rules.service.category.RuleSetsAssocWJobExpception;
import com.tandbergtv.cms.rules.service.category.RuleSetsNotAssocWSiteExpception;
import com.tandbergtv.marvin.engine.IRuleManagerCache;
import com.tandbergtv.marvin.scheduler.RuleSetSchedulerCallback;
import com.tandbergtv.marvin.udt.ShallowRuleSet;
import com.tandbergtv.marvin.udt.TreEvent;
import com.tandbergtv.marvin.udt.TrePackage;
import com.tandbergtv.marvin.udt.TreRuleSet;
import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

@Stateless
public class RuleManagerImpl
implements IRuleManager {
    private static final String ASSOCIATED_ENTITY_TYPE_RULESET = "ruleset";
    private static final String ASSOCIATION_DESCRIPTION_PREFIX_RULESET = "Ruleset: ";
    private static final String JOB_PREFIX_RULESET = "Job for RuleSet ";
    private static final String PERMISSION_SCHEDULER_DELETE = "Scheduler_Delete";
    private static final String PERMISSION_SITES_MODIFY = "Sites_Modify";
    @PersistenceContext(unitName="rulesds")
    private EntityManager entityManager;
    @EJB
    private IScheduler scheduler;
    @EJB
    private IAuthorizationService authorizationService;
    @EJB
    IRuleManagerCache ruleCache;

    @TransactionAttribute
    public TreRuleSet getRuleSet(int ruleSetId) {
        Query query = this.entityManager.createQuery("SELECT rs FROM\tTreRuleSet rs WHERE\truleSetId = :rsid");
        query.setParameter("rsid", (Object)ruleSetId);
        TreRuleSet result = (TreRuleSet)query.getSingleResult();
        return result;
    }

    @TransactionAttribute
    public List<TreRuleSet> getRuleSets(Collection<Integer> ruleSetIds) {
        if (ruleSetIds == null || ruleSetIds.size() == 0) {
            return new ArrayList<TreRuleSet>();
        }
        StringBuffer str = new StringBuffer();
        str.append("SELECT rs ");
        str.append("FROM\tTreRuleSet rs ");
        str.append("WHERE\truleSetId IN (:ruleSetIds)");
        Query query = this.entityManager.createQuery(str.toString());
        query.setParameter("ruleSetIds", ruleSetIds);
        List result = query.getResultList();
        return result;
    }

    @TransactionAttribute
    public List<TreRuleSet> getRuleSetsByPackage(String packageName) {
        String queryString = "SELECT tr FROM\t TrePackage p JOIN\t p.ruleSets tr WHERE  p.name = :pname order by tr.order_";
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("pname", (Object)packageName.toUpperCase());
        List result = query.getResultList();
        return result;
    }

    @TransactionAttribute
    public List<TreRuleSet> getRulesByEvent(String eventName) throws EventRetrivalException {
        String queryString = "SELECT tr FROM\t TreEventWrapper e JOIN\t e.rules tr WHERE\t e.name = :ename ";
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("ename", (Object)eventName);
        List result = query.getResultList();
        return result;
    }

    @TransactionAttribute
    public List<TreRuleSet> getRuleSetsByUuid(String uuid) {
        String queryString = "SELECT rs FROM\tTreRuleSet rs WHERE uuid = :uuid ORDER BY rs.updateDate DESC ";
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("uuid", (Object)uuid);
        List result = query.getResultList();
        return result;
    }

    @TransactionAttribute
    public void deleteRuleSet(TreRuleSet ruleSet) throws RuleDeleteException {
        if (ruleSet != null) {
            boolean allowRuleSetDelete = false;
            Integer ruleSetId = ruleSet.getRuleSetId();
            ArrayList<RuleServiceStatus> reasons = new ArrayList<RuleServiceStatus>();
            List jobs = this.scheduler.getJobsByAssociatedEntity(ASSOCIATED_ENTITY_TYPE_RULESET, (long)ruleSetId.intValue());
            if (jobs != null && jobs.size() > 0) {
                if (this.authorizationService.isAuthorized(PERMISSION_SCHEDULER_DELETE)) {
                    allowRuleSetDelete = true;
                    for (Job ruleSetJob : jobs) {
                        this.scheduler.delete(ruleSetJob.getId().longValue());
                    }
                } else {
                    String deleteDisallowedReasonErrorCode = "errScheduleDeleteNotPermitted";
                    RuleServiceStatus deleteDisallowedReason = new RuleServiceStatus(false, deleteDisallowedReasonErrorCode, String.valueOf(ruleSetId));
                    reasons.add(deleteDisallowedReason);
                }
            } else {
                allowRuleSetDelete = true;
            }
            Set sites = ruleSet.getSites();
            if (sites != null && sites.size() > 0 && this.authorizationService.getUserName() != null && !this.authorizationService.isAuthorized(PERMISSION_SITES_MODIFY)) {
                allowRuleSetDelete = false;
                String deleteDisallowedReasonErrorCode = "errSiteModifyNotAuthorized";
                RuleServiceStatus deleteDisallowedReason = new RuleServiceStatus(false, deleteDisallowedReasonErrorCode, String.valueOf(ruleSetId));
                reasons.add(deleteDisallowedReason);
            }
            if (!allowRuleSetDelete) {
                throw new RuleDeleteException(reasons);
            }
            TrePackage tpack = ruleSet.getTpackage();
            tpack.getRuleSets().remove(ruleSet);
            IRuleManagerCache ruleCache = (IRuleManagerCache)InjectionUtil.injectInstance((String)"cms/RuleManagerCache/local", IRuleManagerCache.class);
            ruleCache.deleteRuleSet(ruleSet.getRuleSetId());
        }
    }

    @TransactionAttribute
    public void deleteRuleSet(int ruleSetId) throws RuleDeleteException {
        TreRuleSet ruleSet = (TreRuleSet)this.entityManager.find(TreRuleSet.class, (Object)ruleSetId);
        this.deleteRuleSet(ruleSet);
    }

    @TransactionAttribute
    public List<TreRuleSet> getRuleSetsByPackAndEvnt(String packageName, String eventName) {
        String queryString = "SELECT tr FROM\tTreEventWrapper e JOIN\te.rules tr JOIN\ttr.tpackage p WHERE p.name = :pname AND\te.name = :ename order by tr.order_ ";
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("pname", (Object)packageName.toUpperCase());
        query.setParameter("ename", (Object)eventName);
        List result = query.getResultList();
        return result;
    }

    @TransactionAttribute
    public void deleteRuleSets(List<Integer> ruleSetIds) throws RuleDeleteException {
        for (Integer id : ruleSetIds) {
            this.deleteRuleSetHelper(id);
        }
    }

    public List<ShallowRuleSet> getShallowRuleSets(String eventName) {
        String queryString = "SELECT new com.tandbergtv.marvin.udt.ShallowRuleSet(tr.ruleSetId, tr.ruleName, p.name) FROM\tTreEventWrapper e JOIN\te.rules tr JOIN\ttr.tpackage p WHERE e.name = :ename order by tr.order_ ";
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("ename", (Object)eventName);
        List result = query.getResultList();
        return result;
    }

    @TransactionAttribute
    private void deleteRuleSetHelper(int ruleSetId) throws RuleDeleteException {
        TreRuleSet ruleSet = (TreRuleSet)this.entityManager.find(TreRuleSet.class, (Object)ruleSetId);
        if (ruleSet != null) {
            this.deleteRuleSet(ruleSet);
        }
    }

    public List<TreRuleSet> getRuleSetBySitePackage(Integer siteId, String packageName) {
        List<Integer> sites = this.getSitePaternity(siteId);
        String queryString = "SELECT tr FROM\t TrePackage p JOIN\t p.ruleSets tr JOIN\t tr.sites s WHERE p.name = :pname AND\t s.id in (:sites) order by tr.order_ ";
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("pname", (Object)packageName.toUpperCase());
        query.setParameter("sites", sites);
        List result = query.getResultList();
        return result;
    }

    public List<TreRuleSet> getRuleSetBySitePackageEvent(Integer siteId, String packageName, TreEvent event) {
        List<Integer> sites = this.getSitePaternity(siteId);
        String queryString = "SELECT tr FROM\tTreEventWrapper e JOIN\te.rules tr JOIN\t tr.sites s JOIN\ttr.tpackage p WHERE s.id in (:sites) AND\t p.name = :pname AND\te.name = :ename order by tr.order_ ";
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("sites", sites);
        query.setParameter("pname", (Object)packageName.toUpperCase());
        query.setParameter("ename", (Object)event.name());
        List result = query.getResultList();
        return result;
    }

    @TransactionAttribute
    public void disassociateRuleSetsSite(List<Integer> ruleSetIds, Integer siteId) throws RuleSetsNotAssocWSiteExpception, RuleSetsAssocWJobExpception {
        ArrayList<Integer> ruleSetsMissingSite = new ArrayList<Integer>();
        String queryString = "SELECT tr FROM\t TreRuleSet tr WHERE tr.ruleSetId in (:ruleSetIds)";
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("ruleSetIds", ruleSetIds);
        List ruleSets = query.getResultList();
        for (TreRuleSet ruleSet : ruleSets) {
            Iterator siteIterator = ruleSet.getSites().iterator();
            boolean foundSite = false;
            while (siteIterator.hasNext()) {
                Site s = (Site)siteIterator.next();
                if (!s.getId().equals(siteId)) continue;
                siteIterator.remove();
                foundSite = true;
                break;
            }
            if (foundSite) continue;
            ruleSetsMissingSite.add(ruleSet.getRuleSetId());
        }
        if (ruleSetsMissingSite.size() > 0) {
            throw new RuleSetsNotAssocWSiteExpception(ruleSetsMissingSite);
        }
        this.ruleCache.disassociateRuleSetsSite(ruleSetIds, siteId);
    }

    @TransactionAttribute
    public void dissociateFromSite(Integer siteId) {
        String queryString = "SELECT tr FROM\t TreRuleSet tr JOIN\t tr.sites s WHERE s.id = :siteId";
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("siteId", (Object)siteId);
        List result = query.getResultList();
        for (TreRuleSet tr : result) {
            Iterator sites = tr.getSites().iterator();
            while (sites.hasNext()) {
                if (!((Site)sites.next()).getId().equals(siteId)) continue;
                sites.remove();
            }
        }
        this.ruleCache.dissociateFromSite(siteId);
    }

    public List<ShallowRuleSet> getSchedulableRuleSets() {
        String queryString = "SELECT new com.tandbergtv.marvin.udt.ShallowRuleSet(tr.ruleSetId, tr.ruleName, p.name) FROM\tTreEventWrapper e JOIN\te.rules tr JOIN\ttr.tpackage p WHERE e.name = :ename AND tr.runOnGlobal = :runOnGlobal order by tr.order_ ";
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("ename", (Object)TreEvent.SCHEDULE.name());
        query.setParameter("runOnGlobal", (Object)true);
        List result = query.getResultList();
        return result;
    }

    public List<ShallowRuleSet> getSchedulableRuleSets(Integer siteId) {
        List<Integer> sites = this.getSitePaternity(siteId);
        String queryString = "SELECT new com.tandbergtv.marvin.udt.ShallowRuleSet(tr.ruleSetId, tr.ruleName, p.name) FROM\tTreEventWrapper e JOIN\te.rules tr JOIN\t tr.sites s JOIN\ttr.tpackage p WHERE e.name = :ename and  s.id in (:sites) order by tr.order_ ";
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("ename", (Object)TreEvent.SCHEDULE.name());
        query.setParameter("sites", sites);
        List result = query.getResultList();
        return result;
    }

    public List<TreRuleSet> getGlobalRuleSetsByPackage(String packageName) {
        String queryString = "SELECT tr FROM\t TrePackage p JOIN\t p.ruleSets tr WHERE  p.name = :pname AND tr.runOnGlobal = :runOnGlobal order by tr.order_";
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("pname", (Object)packageName.toUpperCase());
        query.setParameter("runOnGlobal", (Object)true);
        List result = query.getResultList();
        return result;
    }

    public List<TreRuleSet> getGlobalRSByPackAndEvnt(String packageName, String eventName) {
        String queryString = "SELECT tr FROM\tTreEventWrapper e JOIN\te.rules tr JOIN\ttr.tpackage p WHERE p.name = :pname AND tr.runOnGlobal = :runOnGlobal AND\te.name = :ename order by tr.order_ ";
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("pname", (Object)packageName.toUpperCase());
        query.setParameter("ename", (Object)eventName);
        query.setParameter("runOnGlobal", (Object)true);
        List result = query.getResultList();
        return result;
    }

    private List<Integer> getSitePaternity(int siteId) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(siteId);
        String queryString = "SELECT s FROM Site s WHERE id = :siteId";
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("siteId", (Object)siteId);
        Site site = (Site)query.getSingleResult();
        if (site.getSiteParents() != null) {
            this.recurseParents(site.getSiteParents(), result);
        }
        return result;
    }

    private void recurseParents(Collection<Site> sites, List<Integer> siteIds) {
        for (Site site : sites) {
            siteIds.add(site.getId());
            if (site.getSiteParents() == null) continue;
            this.recurseParents(site.getSiteParents(), siteIds);
        }
    }

    @TransactionAttribute
    public List<ShallowRuleSet> getAllRuleSetsBySite(Integer siteId) {
        String queryString = "SELECT new com.tandbergtv.marvin.udt.ShallowRuleSet(rs.ruleSetId, rs.ruleName, rs.tpackage.name) FROM\tTreRuleSet rs JOIN\t rs.sites s where  s.id = :siteId ";
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("siteId", (Object)siteId);
        List result = query.getResultList();
        return result;
    }

    @TransactionAttribute
    public TreRuleSet saveRuleSet(TreRuleSet ruleSet) {
        this.entityManager.flush();
        ScheduleRule scheduleRule = ruleSet.getScheduleRule();
        Integer ruleSetId = ruleSet.getRuleSetId();
        List jobs = this.scheduler.getJobsByAssociatedEntity(ASSOCIATED_ENTITY_TYPE_RULESET, (long)ruleSetId.intValue());
        Job ruleSetJob = new Job();
        if (scheduleRule != null) {
            if (jobs.size() > 0) {
                ruleSetJob.setId(((Job)jobs.get(0)).getId());
            }
            String associatedEntityType = ASSOCIATED_ENTITY_TYPE_RULESET;
            HashSet<Long> associatedEntities = new HashSet<Long>();
            associatedEntities.add(Long.valueOf(String.valueOf(ruleSetId)));
            ruleSetJob.setRule(scheduleRule);
            ruleSetJob.setAssociatedEntityType(associatedEntityType);
            ruleSetJob.setAssociatedEntities(associatedEntities);
            ruleSetJob.setCallbackClass(RuleSetSchedulerCallback.class);
            String ruleSetName = ruleSet.getRuleName();
            String jobName = JOB_PREFIX_RULESET + ruleSetName;
            String associationDescription = ASSOCIATION_DESCRIPTION_PREFIX_RULESET + ruleSetName;
            ruleSetJob.setName(jobName);
            ruleSetJob.setAssociationDescription(associationDescription);
            Job job = this.scheduler.schedule(ruleSetJob);
            if (job.isActive() != ruleSet.getEnabled().booleanValue()) {
                this.scheduler.setActive(job.getId().longValue(), ruleSet.getEnabled().booleanValue());
            }
        } else if (jobs.size() > 0) {
            ruleSetJob = (Job)jobs.get(0);
            Long ruleSetJobId = ruleSetJob.getId();
            this.scheduler.delete(ruleSetJobId.longValue());
        }
        this.ruleCache.saveRuleSet(ruleSet);
        return ruleSet;
    }

    @TransactionAttribute
    public TreRuleSet getRuleSetWithSchedule(int ruleSetId) {
        Query query = this.entityManager.createQuery("SELECT rs FROM\tTreRuleSet rs WHERE\truleSetId = :rsid");
        query.setParameter("rsid", (Object)ruleSetId);
        TreRuleSet result = this.getRuleSet(ruleSetId);
        ScheduleRule scheduleRule = this.getRuleSetScheduleRule(ruleSetId);
        result.setScheduleRule(scheduleRule);
        return result;
    }

    @TransactionAttribute
    public List<TreRuleSet> getRuleSetsWithSchedule(List<Integer> ruleSetIds) {
        List<TreRuleSet> ruleSets = this.getRuleSets(ruleSetIds);
        for (TreRuleSet ruleSet : ruleSets) {
            int ruleSetId = ruleSet.getRuleSetId();
            ScheduleRule scheduleRule = this.getRuleSetScheduleRule(ruleSetId);
            ruleSet.setScheduleRule(scheduleRule);
        }
        return ruleSets;
    }

    @TransactionAttribute
    public List<TreRuleSet> getRuleSetsByPackageWithSchedule(String packageName) {
        List<TreRuleSet> ruleSets = this.getRuleSetsByPackage(packageName);
        for (TreRuleSet ruleSet : ruleSets) {
            int ruleSetId = ruleSet.getRuleSetId();
            ScheduleRule scheduleRule = this.getRuleSetScheduleRule(ruleSetId);
            ruleSet.setScheduleRule(scheduleRule);
        }
        return ruleSets;
    }

    private ScheduleRule getRuleSetScheduleRule(int ruleSetId) {
        ScheduleRule scheduleRule = null;
        Job ruleSetJob = this.getRuleSetScheduleJob(ruleSetId);
        if (ruleSetJob != null) {
            scheduleRule = ruleSetJob.getRule();
        }
        return scheduleRule;
    }

    private Job getRuleSetScheduleJob(int ruleSetId) {
        Job job = null;
        List jobs = this.scheduler.getJobsByAssociatedEntity(ASSOCIATED_ENTITY_TYPE_RULESET, (long)ruleSetId);
        if (jobs.size() > 0) {
            job = (Job)jobs.get(0);
        }
        return job;
    }

    @TransactionAttribute
    public void setRuleSetsEnabled(List<Integer> ruleSetIds, boolean enabled) {
        List<TreRuleSet> ruleSets = this.getRuleSets(ruleSetIds);
        for (TreRuleSet rs : ruleSets) {
            rs.setEnabled(Boolean.valueOf(enabled));
            List jobs = this.scheduler.getJobsByAssociatedEntity(ASSOCIATED_ENTITY_TYPE_RULESET, (long)rs.getRuleSetId().intValue());
            if (jobs == null) continue;
            for (Job job : jobs) {
                if (enabled == job.isActive()) continue;
                this.scheduler.setActive(job.getId().longValue(), enabled);
            }
        }
        this.ruleCache.setRuleSetsEnabled(ruleSetIds, enabled);
    }

    @TransactionAttribute
    public Collection<ShallowRuleSet> getRuleSetsAssociatedMsos(Integer msoId) {
        Query query = this.entityManager.createQuery("SELECT new com.tandbergtv.marvin.udt.ShallowRuleSet(rs.ruleSetId, rs.ruleName, p.name)  FROM TreMsoOverrrideRuleSet rs   JOIN rs.msos m  JOIN rs.tpackage p  WHERE m.id = :msoId");
        query.setParameter("msoId", (Object)msoId);
        List result = query.getResultList();
        if (result != null) {
            return result;
        }
        return new ArrayList<ShallowRuleSet>(0);
    }

    @TransactionAttribute
    public void deleteMsoReference(Integer msoId) {
        Query query = this.entityManager.createNativeQuery("delete from TRE_RULESET_MSO where msoId = ?");
        query.setParameter(1, (Object)msoId);
        query.executeUpdate();
    }

    @TransactionAttribute
    public List<ShallowRuleSet> getShallowRuleSetsByPackage(String packageName) {
        String queryString = "SELECT new com.tandbergtv.marvin.udt.ShallowRuleSet(tr.ruleSetId, tr.ruleName, p.name) FROM\tTrePackage p JOIN\tp.ruleSets tr WHERE p.name = :pname order by tr.order_ ";
        Query query = this.entityManager.createQuery(queryString);
        query.setParameter("pname", (Object)packageName);
        List result = query.getResultList();
        return result;
    }
}

