/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.services.customrules;

import com.tandbergtv.cms.rules.customrules.CustomRule;
import com.tandbergtv.marvin.services.customrules.CustomRuleLoadException;
import com.tandbergtv.marvin.services.customrules.RuleNotFoundException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CustomRuleProvider {
    private static final Logger logger = Logger.getLogger(CustomRuleProvider.class);
    private static final String NORMALIZATION_RULES_CFG = "RULES-INF/com.tandbergtv.cms.rules.customrules.CustomNormalizationRule";
    private static final String VALIDATION_RULES_CFG = "RULES-INF/com.tandbergtv.cms.rules.customrules.CustomValidationRule";
    public static final String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    public static final String PLUGIN_FOLDER_RELATIVE_PATH = "plugins" + File.separator + "rules";
    private static final CustomRuleProvider instance = new CustomRuleProvider();
    private List<CustomRule> customValidationRules;
    private List<CustomRule> customNormalizationRules;
    private Map<String, CustomRule> customRules;

    private CustomRuleProvider() {
        this.loadCustomRules();
    }

    public static synchronized CustomRuleProvider getInstance() {
        return instance;
    }

    public List<CustomRule> getCustomRules(String packageName) throws CustomRuleLoadException {
        if (packageName.equalsIgnoreCase("VALIDATION")) {
            return this.customValidationRules;
        }
        if (packageName.equalsIgnoreCase("NORMALIZATION")) {
            return this.customNormalizationRules;
        }
        throw new CustomRuleLoadException("unrecognized packageName: " + packageName);
    }

    public CustomRule getCustomRuleInstance(String className) throws RuleNotFoundException, CustomRuleLoadException {
        CustomRule cr = this.customRules.get(className);
        if (cr == null) {
            throw new RuleNotFoundException();
        }
        return cr;
    }

    private void loadCustomRules() {
        File[] jars;
        this.customValidationRules = new ArrayList<CustomRule>();
        this.customNormalizationRules = new ArrayList<CustomRule>();
        this.customRules = new HashMap<String, CustomRule>();
        String installFolder = System.getProperty(PRODUCT_DIR);
        File pluginDir = new File(installFolder + File.separator + PLUGIN_FOLDER_RELATIVE_PATH);
        if (!pluginDir.exists()) {
            return;
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        };
        for (File jar : jars = pluginDir.listFiles(filter)) {
            try {
                URL url = jar.toURL();
                this.addURL(url, this.customValidationRules, VALIDATION_RULES_CFG);
                this.addURL(url, this.customNormalizationRules, NORMALIZATION_RULES_CFG);
            }
            catch (Exception e) {
                logger.error((Object)("Error while loading custom rules for jar: " + jar.getName()), (Throwable)e);
            }
        }
    }

    private void addURL(URL u, List<CustomRule> cache, String lookupFile) throws IOException {
        URL[] urls = new URL[]{u};
        URLClassLoader aUrlCL = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        try {
            InputStream validationStream = aUrlCL.getResource(lookupFile).openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(validationStream));
            String currLine = br.readLine();
            while (currLine != null) {
                try {
                    Class<?> c = aUrlCL.loadClass(currLine);
                    if (this.customRules.containsKey(currLine)) {
                        logger.error((Object)("ENCOUTERED A CUSTOM RULE COLLISION FOR CUSTOM RULE: " + currLine));
                    } else {
                        CustomRule cr = (CustomRule)c.newInstance();
                        cache.add(cr);
                        this.customRules.put(currLine, cr);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Error while loading custom rule: " + currLine), (Throwable)e);
                }
                currLine = br.readLine();
            }
        }
        catch (IOException e) {
            logger.warn((Object)("Lookup file not provided: " + lookupFile), (Throwable)e);
        }
    }
}

