/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduler;

import com.ericsson.cms.scheduler.IScheduler;
import com.ericsson.cms.scheduler.InvalidScheduleException;
import com.ericsson.cms.scheduler.ScheduleTime;
import com.ericsson.cms.scheduler.SchedulerException;
import com.ericsson.cms.scheduler.conf.SchedulerPropertiesReader;
import com.ericsson.cms.scheduler.entities.FutureExecution;
import com.ericsson.cms.scheduler.entities.Job;
import com.ericsson.cms.scheduler.entities.PastExecution;
import com.ericsson.cms.scheduler.entities.ScheduleRule;
import com.ericsson.cms.scheduler.entities.ScheduleRuleParameter;
import com.ericsson.cms.scheduler.quartz.IQuartzScheduler;
import com.ericsson.cms.scheduler.timers.Daily;
import com.ericsson.cms.scheduler.timers.EveryNDays;
import com.ericsson.cms.scheduler.timers.OnDate;
import com.ericsson.cms.scheduler.timers.OnDayEveryNWeeks;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;

@Stateless
@TransactionAttribute
public class Scheduler
implements IScheduler {
    private static final Logger logger = Logger.getLogger(Scheduler.class);
    private static final String JOB_ASSOCIATED_ENTITY_TYPE_SELF_PARTNER = PartnerType.SELF.name();
    private static final String JOB_ASSOCIATED_ENTITY_TYPE_SOURCE_PARTNER = PartnerType.SOURCE.name();

    public Job get(long id) {
        Job job = this.getInternal(id);
        boolean isUserAccessibleJob = this.isUserAccessibleJob(job);
        if (!isUserAccessibleJob) {
            throw new SchedulerException("Job with id: " + id + " is not accessible to the currently logged in user.");
        }
        return job;
    }

    public Job getInternal(long id) {
        Job job = (Job)this.getSession().get(Job.class, (Serializable)Long.valueOf(id));
        if (job == null) {
            throw new SchedulerException("No job with id: " + id + " found.");
        }
        return job;
    }

    public Job getJobByJobName(String jobName) {
        Job job = null;
        List<Object> jobs = new ArrayList();
        jobs = this.getJobsByJobNameInternal(jobName);
        if (!jobs.isEmpty()) {
            jobs = this.filterJobsByAssociatedPartner(jobs);
        }
        if (!jobs.isEmpty()) {
            job = (Job)jobs.get(0);
        }
        return job;
    }

    public List<Job> getAllJobs() {
        String queryStr = "from Job";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        return this.filterJobsByAssociatedPartner(query.list());
    }

    public List<Job> getAllActiveJobs() {
        String queryStr = "from Job where active = true";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        return this.filterJobsByAssociatedPartner(query.list());
    }

    public List<Job> getJobsByAssociatedEntityType(String entityType) {
        String queryStr = "from Job where associatedEntityType = :entityType";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("entityType", (Object)entityType);
        List<Job> jobs = query.list();
        if (JOB_ASSOCIATED_ENTITY_TYPE_SELF_PARTNER.equals(entityType) || JOB_ASSOCIATED_ENTITY_TYPE_SOURCE_PARTNER.equals(entityType)) {
            jobs = this.filterJobsByAssociatedPartner(jobs);
        }
        return jobs;
    }

    public List<Job> getJobsByAssociatedEntity(String entityType, long entityId) {
        String queryStr = "from Job where associatedEntityType = :entityType and :entityId in elements(associatedEntities)";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("entityType", (Object)entityType);
        query.setParameter("entityId", (Object)entityId);
        List<Job> jobs = query.list();
        if (JOB_ASSOCIATED_ENTITY_TYPE_SELF_PARTNER.equals(entityType) || JOB_ASSOCIATED_ENTITY_TYPE_SOURCE_PARTNER.equals(entityType)) {
            jobs = this.filterJobsByAssociatedPartner(jobs);
        }
        return jobs;
    }

    public Job schedule(Job job) {
        if (job == null) {
            throw new SchedulerException("Cannot schedule a 'null' job.");
        }
        boolean isUserAccessibleJob = this.isUserAccessibleJob(job);
        if (!isUserAccessibleJob) {
            throw new SchedulerException("Job: " + job + " is not accessible to the currently logged in user.");
        }
        if (job.getId() == null) {
            return this.createSchedule(job);
        }
        return this.updateSchedule(job);
    }

    private Job createSchedule(Job job) {
        job.setActive(true);
        ScheduleTime time = this.getScheduleTime(job.getRule());
        Map<String, String> validationMessages = this.validateScheduleTime(time, job.getRule());
        if (!validationMessages.isEmpty()) {
            throw new InvalidScheduleException(validationMessages);
        }
        if (job.getRule().getStartDate() == null) {
            job.getRule().setStartDate(time.getStartDate());
        }
        this.getSession().saveOrUpdate((Object)job);
        this.getQuartzScheduler().schedule(job.getId(), time);
        return job;
    }

    private Job updateSchedule(Job job) {
        Job dbJob = this.get(job.getId());
        this.overwrite(job, dbJob);
        ScheduleTime time = this.getScheduleTime(dbJob.getRule());
        Map<String, String> validationMessages = this.validateScheduleTime(time, dbJob.getRule());
        if (!validationMessages.isEmpty()) {
            throw new InvalidScheduleException(validationMessages);
        }
        if (dbJob.getRule().getStartDate() == null) {
            dbJob.getRule().setStartDate(time.getStartDate());
        }
        this.getSession().saveOrUpdate((Object)dbJob);
        logger.info((Object)("Setting past executions of job: " + dbJob + " as stale"));
        this.markPastExecutionsStale(dbJob.getId());
        this.getQuartzScheduler().updateSchedule(dbJob.getId(), time);
        return dbJob;
    }

    private void overwrite(Job fj, Job tj) {
        tj.setName(fj.getName());
        tj.setAssociatedEntityType(fj.getAssociatedEntityType());
        tj.setAssociatedEntities(fj.getAssociatedEntities());
        tj.setAssociationDescription(fj.getAssociationDescription());
        tj.setCallbackClass(fj.getCallbackClass());
        this.overwrite(fj.getRule(), tj.getRule());
    }

    private void overwrite(ScheduleRule fr, ScheduleRule tr) {
        tr.setStartDate(fr.getStartDate());
        tr.setEndDate(fr.getEndDate());
        tr.setType(fr.getType());
        tr.getParams().clear();
        tr.getParams().addAll(fr.getParams());
        for (ScheduleRuleParameter ruleParam : tr.getParams()) {
            ruleParam.setRule(tr);
        }
    }

    private void markPastExecutionsStale(long jobId) {
        String queryStr = "update PastExecution set stale = true where job.id = :jobId and stale = false";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setLong("jobId", jobId);
        query.executeUpdate();
    }

    public void setActive(long id, boolean active) {
        Job job = this.get(id);
        if (job.isActive() == active) {
            throw new SchedulerException("Job is already " + (active ? "active" : "inactive"));
        }
        job.setActive(active);
        this.getSession().saveOrUpdate((Object)job);
    }

    public void dissociate(long jobId, long entityId) {
        Job job = this.get(jobId);
        boolean found = job.getAssociatedEntities().remove(entityId);
        if (!found) {
            throw new SchedulerException("The Schedule is not associated with the given entity");
        }
        this.getSession().saveOrUpdate((Object)job);
    }

    public void delete(long id) {
        Job job = this.get(id);
        this.getQuartzScheduler().deleteSchedule(id);
        List<PastExecution> associatedPastExecutions = this.getPastExecutions(job.getId());
        if (associatedPastExecutions != null) {
            for (PastExecution pe : associatedPastExecutions) {
                this.getSession().delete((Object)pe);
            }
        }
        this.getSession().delete((Object)job);
    }

    public void runNow(long id) {
        Job job = this.get(id);
        if (!job.isActive()) {
            throw new SchedulerException("Cannot run the job. Job is inactive.");
        }
        logger.info((Object)("Run Now requested for job: " + id));
        this.getQuartzScheduler().runNow(id);
    }

    private List<PastExecution> getPastExecutions(long jobId) {
        Job job = this.get(jobId);
        String queryStr = "from PastExecution where job.id = :jobId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setLong("jobId", jobId);
        return query.list();
    }

    public List<PastExecution> getPastExecutions(int numHours) {
        Date afterDate = this.subtract(new Date(), numHours);
        String queryStr = "from PastExecution where executionTime >= :executionTime order by executionTime desc";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setTimestamp("executionTime", afterDate);
        return this.filterPastExecutionsByAssociatedPartner(query.list());
    }

    public List<FutureExecution> getFutureExecutions(int numHours) {
        ArrayList<FutureExecution> executions = new ArrayList<FutureExecution>();
        Date afterDate = new Date();
        List<Job> activeJobs = this.getAllActiveJobs();
        if (activeJobs != null) {
            for (Job job : activeJobs) {
                executions.addAll(this.getFutureExecutions(job, afterDate, numHours));
            }
        }
        Collections.sort(executions, new Comparator<FutureExecution>(){

            @Override
            public int compare(FutureExecution o1, FutureExecution o2) {
                return o1.getExecutionTime().compareTo(o2.getExecutionTime());
            }
        });
        return executions;
    }

    public List<FutureExecution> getNFutureExecutions(int count) {
        List<Object> executions = new ArrayList<FutureExecution>();
        int lookupPeriodDays = SchedulerPropertiesReader.getLookupPeriodDays();
        int maxLookups = SchedulerPropertiesReader.getMaxLookups();
        int periodHours = 24 * lookupPeriodDays;
        int m = 1;
        while (executions.size() < count && m <= maxLookups) {
            executions = this.getFutureExecutions(periodHours * m++);
            Iterator<FutureExecution> eIterator = executions.iterator();
            while (eIterator.hasNext()) {
                FutureExecution execution = eIterator.next();
                if (execution.isEnabled()) continue;
                eIterator.remove();
            }
        }
        int numExecutions = executions.size();
        if (numExecutions > count) {
            executions = executions.subList(0, count);
        }
        return executions;
    }

    public void setFutureExecutionEnabled(long jobId, Date execDate, boolean enabled) {
        Job job = this.get(jobId);
        Set disabledTimes = job.getDisabledTimes();
        long execTime = execDate.getTime();
        if (enabled) {
            if (disabledTimes.contains(execTime)) {
                disabledTimes.remove(execTime);
            }
        } else {
            disabledTimes.add(execTime);
        }
    }

    public List<String> getJobsSchRuleParamValueUsage(String schRuleParamValue) {
        String queryStr = "select distinct job.name from Job job where job.rule in (select schRuleParam.rule from ScheduleRuleParameter schRuleParam where schRuleParam.value = :schRuleParamValue)";
        logger.debug((Object)("queryStr: " + queryStr));
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("schRuleParamValue", (Object)schRuleParamValue);
        return query.list();
    }

    private List<FutureExecution> getFutureExecutions(Job job, Date afterDate, int numHours) {
        ArrayList<FutureExecution> executions = new ArrayList<FutureExecution>();
        logger.debug((Object)("Getting future executions for job: " + job + ", afterDate: " + afterDate + ", numHours: " + numHours));
        if (job != null) {
            boolean isUserAccessibleJob = this.isUserAccessibleJob(job);
            if (!isUserAccessibleJob) {
                throw new SchedulerException("Job: " + job + " is not accessible to the currently logged in user.");
            }
            List<Date> execTimes = this.getQuartzScheduler().getFutureExecutions(job.getId(), afterDate, numHours);
            for (Date execTime : execTimes) {
                long execTimeLong;
                FutureExecution futureExecution = new FutureExecution(job, execTime);
                executions.add(futureExecution);
                Set disabledTimes = job.getDisabledTimes();
                if (!disabledTimes.contains(execTimeLong = execTime.getTime())) continue;
                futureExecution.setEnabled(false);
            }
        }
        logger.debug((Object)("Retrieved " + executions.size() + " future executions for job: " + job + ", afterDate: " + afterDate + ", numHours: " + numHours));
        return executions;
    }

    private List<Job> getJobsByJobNameInternal(String jobName) {
        ArrayList<Job> jobs = new ArrayList();
        String queryStr = "from Job where name = :jobName";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("jobName", (Object)jobName);
        jobs = query.list();
        return jobs;
    }

    private List<Job> filterJobsByAssociatedPartner(List<Job> jobs) {
        ArrayList<Job> filteredJobs = new ArrayList<Job>();
        IPartnerManagement partnerManager = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
        List partners = partnerManager.getAllActivePartnerDTOsForCurrentUser();
        boolean hasSelfPartner = false;
        HashSet<Long> sourcePartnerIds = new HashSet<Long>();
        for (Partner partner : partners) {
            PartnerType partnerType = partner.getType();
            if (PartnerType.SELF.equals((Object)partnerType)) {
                hasSelfPartner = true;
                break;
            }
            if (!PartnerType.SOURCE.equals((Object)partnerType)) continue;
            sourcePartnerIds.add(partner.getId());
        }
        if (hasSelfPartner) {
            filteredJobs.addAll(jobs);
        } else {
            for (Job job : jobs) {
                boolean isUserAccessibleJob = this.isUserAccessibleJob(job, sourcePartnerIds);
                if (!isUserAccessibleJob) continue;
                filteredJobs.add(job);
            }
        }
        return filteredJobs;
    }

    private List<PastExecution> filterPastExecutionsByAssociatedPartner(List<PastExecution> pastExecutions) {
        ArrayList<PastExecution> filteredPastExecutions = new ArrayList<PastExecution>();
        IPartnerManagement partnerManager = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
        List partners = partnerManager.getAllActivePartnerDTOsForCurrentUser();
        boolean hasSelfPartner = false;
        HashSet<Long> sourcePartnerIds = new HashSet<Long>();
        for (Partner partner : partners) {
            PartnerType partnerType = partner.getType();
            if (PartnerType.SELF.equals((Object)partnerType)) {
                hasSelfPartner = true;
                break;
            }
            if (!PartnerType.SOURCE.equals((Object)partnerType)) continue;
            sourcePartnerIds.add(partner.getId());
        }
        if (hasSelfPartner) {
            filteredPastExecutions.addAll(pastExecutions);
        } else {
            for (PastExecution pastExecution : pastExecutions) {
                Job job = pastExecution.getJob();
                boolean isUserAccessibleJob = this.isUserAccessibleJob(job, sourcePartnerIds);
                if (!isUserAccessibleJob) continue;
                filteredPastExecutions.add(pastExecution);
            }
        }
        return filteredPastExecutions;
    }

    private boolean isUserAccessibleJob(Job job) {
        String associatedEntityType;
        boolean isUserAccessibleJob = false;
        if (job != null && (associatedEntityType = job.getAssociatedEntityType()) != null) {
            IPartnerManagement partnerManager = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
            List partners = partnerManager.getAllActivePartnerDTOsForCurrentUser();
            boolean hasSelfPartner = false;
            HashSet<Long> sourcePartnerIds = new HashSet<Long>();
            for (Partner partner : partners) {
                PartnerType partnerType = partner.getType();
                if (PartnerType.SELF.equals((Object)partnerType)) {
                    hasSelfPartner = true;
                    break;
                }
                if (!PartnerType.SOURCE.equals((Object)partnerType)) continue;
                sourcePartnerIds.add(partner.getId());
            }
            Session session = HibernateContext.getContext().getCurrentSession();
            for (Partner partner : partners) {
                session.evict((Object)partner);
            }
            isUserAccessibleJob = hasSelfPartner ? true : this.isUserAccessibleJob(job, sourcePartnerIds);
        }
        return isUserAccessibleJob;
    }

    private boolean isUserAccessibleJob(Job job, Collection<Long> sourcePartnerIds) {
        String associatedEntityType;
        boolean isUserAccessibleJob = false;
        if (job != null && (associatedEntityType = job.getAssociatedEntityType()) != null && !JOB_ASSOCIATED_ENTITY_TYPE_SELF_PARTNER.equals(associatedEntityType)) {
            if (JOB_ASSOCIATED_ENTITY_TYPE_SOURCE_PARTNER.equals(associatedEntityType)) {
                boolean isSourcePartnerAssociated;
                Set associatedSourcePartnerIds = job.getAssociatedEntities();
                boolean bl = isSourcePartnerAssociated = !Collections.disjoint(sourcePartnerIds, associatedSourcePartnerIds);
                if (isSourcePartnerAssociated) {
                    isUserAccessibleJob = true;
                }
            } else {
                isUserAccessibleJob = true;
            }
        }
        return isUserAccessibleJob;
    }

    private ScheduleTime getScheduleTime(ScheduleRule rule) {
        switch (rule.getType()) {
            case ON_DATE: {
                return OnDate.getTime(rule);
            }
            case EVERY_N_DAYS: {
                return EveryNDays.getTime(rule);
            }
            case ON_DAY_EVERY_N_WEEKS: {
                return OnDayEveryNWeeks.getTime(rule);
            }
            case N_DAYS_FROM_METADATA: {
                return Daily.getTime(rule);
            }
        }
        throw new SchedulerException("Unknown Schedule Rule Type: " + rule.getType());
    }

    private Map<String, String> validateScheduleTime(ScheduleTime scheduleTime, ScheduleRule scheduleRule) {
        HashMap<String, String> validationMessages = new HashMap<String, String>();
        String invalidScheduleErrCode = "errInvalidSchedule";
        String invalidScheduleMessage = "Invalid schedule provided.";
        if (scheduleTime != null) {
            Date startDate = scheduleTime.getStartDate();
            Date endDate = scheduleTime.getEndDate();
            Date now = new Date();
            if (startDate.before(now) || endDate != null && endDate.before(startDate)) {
                validationMessages.put(invalidScheduleErrCode, invalidScheduleMessage);
            }
        } else {
            validationMessages.put(invalidScheduleErrCode, invalidScheduleMessage);
        }
        return validationMessages;
    }

    private Date subtract(Date date, int numHours) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(10, -numHours);
        return cal.getTime();
    }

    private IQuartzScheduler getQuartzScheduler() {
        try {
            return (IQuartzScheduler)new InitialContext().lookup("/cms/QuartzScheduler/local");
        }
        catch (Exception ex) {
            throw new SchedulerException("Cannot obtain IQuartzScheduler bean", (Throwable)ex);
        }
    }

    private Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }
}

