/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduler;

import com.ericsson.cms.scheduler.Node;
import com.tandbergtv.watchpoint.pmm.title.conf.ComplexVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.CustomField;
import com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.SimpleVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.List;

public class TitleMetadataOptionProvider {
    public Node getJobParameterMenuOptions() {
        ISpecificationManager specMgr = (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);
        UISpecification s = specMgr.getUISpecification(UISpecification.Type.PACKAGE);
        Node rootNode = new Node("Title Metadata", "Title Metadata");
        rootNode.addChild(TitleMetadataOptionProvider.convertTitleConf(s.getRootTitleConf(), true));
        return rootNode;
    }

    private static Node convertTitleConf(TitleConf tc, boolean isJobParameter) {
        Node group = TitleMetadataOptionProvider.createGroup(tc, isJobParameter);
        for (TitleConf childTc : tc.getChildren()) {
            Node childGroup = TitleMetadataOptionProvider.convertTitleConf(childTc, isJobParameter);
            if (childGroup.getChildren().isEmpty()) continue;
            group.addChild(childGroup);
        }
        return group;
    }

    private static Node createGroup(TitleConf tc, boolean isJobParameter) {
        Node group = new Node();
        group.setName(tc.getName());
        group.setDisplayName(tc.getAlias());
        List<Variable> fields = TitleMetadataOptionProvider.getMetadataFields(tc);
        List<Node> items = TitleMetadataOptionProvider.filterJobVariable(fields, isJobParameter);
        group.setChildren(items);
        return group;
    }

    private static List<Variable> getMetadataFields(TitleConf tc) {
        ArrayList<Variable> fields = new ArrayList<Variable>();
        for (Variable v : tc.getMetadata()) {
            if (v instanceof ComplexVariable && TitleMetadataOptionProvider.isCustomFieldGroup((ComplexVariable)v)) continue;
            fields.add(v);
        }
        for (CustomFieldGroup g : tc.getTitleConfMetadata().customFields.getGroups()) {
            ComplexVariable grp = new ComplexVariable();
            grp.setDisplayName(g.displayName);
            grp.setName(g.displayName);
            grp.setXPath("/CustomFields");
            ArrayList<Variable> cfFields = new ArrayList<Variable>();
            for (CustomField cf : g.fields) {
                cfFields.add(tc.createCustomFieldVar(cf));
            }
            grp.setChildren(cfFields);
            fields.add((Variable)grp);
        }
        return fields;
    }

    private static List<Node> filterJobVariable(List<Variable> vars, boolean isJobParameter) {
        ArrayList<Node> items = new ArrayList<Node>();
        for (Variable v : vars) {
            List<Node> variableChildItems;
            if (v instanceof SimpleVariable) {
                if (isJobParameter) {
                    if (!((SimpleVariable)v).isJobParameter()) continue;
                    items.add(TitleMetadataOptionProvider.createItem(v));
                    continue;
                }
                if (!((SimpleVariable)v).isJobRuleParameter()) continue;
                items.add(TitleMetadataOptionProvider.createItem(v));
                continue;
            }
            if (!(v instanceof ComplexVariable) || (variableChildItems = TitleMetadataOptionProvider.filterJobVariable(((ComplexVariable)v).getChildren(), isJobParameter)).isEmpty()) continue;
            Node variableGroup = new Node();
            if (variableChildItems.size() == 1 && TitleMetadataOptionProvider.isCustomField((ComplexVariable)v)) {
                items.add(variableChildItems.get(0));
                continue;
            }
            variableGroup.setDisplayName(v.getDisplayName());
            variableGroup.setName(null);
            variableGroup.setChildren(variableChildItems);
            items.add(variableGroup);
        }
        return items;
    }

    private static Node createItem(Variable v) {
        Node item = new Node();
        item.setDisplayName(v.getDisplayName());
        item.setName(v.getXPath());
        return item;
    }

    private static boolean isCustomFieldGroup(ComplexVariable v) {
        return v.getXPath().contains("/CustomFields");
    }

    private static boolean isCustomField(ComplexVariable v) {
        return v.getXPath().contains("/CustomField[");
    }
}

