/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduler.authorization;

import com.ericsson.cms.scheduler.authorization.ISchedulerLicenseManager;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import com.tandbergtv.neptune.util.InjectionUtil;
import javax.ejb.Stateless;

@Stateless
public class SchedulerLicenseManager
implements ISchedulerLicenseManager {
    private static final String SCHEDULER_LICENSE_KEY = "SchedulerLicense";
    private static final String RCS_ONLY_LICENSE = "IsRCSOnly";
    private ILicenseManager neptuneLicenseManager = (ILicenseManager)InjectionUtil.injectInstance((String)"cms/LicenseManager/local", ILicenseManager.class);

    public boolean isLicensed() throws InvalidLicenseException {
        String value = this.neptuneLicenseManager.getProperty(SCHEDULER_LICENSE_KEY);
        if (value == null || value.trim().isEmpty()) {
            return true;
        }
        return Boolean.parseBoolean(value) && !this.isRCSOnlyDeployment();
    }

    private boolean isRCSOnlyDeployment() {
        String value = "false";
        try {
            value = this.neptuneLicenseManager.getProperty(RCS_ONLY_LICENSE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value == null || value.trim().isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }
}

