/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduler.quartz;

import com.ericsson.cms.scheduler.IScheduler;
import com.ericsson.cms.scheduler.IWOScheduler;
import com.ericsson.cms.scheduler.ScheduleTime;
import com.ericsson.cms.scheduler.authorization.ISchedulerLicenseManager;
import com.ericsson.cms.scheduler.quartz.IQuartzScheduler;
import com.ericsson.cms.scheduler.quartz.MissedTriggerListener;
import com.ericsson.cms.scheduler.quartz.QuartzCallback;
import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.ejb.EJB;
import org.apache.log4j.Logger;
import org.jboss.ejb3.annotation.Depends;
import org.jboss.ejb3.annotation.Service;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.impl.StdSchedulerFactory;

@Service(objectName="Scheduler:service=com.ericsson.cms.scheduler.quartz.QuartzScheduler")
@Depends(value={"ContentManagement:service=com.tandbergtv.cms.contentmgmt.activation.IServiceActivator"})
public class QuartzScheduler
implements IQuartzScheduler {
    private static final Logger logger = Logger.getLogger(QuartzScheduler.class);
    private static final String JOB_GROUP_NAME = "CMS";
    private static final String TRIGGER_GROUP_NAME = "CMS";
    private static final String TRIGGER_PREFIX = "TRIGGER_";
    private static final String RUN_NOW_TRIGGER_PREFIX = "RUNNOW_TRIGGER_";
    private static final String JOB_PROPERTIES_FILENAME = "com/ericsson/cms/scheduler/quartz/job.quartz.properties";
    private Scheduler scheduler;
    private boolean isStarted;
    @EJB
    private IScheduler s;
    @EJB
    private IWOScheduler wos;
    @EJB
    private ISchedulerLicenseManager schedulerLicenseManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.isSchedulerLicensed()) {
            QuartzScheduler quartzScheduler = this;
            synchronized (quartzScheduler) {
                if (this.isStarted) {
                    return;
                }
                this.isStarted = true;
            }
            try {
                StdSchedulerFactory sf = new StdSchedulerFactory(JOB_PROPERTIES_FILENAME);
                this.scheduler = sf.getScheduler();
            }
            catch (SchedulerException e) {
                throw new RuntimeException("Error while getting/starting com.ericsson.cms.scheduler: ", e);
            }
            if (this.scheduler == null) {
                String errorMsg = "Could not get com.ericsson.cms.scheduler from quartz com.ericsson.cms.scheduler factory.";
                throw new RuntimeException(errorMsg);
            }
            logger.debug((Object)"Will start the com.ericsson.cms.scheduler");
            Executors.newScheduledThreadPool(1).schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (QuartzScheduler.this.scheduler.getTriggerListener(MissedTriggerListener.NAME) == null) {
                            MissedTriggerListener triggerListener = new MissedTriggerListener();
                            QuartzScheduler.this.scheduler.addTriggerListener((TriggerListener)triggerListener);
                        }
                        QuartzScheduler.this.scheduler.start();
                        logger.debug((Object)"There you go. Started the Quartz standard com.ericsson.cms.scheduler.");
                    }
                    catch (SchedulerException e) {
                        logger.error((Object)"Exception while starting the quartz scheduler", (Throwable)e);
                    }
                }
            }, 1L, TimeUnit.MINUTES);
        } else {
            logger.info((Object)"Scheduler component is not licensed. QuartzScheduler will not start.");
        }
    }

    @Override
    public void stop() {
        try {
            if (this.scheduler != null) {
                this.scheduler.shutdown(true);
                this.scheduler = null;
            }
        }
        catch (SchedulerException e) {
            logger.error((Object)("Failure stopping quartz scheduler, error: " + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    @Override
    public void schedule(long jobId, ScheduleTime time) {
        if (this.isSchedulerLicensed()) {
            String jobName = String.valueOf(jobId);
            try {
                SimpleTrigger trigger;
                JobDetail jobDetail = new JobDetail(jobName, "CMS", QuartzCallback.class);
                jobDetail.setDurability(true);
                jobDetail.setRequestsRecovery(true);
                jobDetail.setVolatility(true);
                String triggerName = TRIGGER_PREFIX + jobName;
                if (time.isPeriodic()) {
                    logger.debug((Object)("Setting a periodic job starting at: " + time.getStartDate() + " every " + time.getRepeatInterval() + " msec."));
                    trigger = new SimpleTrigger(triggerName, "CMS", jobName, "CMS", time.getStartDate(), time.getEndDate(), SimpleTrigger.REPEAT_INDEFINITELY, time.getRepeatInterval());
                } else {
                    logger.debug((Object)("Setting a one time job for date: " + time.getStartDate()));
                    trigger = new SimpleTrigger(triggerName, "CMS", time.getStartDate());
                    trigger.setJobName(jobName);
                    trigger.setJobGroup("CMS");
                }
                trigger.setMisfireInstruction(4);
                trigger.setVolatility(true);
                trigger.addTriggerListener(MissedTriggerListener.NAME);
                this.scheduler.addJob(jobDetail, true);
                this.scheduler.scheduleJob((Trigger)trigger);
                logger.debug((Object)("Done scheduling job: " + jobDetail.getName()));
            }
            catch (Exception e) {
                throw new RuntimeException("Error while scheduling: " + jobName + ":", e);
            }
        } else {
            logger.info((Object)"Scheduler component is not licensed. Cannot schedule job.");
        }
    }

    @Override
    public void deleteSchedule(long jobId) {
        if (this.isSchedulerLicensed()) {
            String jobName = String.valueOf(jobId);
            try {
                if (this.scheduler.getJobDetail(jobName, "CMS") == null) {
                    String errorMsg = "Scheduler did not find job: " + jobName + " hence cannot delete it.";
                    throw new RuntimeException(errorMsg);
                }
                this.scheduler.deleteJob(jobName, "CMS");
                logger.debug((Object)("Done deleting job: " + jobName));
            }
            catch (SchedulerException e) {
                throw new RuntimeException("Error while deleting job: " + jobName + ":", e);
            }
        } else {
            logger.info((Object)"Scheduler component is not licensed. Cannot delete job.");
        }
    }

    @Override
    public void updateSchedule(long jobId, ScheduleTime time) {
        if (this.isSchedulerLicensed()) {
            try {
                this.deleteSchedule(jobId);
                this.schedule(jobId, time);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while updating job schedule: ", e);
            }
        } else {
            logger.info((Object)"Scheduler component is not licensed. Cannot update job.");
        }
    }

    @Override
    public void runNow(long jobId) {
        if (!this.isSchedulerLicensed()) {
            logger.info((Object)"Scheduler component is not licensed. Cannot run job.");
            return;
        }
        String jobName = String.valueOf(jobId);
        SimpleTrigger trigger = new SimpleTrigger(RUN_NOW_TRIGGER_PREFIX + jobName, "CMS", new Date());
        trigger.setJobName(jobName);
        trigger.setJobGroup("CMS");
        trigger.setMisfireInstruction(4);
        trigger.setVolatility(true);
        trigger.addTriggerListener(MissedTriggerListener.NAME);
        try {
            this.scheduler.scheduleJob((Trigger)trigger);
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Error while scheduling run now trigger for job: " + jobName, e);
        }
    }

    @Override
    public List<Date> getFutureExecutions(long jobId, Date afterDate, int numHours) {
        ArrayList<Date> fireTimes = new ArrayList<Date>();
        if (this.isSchedulerLicensed()) {
            String jobName = String.valueOf(jobId);
            try {
                JobDetail jobDetail = this.scheduler.getJobDetail(jobName, "CMS");
                if (jobDetail != null) {
                    Date fireTime;
                    String triggerName = TRIGGER_PREFIX + jobName;
                    Trigger trigger = this.scheduler.getTrigger(triggerName, "CMS");
                    if (trigger == null) {
                        return fireTimes;
                    }
                    Date endDate = this.add(afterDate, numHours);
                    while ((fireTime = trigger.getFireTimeAfter(afterDate)) != null && !fireTime.after(endDate)) {
                        fireTimes.add(fireTime);
                        afterDate = fireTime;
                    }
                    return fireTimes;
                }
                String errorMsg = "Scheduler did not find job: " + jobName;
                throw new RuntimeException(errorMsg);
            }
            catch (SchedulerException e) {
                throw new RuntimeException("Error while getting future executions of job: " + jobName + ":", e);
            }
        }
        logger.info((Object)"Scheduler component is not licensed. QuartzScheduler will not start.");
        return fireTimes;
    }

    private Date add(Date date, int numHours) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(10, numHours);
        return cal.getTime();
    }

    private boolean isSchedulerLicensed() {
        boolean isSchedulerLicensed = false;
        try {
            isSchedulerLicensed = this.schedulerLicenseManager.isLicensed();
        }
        catch (InvalidLicenseException ile) {
            String errMsg = "Exception occurred getting Scheduler License : " + (Object)((Object)ile);
            logger.error((Object)errMsg, (Throwable)ile);
            throw new RuntimeException(errMsg, ile);
        }
        return isSchedulerLicensed;
    }
}

