/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduler.timers;

import com.ericsson.cms.scheduler.InvalidScheduleException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class TimerHelper {
    private static final String DEFAULT_TIME = "12:00 am";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd h:mm a");

    public static Date getStartDateTime(Date date, String time) throws InvalidScheduleException {
        if (time == null || time.trim().length() < 0) {
            time = DEFAULT_TIME;
        }
        String dateStr = DATE_FORMAT.format(date);
        String dateTimeStr = dateStr + " " + time;
        try {
            return DATE_TIME_FORMAT.parse(dateTimeStr);
        }
        catch (ParseException e) {
            HashMap<String, String> reasons = new HashMap<String, String>();
            reasons.put("errInvalidSchedule", "Invalid schedule provided.");
            throw new InvalidScheduleException(reasons);
        }
    }

    static {
        DATE_FORMAT.setLenient(false);
        DATE_TIME_FORMAT.setLenient(false);
    }
}

