/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core;

import com.ericsson.cms.sites.core.IDistTemplateUpgrade;
import com.ericsson.cms.sites.distribution.DistributionManager;
import com.ericsson.cms.sites.distribution.jaxb.DistributionTemplates;
import com.ericsson.cms.sites.distribution.upgrade.TemplateUpgradeDBManager;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.ejb3.annotation.Depends;
import org.jboss.ejb3.annotation.Service;

@Service(objectName="Sites:service=com.ericsson.cms.sites.IDistTemplateUpgrade")
@Depends(value={"ContentManagement:service=com.tandbergtv.cms.contentmgmt.activation.IServiceActivator"})
public class DistTemplateUpgrade
implements IDistTemplateUpgrade {
    private static final Logger logger = Logger.getLogger(DistTemplateUpgrade.class);

    @Override
    public void start() {
        logger.info((Object)"Starting distribution template upgrade process");
        DistributionManager manager = DistributionManager.getInstance();
        List<DistributionTemplates.DistributionTemplate> templateList = manager.readTemplateConfigurations();
        if (templateList != null) {
            for (DistributionTemplates.DistributionTemplate templateInfo : templateList) {
                String templateName = templateInfo.getTemplateName();
                String groupName = templateInfo.getAssociatedResourceGroupName();
                TemplateUpgradeDBManager dbManager = new TemplateUpgradeDBManager();
                dbManager.createDistirbutionAnnotation(templateName, groupName);
            }
        }
        manager.deleteConfigFile();
    }

    @Override
    public void stop() {
    }
}

