/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core;

import com.ericsson.cms.scheduler.IScheduler;
import com.ericsson.cms.scheduler.entities.Job;
import com.ericsson.cms.sites.core.DistTimeoutManager;
import com.ericsson.cms.sites.core.EntitiesAssociatedException;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.ISitePartnerManager;
import com.ericsson.cms.sites.core.InactiveSiteException;
import com.ericsson.cms.sites.core.LicenseException;
import com.ericsson.cms.sites.core.SiteListComparator;
import com.ericsson.cms.sites.core.SiteManagementException;
import com.ericsson.cms.sites.core.entities.DistributionOption;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.DistributionSiteTitle;
import com.ericsson.cms.sites.core.entities.DistributionStatus;
import com.ericsson.cms.sites.core.entities.LogicalSite;
import com.ericsson.cms.sites.core.entities.MasterTitleDistStatus;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.SitePartner;
import com.ericsson.cms.sites.core.entities.SiteType;
import com.ericsson.cms.sites.core.entities.TargetResult;
import com.ericsson.cms.sites.core.entities.TrackingSite;
import com.ericsson.cms.sites.core.entities.TrackingSiteTitle;
import com.ericsson.cms.sites.core.entities.TrackingStatus;
import com.ericsson.cms.sites.core.entities.mediapath.MediapathDistributionSite;
import com.ericsson.cms.sites.distribution.DistributionManager;
import com.ericsson.cms.sites.distribution.TemplateInfo;
import com.ericsson.cms.sites.monitoring.ISiteChangeListener;
import com.ericsson.cms.sites.scheduling.SiteTimerSchedulerCallback;
import com.ericsson.cms.sites.util.JTATransactionManager;
import com.tandbergtv.cms.rules.service.category.IRuleExecutionHandler;
import com.tandbergtv.cms.rules.service.category.IRuleManager;
import com.tandbergtv.marvin.udt.ShallowRuleSet;
import com.tandbergtv.marvin.udt.TreEvent;
import com.tandbergtv.marvin.udt.TrePackage;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.title.ITitleCopyService;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.TitleCopyException;
import com.tandbergtv.watchpoint.pmm.title.template.ITitleTemplateProvider;
import com.tandbergtv.workflow.comm.routing.IRoutingService;
import com.tandbergtv.workflow.comm.routing.RoutingServiceFactory;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.util.WPCLConverter;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.naming.InitialContext;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.springframework.transaction.annotation.Transactional;

@Stateless
@TransactionAttribute
public class SiteManager
implements ISiteManager {
    private static final Logger logger = Logger.getLogger(SiteManager.class);
    private static final String LIC_DISTSITE_MAX_COUNT = "Sites.DistributionSite.MaxCount";
    private static final String LIC_TRACKSITE_MAX_COUNT = "Sites.TrackingSite.MaxCount";
    private static final String ASSOCIATED_ENTITY_TYPE_SITE_TIMER = "sitetimer";
    private static final String ASSOCIATION_DESCRIPTION_PREFIX_SITE_TIMER = "Site: ";
    private static final String ASSOCIATION_DESCRIPTION_SUFFIX_SITE_TIMER = " [DIST. TIMER]";
    private static final String JOB_PREFIX_SITE_TIMER = "Timer Job for Site ";
    private static final String ASSOCIATED_ENTITY_TYPE_SITE = "Sites";
    @EJB
    private ITitleCopyService titleCopyService;
    @EJB
    private ITitleManager titleManager;
    @EJB
    private IRuleExecutionHandler ruleExecHandler;
    @EJB
    private IRuleManager ruleManager;
    @EJB
    private ISiteChangeListener siteChangeListener;
    @EJB
    private ILicenseManager licenseManager;
    @EJB
    private IScheduler scheduler;

    public Site getSite(int siteId) {
        String queryStr = "from Site where id_ = :siteId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("siteId", (Object)siteId);
        return (Site)query.uniqueResult();
    }

    public Site getSiteByName(String siteName) {
        String queryStr = "from Site where name = :siteName";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("siteName", (Object)siteName);
        return (Site)query.uniqueResult();
    }

    public List<Site> getSitesByExternalId(String externalId) {
        String queryStr = "from Site where externalId = :externalId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("externalId", (Object)externalId);
        return query.list();
    }

    public List<Site> getAllSites() {
        Session session = this.getSession();
        String queryStr = "FROM Site ORDER BY LOWER(name)";
        Query query = session.createQuery(queryStr);
        return query.list();
    }

    public List<Site> getTopLevelSites() {
        Session session = this.getSession();
        String queryStr1 = "SELECT ds FROM DistributionSite ds WHERE ds.parent is null ";
        Query query1 = session.createQuery(queryStr1);
        List result = query1.list();
        String queryStr2 = "SELECT ls FROM LogicalSite ls";
        Query query2 = session.createQuery(queryStr2);
        result.addAll(query2.list());
        this.sortResultAsc(result);
        return result;
    }

    private void sortResultAsc(List<Site> result) {
        Collections.sort(result, new SiteListComparator());
    }

    public List<DistributionSite> getAllDistributionSites() {
        String queryStr = "FROM DistributionSite";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        return query.list();
    }

    public List<DistributionSite> getActiveDistributionSites() {
        String queryStr = "FROM DistributionSite WHERE active = true";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        return query.list();
    }

    public List<TrackingSite> getAllTrackingSites(Integer parentDistSiteId) {
        List queryResult;
        Session session = this.getSession();
        if (parentDistSiteId != null) {
            String quesryStr = "SELECT ds.children FROM DistributionSite ds WHERE ds.id = :distributionSiteId";
            Query query = session.createQuery(quesryStr);
            query.setParameter("distributionSiteId", (Object)parentDistSiteId);
            queryResult = query.list();
        } else {
            String queryStr = "FROM TrackingSite ts";
            Query query = session.createQuery(queryStr);
            queryResult = query.list();
        }
        if (queryResult != null) {
            Collections.sort(queryResult, new SiteListComparator());
        }
        return queryResult;
    }

    public List<TrackingSite> getShareableTrackingSites(int distributionSiteId) {
        Session session = this.getSession();
        String queryStr1 = "FROM TrackingSite ts";
        Query query1 = session.createQuery(queryStr1);
        List result = query1.list();
        String quesryStr2 = "SELECT ds.children FROM DistributionSite ds WHERE ds.id = :distributionSiteId";
        Query query2 = session.createQuery(quesryStr2);
        query2.setParameter("distributionSiteId", (Object)distributionSiteId);
        result.removeAll(query2.list());
        return result;
    }

    public List<Long> getSiteCopyIds(long masterTitleId) {
        String queryStr = "SELECT dst.title.id FROM DistributionSiteTitle dst WHERE dst.title.originalId = :masterTitleId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("masterTitleId", (Object)masterTitleId);
        return query.list();
    }

    public List<Title> getSiteCopies(long masterTitleId) {
        String queryStr = "SELECT dst.title FROM DistributionSiteTitle dst WHERE dst.title.originalId = :masterTitleId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("masterTitleId", (Object)masterTitleId);
        return query.list();
    }

    public DistributionSite getAssociatedDistributionSite(long localTitleId) {
        String queryStr = "SELECT distSite FROM DistributionSite distSite JOIN distSite.distributionSiteTitles dst WHERE dst.title.id = :localTitleId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("localTitleId", (Object)localTitleId);
        return (DistributionSite)query.uniqueResult();
    }

    public DistributionSiteTitle getDistributionSiteTitleById(long dstId) {
        return (DistributionSiteTitle)this.getSession().load(DistributionSiteTitle.class, (Serializable)Long.valueOf(dstId));
    }

    public DistributionSiteTitle getDistributionSiteTitle(long localTitleId) {
        String queryStr = "FROM DistributionSiteTitle WHERE title.id = :localTitleId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("localTitleId", (Object)localTitleId);
        return (DistributionSiteTitle)query.uniqueResult();
    }

    private DistributionSiteTitle getDistributionSiteTitle(int distSiteId, long localTitleId) {
        String queryStr = "FROM DistributionSiteTitle WHERE distributionSite.id = :distSiteId AND title.id = :localTitleId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("distSiteId", (Object)distSiteId);
        query.setParameter("localTitleId", (Object)localTitleId);
        return (DistributionSiteTitle)query.uniqueResult();
    }

    private TrackingSiteTitle getTrackingSiteTitle(int trackSiteId, long localTitleId) {
        String queryStr = "FROM TrackingSiteTitle WHERE trackingSite.id = :trackSiteId AND title.id = :localTitleId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("trackSiteId", (Object)trackSiteId);
        query.setParameter("localTitleId", (Object)localTitleId);
        return (TrackingSiteTitle)query.uniqueResult();
    }

    public List<DistributionSiteTitle> getDistributionSiteTitles(long masterTitleId) {
        String queryStr = "FROM DistributionSiteTitle WHERE title.originalId = :masterTitleId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("masterTitleId", (Object)masterTitleId);
        return query.list();
    }

    public List<DistributionSiteTitle> getDistributionSiteTitles(int siteId, List<Long> partnerIds) {
        StringBuilder queryStr = new StringBuilder("SELECT dst FROM DistributionSiteTitle dst ");
        if (!partnerIds.isEmpty()) {
            queryStr.append("JOIN dst.title t WHERE t.partnerId in (:partners) AND ");
        } else {
            queryStr.append("WHERE ");
        }
        queryStr.append("dst.distributionSite.id = :siteId ");
        Session session = this.getSession();
        Query query = session.createQuery(queryStr.toString());
        query.setParameter("siteId", (Object)siteId);
        if (!partnerIds.isEmpty()) {
            query.setParameterList("partners", partnerIds);
        }
        return query.list();
    }

    public List<DistributionSiteTitle> getDistributionSiteTitlesByStatus(DistributionStatus status) {
        String queryStr = "FROM DistributionSiteTitle WHERE status = :status";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("status", (Object)status);
        return query.list();
    }

    public List<DistributionSiteTitle> getDistributionSiteTitlesBySiteAndStatus(int siteId, DistributionStatus status) {
        String queryStr = "FROM DistributionSiteTitle WHERE distributionSite.id = :siteId AND status = :status";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("siteId", (Object)siteId);
        query.setParameter("status", (Object)status);
        return query.list();
    }

    public List<Long> getDistributionSiteTitleIdsBySiteAndStatus(int siteId, DistributionStatus status) {
        String queryStr = "SELECT id FROM DistributionSiteTitle WHERE distributionSite.id = :siteId AND status = :status";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("siteId", (Object)siteId);
        query.setParameter("status", (Object)status);
        return query.list();
    }

    public List<TrackingSiteTitle> getTrackingSiteTitlesByStatus(TrackingStatus status) {
        String queryStr = "FROM TrackingSiteTitle WHERE status = :status";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("status", (Object)status);
        return query.list();
    }

    public List<DistributionSiteTitle> getDistributionSiteTitlesOfLogicalSite(int logicalSiteId, List<Long> partnerIds) {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("SELECT DST.* FROM SITES_DISTSITETITLE DST ");
        queryStr.append("JOIN SITES_SITE S ON(DST.SITEID = S.id_) ");
        queryStr.append("JOIN SITES_SITELINK SL ON( S.ID_ = SL.CHILD) ");
        if (!partnerIds.isEmpty()) {
            queryStr.append("JOIN PMM_TITLE T ON(t.id_ = DST.TITLEID) ");
        }
        queryStr.append("WHERE SL.PARENT = ? ");
        if (!partnerIds.isEmpty()) {
            queryStr.append("AND t.partner_Id in (?");
            for (int i = 1; i < partnerIds.size(); ++i) {
                queryStr.append(", ?");
            }
            queryStr.append(")");
        }
        Session session = this.getSession();
        SQLQuery query = session.createSQLQuery(queryStr.toString()).addEntity(DistributionSiteTitle.class);
        int index = 0;
        query = query.setInteger(index++, logicalSiteId);
        for (Long partnerId : partnerIds) {
            query.setLong(index++, partnerId.longValue());
        }
        List list = query.list();
        return list;
    }

    private Title getLocalTitle(long masterTitleId, int distSiteId) {
        String queryStr = "SELECT dst.title FROM DistributionSiteTitle dst WHERE dst.distributionSite.id = :distSiteId AND dst.title.originalId = :masterTitleId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("distSiteId", (Object)distSiteId);
        query.setParameter("masterTitleId", (Object)masterTitleId);
        return (Title)query.uniqueResult();
    }

    public List<TrackingSiteTitle> getTrackingSiteTitles(long localTitleId) {
        String queryStr = "FROM TrackingSiteTitle WHERE title.id = :localTitleId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("localTitleId", (Object)localTitleId);
        return query.list();
    }

    public TrackingSiteTitle getTrackingSiteTitle(long localTitleId, int trackingSiteId) {
        String queryStr = "FROM TrackingSiteTitle WHERE title.id = :localTitleId and trackingSite.id = :trackingSiteId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("localTitleId", (Object)localTitleId);
        query.setParameter("trackingSiteId", (Object)trackingSiteId);
        return (TrackingSiteTitle)query.uniqueResult();
    }

    public LogicalSite createLogicalSite(LogicalSite site) {
        LogicalSite logicalSite = (LogicalSite)this.save((Site)site);
        ISitePartnerManager sitePartnerManager = (ISitePartnerManager)InjectionUtil.injectInstance((String)"/cms/SitePartnerManager/local", ISitePartnerManager.class);
        sitePartnerManager.createPartnerForSite(site.getId().intValue());
        return logicalSite;
    }

    public LogicalSite createLogicalSite(LogicalSite site, SitePartner sitePartner) {
        LogicalSite logicalSite = (LogicalSite)this.save((Site)site);
        ISitePartnerManager sitePartnerManager = (ISitePartnerManager)InjectionUtil.injectInstance((String)"/cms/SitePartnerManager/local", ISitePartnerManager.class);
        sitePartnerManager.createPartnerForSite(site.getId().intValue(), sitePartner);
        return logicalSite;
    }

    public boolean hasReachedMaxLicensedDistributionSites() {
        String maxAllowedStr = null;
        try {
            maxAllowedStr = this.licenseManager.getProperty(LIC_DISTSITE_MAX_COUNT);
        }
        catch (InvalidLicenseException e) {
            throw new SiteManagementException((Throwable)e);
        }
        if (maxAllowedStr != null && maxAllowedStr.trim().length() != 0) {
            int maxAllowed = Integer.parseInt(maxAllowedStr);
            if (this.getDistSitesCount() >= maxAllowed) {
                return true;
            }
        }
        return false;
    }

    private int getDistSitesCount() {
        Query query = this.getSession().createQuery("SELECT count(*) FROM DistributionSite");
        return ((Long)query.uniqueResult()).intValue();
    }

    public synchronized DistributionSite createDistributionSite(DistributionSite site, Integer parentSiteId) {
        if (this.hasReachedMaxLicensedDistributionSites()) {
            throw new LicenseException("Reached maximum allowed Distribution Sites as per license.");
        }
        if (parentSiteId != null) {
            LogicalSite parentSite = this.getLogicalSite(parentSiteId);
            site.setParent(parentSite);
        }
        DistributionSite savedSite = (DistributionSite)this.save((Site)site);
        if (DistributionOption.TIMED.equals((Object)site.getDistributionOption())) {
            this.scheduleTimerJob(site);
        }
        ISitePartnerManager sitePartnerManager = (ISitePartnerManager)InjectionUtil.injectInstance((String)"/cms/SitePartnerManager/local", ISitePartnerManager.class);
        sitePartnerManager.createPartnerForSite(site.getId().intValue());
        return savedSite;
    }

    public synchronized DistributionSite createDistributionSite(DistributionSite site, Integer parentSiteId, SitePartner sitePartner) {
        if (this.hasReachedMaxLicensedDistributionSites()) {
            throw new LicenseException("Reached maximum allowed Distribution Sites as per license.");
        }
        if (parentSiteId != null) {
            LogicalSite parentSite = this.getLogicalSite(parentSiteId);
            site.setParent(parentSite);
        }
        DistributionSite savedSite = (DistributionSite)this.save((Site)site);
        if (DistributionOption.TIMED.equals((Object)site.getDistributionOption())) {
            this.scheduleTimerJob(site);
        }
        ISitePartnerManager sitePartnerManager = (ISitePartnerManager)InjectionUtil.injectInstance((String)"/cms/SitePartnerManager/local", ISitePartnerManager.class);
        sitePartnerManager.createPartnerForSite(site.getId().intValue(), sitePartner);
        return savedSite;
    }

    public boolean hasReachedMaxLicensedTrackingSites() {
        String maxAllowedStr = null;
        try {
            maxAllowedStr = this.licenseManager.getProperty(LIC_TRACKSITE_MAX_COUNT);
        }
        catch (InvalidLicenseException e) {
            throw new SiteManagementException((Throwable)e);
        }
        if (maxAllowedStr != null && maxAllowedStr.trim().length() != 0) {
            int maxAllowed = Integer.parseInt(maxAllowedStr);
            if (this.getTrackSitesCount() >= maxAllowed) {
                return true;
            }
        }
        return false;
    }

    private int getTrackSitesCount() {
        Query query = this.getSession().createQuery("SELECT count(*) FROM TrackingSite");
        return ((Long)query.uniqueResult()).intValue();
    }

    public List<TrackingSite> getAllTrackingSites() {
        ArrayList<TrackingSite> trackList = new ArrayList();
        Session session = this.getSession();
        String queryStr1 = "FROM TrackingSite ts order by ts.name";
        Query query1 = session.createQuery(queryStr1);
        trackList = query1.list();
        return trackList;
    }

    public synchronized TrackingSite createTrackingSite(TrackingSite site, Integer parentSiteId) {
        if (this.hasReachedMaxLicensedTrackingSites()) {
            throw new LicenseException("Reached maximum allowed Tracking Sites as per license.");
        }
        if (parentSiteId == null) {
            throw new RuntimeException("parentSiteId cannot be null. Tracking Site must be associated with a parent.");
        }
        DistributionSite parentSite = this.getDistributionSite(parentSiteId);
        site.addParent(parentSite);
        TrackingSite savedTrackingSite = (TrackingSite)this.save((Site)site);
        this.getSession().flush();
        int numTitles = this.associateTitles(savedTrackingSite.getId(), parentSite.getId());
        logger.info((Object)(numTitles + " titles has been associated to [" + savedTrackingSite + "] from [" + parentSite + "]"));
        return savedTrackingSite;
    }

    public void associateTrackingSites(Set<Integer> trackingSiteIds, int distributionSiteId) {
        DistributionSite ds = this.getDistributionSite(distributionSiteId);
        if (trackingSiteIds != null) {
            for (Integer tsId : trackingSiteIds) {
                TrackingSite ts = this.getTrackingSite(tsId);
                ds.addChild(ts);
                this.getSession().flush();
                int numTitles = this.associateTitles(ts.getId(), ds.getId());
                logger.info((Object)(numTitles + " titles has been associated to [" + ts + "] from [" + ds + "]"));
                this.siteChangeListener.trackingSiteShared(ds, ts);
            }
        }
        this.save((Site)ds);
    }

    private int associateTitles(int tsId, int dsId) {
        SQLQuery q = this.getSession().createSQLQuery("insert into sites_tracksitetitle (siteid, titleid, status, status_updated_time) select :tsId, titleid, " + TrackingStatus.TARGETED.ordinal() + ", SYSTIMESTAMP " + " from sites_distsitetitle where siteid = :dsId");
        q.setInteger("tsId", tsId);
        q.setInteger("dsId", dsId);
        return q.executeUpdate();
    }

    private int dissociateTitles(int tsId, int dsId) {
        SQLQuery q = this.getSession().createSQLQuery("delete from sites_tracksitetitle where siteid = :tsId and titleid in (select titleid from sites_distsitetitle where siteid = :dsId)");
        q.setInteger("tsId", tsId);
        q.setInteger("dsId", dsId);
        return q.executeUpdate();
    }

    public void dissociateTrackingSite(int trackingSiteId, int distributionSiteId) {
        DistributionSite ds = this.getDistributionSite(distributionSiteId);
        TrackingSite ts = this.getTrackingSite(trackingSiteId);
        ds.removeChild(ts);
        int numTitles = this.dissociateTitles(ts.getId(), ds.getId());
        logger.info((Object)(numTitles + " titles of [" + ds + "] has been dissociated from [" + ts + "]"));
        this.siteChangeListener.trackingSiteDetached(ds, ts);
        this.save((Site)ds);
    }

    public Site save(Site site) {
        Long timerJobId;
        Job timerJob;
        DistributionSite distSite;
        if (site.getType() == SiteType.DISTRIBUTION && (distSite = (DistributionSite)site).getDistributionOption() != DistributionOption.TIMED && (timerJob = distSite.getTimerJob()) != null && (timerJobId = timerJob.getId()) != null) {
            this.scheduler.delete(timerJobId.longValue());
        }
        this.getSession().saveOrUpdate((Object)site);
        return site;
    }

    public SitePartner save(Site site, SitePartner sitePartner) {
        SitePartner savedSitePartner = null;
        if (site != null && sitePartner != null && sitePartner.getContextId() > 0L) {
            ISitePartnerManager sitePartnerManager = (ISitePartnerManager)InjectionUtil.injectInstance((String)"/cms/SitePartnerManager/local", ISitePartnerManager.class);
            sitePartnerManager.update(sitePartner);
            savedSitePartner = sitePartnerManager.get(site.getId().intValue());
        }
        return savedSitePartner;
    }

    public Site updateSiteProperties(Site site) {
        Site dbSite = this.internalGetSite(site.getId());
        if (site.getType() != dbSite.getType()) {
            throw new RuntimeException("Cannot change the Site Type");
        }
        dbSite.setName(site.getName());
        dbSite.setExternalId(site.getExternalId());
        dbSite.setDescription(site.getDescription());
        switch (site.getType()) {
            case LOGICAL: {
                break;
            }
            case DISTRIBUTION: {
                List timerJobs;
                DistributionSite dbDistSite = (DistributionSite)dbSite;
                DistributionSite distSite = (DistributionSite)site;
                dbDistSite.setFileLookupKeys(distSite.getFileLookupKeys());
                dbDistSite.setMetadataFormat(distSite.getMetadataFormat());
                dbDistSite.setAlertDelayPeriod(distSite.getAlertDelayPeriod());
                boolean wasTimed = dbDistSite.getDistributionOption() == DistributionOption.TIMED;
                boolean isTimed = distSite.getDistributionOption() == DistributionOption.TIMED;
                boolean wasImmediate = dbDistSite.getDistributionOption() == DistributionOption.IMMEDIATE;
                boolean isImmediate = distSite.getDistributionOption() == DistributionOption.IMMEDIATE;
                dbDistSite.setDistributionOption(distSite.getDistributionOption());
                if (wasTimed && !isTimed && (timerJobs = this.scheduler.getJobsByAssociatedEntity(ASSOCIATED_ENTITY_TYPE_SITE_TIMER, (long)distSite.getId().intValue())) != null) {
                    for (Job timerJob : timerJobs) {
                        this.scheduler.delete(timerJob.getId().longValue());
                    }
                }
                if (!wasTimed && isTimed) {
                    distSite.setActive(dbDistSite.isActive());
                    this.scheduleTimerJob(distSite);
                }
                if (wasTimed && isTimed) {
                    Job timerJob = distSite.getTimerJob();
                    String jobName = JOB_PREFIX_SITE_TIMER + distSite.getName();
                    String associationDescription = ASSOCIATION_DESCRIPTION_PREFIX_SITE_TIMER + distSite.getName() + ASSOCIATION_DESCRIPTION_SUFFIX_SITE_TIMER;
                    timerJob.setName(jobName);
                    timerJob.setAssociationDescription(associationDescription);
                    timerJob.setCallbackClass(SiteTimerSchedulerCallback.class);
                    Job job = this.scheduler.schedule(timerJob);
                    if (job.isActive() != dbDistSite.isActive()) {
                        this.scheduler.setActive(job.getId().longValue(), dbDistSite.isActive());
                    }
                }
                if (!wasImmediate && isImmediate && dbDistSite.isActive()) {
                    this.distributeReadyTitlesImmediately(dbDistSite.getId());
                }
                dbDistSite.setDistTemplateName(distSite.getDistTemplateName());
                dbDistSite.setAssociatedGroupName(distSite.getAssociatedGroupName());
                dbDistSite.setDistConfParams(distSite.getDistConfParams());
                dbDistSite.setAssociatedResourceId(distSite.getAssociatedResourceId());
                dbDistSite.setExportPluginName(distSite.getExportPluginName());
                dbDistSite.setExportConfParams(distSite.getExportConfParams());
                break;
            }
            case TRACKING: {
                ((TrackingSite)dbSite).setAlertDelayPeriod(((TrackingSite)site).getAlertDelayPeriod());
            }
        }
        return this.save(dbSite);
    }

    public SitePartner updateSitePartnerProperties(Site site, SitePartner sitePartner) {
        return this.save(site, sitePartner);
    }

    public void delete(int siteId) throws EntitiesAssociatedException {
        this.delete(this.internalGetSite(siteId), null);
    }

    private void delete(Site site, Site parentSite) throws EntitiesAssociatedException {
        ISitePartnerManager sitePartnerManager;
        List nonTimerJobs;
        if (site.getSiteChildren() != null) {
            for (Site childSite : site.getSiteChildren()) {
                this.delete(childSite, site);
            }
        }
        EntitiesAssociatedException eaException = new EntitiesAssociatedException(site);
        if (site instanceof MediapathDistributionSite && ((MediapathDistributionSite)site).getMsos() != null && !((MediapathDistributionSite)site).getMsos().isEmpty()) {
            ((MediapathDistributionSite)site).setMsos(null);
            this.deleteMsoAssociation(site);
        }
        switch (site.getType()) {
            case DISTRIBUTION: {
                Set dsts = ((DistributionSite)site).getDistributionSiteTitles();
                if (dsts == null || dsts.isEmpty()) break;
                eaException.addAssociatedEntity(EntitiesAssociatedException.EntityType.TITLES);
                break;
            }
            case TRACKING: {
                Set tsts = ((TrackingSite)site).getTrackingSiteTitles();
                if (tsts == null || tsts.isEmpty()) break;
                eaException.addAssociatedEntity(EntitiesAssociatedException.EntityType.TITLES);
            }
        }
        List ruleSets = this.ruleManager.getAllRuleSetsBySite(site.getId());
        if (ruleSets != null && !ruleSets.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (ShallowRuleSet rs : ruleSets) {
                if (!rs.packageName.equals("TARGETING")) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(rs.getRuleSetId());
            }
            if (!sb.toString().isEmpty()) {
                sb.insert(0, "Including targeting rule set(s): ");
            }
            eaException.addAssociatedEntity(EntitiesAssociatedException.EntityType.RULES, sb.toString());
        }
        if ((nonTimerJobs = this.scheduler.getJobsByAssociatedEntity(ASSOCIATED_ENTITY_TYPE_SITE, (long)site.getId().intValue())) != null && nonTimerJobs.size() > 0) {
            eaException.addAssociatedEntity(EntitiesAssociatedException.EntityType.JOBS);
        }
        if (site.getType() != SiteType.TRACKING && (sitePartnerManager = (ISitePartnerManager)InjectionUtil.injectInstance((String)"/cms/SitePartnerManager/local", ISitePartnerManager.class)).getSchedulesCountForSite(site.getId().intValue()) > 0) {
            eaException.addAssociatedEntity(EntitiesAssociatedException.EntityType.SCHEDULES);
        }
        if (eaException.hasEntities()) {
            throw eaException;
        }
        List timerJobs = this.scheduler.getJobsByAssociatedEntity(ASSOCIATED_ENTITY_TYPE_SITE_TIMER, (long)site.getId().intValue());
        if (timerJobs != null) {
            for (Job timerJob : timerJobs) {
                this.scheduler.delete(timerJob.getId().longValue());
            }
        }
        if (site.getType() == SiteType.TRACKING) {
            TrackingSite ts = (TrackingSite)site;
            if (parentSite != null && ts.getParents().size() > 1) {
                logger.info((Object)("Dissociating tracking site: [" + site + "]" + " from site[" + parentSite.getId() + "]"));
                this.dissociateTrackingSite(site.getId(), parentSite.getId());
                return;
            }
        }
        if (site.getType() != SiteType.TRACKING) {
            ISitePartnerManager sitePartnerManager2 = (ISitePartnerManager)InjectionUtil.injectInstance((String)"/cms/SitePartnerManager/local", ISitePartnerManager.class);
            sitePartnerManager2.deletePartnerForSite(site.getId().intValue());
        }
        this.siteChangeListener.siteDeleted(site);
        logger.info((Object)("Deleting site: [" + site + "]"));
        this.getSession().delete((Object)site);
    }

    @Transactional
    private void deleteMsoAssociation(Site site) {
        Session session = this.getSession();
        try {
            Query query = session.createSQLQuery("delete from sites_mso_site where site_id = ?").addEntity(MediapathDistributionSite.class).setInteger(0, site.getId().intValue());
            query.executeUpdate();
        }
        catch (Exception e) {
            logger.error((Object)("Could not delete mediapath site association: " + e));
        }
    }

    public void activate(int siteId) {
        Site site = this.getSite(siteId);
        this.setSiteActive(site, true);
    }

    public void inactivate(int siteId) {
        Site site = this.getSite(siteId);
        this.setSiteActive(site, false);
    }

    private void setSiteActive(Site site, boolean isActive) {
        if (site.isActive() != isActive) {
            site.setActive(isActive);
            this.save(site);
            if (site.getType() == SiteType.DISTRIBUTION) {
                DistributionSite distSite = (DistributionSite)site;
                if (distSite.getDistributionOption() == DistributionOption.TIMED) {
                    List siteTimerJobs = this.scheduler.getJobsByAssociatedEntity(ASSOCIATED_ENTITY_TYPE_SITE_TIMER, (long)distSite.getId().intValue());
                    if (siteTimerJobs != null) {
                        for (Job siteTimerJob : siteTimerJobs) {
                            this.scheduler.setActive(siteTimerJob.getId().longValue(), isActive);
                        }
                    }
                } else if (distSite.getDistributionOption() == DistributionOption.IMMEDIATE && isActive) {
                    this.distributeReadyTitlesImmediately(distSite.getId());
                }
            }
            if (isActive) {
                this.siteChangeListener.siteActivated(site);
            } else {
                this.siteChangeListener.siteInactivated(site);
            }
        }
        if (site.getSiteChildren() != null) {
            for (Site child : site.getSiteChildren()) {
                this.setSiteActive(child, isActive);
            }
        }
    }

    public Set<TemplateInfo> getDistributionTemplatesInfo() {
        Set<TemplateInfo> templateInfo = new HashSet<TemplateInfo>();
        ArrayList<String> templateNames = new ArrayList<String>();
        ITitleTemplateProvider service = (ITitleTemplateProvider)ServiceRegistry.getDefault().lookup(ITitleTemplateProvider.class);
        for (WorkflowTemplate template : service.getTemplatesWithAnnotation("Category", "Distribution")) {
            templateNames.add(template.getName());
        }
        if (templateNames != null) {
            templateInfo = DistributionManager.getInstance().getDistributionTemplateInfoByName(templateNames);
        }
        return templateInfo;
    }

    public Set<String> getDistributionTemplateNames() {
        HashSet<String> templateNames = new HashSet<String>();
        ITitleTemplateProvider service = (ITitleTemplateProvider)ServiceRegistry.getDefault().lookup(ITitleTemplateProvider.class);
        for (WorkflowTemplate template : service.getTemplatesWithAnnotation("Category", "Distribution")) {
            templateNames.add(template.getName());
        }
        return templateNames;
    }

    public Title createSiteCopy(long masterTitleId, int distributionSiteId) throws SiteManagementException {
        String assetType;
        boolean newTarget;
        DistributionSite distSite = this.getDistributionSite(distributionSiteId);
        if (!distSite.isActive()) {
            throw new InactiveSiteException((Site)distSite);
        }
        Title masterTitle = this.getMasterTitle(masterTitleId, true);
        if (masterTitle.getStatus() == TitleStatus.DRAFT) {
            throw new SiteManagementException("Cannot target | Can target only a title that is not in DRAFT status.");
        }
        Title copyTitle = this.getLocalTitle(masterTitleId, distSite.getId());
        boolean bl = newTarget = copyTitle == null;
        if (newTarget) {
            try {
                copyTitle = this.titleCopyService.createTitleCopy(masterTitleId, true);
            }
            catch (TitleCopyException e) {
                throw new SiteManagementException((Throwable)e);
            }
        }
        try {
            copyTitle = this.titleCopyService.overwriteTitleCopy(copyTitle.getId().longValue());
        }
        catch (TitleCopyException e) {
            throw new SiteManagementException((Throwable)e);
        }
        HashMap<String, HashSet<String>> siteAssetTypeFLKsMap = new HashMap<String, HashSet<String>>();
        List fileLookupKeysList = distSite.getFileLookupKeys();
        if (fileLookupKeysList != null) {
            for (String fileLookupKey : fileLookupKeysList) {
                String[] flkSplitArray = fileLookupKey.split("-");
                assetType = flkSplitArray[0].trim();
                HashSet<String> fileLookupKeys = (HashSet<String>)siteAssetTypeFLKsMap.get(assetType);
                if (fileLookupKeys == null) {
                    fileLookupKeys = new HashSet<String>();
                    siteAssetTypeFLKsMap.put(assetType, fileLookupKeys);
                }
                fileLookupKeys.add(flkSplitArray[1].trim());
            }
        }
        Collection assets = copyTitle.getAllAssets(false);
        for (Asset asset : assets) {
            assetType = asset.getAssetType();
            String lookupKey = null;
            Set chosenFLKs = (Set)siteAssetTypeFLKsMap.get(assetType);
            if (chosenFLKs != null) {
                Set availableFLKs = this.titleManager.getFileLookupKeys(asset);
                HashSet matchingFLKs = new HashSet();
                matchingFLKs.addAll(chosenFLKs);
                matchingFLKs.retainAll(availableFLKs);
                if (matchingFLKs.size() > 1) {
                    throw new SiteManagementException("More than one file matched to be copied for the asset: " + asset + ". Matched lookup keys: " + matchingFLKs);
                }
                if (matchingFLKs.size() == 1) {
                    lookupKey = (String)matchingFLKs.iterator().next();
                }
            }
            this.titleManager.filterFiles(asset, lookupKey);
            try {
                this.titleManager.updateWithFileMetadata(asset, lookupKey);
            }
            catch (Exception e) {
                throw new SiteManagementException("Failed to update asset with file metadata.", (Throwable)e);
            }
        }
        TitleActionSource source = new TitleActionSource(ASSOCIATED_ENTITY_TYPE_SITE, "", Integer.toString(distSite.getId()));
        if (newTarget) {
            try {
                this.titleManager.create(copyTitle, true, (ITitleActionSource)source);
            }
            catch (TitleValidationException e) {
                throw new SiteManagementException((Throwable)e);
            }
            this.getSession().saveOrUpdate((Object)new DistributionSiteTitle(distSite, copyTitle, DistributionStatus.TARGETED));
            Set trackingSites = distSite.getChildren();
            if (trackingSites != null) {
                for (TrackingSite trackingSite : trackingSites) {
                    this.getSession().saveOrUpdate((Object)new TrackingSiteTitle(trackingSite, copyTitle, TrackingStatus.TARGETED));
                }
            }
        } else {
            DistributionSiteTitle dst = this.getDistributionSiteTitle(copyTitle.getId());
            if (dst.getStatus() == DistributionStatus.IN_PROGRESS) {
                logger.warn((Object)("Retargeting a title whose distribution is in progress. Distribution Site: " + dst.getDistributionSite().getId() + " | Local Title Id: " + copyTitle.getId()));
            }
            dst.setStatus(DistributionStatus.TARGETED);
            this.getSession().saveOrUpdate((Object)dst);
        }
        try {
            this.titleManager.update(copyTitle, false, (ITitleActionSource)source);
        }
        catch (TitleValidationException e) {
            try {
                this.titleManager.update(copyTitle, true, (ITitleActionSource)source);
            }
            catch (TitleValidationException e1) {
                throw new SiteManagementException((Throwable)e1);
            }
        }
        return copyTitle;
    }

    public Set<Site> target(long masterTitleId, List<Integer> siteIds) throws SiteManagementException {
        if (siteIds == null || siteIds.isEmpty()) {
            throw new IllegalArgumentException("siteIds list is null or empty");
        }
        Title masterTitle = this.getMasterTitle(masterTitleId, false);
        HashSet<Site> targetedDistSites = new HashSet<Site>();
        for (Integer siteId : siteIds) {
            Site site = this.internalGetSite(siteId);
            if (!site.isActive()) {
                throw new InactiveSiteException(site);
            }
            if (site.getType() == SiteType.DISTRIBUTION) {
                targetedDistSites.add(site);
                continue;
            }
            if (site.getType() == SiteType.LOGICAL) {
                if (site.getSiteChildren() == null) continue;
                for (Site child : site.getSiteChildren()) {
                    if (!child.isActive()) continue;
                    targetedDistSites.add(child);
                }
                continue;
            }
            throw new SiteManagementException("Can target only to Distribution or Logical site. Given site: " + siteId + " is of type: " + site.getType());
        }
        if (!targetedDistSites.isEmpty()) {
            this.target(masterTitle, targetedDistSites);
        }
        return targetedDistSites;
    }

    public TargetResult targetWithRules(long masterTitleId) {
        Title masterTitle = this.getMasterTitle(masterTitleId, false);
        Set siteIds = this.ruleExecHandler.getTargetedSites(masterTitle);
        HashSet<Site> activeDistSites = new HashSet<Site>();
        HashSet<Site> inactiveSites = new HashSet<Site>();
        if (siteIds != null) {
            for (Integer siteId : siteIds) {
                Site site = this.internalGetSite(siteId);
                if (site.isActive()) {
                    if (site.getType() == SiteType.DISTRIBUTION) {
                        activeDistSites.add(site);
                        continue;
                    }
                    if (site.getType() != SiteType.LOGICAL || site.getSiteChildren() == null) continue;
                    for (Site child : site.getSiteChildren()) {
                        if (child.isActive()) {
                            activeDistSites.add(child);
                            continue;
                        }
                        inactiveSites.add(child);
                    }
                    continue;
                }
                inactiveSites.add(site);
            }
        }
        if (!activeDistSites.isEmpty()) {
            this.target(masterTitle, activeDistSites);
        }
        return new TargetResult(activeDistSites, inactiveSites);
    }

    protected void target(Title masterTitle, Collection<Site> sites) {
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)"SM0103");
        message.setCommand(new WPCLCommand("create"));
        message.getPayload().putValue("titleId", String.valueOf(masterTitle.getId()));
        message.getPayload().putValue("siteIds", this.convertToCommaSeparatedListOfSiteIds(sites));
        IRoutingService router = RoutingServiceFactory.newInstance().createRoutingService();
        try {
            router.send(new WPCLConverter().convert(message));
            logger.debug((Object)("Sent WPCL message to create targeting WO: " + message.toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String convertToCommaSeparatedListOfSiteIds(Collection<Site> sites) {
        StringBuffer sb = new StringBuffer();
        boolean firstTime = true;
        for (Site site : sites) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(",");
            }
            sb.append(site.getId());
        }
        return sb.toString();
    }

    public void distribute(long localTitleId) throws SiteManagementException {
        DistributionSite distSite = this.getAssociatedDistributionSite(localTitleId);
        if (distSite == null) {
            throw new SiteManagementException("Title with the given id: " + localTitleId + " is not associated with any Distribution Site");
        }
        this.distribute(distSite, localTitleId);
    }

    public void distributeImmediately(long localTitleId) throws SiteManagementException {
        try {
            DistributionSiteTitle dst = this.getDistributionSiteTitle(localTitleId);
            if (dst == null) {
                logger.error((Object)("No DistributionSiteTitle found by localTitleId : " + localTitleId));
                throw new SiteManagementException("No title exist with the given titleId: " + localTitleId);
            }
            this.distributeImmediately(dst);
            logger.info((Object)("Finished immediate distribution of localTitleId: " + localTitleId));
        }
        catch (SiteManagementException sme) {
            throw sme;
        }
        catch (Exception e) {
            logger.error((Object)("Failure in immediate distribution of localTitleId " + localTitleId), (Throwable)e);
            throw new RuntimeException("Failure in immediate distribution of localTitleId " + localTitleId, e);
        }
    }

    @Deprecated
    public void distribute(int siteId, List<Long> localTitleIds) throws SiteManagementException {
        if (localTitleIds == null) {
            throw new IllegalArgumentException("localTitleIds cannot be null");
        }
        DistributionSite distSite = this.getDistributionSite(siteId);
        for (Long localTitleId : localTitleIds) {
            this.distribute(distSite, localTitleId);
        }
    }

    protected void distribute(DistributionSite distSite, long localTitleId) throws SiteManagementException {
        if (!distSite.isActive()) {
            throw new InactiveSiteException((Site)distSite);
        }
        DistributionSiteTitle dst = this.getDistributionSiteTitle(distSite.getId(), localTitleId);
        if (dst == null) {
            throw new SiteManagementException("No title exist with the given titleId: " + localTitleId + " in the given site: " + distSite.getId());
        }
        if (dst.getStatus() != DistributionStatus.TARGETED) {
            throw new SiteManagementException("Title must be in " + DistributionStatus.TARGETED + " status.");
        }
        dst.setStatus(DistributionStatus.READY_FOR_DISTRIBUTION);
        this.getSession().saveOrUpdate((Object)dst);
        if (distSite.getDistributionOption() == DistributionOption.IMMEDIATE) {
            this.distributeImmediately(dst);
        }
    }

    public void distributeReadyTitlesImmediately(final int siteId) throws SiteManagementException {
        DistributionSite distSite = this.getDistributionSite(siteId);
        if (!distSite.isActive()) {
            throw new InactiveSiteException((Site)distSite);
        }
        this.execute(new Runnable(){

            @Override
            public void run() {
                block10: {
                    logger.info((Object)("Beginning asynchronous distribution of ready titles of site: " + siteId));
                    TransactionManager transactionManager = null;
                    try {
                        transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
                        transactionManager.begin();
                        List<Long> dstIds = SiteManager.this.getDistributionSiteTitleIdsBySiteAndStatus(siteId, DistributionStatus.READY_FOR_DISTRIBUTION);
                        transactionManager.commit();
                        for (Long dstId : dstIds) {
                            try {
                                transactionManager.begin();
                                SiteManager.this.distributeImmediately(SiteManager.this.getDistributionSiteTitleById(dstId));
                                transactionManager.commit();
                            }
                            catch (Exception e) {
                                logger.error((Object)("Failed to distribute distribution site title: " + dstId), (Throwable)e);
                                try {
                                    if (transactionManager.getTransaction() == null) continue;
                                    transactionManager.rollback();
                                }
                                catch (Exception e2) {
                                    logger.error((Object)"Unable to rollback the transaction", (Throwable)e2);
                                }
                            }
                        }
                        logger.info((Object)("Finished asynchronous distribution of ready titles of site: " + siteId));
                    }
                    catch (Exception e) {
                        logger.error((Object)("Failure in asynchronous distribution of ready titles of site: " + siteId), (Throwable)e);
                        if (transactionManager == null) break block10;
                        try {
                            if (transactionManager.getTransaction() != null) {
                                transactionManager.rollback();
                            }
                        }
                        catch (Exception e2) {
                            logger.error((Object)"Unable to rollback the transaction", (Throwable)e2);
                        }
                    }
                }
            }
        });
        logger.info((Object)("Scheduled distribution of ready titles of site: " + siteId));
    }

    public void distributeImmediately(final int siteId, final List<Long> localTitleIds) throws InactiveSiteException {
        if (localTitleIds == null) {
            throw new IllegalArgumentException("localTitleIds cannot be null");
        }
        DistributionSite distSite = this.getDistributionSite(siteId);
        this.validateDistributionSiteforDistribution((Site)distSite);
        this.execute(new Runnable(){

            @Override
            public void run() {
                block10: {
                    logger.info((Object)("Beginning asynchronous distribution of titles of site: " + siteId));
                    TransactionManager transactionManager = null;
                    try {
                        transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
                        for (Long localTitleId : localTitleIds) {
                            try {
                                transactionManager.begin();
                                DistributionSiteTitle dst = SiteManager.this.getDistributionSiteTitle(siteId, localTitleId);
                                SiteManager.this.validateTitleforDistribution(dst, localTitleId, siteId);
                                SiteManager.this.distributeImmediately(dst);
                                transactionManager.commit();
                            }
                            catch (Exception e) {
                                logger.error((Object)("Exception occured distributing titleId : " + localTitleId + " of the given site : " + siteId + " : " + e), (Throwable)e);
                                try {
                                    if (transactionManager.getTransaction() == null) continue;
                                    transactionManager.rollback();
                                }
                                catch (Exception e2) {
                                    logger.error((Object)"Unable to rollback the transaction", (Throwable)e2);
                                }
                            }
                        }
                        logger.info((Object)("Finished asynchronous distribution of titles of site: " + siteId));
                    }
                    catch (Exception e) {
                        logger.error((Object)("Failure in asynchronous distribution of ready titles of site: " + siteId), (Throwable)e);
                        if (transactionManager == null) break block10;
                        try {
                            if (transactionManager.getTransaction() != null) {
                                transactionManager.rollback();
                            }
                        }
                        catch (Exception e2) {
                            logger.error((Object)"Unable to rollback the transaction", (Throwable)e2);
                        }
                    }
                }
            }
        });
        logger.info((Object)("Scheduled distribution of titles of site: " + siteId));
    }

    public void validateDistributionSiteforDistribution(Site distSite) {
        if (distSite == null) {
            throw new RuntimeException("No distribution site with given id exists.");
        }
        if (distSite.getType() != SiteType.DISTRIBUTION) {
            throw new RuntimeException("Given siteId: " + distSite.getId() + " does not correspond to a Distribution Site");
        }
        if (!distSite.isActive()) {
            throw new InactiveSiteException(distSite);
        }
    }

    public void validateTitleforDistribution(DistributionSiteTitle dst, long localTitleId, int siteId) {
        if (dst == null) {
            throw new SiteManagementException("No title exist with the given titleId: " + localTitleId + " in the given site: " + siteId);
        }
        if (dst.getStatus() == DistributionStatus.TARGETED || dst.getStatus() == DistributionStatus.IN_PROGRESS) {
            throw new SiteManagementException("Cannot distribute title: " + localTitleId + ", status is: " + dst.getStatus());
        }
    }

    private void execute(Runnable r) {
        new Thread(r).start();
    }

    protected void distributeImmediately(DistributionSiteTitle dst) {
        dst.setStatus(DistributionStatus.IN_PROGRESS);
        dst.setDistributedVersion(dst.getTitle().getVersion());
        DistTimeoutManager.getInstance().errorOut(dst, (int)dst.getDistributionSite().getAlertDelayPeriod());
        DistributionSite distSite = dst.getDistributionSite();
        Set trackingSites = distSite.getChildren();
        if (trackingSites != null) {
            for (TrackingSite ts : trackingSites) {
                TrackingSiteTitle tst = this.getTrackingSiteTitle(ts.getId(), dst.getTitle().getId());
                if (tst != null) {
                    tst.setStatus(TrackingStatus.TARGETED);
                    continue;
                }
                tst = new TrackingSiteTitle(ts, dst.getTitle(), TrackingStatus.TARGETED);
                this.getSession().saveOrUpdate((Object)tst);
            }
        }
        logger.info((Object)("Distributing Title: " + dst));
        String resourceConnectionString = distSite.getAssociatedResourceId() != null ? this.getResourceConnectionString(distSite.getAssociatedResourceId()) : null;
        DistributionManager.getInstance().distribute(distSite.getId(), dst.getTitle().getId(), distSite.getDistTemplateName(), resourceConnectionString, distSite.getDistConfParams());
    }

    private String getResourceConnectionString(Long resourceId) {
        ResourceManagement rm = (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class);
        Resource resource = null;
        Transaction transaction = JTATransactionManager.trySuspendTransaction();
        try {
            resource = rm.getResource(resourceId.longValue());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get resource with id: " + resourceId, e);
        }
        finally {
            JTATransactionManager.tryResumeTransaction(transaction);
        }
        return resource.getConnectionString();
    }

    public void updateDistributionStatus(long localTitleId, DistributionStatus status) {
        if (status != DistributionStatus.DISTRIBUTED && status != DistributionStatus.FAILED) {
            throw new RuntimeException("Status cannot be requested to be set to anything other than: " + DistributionStatus.DISTRIBUTED + " and " + DistributionStatus.FAILED + " | Requested to set to: " + status);
        }
        DistributionSiteTitle dst = this.getDistributionSiteTitle(localTitleId);
        if (dst == null) {
            throw new RuntimeException("No title found with id: " + localTitleId + " in any Distribution Site");
        }
        if (dst.getStatus() == DistributionStatus.TARGETED || dst.getStatus() == DistributionStatus.READY_FOR_DISTRIBUTION) {
            logger.info((Object)("Ignoring distribution status update for [local title id: " + localTitleId + " | site id: " + dst.getDistributionSite().getId() + " | status: " + status + "] Reason: Title must have got retargeted. Title is in status: " + dst.getStatus()));
            return;
        }
        dst.setStatus(status);
        this.getSession().saveOrUpdate((Object)dst);
    }

    public void updateTrackingStatus(int siteId, long localTitleId, TrackingStatus status) {
        if (status == TrackingStatus.TARGETED) {
            throw new RuntimeException("Status cannot be requested to be set to: " + status);
        }
        TrackingSite ts = this.getTrackingSite(siteId);
        TrackingSiteTitle tst = this.getTrackingSiteTitle(siteId, localTitleId);
        if (tst == null) {
            throw new RuntimeException("Title with given id: " + localTitleId + " is not found in site: " + siteId);
        }
        tst.setStatus(status);
        this.getSession().saveOrUpdate((Object)tst);
        if (status == TrackingStatus.DEPLOYMENT_IN_PROGRESS) {
            DistTimeoutManager.getInstance().errorOut(tst, (int)ts.getAlertDelayPeriod());
        }
    }

    public void updateTitlesStatusFromInProgressToFailed() {
        int updatedRecordsCount = this.getSession().createQuery("Update DistributionSiteTitle set status = " + DistributionStatus.FAILED.ordinal() + " where status = " + DistributionStatus.IN_PROGRESS.ordinal()).executeUpdate();
        logger.info((Object)("Updated " + updatedRecordsCount + " distribution site titles status from " + DistributionStatus.IN_PROGRESS + " to " + DistributionStatus.FAILED));
        updatedRecordsCount = this.getSession().createQuery("Update TrackingSiteTitle set status = " + TrackingStatus.DEPLOYMENT_FAILED.ordinal() + " where status = " + TrackingStatus.DEPLOYMENT_IN_PROGRESS.ordinal()).executeUpdate();
        logger.info((Object)("Updated " + updatedRecordsCount + " tracking site titles status from " + TrackingStatus.DEPLOYMENT_IN_PROGRESS + " to " + TrackingStatus.DEPLOYMENT_FAILED));
    }

    public Map<Title, Exception> purgeSiteTitles(long masterTitleId) {
        HashMap<Title, Exception> failedTitles = new HashMap<Title, Exception>();
        for (Title localTitle : this.getSiteCopies(masterTitleId)) {
            try {
                this.ruleExecHandler.runRuler(localTitle, TreEvent.PURGE, new TrePackage("PROCESSING"));
            }
            catch (Exception e) {
                failedTitles.put(localTitle, e);
            }
        }
        return failedTitles;
    }

    @Deprecated
    public void delete(long localTitleId) {
        this.deleteTitle(localTitleId);
    }

    public void deleteTitle(long localTitleId) {
        DistributionSiteTitle dst = this.getDistributionSiteTitle(localTitleId);
        if (dst == null) {
            throw new RuntimeException("No title found with id: " + localTitleId + " in any Distribution Site");
        }
        Set trackingSites = dst.getDistributionSite().getChildren();
        for (TrackingSite ts : trackingSites) {
            TrackingSiteTitle tst = this.getTrackingSiteTitle(ts.getId(), localTitleId);
            if (tst == null) continue;
            this.getSession().delete((Object)tst);
        }
        this.getSession().delete((Object)dst);
        this.titleManager.delete(Long.valueOf(localTitleId));
    }

    public void deleteTrackingSiteTitle(long localTitleId, int trackingSiteId) {
        TrackingSiteTitle tst = this.getTrackingSiteTitle(localTitleId, trackingSiteId);
        if (tst == null) {
            throw new RuntimeException("No title found with id: " + localTitleId + " in Tracking Site: " + trackingSiteId);
        }
        this.getSession().delete((Object)tst);
    }

    public Job getTimerJob(DistributionSite distSite) {
        Job timerJob = null;
        List jobs = this.scheduler.getJobsByAssociatedEntity(ASSOCIATED_ENTITY_TYPE_SITE_TIMER, (long)distSite.getId().intValue());
        if (jobs != null && jobs.size() > 0) {
            timerJob = (Job)jobs.get(0);
        }
        return timerJob;
    }

    protected LogicalSite getLogicalSite(int siteId) {
        Site site = this.internalGetSite(siteId);
        if (site.getType() != SiteType.LOGICAL) {
            throw new RuntimeException("Given siteId: " + siteId + " does not correspond to a Logical Site");
        }
        return (LogicalSite)site;
    }

    protected DistributionSite getDistributionSite(int siteId) {
        Site site = this.internalGetSite(siteId);
        if (site.getType() != SiteType.DISTRIBUTION) {
            throw new RuntimeException("Given siteId: " + siteId + " does not correspond to a Distribution Site");
        }
        return (DistributionSite)site;
    }

    protected TrackingSite getTrackingSite(int siteId) {
        Site site = this.internalGetSite(siteId);
        if (site.getType() != SiteType.TRACKING) {
            throw new RuntimeException("Given siteId: " + siteId + " does not correspond to a Tracking Site");
        }
        return (TrackingSite)site;
    }

    protected Site internalGetSite(int siteId) {
        Site site = this.getSite(siteId);
        if (site == null) {
            throw new RuntimeException("No site found for the given id: " + siteId);
        }
        return site;
    }

    protected Title getMasterTitle(long titleId, boolean lock) {
        Title title;
        Title title2 = title = lock ? this.titleManager.getForUpdate(Long.valueOf(titleId)) : this.titleManager.get(Long.valueOf(titleId));
        if (title == null) {
            throw new SiteManagementException("No master title found for the given id: " + titleId);
        }
        if (!title.getIsActive().booleanValue()) {
            throw new SiteManagementException("The master title for id: " + titleId + " is inactive.");
        }
        if (title.isCopy()) {
            throw new SiteManagementException("Failed to get master title for id: " + titleId + ", title with given id is not a master title.");
        }
        return title;
    }

    protected Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    public List<MasterTitleDistStatus> getRecentDistributionActivity(List<DistributionStatus> distributionStatus, int startIndex, int pageSize, boolean isAscending, List<Long> partnerIdsFilter) {
        List siteMasterTitles;
        Session session = this.getSession();
        String queryStr = "SELECT t.originalId FROM DistributionSiteTitle dst JOIN dst.title t WHERE dst.status IN (:status) ";
        if (!partnerIdsFilter.isEmpty()) {
            queryStr = queryStr + "AND t.partnerId in (:partners) ";
        }
        queryStr = queryStr + "GROUP BY t.originalId ORDER BY max(dst.statusUpdatedTime) ";
        queryStr = queryStr + (isAscending ? "ASC" : "DESC");
        Query query = session.createQuery(queryStr);
        query.setMaxResults(pageSize);
        query.setFirstResult(startIndex);
        query.setParameterList("status", distributionStatus);
        if (!partnerIdsFilter.isEmpty()) {
            query.setParameterList("partners", partnerIdsFilter);
        }
        if ((siteMasterTitles = query.list()).isEmpty()) {
            return new ArrayList<MasterTitleDistStatus>();
        }
        queryStr = "SELECT t.originalId, dst.status FROM DistributionSiteTitle dst JOIN dst.title t WHERE t.originalId IN (:originalIds) AND dst.status IN (:status) ";
        if (!partnerIdsFilter.isEmpty()) {
            queryStr = queryStr + "AND t.partnerId in (:partners) ";
        }
        queryStr = queryStr + "GROUP BY t.originalId, dst.status ORDER BY max(dst.statusUpdatedTime) ";
        queryStr = queryStr + (isAscending ? "ASC" : "DESC");
        query = session.createQuery(queryStr);
        query.setParameterList("originalIds", (Collection)siteMasterTitles);
        query.setParameterList("status", distributionStatus);
        if (!partnerIdsFilter.isEmpty()) {
            query.setParameterList("partners", partnerIdsFilter);
        }
        List queryResults = query.list();
        ArrayList<MasterTitleDistStatus> results = new ArrayList<MasterTitleDistStatus>();
        for (Object[] obj : queryResults) {
            Long id = (Long)obj[0];
            DistributionStatus status = (DistributionStatus)obj[1];
            boolean found = false;
            for (MasterTitleDistStatus mtds : results) {
                if (!id.equals(mtds.getMasterTitleId())) continue;
                found = true;
                mtds.addStatus(status);
                break;
            }
            if (found) continue;
            results.add(new MasterTitleDistStatus(id.longValue(), status));
        }
        return results;
    }

    public List<DistributionSiteTitle> getDistributionSiteTitlesByMasterTitleId(long masterTitleId) {
        String queryStr = "FROM DistributionSiteTitle WHERE title.originalId = :masterTitleId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("masterTitleId", (Object)masterTitleId);
        List siteTitles = query.list();
        return siteTitles;
    }

    public int getMasterTitleCountOfLogicalSite(int logicalSiteId, List<Long> partnerIds) {
        List res;
        String queryStr = "SELECT count(distinct dst.title.originalId) FROM DistributionSiteTitle dst WHERE dst.distributionSite.parent.id = :logicalSiteId";
        if (!partnerIds.isEmpty()) {
            queryStr = queryStr + " AND  dst.title.partnerId in (:partners) ";
        }
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("logicalSiteId", (Object)logicalSiteId);
        if (!partnerIds.isEmpty()) {
            query.setParameterList("partners", partnerIds);
        }
        if ((res = query.list()).size() > 0) {
            return ((Long)res.get(0)).intValue();
        }
        return 0;
    }

    public int getMasterTitleCountOfDistributionSite(int distSiteId, List<Long> partnerIds) {
        List res;
        StringBuilder queryStr = new StringBuilder("SELECT count(distinct dst.title.originalId) FROM DistributionSiteTitle dst WHERE dst.distributionSite.id = :distSiteId ");
        if (!partnerIds.isEmpty()) {
            queryStr.append("AND dst.title.partnerId in (:partners) ");
        }
        Session session = this.getSession();
        Query query = session.createQuery(queryStr.toString());
        query.setParameter("distSiteId", (Object)distSiteId);
        if (!partnerIds.isEmpty()) {
            query.setParameterList("partners", partnerIds);
        }
        if ((res = query.list()).size() > 0) {
            return ((Long)res.get(0)).intValue();
        }
        return 0;
    }

    public List<Long> getMasterTitleIdsOfLogicalSite(int logicalSiteId, int startIndex, int pageSize, boolean isAscending, List<Long> partnerIds) {
        StringBuilder queryStr = new StringBuilder("SELECT t.originalId FROM DistributionSiteTitle dst JOIN dst.title t WHERE dst.distributionSite.parent.id = :logicalSiteId ");
        if (!partnerIds.isEmpty()) {
            queryStr.append("AND t.partnerId in (:partners) ");
        }
        queryStr.append("group by t.originalId order by t.originalId ");
        queryStr.append(isAscending ? "ASC" : "DESC");
        Session session = this.getSession();
        Query query = session.createQuery(queryStr.toString());
        query.setMaxResults(pageSize);
        query.setFirstResult(startIndex);
        query.setParameter("logicalSiteId", (Object)logicalSiteId);
        if (!partnerIds.isEmpty()) {
            query.setParameterList("partners", partnerIds);
        }
        List masterTitleIds = query.list();
        return masterTitleIds;
    }

    public List<Long> getMasterTitleIdsOfDistributionSite(int distSiteId, int startIndex, int pageSize, boolean isAscending, List<Long> partnerIds) {
        StringBuilder queryStr = new StringBuilder("SELECT t.originalId FROM DistributionSiteTitle dst JOIN dst.title t WHERE dst.distributionSite.id = :distSiteId ");
        if (!partnerIds.isEmpty()) {
            queryStr.append("AND t.partnerId in (:partners) ");
        }
        queryStr.append("GROUP BY t.originalId ORDER BY t.originalId ");
        queryStr.append(isAscending ? "ASC" : "DESC");
        Session session = this.getSession();
        Query query = session.createQuery(queryStr.toString());
        query.setMaxResults(pageSize);
        query.setFirstResult(startIndex);
        query.setParameter("distSiteId", (Object)distSiteId);
        if (!partnerIds.isEmpty()) {
            query.setParameterList("partners", partnerIds);
        }
        List masterTitleIds = query.list();
        return masterTitleIds;
    }

    public List<List<?>> getAggDistStatusCountsOfLogicalSite(int logicalSiteId, boolean isAscending, long startMasterTitleId, long endMasterTitleId, List<Long> partnerIds) {
        StringBuilder queryStr = new StringBuilder("SELECT new list(t.originalId, dst.status, count(*)) FROM DistributionSiteTitle dst JOIN dst.title t WHERE dst.distributionSite.parent.id = :logicalSiteId AND t.originalId >= :startMasterTitleId and t.originalId <= :endMasterTitleId ");
        if (!partnerIds.isEmpty()) {
            queryStr.append("AND t.partnerId in (:partners) ");
        }
        queryStr.append("group by t.originalId, dst.status order by t.originalId ");
        queryStr.append(isAscending ? "ASC" : "DESC");
        Session session = this.getSession();
        Query query = session.createQuery(queryStr.toString());
        query.setParameter("logicalSiteId", (Object)logicalSiteId);
        query.setParameter("startMasterTitleId", (Object)startMasterTitleId);
        query.setParameter("endMasterTitleId", (Object)endMasterTitleId);
        if (!partnerIds.isEmpty()) {
            query.setParameterList("partners", partnerIds);
        }
        List aggDistCounts = query.list();
        return aggDistCounts;
    }

    public List<List<?>> getAggDistStatusCountsOfDistributionSite(int distSiteId, boolean isAscending, long startMasterTitleId, long endMasterTitleId, List<Long> partnerIds) {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("SELECT new list(t.originalId, dst.status, count(*))");
        queryStr.append("FROM DistributionSiteTitle dst JOIN dst.title t WHERE ");
        if (!partnerIds.isEmpty()) {
            queryStr.append("t.partnerId in (:partners) AND ");
        }
        queryStr.append("dst.distributionSite.id = :distSiteId and ");
        queryStr.append("t.originalId >= :startMasterTitleId and t.originalId <= :endMasterTitleId ");
        queryStr.append("group by t.originalId, dst.status order by t.originalId ");
        queryStr.append(isAscending ? "ASC" : "DESC");
        Session session = this.getSession();
        Query query = session.createQuery(queryStr.toString());
        query.setParameter("distSiteId", (Object)distSiteId);
        query.setParameter("startMasterTitleId", (Object)startMasterTitleId);
        query.setParameter("endMasterTitleId", (Object)endMasterTitleId);
        if (!partnerIds.isEmpty()) {
            query.setParameterList("partners", partnerIds);
        }
        List aggDistCounts = query.list();
        return aggDistCounts;
    }

    public List<List<?>> getAggTrackStatusCountsOfLogicalSite(int logicalSiteId, boolean isAscending, long startMasterTitleId, long endMasterTitleId, List<Long> partnerIds) {
        StringBuilder queryStr = new StringBuilder("SELECT new list(tst.title.originalId, tst.status, count(*)) FROM TrackingSiteTitle tst JOIN tst.trackingSite.parents distSite JOIN distSite.distributionSiteTitles dst WHERE tst.title.id = dst.title.id AND distSite.parent.id = :logicalSiteId AND tst.title.originalId >= :startMasterTitleId AND tst.title.originalId <= :endMasterTitleId ");
        if (!partnerIds.isEmpty()) {
            queryStr.append("AND dst.title.partnerId in (:partners) ");
        }
        queryStr.append("group by tst.title.originalId, tst.status order by tst.title.originalId ");
        queryStr.append(isAscending ? "ASC" : "DESC");
        Session session = this.getSession();
        Query query = session.createQuery(queryStr.toString());
        query.setParameter("logicalSiteId", (Object)logicalSiteId);
        query.setParameter("startMasterTitleId", (Object)startMasterTitleId);
        query.setParameter("endMasterTitleId", (Object)endMasterTitleId);
        if (!partnerIds.isEmpty()) {
            query.setParameterList("partners", partnerIds);
        }
        List aggTrackCounts = query.list();
        return aggTrackCounts;
    }

    public List<List<?>> getAggTrackStatusCountsOfDistributionSite(int distSiteId, boolean isAscending, long startMasterTitleId, long endMasterTitleId, List<Long> partnerIds) {
        StringBuilder queryStr = new StringBuilder("SELECT new list(tst.title.originalId, tst.status, count(*)) FROM TrackingSiteTitle tst join tst.trackingSite.parents distSite join distSite.distributionSiteTitles dst WHERE tst.title.id = dst.title.id and distSite.id = :distSiteId AND tst.title.originalId >= :startMasterTitleId AND tst.title.originalId <= :endMasterTitleId ");
        if (!partnerIds.isEmpty()) {
            queryStr.append("AND dst.title.partnerId in (:partners) ");
        }
        queryStr.append("group by tst.title.originalId, tst.status order by tst.title.originalId ");
        queryStr.append(isAscending ? "ASC" : "DESC");
        Session session = this.getSession();
        Query query = session.createQuery(queryStr.toString());
        query.setParameter("distSiteId", (Object)distSiteId);
        query.setParameter("startMasterTitleId", (Object)startMasterTitleId);
        query.setParameter("endMasterTitleId", (Object)endMasterTitleId);
        if (!partnerIds.isEmpty()) {
            query.setParameterList("partners", partnerIds);
        }
        List aggTrackCounts = query.list();
        return aggTrackCounts;
    }

    public Set<Integer> getActiveDistributionSitesInError(List<Long> partnerIds) {
        StringBuilder querySB = new StringBuilder("SELECT DISTINCT site.ID_ FROM SITES_SITE site, SITES_DISTSITETITLE dst");
        if (!this.isNullOrEmpty(partnerIds)) {
            querySB.append(", PMM_TITLE title");
        }
        querySB.append(" WHERE site.active=1 AND site.ID_=dst.siteId AND dst.status=").append(DistributionStatus.FAILED.ordinal());
        if (!this.isNullOrEmpty(partnerIds)) {
            querySB.append(" AND dst.titleId=title.ID_ AND (title.PARTNER_ID in (:partnerIds))");
        }
        SQLQuery query = this.getSession().createSQLQuery(querySB.toString());
        if (!this.isNullOrEmpty(partnerIds)) {
            query.setParameterList("partnerIds", partnerIds);
        }
        List resultList = query.list();
        HashSet<Integer> result = new HashSet<Integer>();
        if (resultList != null) {
            for (Object o : resultList) {
                result.add(((BigDecimal)o).intValueExact());
            }
        }
        return result;
    }

    public Set<String> getActiveTrackingSitesInError(List<Long> partnerIds) {
        StringBuilder querySB = new StringBuilder("SELECT DISTINCT dst.siteid AS dsid, tst.siteid AS tsid").append(" FROM SITES_TRACKSITETITLE tst, SITES_SITE site, SITES_DISTSITETITLE dst");
        if (!this.isNullOrEmpty(partnerIds)) {
            querySB.append(", PMM_TITLE title");
        }
        querySB.append(" WHERE tst.status=").append(TrackingStatus.DEPLOYMENT_FAILED.ordinal()).append(" AND tst.siteid=site.id_ AND site.active=1").append(" AND tst.titleid = dst.titleid");
        if (!this.isNullOrEmpty(partnerIds)) {
            querySB.append(" AND tst.titleId=title.ID_ AND (title.PARTNER_ID in (:partnerIds))");
        }
        SQLQuery query = this.getSession().createSQLQuery(querySB.toString());
        if (!this.isNullOrEmpty(partnerIds)) {
            query.setParameterList("partnerIds", partnerIds);
        }
        List resultList = query.list();
        HashSet<String> result = new HashSet<String>();
        if (resultList != null) {
            for (Object[] cols : resultList) {
                int dsid = ((BigDecimal)cols[0]).intValueExact();
                int tsid = ((BigDecimal)cols[1]).intValueExact();
                result.add(dsid + "_" + tsid);
            }
        }
        return result;
    }

    private boolean isNullOrEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    public boolean isSiteNameAlreadyUsed(String siteName) {
        boolean isSiteNameAlreadyUsed = false;
        String queryStr = "from Site where name = :siteName";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("siteName", (Object)siteName);
        List sites = query.list();
        if (sites.size() > 0) {
            isSiteNameAlreadyUsed = true;
        }
        return isSiteNameAlreadyUsed;
    }

    public boolean isExternalSiteIdAlreadyUsed(String externalSiteId, SiteType siteType) {
        boolean isExternalSiteIdAlreadyUsed = false;
        String queryStr = "from Site where externalId = :externalSiteId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("externalSiteId", (Object)externalSiteId);
        List sites = query.list();
        for (Site site : sites) {
            if (site.getType().equals((Object)siteType)) continue;
            isExternalSiteIdAlreadyUsed = true;
        }
        return isExternalSiteIdAlreadyUsed;
    }

    private void scheduleTimerJob(DistributionSite distSite) {
        Job timerJob = distSite.getTimerJob();
        if (timerJob != null) {
            Integer siteId = distSite.getId();
            String siteName = distSite.getName();
            String jobName = JOB_PREFIX_SITE_TIMER + siteName;
            String associatedEntityType = ASSOCIATED_ENTITY_TYPE_SITE_TIMER;
            HashSet<Long> associatedEntities = new HashSet<Long>();
            associatedEntities.add(Long.valueOf(String.valueOf(siteId)));
            String associationDescription = ASSOCIATION_DESCRIPTION_PREFIX_SITE_TIMER + siteName + ASSOCIATION_DESCRIPTION_SUFFIX_SITE_TIMER;
            timerJob.setName(jobName);
            timerJob.setAssociatedEntityType(associatedEntityType);
            timerJob.setAssociatedEntities(associatedEntities);
            timerJob.setAssociationDescription(associationDescription);
            timerJob.setCallbackClass(SiteTimerSchedulerCallback.class);
            Job job = this.scheduler.schedule(timerJob);
            if (job.isActive() != distSite.isActive()) {
                this.scheduler.setActive(job.getId().longValue(), distSite.isActive());
            }
        }
    }

    public Integer getDistributionSiteId(Long siteTitleId) {
        String queryStr = "SELECT dst.distributionSite.id FROM DistributionSiteTitle dst WHERE title.id = :siteTitleId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("siteTitleId", (Object)siteTitleId);
        return (Integer)query.uniqueResult();
    }

    public void updateTrackingStatus(String externalId, long localTitleId, TrackingStatus status) {
        List<Site> matchingSites = this.getSitesByExternalId(externalId);
        if (matchingSites == null || matchingSites.isEmpty()) {
            throw new SiteManagementException("No site with externalId: " + externalId + " was found.");
        }
        Site ts = matchingSites.get(0);
        this.updateTrackingStatus(ts.getId(), localTitleId, status);
    }

    public List<Long> getSiteTitleIds(long masterTitleId, Set<String> externalSiteIds) {
        StringBuffer siteExtIds = new StringBuffer();
        for (String id : externalSiteIds) {
            if (siteExtIds.length() > 0) {
                siteExtIds.append(",");
            }
            siteExtIds.append("'" + id + "'");
        }
        String queryStr = "select t.id_ from (select id_ from pmm_title where TITLESTATUSID <> 5 start with originaltitle_id is null and id_ = :masterTitleId connect by  prior id_ = originaltitle_id) t, sites_site s, sites_distsitetitle dst where s.EXTERNALID in (" + siteExtIds + " )" + " and dst.TITLEID = t.ID_" + " and dst.SITEID = s.ID_";
        Session session = this.getSession();
        SQLQuery query = session.createSQLQuery(queryStr);
        query.setParameter("masterTitleId", (Object)masterTitleId);
        return query.list();
    }

    public Map<Integer, Long> getDistributionSiteTitleIdsByMasterTitleIdForTrackingSite(long masterTitleId, String trackingSiteExternalId) {
        String queryStr = "select distinct t.id_ as siteTitleId, dst.siteid siteId from (select id_ from pmm_title where TITLESTATUSID <> 5 start with originaltitle_id is null and id_ = " + masterTitleId + " connect by  prior id_ = originaltitle_id) t, sites_site s, sites_distsitetitle dst, sites_tracksitetitle ts" + " where" + " dst.TITLEID = t.ID_" + " and ts.titleid = t.ID_" + " and s.EXTERNALID = '" + trackingSiteExternalId + "'" + " and ts.siteid = s.id_";
        SQLQuery query = this.getSession().createSQLQuery(queryStr);
        List resultList = query.list();
        HashMap<Integer, Long> result = new HashMap<Integer, Long>();
        if (resultList != null) {
            for (Object[] cols : resultList) {
                int dstSiteId = ((BigDecimal)cols[0]).intValueExact();
                long dstTitleId = ((BigDecimal)cols[1]).intValueExact();
                result.put(dstSiteId, dstTitleId);
            }
        }
        return result;
    }

    public Boolean hasMPWithTrackingSites() {
        List<DistributionSite> distSites = this.getAllDistributionSites();
        if (distSites != null) {
            for (DistributionSite distributionSite : distSites) {
                Set trackingSites;
                if (!(distributionSite instanceof MediapathDistributionSite) || (trackingSites = distributionSite.getChildren()) == null || trackingSites.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public Boolean isMediaPathSiteTitle(Integer siteId) {
        Site site = this.getSite(siteId);
        if (site != null && site instanceof MediapathDistributionSite) {
            return true;
        }
        return false;
    }
}

