/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core;

import com.ericsson.cms.scheduler.entities.Job;
import com.ericsson.cms.sites.core.EntitiesAssociatedException;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.ISiteManagerRemote;
import com.ericsson.cms.sites.core.SiteManagementException;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.DistributionSiteTitle;
import com.ericsson.cms.sites.core.entities.DistributionStatus;
import com.ericsson.cms.sites.core.entities.LogicalSite;
import com.ericsson.cms.sites.core.entities.MasterTitleDistStatus;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.SitePartner;
import com.ericsson.cms.sites.core.entities.SiteType;
import com.ericsson.cms.sites.core.entities.TargetResult;
import com.ericsson.cms.sites.core.entities.TrackingSite;
import com.ericsson.cms.sites.core.entities.TrackingSiteTitle;
import com.ericsson.cms.sites.core.entities.TrackingStatus;
import com.ericsson.cms.sites.distribution.TemplateInfo;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.hibernate.Session;

@Stateless(mappedName="cms/SiteManagerRemote/remote")
@Remote(value={ISiteManagerRemote.class})
public class SiteManagerRemote
implements ISiteManagerRemote {
    private ISiteManager siteManager = (ISiteManager)InjectionUtil.injectInstance((String)"/cms/SiteManager/local", ISiteManager.class);

    public Site getSite(int siteId) {
        return this.siteManager.getSite(siteId);
    }

    public Site getSiteByName(String siteName) {
        return this.siteManager.getSiteByName(siteName);
    }

    public List<Site> getSitesByExternalId(String externalId) {
        return this.siteManager.getSitesByExternalId(externalId);
    }

    public List<Site> getAllSites() {
        return this.siteManager.getAllSites();
    }

    public List<Site> getTopLevelSites() {
        return this.siteManager.getTopLevelSites();
    }

    public List<DistributionSite> getAllDistributionSites() {
        return this.siteManager.getAllDistributionSites();
    }

    public List<DistributionSite> getActiveDistributionSites() {
        return this.siteManager.getActiveDistributionSites();
    }

    public List<TrackingSite> getShareableTrackingSites(int distributionSiteId) {
        return this.siteManager.getShareableTrackingSites(distributionSiteId);
    }

    public List<Title> getSiteCopies(long masterTitleId) {
        return this.siteManager.getSiteCopies(masterTitleId);
    }

    public List<Long> getSiteCopyIds(long masterTitleId) {
        return this.siteManager.getSiteCopyIds(masterTitleId);
    }

    public DistributionSite getAssociatedDistributionSite(long localTitleId) {
        return this.siteManager.getAssociatedDistributionSite(localTitleId);
    }

    public DistributionSiteTitle getDistributionSiteTitleById(long dstId) {
        return this.siteManager.getDistributionSiteTitleById(dstId);
    }

    public DistributionSiteTitle getDistributionSiteTitle(long localTitleId) {
        return this.siteManager.getDistributionSiteTitle(localTitleId);
    }

    public List<DistributionSiteTitle> getDistributionSiteTitles(long masterTitleId) {
        return this.siteManager.getDistributionSiteTitles(masterTitleId);
    }

    public List<DistributionSiteTitle> getDistributionSiteTitles(int siteId, List<Long> partnerIds) {
        return this.siteManager.getDistributionSiteTitles(siteId, partnerIds);
    }

    public List<DistributionSiteTitle> getDistributionSiteTitlesByStatus(DistributionStatus status) {
        return this.siteManager.getDistributionSiteTitlesByStatus(status);
    }

    public List<DistributionSiteTitle> getDistributionSiteTitlesBySiteAndStatus(int siteId, DistributionStatus status) {
        return this.siteManager.getDistributionSiteTitlesBySiteAndStatus(siteId, status);
    }

    public List<Long> getDistributionSiteTitleIdsBySiteAndStatus(int siteId, DistributionStatus status) {
        return this.siteManager.getDistributionSiteTitleIdsBySiteAndStatus(siteId, status);
    }

    public List<TrackingSiteTitle> getTrackingSiteTitlesByStatus(TrackingStatus status) {
        return this.siteManager.getTrackingSiteTitlesByStatus(status);
    }

    public List<DistributionSiteTitle> getDistributionSiteTitlesOfLogicalSite(int logicalSiteId, List<Long> partnerIds) {
        return this.siteManager.getDistributionSiteTitlesOfLogicalSite(logicalSiteId, partnerIds);
    }

    public List<TrackingSiteTitle> getTrackingSiteTitles(long localTitleId) {
        return this.siteManager.getTrackingSiteTitles(localTitleId);
    }

    public TrackingSiteTitle getTrackingSiteTitle(long localTitleId, int trackingSiteId) {
        return this.siteManager.getTrackingSiteTitle(localTitleId, trackingSiteId);
    }

    public LogicalSite createLogicalSite(LogicalSite site) {
        return this.siteManager.createLogicalSite(site);
    }

    public LogicalSite createLogicalSite(LogicalSite site, SitePartner sitePartner) {
        return this.siteManager.createLogicalSite(site, sitePartner);
    }

    public boolean hasReachedMaxLicensedDistributionSites() {
        return this.siteManager.hasReachedMaxLicensedDistributionSites();
    }

    public DistributionSite createDistributionSite(DistributionSite site, Integer parentSiteId) {
        return this.siteManager.createDistributionSite(site, parentSiteId);
    }

    public DistributionSite createDistributionSite(DistributionSite site, Integer parentSiteId, SitePartner sitePartner) {
        return this.siteManager.createDistributionSite(site, parentSiteId, sitePartner);
    }

    public boolean hasReachedMaxLicensedTrackingSites() {
        return this.siteManager.hasReachedMaxLicensedTrackingSites();
    }

    public TrackingSite createTrackingSite(TrackingSite site, Integer parentSiteId) {
        return this.siteManager.createTrackingSite(site, parentSiteId);
    }

    public void associateTrackingSites(Set<Integer> trackingSiteIds, int distributionSiteId) {
        this.siteManager.associateTrackingSites(trackingSiteIds, distributionSiteId);
    }

    public void dissociateTrackingSite(int trackingSiteId, int distributionSiteId) {
        this.siteManager.dissociateTrackingSite(trackingSiteId, distributionSiteId);
    }

    public Site save(Site site) {
        return this.siteManager.save(site);
    }

    public SitePartner save(Site site, SitePartner sitePartner) {
        return this.siteManager.save(site, sitePartner);
    }

    public Site updateSiteProperties(Site site) {
        return this.siteManager.updateSiteProperties(site);
    }

    public SitePartner updateSitePartnerProperties(Site site, SitePartner sitePartner) {
        return this.siteManager.updateSitePartnerProperties(site, sitePartner);
    }

    public void delete(int siteId) throws EntitiesAssociatedException {
        this.siteManager.delete(siteId);
    }

    public void activate(int siteId) throws SiteManagementException {
        this.siteManager.activate(siteId);
    }

    public void inactivate(int siteId) throws SiteManagementException {
        this.siteManager.inactivate(siteId);
    }

    public Set<TemplateInfo> getDistributionTemplatesInfo() {
        return this.siteManager.getDistributionTemplatesInfo();
    }

    public Set<String> getDistributionTemplateNames() {
        return this.siteManager.getDistributionTemplateNames();
    }

    public Title createSiteCopy(long masterTitleId, int distributionSiteId) throws SiteManagementException {
        return this.siteManager.createSiteCopy(masterTitleId, distributionSiteId);
    }

    public Set<Site> target(long masterTitleId, List<Integer> siteIds) throws SiteManagementException {
        return this.siteManager.target(masterTitleId, siteIds);
    }

    public TargetResult targetWithRules(long masterTitleId) {
        return this.siteManager.targetWithRules(masterTitleId);
    }

    @Deprecated
    public void distribute(int siteId, List<Long> localTitleIds) throws SiteManagementException {
        this.siteManager.distribute(siteId, localTitleIds);
    }

    public void distribute(long localTitleId) throws SiteManagementException {
        this.siteManager.distribute(localTitleId);
    }

    public void distributeImmediately(long localTitleId) throws SiteManagementException {
        this.siteManager.distributeImmediately(localTitleId);
    }

    public void distributeImmediately(int siteId, List<Long> localTitleIds) throws SiteManagementException {
        this.siteManager.distributeImmediately(siteId, localTitleIds);
    }

    public void distributeReadyTitlesImmediately(int siteId) throws SiteManagementException {
        this.siteManager.distributeReadyTitlesImmediately(siteId);
    }

    public void updateDistributionStatus(long localTitleId, DistributionStatus status) {
        this.siteManager.updateDistributionStatus(localTitleId, status);
    }

    public void updateTrackingStatus(int siteId, long localTitleId, TrackingStatus status) {
        this.siteManager.updateTrackingStatus(siteId, localTitleId, status);
    }

    public void updateTrackingStatus(String externalId, long localTitleId, TrackingStatus status) {
        this.siteManager.updateTrackingStatus(externalId, localTitleId, status);
    }

    public void updateTitlesStatusFromInProgressToFailed() {
        this.siteManager.updateTitlesStatusFromInProgressToFailed();
    }

    public Map<Title, Exception> purgeSiteTitles(long masterTitleId) {
        return this.siteManager.purgeSiteTitles(masterTitleId);
    }

    @Deprecated
    public void delete(long localTitleId) {
        this.siteManager.delete(localTitleId);
    }

    public void deleteTitle(long localTitleId) {
        this.siteManager.deleteTitle(localTitleId);
    }

    public void deleteTrackingSiteTitle(long localTitleId, int trackingSiteId) {
        this.siteManager.deleteTrackingSiteTitle(localTitleId, trackingSiteId);
    }

    public List<MasterTitleDistStatus> getRecentDistributionActivity(List<DistributionStatus> distributionStatus, int startIndex, int pageSize, boolean isAscending, List<Long> partnerIdsFilter) {
        return this.siteManager.getRecentDistributionActivity(distributionStatus, startIndex, pageSize, isAscending, partnerIdsFilter);
    }

    public List<DistributionSiteTitle> getDistributionSiteTitlesByMasterTitleId(long titleId) {
        return this.siteManager.getDistributionSiteTitlesByMasterTitleId(titleId);
    }

    public int getMasterTitleCountOfLogicalSite(int logicalSiteId, List<Long> partnerIds) {
        return this.siteManager.getMasterTitleCountOfLogicalSite(logicalSiteId, partnerIds);
    }

    public int getMasterTitleCountOfDistributionSite(int distSiteId, List<Long> partnerIds) {
        return this.siteManager.getMasterTitleCountOfDistributionSite(distSiteId, partnerIds);
    }

    public List<Long> getMasterTitleIdsOfLogicalSite(int logicalSiteId, int startIndex, int pageSize, boolean isAscending, List<Long> partnerIds) {
        return this.siteManager.getMasterTitleIdsOfLogicalSite(logicalSiteId, startIndex, pageSize, isAscending, partnerIds);
    }

    public List<Long> getMasterTitleIdsOfDistributionSite(int distSiteId, int startIndex, int pageSize, boolean isAscending, List<Long> partnerIds) {
        return this.siteManager.getMasterTitleIdsOfDistributionSite(distSiteId, startIndex, pageSize, isAscending, partnerIds);
    }

    public List<List<?>> getAggDistStatusCountsOfLogicalSite(int logicalSiteId, boolean isAscending, long startId, long endId, List<Long> partnerIds) {
        return this.siteManager.getAggDistStatusCountsOfLogicalSite(logicalSiteId, isAscending, startId, endId, partnerIds);
    }

    public List<List<?>> getAggDistStatusCountsOfDistributionSite(int distSiteId, boolean isAscending, long startMasterTitleId, long endMasterTitleId, List<Long> partnerIds) {
        return this.siteManager.getAggDistStatusCountsOfDistributionSite(distSiteId, isAscending, startMasterTitleId, endMasterTitleId, partnerIds);
    }

    public List<List<?>> getAggTrackStatusCountsOfLogicalSite(int logicalSiteId, boolean isAscending, long startId, long endId, List<Long> partnerIds) {
        return this.siteManager.getAggTrackStatusCountsOfLogicalSite(logicalSiteId, isAscending, startId, endId, partnerIds);
    }

    public List<List<?>> getAggTrackStatusCountsOfDistributionSite(int distSiteId, boolean isAscending, long startMasterTitleId, long endMasterTitleId, List<Long> partnerIds) {
        return this.siteManager.getAggTrackStatusCountsOfDistributionSite(distSiteId, isAscending, startMasterTitleId, endMasterTitleId, partnerIds);
    }

    public Set<Integer> getActiveDistributionSitesInError(List<Long> partnerIds) {
        return this.siteManager.getActiveDistributionSitesInError(partnerIds);
    }

    public Set<String> getActiveTrackingSitesInError(List<Long> partnerIds) {
        return this.siteManager.getActiveTrackingSitesInError(partnerIds);
    }

    public boolean isSiteNameAlreadyUsed(String siteName) {
        return this.siteManager.isSiteNameAlreadyUsed(siteName);
    }

    public boolean isExternalSiteIdAlreadyUsed(String externalSiteId, SiteType siteType) {
        return this.siteManager.isExternalSiteIdAlreadyUsed(externalSiteId, siteType);
    }

    public Job getTimerJob(DistributionSite distSite) {
        return this.siteManager.getTimerJob(distSite);
    }

    public Integer getDistributionSiteId(Long siteTitleId) {
        return this.siteManager.getDistributionSiteId(siteTitleId);
    }

    public void validateDistributionSiteforDistribution(Site distSite) {
        this.siteManager.validateDistributionSiteforDistribution(distSite);
    }

    public void validateTitleforDistribution(DistributionSiteTitle dst, long localTitleId, int siteId) {
        this.siteManager.validateTitleforDistribution(dst, localTitleId, siteId);
    }

    protected Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    public List<TrackingSite> getAllTrackingSites(Integer parentDistSiteId) {
        return this.siteManager.getAllTrackingSites(parentDistSiteId);
    }

    public List<TrackingSite> getAllTrackingSites() {
        return this.siteManager.getAllTrackingSites();
    }

    public Map<Integer, Long> getDistributionSiteTitleIdsByMasterTitleIdForTrackingSite(long titleId, String trackingSiteExternalId) {
        return this.siteManager.getDistributionSiteTitleIdsByMasterTitleIdForTrackingSite(titleId, trackingSiteExternalId);
    }

    public List<Long> getSiteTitleIds(long masterTitleId, Set<String> externalSiteIds) {
        return this.siteManager.getSiteTitleIds(masterTitleId, externalSiteIds);
    }

    public Boolean hasMPWithTrackingSites() {
        return this.siteManager.hasMPWithTrackingSites();
    }

    public Boolean isMediaPathSiteTitle(Integer titleId) {
        return this.siteManager.isMediaPathSiteTitle(titleId);
    }
}

