/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core;

import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.ISitePartnerManager;
import com.ericsson.cms.sites.core.SiteManagementException;
import com.ericsson.cms.sites.core.SiteNotFoundException;
import com.ericsson.cms.sites.core.entities.Contact;
import com.ericsson.cms.sites.core.entities.PitchSchedule;
import com.ericsson.cms.sites.core.entities.Property;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.SitePartner;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.ContainerProperty;
import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerContact;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.schedule.notify.IScheduleNotifier;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.util.DataOperationException;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import org.hibernate.Hibernate;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.type.Type;

@Stateless
@TransactionAttribute
public class SitePartnerManager
implements ISitePartnerManager {
    @EJB
    private ISiteManager siteManager;

    public void createPartnerForSite(int siteId) {
        Partner p = new Partner();
        p.setName("SITE_" + siteId);
        p.setType(PartnerType.DISTRIBUTION);
        this.copy(new SitePartner(), p);
        this.getPartnerManager().createPartner(p);
    }

    public void createPartnerForSite(int siteId, SitePartner sitePartner) {
        Partner p = new Partner();
        p.setName("SITE_" + siteId);
        p.setType(PartnerType.DISTRIBUTION);
        if (sitePartner != null) {
            this.copy(sitePartner, p);
        } else {
            this.copy(new SitePartner(), p);
        }
        this.getPartnerManager().createPartner(p);
    }

    public Map<Long, String> getContextIdNameMap() {
        HashMap<Long, String> map = new HashMap<Long, String>();
        String sql = "select p.contextid, s.name from pmm_partner p, sites_site s where p.isactive = 1 and p.name = 'SITE_'||s.id_ and s.type in (1, 2, 4)";
        SQLQuery query = this.getSession().createSQLQuery(sql).addScalar("contextid", (Type)Hibernate.LONG).addScalar("name", (Type)Hibernate.STRING);
        List result = query.list();
        if (result != null && !result.isEmpty()) {
            for (Object[] row : result) {
                map.put((Long)row[0], (String)row[1]);
            }
        }
        return map;
    }

    public Map<Long, Site> getContextIdSiteMap() {
        HashMap<Long, Site> map = new HashMap<Long, Site>();
        String sql = "select p.contextid, s.* from pmm_partner p, sites_site s where p.isactive = 1 and p.name = 'SITE_'||s.id_ and s.type in (1, 2, 4)";
        SQLQuery query = this.getSession().createSQLQuery(sql).addScalar("contextid", (Type)Hibernate.LONG).addEntity(Site.class);
        List result = query.list();
        if (result != null && !result.isEmpty()) {
            for (Object[] row : result) {
                map.put((Long)row[0], (Site)row[1]);
            }
        }
        return map;
    }

    public Map<Long, Site> getContextIdActiveSiteMap() {
        HashMap<Long, Site> map = new HashMap<Long, Site>();
        String sql = "select p.contextid, s.* from pmm_partner p, sites_site s where p.isactive = 1 and p.name = 'SITE_'||s.id_ and s.type in (1, 2, 4) and s.active = 1";
        SQLQuery query = this.getSession().createSQLQuery(sql).addScalar("contextid", (Type)Hibernate.LONG).addEntity(Site.class);
        List result = query.list();
        if (result != null && !result.isEmpty()) {
            for (Object[] row : result) {
                map.put((Long)row[0], (Site)row[1]);
            }
        }
        return map;
    }

    public Site getSiteByContextId(long contextId) throws SiteNotFoundException {
        String sql = "select s.* from sites_site s, pmm_partner p where s.type in (1, 2, 4) and s.id_ = substr(p.name, 6) and p.isactive = 1 and p.contextid = ?";
        SQLQuery query = this.getSession().createSQLQuery(sql).addEntity(Site.class);
        query.setLong(0, contextId);
        Site site = (Site)query.uniqueResult();
        if (site == null) {
            throw new SiteNotFoundException();
        }
        return site;
    }

    public SitePartner get(int siteId) throws SiteNotFoundException {
        Site site = this.siteManager.getSite(siteId);
        if (site == null) {
            throw new SiteNotFoundException();
        }
        Partner p = this.getPartnerManager().getPartnerByName("SITE_" + site.getId());
        return this.convert(p);
    }

    public SitePartner getByName(String siteName) throws SiteNotFoundException {
        Site site = this.siteManager.getSiteByName(siteName);
        if (site == null) {
            throw new SiteNotFoundException();
        }
        Partner p = this.getPartnerManager().getPartnerByName("SITE_" + site.getId());
        return this.convert(p);
    }

    public SitePartner getByProviderId(String providerId) {
        Partner p = this.getPartnerManager().getPartnerByProviderId(providerId);
        if (p == null) {
            return null;
        }
        return this.convert(p);
    }

    public SitePartner getByLookupKey(String lookupKey) {
        Partner p = this.getPartnerManager().getPartnerByLookupKey(lookupKey);
        if (p == null) {
            return null;
        }
        return this.convert(p);
    }

    public int getSchedulesCountForSite(int siteId) {
        SitePartner sp = this.get(siteId);
        return this.getPartnerManager().countPitchSchedules(Long.valueOf(sp.getContextId()));
    }

    public List<PitchSchedule> getSchedulesForSite(int siteId, int month, int year) {
        ArrayList<PitchSchedule> siteSchedules = new ArrayList<PitchSchedule>();
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, 1);
        this.setToBeginningOfTheDay(cal);
        Date start = cal.getTime();
        cal.add(2, 1);
        Date end = cal.getTime();
        SitePartner sp = this.get(siteId);
        Collection pmmSchedules = this.getScheduleSearchService().getPitchSchedulesByDateRange(Long.valueOf(sp.getContextId()), start, end);
        if (pmmSchedules != null) {
            IScheduleNotifier service = (IScheduleNotifier)ServiceRegistry.getDefault().lookup(IScheduleNotifier.class);
            for (DistributionSchedule ds : pmmSchedules) {
                PitchSchedule ps = new PitchSchedule();
                ps.setId(ds.getId().longValue());
                ps.setPitchDate(ds.getPitchDate());
                ps.setError(service.getNotification((Schedule)ds) != null);
                siteSchedules.add(ps);
            }
        }
        return siteSchedules;
    }

    public void update(SitePartner sitePartner) {
        Partner p = this.getPartnerManager().getPartnerByContextId(sitePartner.getContextId());
        this.copy(sitePartner, p);
        this.getPartnerManager().updatePartner(p);
    }

    public void deletePartnerForSite(int siteId) throws SiteManagementException {
        Partner p = this.getPartnerManager().getPartnerByName("SITE_" + siteId);
        try {
            this.getPartnerManager().deletePartner(p.getId());
        }
        catch (DataOperationException e) {
            throw new SiteManagementException("Unable to delete the associated partner.", (Throwable)e);
        }
    }

    private SitePartner convert(Partner p) {
        SitePartner sp = new SitePartner();
        sp.setContextId(p.getContainerContextId());
        sp.setLookupKey(p.getLookupKey());
        sp.setProviderId(p.getProviderId());
        sp.setContact(new Contact(p.getContact().getFirstName(), p.getContact().getLastName(), p.getContact().getEmail()));
        if (p.getProperties() != null) {
            for (ContainerProperty cp : p.getProperties()) {
                sp.addProperty(cp.getName(), cp.getValue());
            }
        }
        return sp;
    }

    private void copy(SitePartner sp, Partner p) {
        p.setProviderId(sp.getProviderId());
        p.setLookupKey(sp.getLookupKey());
        PartnerContact pc = p.getContact();
        if (pc == null) {
            pc = new PartnerContact();
            pc.setPartner(p);
        }
        pc.setFirstName(sp.getContact().getFirstName());
        pc.setLastName(sp.getContact().getLastName());
        pc.setEmail(sp.getContact().getEmail());
        p.setContact(pc);
        p.updateProperties(this.convert(sp.getProperties()));
    }

    private List<ContainerProperty> convert(List<Property> props) {
        ArrayList<ContainerProperty> cprops = new ArrayList<ContainerProperty>();
        if (props != null) {
            for (Property p : props) {
                cprops.add(new ContainerProperty(p.getName(), p.getValue()));
            }
        }
        return cprops;
    }

    private void setToBeginningOfTheDay(Calendar c) {
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
    }

    private IPartnerManagement getPartnerManager() {
        return (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
    }

    private IScheduleSearchService getScheduleSearchService() {
        return (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
    }

    private Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }
}

