/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core.authorization;

import com.ericsson.cms.sites.core.authorization.Messages;
import com.tandbergtv.neptune.authorization.entity.BasicModule;
import com.tandbergtv.neptune.authorization.entity.BasicPermission;
import com.tandbergtv.neptune.authorization.entity.IModule;
import com.tandbergtv.neptune.authorization.service.IModuleProvider;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SitesModuleProvider
implements IModuleProvider {
    private static final String RCS_ONLY_LICENSE = "IsRCSOnly";
    private ILicenseManager neptuneLicenseManager = (ILicenseManager)InjectionUtil.injectInstance((String)"cms/LicenseManager/local", ILicenseManager.class);

    public Collection<IModule> getModules() {
        ArrayList<IModule> modules = new ArrayList<IModule>();
        if (this.isRCSOnlyDeployment()) {
            return modules;
        }
        String moduleName = "Sites";
        String displayName = Messages.getString("SitesModule.DisplayName");
        BasicModule module = new BasicModule(moduleName, displayName);
        List permissions = module.getPermissions();
        displayName = Messages.getString("SitesModule.Permissions.View");
        permissions.add(new BasicPermission("View", displayName, moduleName));
        displayName = Messages.getString("SitesModule.Permissions.Create");
        permissions.add(new BasicPermission("Create", displayName, moduleName));
        displayName = Messages.getString("SitesModule.Permissions.Modify");
        permissions.add(new BasicPermission("Modify", displayName, moduleName));
        displayName = Messages.getString("SitesModule.Permissions.Delete");
        permissions.add(new BasicPermission("Delete", displayName, moduleName));
        displayName = Messages.getString("SitesModule.Permissions.Target");
        permissions.add(new BasicPermission("Target", displayName, moduleName));
        displayName = Messages.getString("SitesModule.Permissions.Distribute");
        permissions.add(new BasicPermission("Distribute", displayName, moduleName));
        displayName = Messages.getString("SitesModule.Permissions.Export");
        permissions.add(new BasicPermission("Export", displayName, moduleName));
        modules.add((IModule)module);
        return modules;
    }

    private boolean isRCSOnlyDeployment() {
        String value = "false";
        try {
            value = this.neptuneLicenseManager.getProperty(RCS_ONLY_LICENSE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value == null || value.trim().isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }
}

