/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core.mediapath;

import com.ericsson.cms.sites.core.entities.mediapath.MSO;
import com.ericsson.cms.sites.core.entities.mediapath.MediapathDistributionSite;
import com.ericsson.cms.sites.core.mediapath.IMSOManager;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import java.io.Serializable;
import java.util.List;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

@Stateless
@TransactionAttribute
public class MSOManager
implements IMSOManager {
    private HibernateTemplate template;
    private PlatformTransactionManager platformTxMgr;
    private static Logger logger = Logger.getLogger(MSOManager.class);

    @Transactional
    public List<MSO> getAllMSOs() {
        Session session = this.getSession();
        SQLQuery query = session.createSQLQuery("select * from sites_mso_mtm").addEntity(MSO.class);
        List msoList = query.list();
        return msoList;
    }

    @Transactional
    public List<MSO> getMSOsForSiteTitle(Long siteTitleId) {
        Session session = this.getSession();
        Query query = session.createQuery("select m from MSO m join m.mediaPathSiteSet ds join ds.distributionSiteTitles t where t.title.id = :distSiteTitleId");
        query.setLong("distSiteTitleId", siteTitleId.longValue());
        List msoList = query.list();
        return msoList;
    }

    @Transactional
    public MSO getMSOById(int msoId) throws Exception {
        MSO mso = null;
        Session session = this.getSession();
        try {
            mso = (MSO)session.get(MSO.class, (Serializable)Integer.valueOf(msoId));
        }
        catch (Exception e) {
            logger.error((Object)("error retrieving mso: " + e));
            throw e;
        }
        return mso;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional
    public void saveMSO(MSO mso, List<Integer> siteIds) throws Exception {
        Session session = this.getSession();
        try {
            if (mso.getId() != null) {
                MSO oldMso = (MSO)session.get(MSO.class, (Serializable)mso.getId());
                if (oldMso != null) {
                    if (!mso.getMsoName().equalsIgnoreCase(oldMso.getMsoName())) {
                        if (!this.checkDuplicatesPass(mso.getMsoName())) throw new Exception("MSO already exists: " + mso.getMsoName());
                        this.updateMso(mso, oldMso);
                        this.setSites(oldMso, siteIds);
                        session.saveOrUpdate((Object)oldMso);
                    } else {
                        this.updateMso(mso, oldMso);
                        this.setSites(oldMso, siteIds);
                        session.saveOrUpdate((Object)oldMso);
                    }
                }
            } else {
                if (!this.checkDuplicatesPass(mso.getMsoName())) throw new Exception("MSO already exists: " + mso.getMsoName());
                this.setSites(mso, siteIds);
                session.saveOrUpdate((Object)mso);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Could not save mso: " + e));
            throw e;
        }
        session.flush();
    }

    @Transactional
    private void setSites(MSO mso, List<Integer> siteIds) {
        Session session = this.getSession();
        mso.setMediaPathSiteSet(null);
        if (siteIds != null) {
            for (Integer siteId : siteIds) {
                MediapathDistributionSite site = (MediapathDistributionSite)session.get(MediapathDistributionSite.class, (Serializable)siteId);
                if (site == null) continue;
                mso.addMediaPathSiteSet(site);
            }
        }
    }

    @Transactional
    private boolean checkDuplicatesPass(String msoName) {
        MSO mso = this.getMSOByName(msoName);
        return mso == null;
    }

    private void updateMso(MSO mso, MSO oldMso) {
        oldMso.setMsoDescription(mso.getMsoDescription());
        oldMso.setMsoName(mso.getMsoName());
    }

    public void saveAllMSOs(List<MSO> msoList) throws Exception {
    }

    @Transactional
    public void deleteMSO(MSO mso) throws Exception {
        Session session = this.getSession();
        try {
            Query query = session.createSQLQuery("delete from sites_mso_site where mso_id = ?").addEntity(MSO.class).setInteger(0, mso.getId().intValue());
            query.executeUpdate();
            Query query2 = session.createSQLQuery("delete from sites_mso_mtm where mso_id = ?").addEntity(MSO.class).setInteger(0, mso.getId().intValue());
            query2.executeUpdate();
        }
        catch (Exception e) {
            logger.error((Object)("Could not delete mso: " + e));
            throw e;
        }
    }

    protected Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    public HibernateTemplate getTemplate() {
        return this.template;
    }

    public PlatformTransactionManager getPlatformTxMgr() {
        return this.platformTxMgr;
    }

    public void setPlatformTxMgr(PlatformTransactionManager platformTxMgr) {
        this.platformTxMgr = platformTxMgr;
    }

    public void setTemplate(HibernateTemplate template) {
        this.template = template;
    }

    @Transactional
    public MSO getMSOByName(String msoName) {
        Session session = this.getSession();
        List msoList = session.createCriteria(MSO.class).add((Criterion)Restrictions.eq((String)"msoName", (Object)msoName)).list();
        if (msoList.size() > 0) {
            return (MSO)msoList.get(0);
        }
        return null;
    }

    public List<MediapathDistributionSite> getAllMediapathDistributionSites() {
        return null;
    }

    @Transactional
    public void saveMSO(MSO mso) throws Exception {
        Session session;
        block5: {
            session = this.getSession();
            try {
                if (mso.getId() != null) {
                    MSO oldMso = (MSO)session.get(MSO.class, (Serializable)mso.getId());
                    if (oldMso != null) {
                        this.updateMso(mso, oldMso);
                        oldMso.setMediaPathSiteSet(mso.getMediaPathSiteSet());
                        session.saveOrUpdate((Object)oldMso);
                    }
                    break block5;
                }
                if (this.checkDuplicatesPass(mso.getMsoName())) {
                    session.saveOrUpdate((Object)mso);
                    break block5;
                }
                throw new Exception("MSO already exists: " + mso.getMsoName());
            }
            catch (Exception e) {
                logger.error((Object)("Could not save mso: " + e));
                throw e;
            }
        }
        session.flush();
    }
}

