/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core.mediapath;

import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.mediapath.MSO;
import com.ericsson.cms.sites.core.entities.mediapath.MSOOverride;
import com.ericsson.cms.sites.core.entities.mediapath.MSOOverrideHistory;
import com.ericsson.cms.sites.core.entities.mediapath.MSOOverridesHistoryRequest;
import com.ericsson.cms.sites.core.entities.mediapath.MSOOverridesHistoryResponse;
import com.ericsson.cms.sites.core.entities.mediapath.MSOOverridesRequest;
import com.ericsson.cms.sites.core.entities.mediapath.MSOOverridesResponse;
import com.ericsson.cms.sites.core.entities.mediapath.MediapathDistributionSite;
import com.ericsson.cms.sites.core.mediapath.IMSOOverridesManager;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.hibernate.type.Type;

@Stateless
@TransactionAttribute
public class MSOOverridesManager
implements IMSOOverridesManager {
    private static final Logger logger = Logger.getLogger(MSOOverridesManager.class);
    private static final String FIELD_XPATH_COLUMN = "fieldXPath";
    private static final String SEARCH_VALUE_COLUMN = "searchValue";
    private static final String REPLACEMENT_VALUE_COLUMN = "replacementValue";
    private static final String FIELD_DISPLAY_NAME_COLUMN = "fieldDisplayName";
    @EJB
    private ISiteManager siteManager;

    public List<MSO> getMSOs(int siteId) {
        String queryStr = "from MSO mso where mso.mediaPathSite.id = :siteId order by mso.msoName asc";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("siteId", (Object)siteId);
        return query.list();
    }

    public List<MSO> getMSOsFromOverridesHistory(long siteTitleId) {
        String queryStr = "select distinct smoh.mso_id, NVL(smoh.mso_name, (select mso_name from sites_mso where mso_id = smoh.mso_id)) as msoName from sites_mso_override_history smoh where smoh.site_title_id = :siteTitleId order by msoName asc";
        Session session = this.getSession();
        SQLQuery sqlQuery = session.createSQLQuery(queryStr);
        sqlQuery.addScalar("mso_id", (Type)Hibernate.INTEGER).addScalar("msoName");
        sqlQuery.setParameter("siteTitleId", (Object)siteTitleId);
        List resultsList = sqlQuery.list();
        ArrayList<MSO> msos = new ArrayList<MSO>();
        for (Object[] resultRow : resultsList) {
            MSO mso = new MSO();
            mso.setId((Integer)resultRow[0]);
            mso.setMsoName((String)resultRow[1]);
            msos.add(mso);
        }
        return msos;
    }

    public List<MSOOverride> getMSOOverrides(int siteId, String msoName) {
        String queryStr = "from MSOOverride where mso.msoName = :msoName and mso.mediaPathSite.id = :siteId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("siteId", (Object)siteId);
        query.setParameter("msoName", (Object)msoName);
        return query.list();
    }

    public MSO getMSO(int msoId) {
        String queryStr = "from MSO where id = :msoId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("msoId", (Object)msoId);
        return (MSO)query.uniqueResult();
    }

    public MSO saveMSO(int siteId, MSO mso) {
        Site site = this.siteManager.getSite(siteId);
        if (site instanceof MediapathDistributionSite) {
            MediapathDistributionSite mediaPathSite = (MediapathDistributionSite)site;
        }
        return mso;
    }

    public boolean isMSONameAlreadyUsed(int siteId, String msoName) {
        boolean isMSONameAlreadyUsed = false;
        String queryStr = "select count(*) from MSO where mediaPathSite.id = :siteId and msoName = :msoName";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("siteId", (Object)siteId);
        query.setParameter("msoName", (Object)msoName);
        int numMSOs = ((Long)query.iterate().next()).intValue();
        if (numMSOs > 0) {
            isMSONameAlreadyUsed = true;
        }
        return isMSONameAlreadyUsed;
    }

    public void deleteMSO(int msoId) {
        MSO mso = this.getMSO(msoId);
        List<MSOOverrideHistory> msoOverrideHistories = this.getMSOOverridesHistoryForMSOId(msoId);
        for (MSOOverrideHistory msoOverrideHistory : msoOverrideHistories) {
            msoOverrideHistory.setMsoName(mso.getMsoName());
        }
        this.getSession().delete((Object)mso);
        UpdateMSOOverrideHistories updateMSOOverrideHistories = new UpdateMSOOverrideHistories(msoOverrideHistories);
        Session session = this.getSession();
        long timeUpdateHistoryStarted = new Date().getTime();
        session.doWork((Work)updateMSOOverrideHistories);
        long timeUpdateHistoryEnded = new Date().getTime();
        logger.debug((Object)("Total time taken : " + (timeUpdateHistoryEnded - timeUpdateHistoryStarted) + " milliseconds."));
    }

    public List<MSOOverride> getMSOOverrides(int msoId) {
        String queryStr = "from MSOOverride msoOverride where msoOverride.mso.id = :msoId order by msoOverride.id asc";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("msoId", (Object)msoId);
        return query.list();
    }

    public MSOOverridesResponse getMSOOverrides(MSOOverridesRequest msoOverridesRequest) {
        MSOOverridesResponse msoOverridesResponse = null;
        if (msoOverridesRequest != null) {
            msoOverridesResponse = new MSOOverridesResponse();
            String queryStr = this.getMSOOverridesQuery(msoOverridesRequest);
            Session session = this.getSession();
            SQLQuery sqlQuery = session.createSQLQuery(queryStr);
            sqlQuery.addScalar("cnt", (Type)Hibernate.INTEGER).addScalar("override_id", (Type)Hibernate.LONG).addScalar("field_xpath").addScalar("search_value").addScalar("replacement_value");
            sqlQuery.setParameter("msoId", (Object)msoOverridesRequest.getMsoId());
            if (queryStr.contains("order by")) {
                int numRecords;
                int startIndex = msoOverridesRequest.getStartIndex();
                if (startIndex > 0) {
                    sqlQuery.setFirstResult(startIndex);
                }
                if ((numRecords = msoOverridesRequest.getNumRecords()) > 0) {
                    sqlQuery.setMaxResults(numRecords);
                }
            }
            List resultsList = sqlQuery.list();
            ArrayList<MSOOverride> msoOverridesList = new ArrayList<MSOOverride>();
            int count = 0;
            for (Object[] resultRow : resultsList) {
                count = (Integer)resultRow[0];
                MSOOverride msoOverride = new MSOOverride();
                msoOverride.setId((Long)resultRow[1]);
                msoOverride.setFieldXPath((String)resultRow[2]);
                msoOverride.setSearchValue((String)resultRow[3]);
                msoOverride.setReplacementValue((String)resultRow[4]);
                msoOverridesList.add(msoOverride);
            }
            msoOverridesResponse.setCount(count);
            msoOverridesResponse.setMSOOverrides(msoOverridesList);
        }
        return msoOverridesResponse;
    }

    public void deleteMSOOverrides(Set<Long> overrideIds) {
        String queryStr = "delete MSOOverride msoOverride where msoOverride.id in (:overrideIds)";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameterList("overrideIds", overrideIds);
        query.executeUpdate();
    }

    public void save(List<MSOOverrideHistory> msoOverrideHistories) {
        SaveMSOOverrideHistories saveMSOOverrideHistories = new SaveMSOOverrideHistories(msoOverrideHistories);
        logger.debug((Object)("Saving " + msoOverrideHistories.size() + " MSO Override histories..."));
        Session session = this.getSession();
        long timeSaveHistoryStarted = new Date().getTime();
        session.doWork((Work)saveMSOOverrideHistories);
        long timeSaveHistoryEnded = new Date().getTime();
        logger.debug((Object)("Total time taken : " + (timeSaveHistoryEnded - timeSaveHistoryStarted) + " milliseconds."));
    }

    public List<MSOOverrideHistory> getMSOOverridesHistory(long distSiteTitleId) {
        String queryStr = "from MSOOverrideHistory msoOverrideHistory where msoOverrideHistory.siteTitleId = :siteTitleId order by msoOverrideHistory.timeApplied desc";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("siteTitleId", (Object)distSiteTitleId);
        return query.list();
    }

    public MSOOverridesHistoryResponse getMSOOverridesHistory(MSOOverridesHistoryRequest msoOverridesHistoryRequest) {
        MSOOverridesHistoryResponse msoOverridesHistoryResponse = null;
        if (msoOverridesHistoryRequest != null) {
            int numRecords;
            msoOverridesHistoryResponse = new MSOOverridesHistoryResponse();
            String queryStr = this.getMSOOverridesHistoryQuery(msoOverridesHistoryRequest);
            logger.debug((Object)("queryStr = " + queryStr));
            Session session = this.getSession();
            SQLQuery sqlQuery = session.createSQLQuery(queryStr);
            sqlQuery.addScalar("cnt", (Type)Hibernate.INTEGER).addScalar("override_history_id", (Type)Hibernate.LONG).addScalar("mso_id", (Type)Hibernate.INTEGER).addScalar("field_xpath").addScalar("search_value").addScalar("replacement_value").addScalar("time_applied", (Type)Hibernate.TIMESTAMP).addScalar("site_title_id", (Type)Hibernate.LONG).addScalar("distributed_version").addScalar("mso_name").addScalar("action_name");
            sqlQuery.setParameter("msoId", (Object)msoOverridesHistoryRequest.getMsoId());
            sqlQuery.setParameter("siteTitleId", (Object)msoOverridesHistoryRequest.getSiteTitleId());
            int startIndex = msoOverridesHistoryRequest.getStartIndex();
            if (startIndex > 0) {
                sqlQuery.setFirstResult(startIndex);
            }
            if ((numRecords = msoOverridesHistoryRequest.getNumRecords()) > 0) {
                sqlQuery.setMaxResults(numRecords);
            }
            List resultsList = sqlQuery.list();
            ArrayList<MSOOverrideHistory> msoOverridesHistoryList = new ArrayList<MSOOverrideHistory>();
            int count = 0;
            for (Object[] resultRow : resultsList) {
                count = (Integer)resultRow[0];
                MSOOverrideHistory msoOverrideHistory = new MSOOverrideHistory();
                msoOverrideHistory.setId((Long)resultRow[1]);
                msoOverrideHistory.setMsoId((Integer)resultRow[2]);
                msoOverrideHistory.setFieldXPath((String)resultRow[3]);
                msoOverrideHistory.setSearchValue((String)resultRow[4]);
                msoOverrideHistory.setReplacementValue((String)resultRow[5]);
                msoOverrideHistory.setTimeApplied((Date)resultRow[6]);
                msoOverrideHistory.setSiteTitleId((Long)resultRow[7]);
                msoOverrideHistory.setDistributedVersion((String)resultRow[8]);
                msoOverrideHistory.setMsoName((String)resultRow[9]);
                msoOverrideHistory.setActionName((String)resultRow[10]);
                msoOverridesHistoryList.add(msoOverrideHistory);
            }
            msoOverridesHistoryResponse.setCount(count);
            msoOverridesHistoryResponse.setMsoOverridesHistories(msoOverridesHistoryList);
        }
        return msoOverridesHistoryResponse;
    }

    public boolean isMediaPathSiteTitle(Long titleId) {
        boolean isMediapathSiteTitle = false;
        DistributionSite distSite = this.siteManager.getAssociatedDistributionSite(titleId.longValue());
        if (distSite != null && distSite instanceof MediapathDistributionSite) {
            isMediapathSiteTitle = true;
        }
        return isMediapathSiteTitle;
    }

    public Set<String> getMSOOverridableFields() {
        return null;
    }

    protected String getMSOOverridesQuery(MSOOverridesRequest msoOverridesRequest) {
        String queryStr = null;
        if (msoOverridesRequest != null) {
            queryStr = "select count(*) over () cnt, override_id, field_xpath, search_value, replacement_value from sites_mso_override where mso_id = :msoId ";
            String sortColumnName = msoOverridesRequest.getSortColumnName();
            String orderByColumn = "override_id";
            if (FIELD_XPATH_COLUMN.equals(sortColumnName)) {
                orderByColumn = "field_xpath";
            } else if (SEARCH_VALUE_COLUMN.equals(sortColumnName)) {
                orderByColumn = "search_value";
            } else if (REPLACEMENT_VALUE_COLUMN.equals(sortColumnName)) {
                orderByColumn = "replacement_value";
            } else if (FIELD_DISPLAY_NAME_COLUMN.equals(sortColumnName)) {
                orderByColumn = null;
            }
            if (orderByColumn != null) {
                queryStr = queryStr + "order by " + orderByColumn + " ";
                queryStr = queryStr + (msoOverridesRequest.isAscending() ? "asc " : "desc ");
            }
        }
        return queryStr;
    }

    protected String getMSOOverridesHistoryQuery(MSOOverridesHistoryRequest msoOverridesHistoryRequest) {
        String queryStr = null;
        if (msoOverridesHistoryRequest != null) {
            queryStr = "select count(*) over () cnt, smoh.override_history_id, smoh.mso_id, smoh.field_xpath, smoh.search_value, smoh.replacement_value, smoh.time_applied, smoh.site_title_id, smoh.distributed_version, smoh.mso_name, smoh.action_name from sites_mso_override_history smoh where smoh.mso_id = :msoId and smoh.site_title_id = :siteTitleId ";
            String orderByColumn = "smoh.time_applied";
            queryStr = queryStr + "order by " + orderByColumn + " ";
            queryStr = queryStr + "desc ";
        }
        return queryStr;
    }

    protected List<MSOOverrideHistory> getMSOOverridesHistoryForMSOId(int msoId) {
        String queryStr = "from MSOOverrideHistory msoOverrideHistory where msoOverrideHistory.msoId = :msoId ";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("msoId", (Object)msoId);
        return query.list();
    }

    protected Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    public Map<String, Set<String>> getSitesUsingXpath(String msoOverrideXpath) {
        String queryStr = "select distinct s.name, mso.msoName from MSOOverride msoo, MSO mso, Site s where msoo.fieldXPath =:msoOverrideXpath and msoo.mso.id = mso.id and mso.mediaPathSite.id = s.id";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("msoOverrideXpath", (Object)msoOverrideXpath);
        List results = query.list();
        HashMap<String, Set<String>> siteMsoMap = new HashMap<String, Set<String>>();
        for (Object[] obj : results) {
            String siteName = (String)obj[0];
            String msoName = (String)obj[1];
            if (siteMsoMap.containsKey(siteName)) {
                ((Set)siteMsoMap.get(siteName)).add(msoName);
                continue;
            }
            HashSet<String> msos = new HashSet<String>();
            msos.add(msoName);
            siteMsoMap.put(siteName, msos);
        }
        return siteMsoMap;
    }

    public List<MSO> getMSOsWithOverrides(int siteId) {
        return null;
    }

    public void saveMSOOverrides(int msoId, List<MSOOverride> msoOverrides) {
    }

    private static class UpdateMSOOverrideHistories
    implements Work {
        private List<MSOOverrideHistory> msoOverrideHistories;

        public UpdateMSOOverrideHistories(List<MSOOverrideHistory> msoOverrideHistories) {
            this.msoOverrideHistories = msoOverrideHistories;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Connection conn) throws SQLException {
            PreparedStatement ps = null;
            String updateSQL = "update sites_mso_override_history set mso_name = ? where  site_title_id = ? and mso_id = ?";
            try {
                ps = conn.prepareStatement(updateSQL);
                for (MSOOverrideHistory msoOverrideHistory : this.msoOverrideHistories) {
                    Long siteTitleId = msoOverrideHistory.getSiteTitleId();
                    Integer msoId = msoOverrideHistory.getMsoId();
                    String msoName = msoOverrideHistory.getMsoName();
                    ps.setString(1, msoName);
                    ps.setLong(2, siteTitleId);
                    ps.setInt(3, msoId);
                    ps.executeUpdate();
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    private static class SaveMSOOverrideHistories
    implements Work {
        private List<MSOOverrideHistory> msoOverrideHistories;

        public SaveMSOOverrideHistories(List<MSOOverrideHistory> msoOverrideHistories) {
            this.msoOverrideHistories = msoOverrideHistories;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Connection conn) throws SQLException {
            PreparedStatement ps = null;
            String insertSQL = "insert into sites_mso_override_history (override_history_id, site_title_id, mso_id, field_xpath, search_value, replacement_value, time_applied, distributed_version, mso_name, action_name) values (sites_mso_override_history_seq.nextval, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            try {
                ps = conn.prepareStatement(insertSQL);
                for (MSOOverrideHistory msoOverrideHistory : this.msoOverrideHistories) {
                    Long siteTitleId = msoOverrideHistory.getSiteTitleId();
                    Integer msoId = msoOverrideHistory.getMsoId();
                    String fieldXPath = msoOverrideHistory.getFieldXPath();
                    String searchValue = msoOverrideHistory.getSearchValue();
                    String replacementValue = msoOverrideHistory.getReplacementValue();
                    Date timeApplied = msoOverrideHistory.getTimeApplied();
                    String distributedVersion = msoOverrideHistory.getDistributedVersion();
                    String msoName = msoOverrideHistory.getMsoName();
                    String actionName = msoOverrideHistory.getActionName();
                    ps.setLong(1, siteTitleId);
                    ps.setInt(2, msoId);
                    ps.setString(3, fieldXPath);
                    ps.setString(4, searchValue);
                    ps.setString(5, replacementValue);
                    ps.setTimestamp(6, new Timestamp(timeApplied.getTime()));
                    ps.setString(7, distributedVersion);
                    ps.setString(8, msoName);
                    ps.setString(9, actionName);
                    ps.executeUpdate();
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }
}

