/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.distribution;

import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.criteria.info.SortOrder;
import com.ericsson.cms.criteria.info.SortingInfo;
import com.ericsson.cms.sites.core.entities.DistributionStatus;
import com.ericsson.cms.sites.core.entities.SiteActivity;
import com.ericsson.cms.sites.core.entities.SiteType;
import com.ericsson.cms.sites.core.entities.TrackingStatus;
import com.ericsson.cms.sites.distribution.ISitesActivityService;
import com.tandbergtv.metadatamanager.search.AssetSearchQueryBuilder;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import org.apache.log4j.Logger;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;

@Stateless
@TransactionAttribute
public class SitesActivityService
implements ISitesActivityService {
    private static final Logger logger = Logger.getLogger(SitesActivityService.class);
    private static final String METADATA_COLUMN_DISP_NAME_PREFIX = "t";
    private Date minFlashbackTime;

    public List<SiteActivity> getDistributionSiteActivity(Integer distSiteId, DistributionStatus status, Date fromDate, Date toDate, Integer trackSiteId, Collection<Long> partnerIds, List<SearchColumn> columns, SortingInfo sortInfo) {
        return this.getActivity(SiteType.DISTRIBUTION, distSiteId, partnerIds, trackSiteId, status.ordinal(), fromDate, toDate, columns, sortInfo);
    }

    public List<SiteActivity> getTrackingSiteActivity(Integer trackSiteId, TrackingStatus status, Date fromDate, Date toDate, Integer distSiteId, Collection<Long> partnerIds, List<SearchColumn> columns, SortingInfo sortInfo) {
        return this.getActivity(SiteType.TRACKING, distSiteId, partnerIds, trackSiteId, status.ordinal(), fromDate, toDate, columns, sortInfo);
    }

    private List<SiteActivity> getActivity(final SiteType siteType, final Integer distSiteId, final Collection<Long> partnerIds, final Integer trackSiteId, final int status, Date fromDate, final Date toDate, final List<SearchColumn> columns, final SortingInfo sortInfo) {
        final LinkedList<SiteActivity> activities = new LinkedList<SiteActivity>();
        final Date finalFromDate = fromDate;
        Date minFlashbackTime = this.getMinFlashbackTime();
        if (fromDate.before(minFlashbackTime)) {
            logger.debug((Object)("From date [" + fromDate + "] is earlier than the earliest time flash back is available [" + minFlashbackTime + "]. Changed to query only in the available time."));
            fromDate = minFlashbackTime;
        }
        final Date versionsFromDate = fromDate;
        Work work = new Work(){

            public void execute(Connection conn) throws SQLException {
                PreparedStatement statement = siteType == SiteType.DISTRIBUTION ? SitesActivityService.this.prepareDistSiteStatement(conn, distSiteId, partnerIds, status, versionsFromDate, finalFromDate, toDate, trackSiteId, columns, sortInfo) : SitesActivityService.this.prepareTrackSiteStatement(conn, distSiteId, partnerIds, status, versionsFromDate, finalFromDate, toDate, trackSiteId, columns, sortInfo);
                ResultSet results = statement.executeQuery();
                while (results.next()) {
                    activities.add(SitesActivityService.this.read(results, columns));
                }
            }
        };
        this.doWork(work);
        return activities;
    }

    private PreparedStatement prepareDistSiteStatement(Connection conn, Integer distSiteId, Collection<Long> partnerIds, int status, Date versionsFromDate, Date fromDate, Date toDate, Integer trackSiteId, List<SearchColumn> columns, SortingInfo sortInfo) throws SQLException {
        boolean useLatestFlashbackAvailable = true;
        StringBuilder sb = new StringBuilder(1000);
        sb.append("SELECT * FROM (").append("SELECT row_number() over (PARTITION BY dst.siteid, dst.titleid ORDER BY dst.status_updated_time desc) AS rownumber, ").append("versions_operation, dst.siteid, s.name AS sitename, dst.titleid, dst.status, dst.status_updated_time");
        this.addMetadataColumnsInSelect(columns, sb);
        sb.append(" FROM SITES_DISTSITETITLE VERSIONS BETWEEN TIMESTAMP ? AND ").append(useLatestFlashbackAvailable ? "maxvalue " : "? ").append("dst ").append("JOIN PMM_TITLE T ON (t.id_ = dst.titleid) ").append("JOIN MDM_METADATA mdm ON (extractvalue(sys_nc_rowinfo$, '/ECMFSpec/@documentId') = t.mdmdocid) ").append("JOIN SITES_SITE s ON (s.id_ = dst.siteid) ");
        if (distSiteId == null && trackSiteId != null) {
            sb.append("JOIN SITES_SITELINK sl ON (sl.parent = s.id_) ");
        }
        sb.append("WHERE TITLESTATUSID <> 5 AND dst.STATUS_UPDATED_TIME BETWEEN ? AND ? ");
        if (distSiteId == null && trackSiteId != null) {
            sb.append("AND sl.child = ? ");
        }
        if (distSiteId != null) {
            sb.append("AND dst.siteid = ? ");
        }
        this.appendPartners(partnerIds.size(), sb);
        sb.append(") WHERE rownumber = 1 and NVL(versions_operation, 'MH') <> 'D' and status = ? ");
        sb.append("ORDER BY siteid");
        this.addOrderByClause(sortInfo, columns, sb);
        String sql = sb.toString();
        logger.debug((Object)("sql: " + sql));
        PreparedStatement statement = conn.prepareStatement(sql);
        int bindVarIndex = 1;
        statement.setTimestamp(bindVarIndex++, new Timestamp(versionsFromDate.getTime()));
        if (!useLatestFlashbackAvailable) {
            statement.setTimestamp(bindVarIndex++, new Timestamp(toDate.getTime()));
        }
        statement.setTimestamp(bindVarIndex++, new Timestamp(fromDate.getTime()));
        statement.setTimestamp(bindVarIndex++, new Timestamp(toDate.getTime()));
        if (distSiteId == null && trackSiteId != null) {
            statement.setInt(bindVarIndex++, trackSiteId);
        }
        if (distSiteId != null) {
            statement.setInt(bindVarIndex++, distSiteId);
        }
        for (Long partnerId : partnerIds) {
            statement.setLong(bindVarIndex++, partnerId);
        }
        statement.setInt(bindVarIndex++, status);
        return statement;
    }

    private void appendPartners(int partnerIdsCount, StringBuilder sb) {
        if (partnerIdsCount > 0) {
            sb.append(" AND T.Partner_Id in (?");
            for (int i = 1; i < partnerIdsCount; ++i) {
                sb.append(", ?");
            }
            sb.append(")");
        }
    }

    private PreparedStatement prepareTrackSiteStatement(Connection conn, Integer distSiteId, Collection<Long> partnerIds, int status, Date versionsFromDate, Date fromDate, Date toDate, Integer trackSiteId, List<SearchColumn> columns, SortingInfo sortInfo) throws SQLException {
        boolean useLatestFlashbackAvailable = true;
        StringBuilder sb = new StringBuilder(1000);
        sb.append("SELECT * FROM (").append("SELECT row_number() over (PARTITION BY tst.siteid, tst.titleid ORDER BY tst.status_updated_time desc) AS rownumber, ").append("versions_operation, tst.siteid, s.name AS sitename, tst.titleid, tst.status, tst.status_updated_time");
        this.addMetadataColumnsInSelect(columns, sb);
        sb.append(" FROM SITES_TRACKSITETITLE VERSIONS BETWEEN TIMESTAMP ? AND ").append(useLatestFlashbackAvailable ? "maxvalue " : "? ").append("tst ").append("JOIN PMM_TITLE T ON (t.id_ = tst.titleid) ").append("JOIN MDM_METADATA mdm ON (extractvalue(sys_nc_rowinfo$, '/ECMFSpec/@documentId') = t.mdmdocid) ").append("JOIN SITES_SITE s ON (s.id_ = tst.siteid) ");
        if (distSiteId != null) {
            sb.append("JOIN SITES_DISTSITETITLE dst ON (dst.titleid = tst.titleid)");
        }
        sb.append("WHERE TITLESTATUSID <> 5 AND tst.STATUS_UPDATED_TIME BETWEEN ? AND ? ");
        if (distSiteId != null) {
            sb.append("AND dst.siteid = ? ");
        }
        if (trackSiteId != null) {
            sb.append("AND tst.siteid = ? ");
        }
        this.appendPartners(partnerIds.size(), sb);
        sb.append(") WHERE rownumber = 1 and versions_operation <> 'D' and status = ? ");
        sb.append("ORDER BY siteid");
        this.addOrderByClause(sortInfo, columns, sb);
        String sql = sb.toString();
        logger.debug((Object)("sql: " + sql));
        PreparedStatement statement = conn.prepareStatement(sql);
        int bindVarIndex = 1;
        statement.setTimestamp(bindVarIndex++, new Timestamp(versionsFromDate.getTime()));
        if (!useLatestFlashbackAvailable) {
            statement.setTimestamp(bindVarIndex++, new Timestamp(toDate.getTime()));
        }
        statement.setTimestamp(bindVarIndex++, new Timestamp(fromDate.getTime()));
        statement.setTimestamp(bindVarIndex++, new Timestamp(toDate.getTime()));
        if (distSiteId != null) {
            statement.setInt(bindVarIndex++, distSiteId);
        }
        if (trackSiteId != null) {
            statement.setInt(bindVarIndex++, trackSiteId);
        }
        for (Long partnerId : partnerIds) {
            statement.setLong(bindVarIndex++, partnerId);
        }
        statement.setInt(bindVarIndex++, status);
        return statement;
    }

    private void addMetadataColumnsInSelect(List<SearchColumn> columns, StringBuilder sb) {
        int i = 1;
        for (SearchColumn sc : columns) {
            if (sc.getFieldType() != FieldType.ASSET) continue;
            sb.append(", ").append(AssetSearchQueryBuilder.getExtractValue((String)sc.getSectionType(), (String)sc.getFieldName())).append(" AS t" + i++);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addOrderByClause(SortingInfo sortInfo, List<SearchColumn> columns, StringBuilder sb) {
        if (sortInfo == null) return;
        sb.append(", ");
        if (sortInfo.getFieldType() == FieldType.ASSET) {
            int matchingIndex = -1;
            int i = 1;
            for (SearchColumn sc : columns) {
                if (sc.getFieldType() != FieldType.ASSET) continue;
                if (sc.getSectionType() == sortInfo.getAssetType() && sc.getFieldName() == sortInfo.getSortItemName()) {
                    matchingIndex = i;
                    break;
                }
                ++i;
            }
            if (matchingIndex == -1) throw new RuntimeException("Cannot sort by the metadata field: [" + sortInfo.getAssetType() + " | " + sortInfo.getSortItemName() + "] as it is not selected");
            sb.append(METADATA_COLUMN_DISP_NAME_PREFIX + matchingIndex);
        } else {
            sb.append(sortInfo.getSortItemName());
        }
        if (sortInfo.getOrder() != SortOrder.DESCENDING) return;
        sb.append(" DESC");
    }

    private SiteActivity read(ResultSet results, List<SearchColumn> columns) throws SQLException {
        SiteActivity sa = new SiteActivity();
        sa.setSiteId(results.getInt("siteid"));
        sa.setSiteName(results.getString("sitename"));
        sa.setTitleId(results.getLong("titleid"));
        sa.setStatus(results.getInt("status"));
        sa.setStatusUpdatedTime(new Date(results.getTimestamp("status_updated_time").getTime()));
        int i = 1;
        for (SearchColumn sc : columns) {
            if (sc.getFieldType() != FieldType.ASSET) continue;
            sa.addTitleMetadataField(results.getString(METADATA_COLUMN_DISP_NAME_PREFIX + i++));
        }
        return sa;
    }

    private void doWork(Work work) {
        Session session = this.getSession();
        try {
            session.doWork(work);
        }
        catch (RuntimeException e) {
            try {
                session.cancelQuery();
            }
            catch (Exception e1) {
                // empty catch block
            }
            throw e;
        }
    }

    private Date getMinFlashbackTime() {
        if (this.minFlashbackTime == null) {
            SQLQuery query = this.getSession().createSQLQuery("select min(TIME_DP) from SMON_SCN_TIME");
            Timestamp minFlashbackTimeSQL = (Timestamp)query.uniqueResult();
            this.minFlashbackTime = new Date(minFlashbackTimeSQL.getTime() + 1000L);
        }
        return this.minFlashbackTime;
    }

    private boolean isTodayOrLater(Date date) {
        Calendar today = Calendar.getInstance();
        this.setToBeginningOfTheDay(today);
        return !date.before(today.getTime());
    }

    private void setToBeginningOfTheDay(Calendar c) {
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
    }

    protected Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }
}

