/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.monitoring;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.DistributionStatus;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.TrackingStatus;
import com.ericsson.cms.sites.monitoring.SearchCriterion;
import com.ericsson.cms.sites.monitoring.StatusUpdate;
import com.ericsson.cms.sites.monitoring.StatusUpdates;
import com.ericsson.cms.sites.monitoring.plugins.StatusPluginType;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.title.search.entities.SiteType;
import com.tandbergtv.metadatamanager.util.FieldAliasMappingReader;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.persistence.PreRemove;
import org.apache.log4j.Logger;
import org.jboss.ejb3.annotation.Depends;
import org.jboss.ejb3.annotation.Pool;

@MessageDriven(name="TitleStatusManager", activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="queue/TitleStatusQueue"), @ActivationConfigProperty(propertyName="acknowledgeMode", propertyValue="Auto-acknowledge"), @ActivationConfigProperty(propertyName="maxSession", propertyValue="5")})
@Pool(value="StrictMaxPool", maxSize=5, timeout=1800000L)
@TransactionManagement(value=TransactionManagementType.BEAN)
@Depends(value={"ContentManagement:service=com.tandbergtv.cms.contentmgmt.activation.IServiceActivator"})
public class TitleStatusManager
implements MessageListener {
    private static final Logger logger = Logger.getLogger((String)TitleStatusManager.class.getName());
    @EJB
    ISiteManager siteManager;
    ITitleSearchService titleSearchService = (ITitleSearchService)ServiceRegistry.getDefault().lookup(ITitleSearchService.class);

    public void onMessage(Message message) {
        block23: {
            try {
                ObjectMessage objectMessage;
                Serializable object;
                logger.debug((Object)("message : " + message));
                String strStatusPluginType = message.getStringProperty("status_plugin_type");
                StatusPluginType statusPluginType = StatusPluginType.valueOf((String)strStatusPluginType);
                String extId = null;
                String lastExtId = null;
                List sites = null;
                int resultsCount = message.getIntProperty("results_count");
                boolean hasSearchCriteria = false;
                if (message instanceof ObjectMessage && (object = (objectMessage = (ObjectMessage)message).getObject()) instanceof StatusUpdates) {
                    hasSearchCriteria = true;
                    StatusUpdates statusUpdates = (StatusUpdates)object;
                    List statusUpdatesList = statusUpdates.getStatusUpdates();
                    for (StatusUpdate statusUpdate : statusUpdatesList) {
                        extId = statusUpdate.getExternalId();
                        if (!extId.equals(lastExtId)) {
                            sites = this.getSiteManager().getSitesByExternalId(extId);
                            lastExtId = extId;
                        }
                        List<Integer> siteIds = this.getSiteIds(sites);
                        List searchCriteriaList = statusUpdate.getSearchCriteriaList();
                        Long localTitleId = null;
                        Long l = localTitleId = siteIds.size() == 0 ? null : this.getTitleId(siteIds, searchCriteriaList, statusPluginType);
                        if (localTitleId != null) {
                            for (int siteId : siteIds) {
                                DistributionStatus status;
                                if (statusPluginType == StatusPluginType.DISTRIBUTION_STATUS) {
                                    status = statusUpdate.getDistStatus();
                                    try {
                                        this.getSiteManager().updateDistributionStatus(localTitleId.longValue(), status);
                                    }
                                    catch (Exception e) {
                                        logger.error((Object)"TitleStatusManager.onMessage() [calling getSiteManager().updateDistributionStatus()] error", (Throwable)e);
                                    }
                                }
                                if (statusPluginType != StatusPluginType.DEPLOYMENT_STATUS) continue;
                                status = statusUpdate.getTrackingStatus();
                                try {
                                    this.getSiteManager().updateTrackingStatus(siteId, localTitleId.longValue(), (TrackingStatus)status);
                                }
                                catch (Exception e) {
                                    logger.error((Object)"TitleStatusManager.onMessage() [calling getSiteManager().updateTrackingStatus()] error", (Throwable)e);
                                }
                            }
                            continue;
                        }
                        String strSitesIds = siteIds == null || siteIds.size() == 0 ? "" : Arrays.toString(siteIds.toArray());
                        String msg = String.format("No titleId for: SearchCriteriaList: %s, Sites: %s", searchCriteriaList, strSitesIds);
                        logger.warn((Object)msg);
                    }
                }
                if (hasSearchCriteria) break block23;
                for (int i = 0; i < resultsCount; ++i) {
                    extId = message.getStringProperty("ext_id_" + Integer.toString(i));
                    if (!extId.equals(lastExtId)) {
                        sites = this.getSiteManager().getSitesByExternalId(extId);
                        lastExtId = extId;
                    }
                    List<Integer> siteIds = this.getSiteIds(sites);
                    String assetId = message.getStringProperty("asset_id_" + Integer.toString(i));
                    String providerId = message.getStringProperty("provider_id_" + Integer.toString(i));
                    String statusString = message.getStringProperty("status_" + Integer.toString(i));
                    Long localTitleId = null;
                    try {
                        localTitleId = siteIds.size() == 0 ? null : this.getTitleId(siteIds, assetId, providerId, statusPluginType);
                    }
                    catch (Exception ex) {
                        logger.error((Object)"TitleStatusManager.onMessage() [calling getTitleId()] error", (Throwable)ex);
                        continue;
                    }
                    if (localTitleId != null) {
                        for (int siteId : siteIds) {
                            DistributionStatus status;
                            if (statusPluginType == StatusPluginType.DISTRIBUTION_STATUS) {
                                status = DistributionStatus.valueOf((String)statusString);
                                try {
                                    this.getSiteManager().updateDistributionStatus(localTitleId.longValue(), status);
                                }
                                catch (Exception e) {
                                    logger.error((Object)"TitleStatusManager.onMessage() [calling getSiteManager().updateDistributionStatus()] error", (Throwable)e);
                                }
                            }
                            if (statusPluginType != StatusPluginType.DEPLOYMENT_STATUS) continue;
                            status = TrackingStatus.valueOf((String)statusString);
                            try {
                                this.getSiteManager().updateTrackingStatus(siteId, localTitleId.longValue(), (TrackingStatus)status);
                            }
                            catch (Exception e) {
                                logger.error((Object)"TitleStatusManager.onMessage() [calling getSiteManager().updateTrackingStatus()] error", (Throwable)e);
                            }
                        }
                        continue;
                    }
                    String strSitesIds = siteIds == null || siteIds.size() == 0 ? "" : Arrays.toString(siteIds.toArray());
                    String msg = String.format("No titleId for: AssetId: %s, ProviderId: %s, Sites: %s", assetId, providerId, strSitesIds);
                    logger.warn((Object)msg);
                }
            }
            catch (Exception e) {
                logger.error((Object)"TitleStatusManager.onMessage() error", (Throwable)e);
            }
        }
    }

    private Long getTitleId(List<Integer> siteIds, String assetId, String providerId, StatusPluginType statusPluginType) {
        ArrayList<ExpValue> condList = new ArrayList<ExpValue>();
        ExpList condition = new ExpList("AND", condList);
        ArrayList<String> values1 = new ArrayList<String>();
        values1.add(assetId);
        PredicateRightValue prv1 = new PredicateRightValue("/Fields/Identifier/Id", "Package", FieldType.ASSET, values1, LogicalOperator.EQUAL, Boolean.valueOf(false));
        condList.add(new ExpValue((Predicate)prv1));
        ArrayList<String> values2 = new ArrayList<String>();
        values2.add(providerId);
        PredicateRightValue prv2 = new PredicateRightValue("/Fields/ProviderInfo/Identifier/Id", "Package", FieldType.ASSET, values2, LogicalOperator.EQUAL, Boolean.valueOf(false));
        condList.add(new ExpValue((Predicate)prv2));
        SiteType type = statusPluginType == StatusPluginType.DISTRIBUTION_STATUS ? SiteType.DISTRIBUTION_SITE : SiteType.TRACKING_SITE;
        List titleIds = this.titleSearchService.getSiteTitleIds((ExpNode)condition, siteIds, type);
        if (titleIds.size() > 1) {
            throw new RuntimeException("Site cannot have multiple titles with the same keys.");
        }
        Long titleId = titleIds.size() == 0 ? null : new Long((Long)titleIds.get(0));
        return titleId;
    }

    private Long getTitleId(List<Integer> siteIds, List<SearchCriterion> searchCriteriaList, StatusPluginType statusPluginType) {
        ArrayList<ExpValue> condList = new ArrayList<ExpValue>();
        ExpList condition = new ExpList("AND", condList);
        for (SearchCriterion searchCriterion : searchCriteriaList) {
            String xPath = searchCriterion.getxPath();
            if (!this.isXPath(xPath)) {
                xPath = this.getFieldXPathForAlias(xPath);
            }
            String assetType = searchCriterion.getAssetType();
            ArrayList<String> values = new ArrayList<String>();
            values.add(searchCriterion.getValue());
            PredicateRightValue prv = new PredicateRightValue(xPath, assetType, FieldType.ASSET, values, LogicalOperator.EQUAL, Boolean.valueOf(false));
            condList.add(new ExpValue((Predicate)prv));
        }
        SiteType type = statusPluginType == StatusPluginType.DISTRIBUTION_STATUS ? SiteType.DISTRIBUTION_SITE : SiteType.TRACKING_SITE;
        List titleIds = this.titleSearchService.getSiteTitleIds((ExpNode)condition, siteIds, type);
        if (titleIds.size() > 1) {
            throw new RuntimeException("Site cannot have multiple titles with the same keys.");
        }
        Long titleId = titleIds.size() == 0 ? null : new Long((Long)titleIds.get(0));
        return titleId;
    }

    private boolean isXPath(String str) {
        boolean isXPath = false;
        if (str != null && str.startsWith("/Fields")) {
            isXPath = true;
        }
        return isXPath;
    }

    private String getFieldXPathForAlias(String alias) {
        FieldAliasMappingReader fieldAliasMappingReader;
        Map aliasMap;
        String xPath = null;
        if (alias != null && alias.trim().length() > 0 && (aliasMap = (fieldAliasMappingReader = FieldAliasMappingReader.getInstance()).getAliasMap()) != null) {
            xPath = (String)aliasMap.get(alias.trim());
        }
        return xPath;
    }

    private List<Integer> getSiteIds(Collection<Site> sites) {
        ArrayList<Integer> siteIds = new ArrayList<Integer>(sites.size());
        for (Site site : sites) {
            siteIds.add(site.getId());
        }
        return siteIds;
    }

    @PostConstruct
    public void init() {
        logger.debug((Object)"In init()");
    }

    @PreRemove
    public void destroy() {
        logger.info((Object)"In destroy()");
    }

    public void setSiteManager(ISiteManager siteManager) {
        this.siteManager = siteManager;
    }

    public ISiteManager getSiteManager() {
        return this.siteManager;
    }
}

