/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.monitoring.dao;

import com.ericsson.cms.sites.monitoring.SiteMonitoring;
import com.ericsson.cms.sites.monitoring.SiteMonitoringAction;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.hibernate.LockMode;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;

public class SiteMonitoringDao {
    private static final Logger logger = Logger.getLogger((String)SiteMonitoringDao.class.getName());
    private final SessionFactory sessionFactory = this.getSessionFactory();

    protected SessionFactory getSessionFactory() {
        try {
            return HibernateContext.getContext().getSessionFactory();
        }
        catch (Exception e) {
            logger.error((Object)"Could not get SessionFactory from Application Context", (Throwable)e);
            throw new IllegalStateException("Could not get SessionFactory from Application Context");
        }
    }

    public void persist(SiteMonitoring transientInstance) {
        logger.debug((Object)"persisting SiteMonitoring instance");
        try {
            this.sessionFactory.getCurrentSession().persist((Object)transientInstance);
            logger.debug((Object)"persist successful");
        }
        catch (RuntimeException re) {
            logger.error((Object)"persist failed", (Throwable)re);
            throw re;
        }
    }

    public void attachDirty(SiteMonitoring instance) {
        logger.debug((Object)"attaching dirty SiteMonitoring instance");
        try {
            this.sessionFactory.getCurrentSession().saveOrUpdate((Object)instance);
            logger.debug((Object)"attach successful");
        }
        catch (RuntimeException re) {
            logger.error((Object)"attach failed", (Throwable)re);
            throw re;
        }
    }

    public void attachClean(SiteMonitoring instance) {
        logger.debug((Object)"attaching clean SiteMonitoring instance");
        try {
            this.sessionFactory.getCurrentSession().lock((Object)instance, LockMode.NONE);
            logger.debug((Object)"attach successful");
        }
        catch (RuntimeException re) {
            logger.error((Object)"attach failed", (Throwable)re);
            throw re;
        }
    }

    public void delete(SiteMonitoring persistentInstance) {
        logger.debug((Object)"deleting SiteMonitoring instance");
        try {
            this.sessionFactory.getCurrentSession().delete((Object)persistentInstance);
            logger.debug((Object)"delete successful");
        }
        catch (RuntimeException re) {
            logger.error((Object)"delete failed", (Throwable)re);
            throw re;
        }
    }

    public SiteMonitoring merge(SiteMonitoring detachedInstance) {
        logger.debug((Object)"merging SiteMonitoring instance");
        try {
            SiteMonitoring result = (SiteMonitoring)this.sessionFactory.getCurrentSession().merge((Object)detachedInstance);
            logger.debug((Object)"merge successful");
            return result;
        }
        catch (RuntimeException re) {
            logger.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public SiteMonitoring findById(long id) {
        logger.debug((Object)("getting SiteMonitoring instance with id: " + id));
        try {
            SiteMonitoring instance = (SiteMonitoring)this.sessionFactory.getCurrentSession().get("com.ericsson.cms.sites.monitoring.SiteMonitoring", (Serializable)Long.valueOf(id));
            if (instance == null) {
                logger.debug((Object)"get successful, no instance found");
            } else {
                logger.debug((Object)"get successful, instance found");
            }
            return instance;
        }
        catch (RuntimeException re) {
            logger.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List<SiteMonitoring> findByExample(SiteMonitoring instance) {
        logger.debug((Object)"finding SiteMonitoring instance by example");
        try {
            List results = this.sessionFactory.getCurrentSession().createCriteria("com.ericsson.cms.sites.monitoring.SiteMonitoring").add((Criterion)Example.create((Object)instance)).list();
            logger.debug((Object)("find by example successful, result size: " + results.size()));
            return results;
        }
        catch (RuntimeException re) {
            logger.error((Object)"find by example failed", (Throwable)re);
            throw re;
        }
    }

    @Transactional
    public List<SiteMonitoring> findBySiteId(int siteId) {
        int n = siteId;
        return (List)SiteMonitoringDao.findBySiteId_aroundBody1$advice(this, n, TransactionEnforcer.aspectOf(), SiteMonitoringDao.class.getDeclaredMethod("findBySiteId", Integer.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public SiteMonitoring findBySiteIdAndMonitoringType(int siteId, String monitoringType) {
        int n = siteId;
        String string = monitoringType;
        return (SiteMonitoring)SiteMonitoringDao.findBySiteIdAndMonitoringType_aroundBody3$advice(this, n, string, TransactionEnforcer.aspectOf(), SiteMonitoringDao.class.getDeclaredMethod("findBySiteIdAndMonitoringType", Integer.TYPE, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public List<SiteMonitoring> findAllMonitorable(boolean associated, boolean monitoringEnabled) {
        boolean bl = associated;
        boolean bl2 = monitoringEnabled;
        return (List)SiteMonitoringDao.findAllMonitorable_aroundBody5$advice(this, bl, bl2, TransactionEnforcer.aspectOf(), SiteMonitoringDao.class.getDeclaredMethod("findAllMonitorable", Boolean.TYPE, Boolean.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public SiteMonitoring findLatest(int siteId, String pluginId, String monitoringType) {
        int n = siteId;
        String string = pluginId;
        String string2 = monitoringType;
        return (SiteMonitoring)SiteMonitoringDao.findLatest_aroundBody7$advice(this, n, string, string2, TransactionEnforcer.aspectOf(), SiteMonitoringDao.class.getDeclaredMethod("findLatest", Integer.TYPE, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public SiteMonitoring saveSiteMonitoringAction(int siteId, String pluginId, SiteMonitoringAction action, String monitoringType) {
        int n = siteId;
        String string = pluginId;
        SiteMonitoringAction siteMonitoringAction = action;
        String string2 = monitoringType;
        return (SiteMonitoring)SiteMonitoringDao.saveSiteMonitoringAction_aroundBody9$advice(this, n, string, siteMonitoringAction, string2, TransactionEnforcer.aspectOf(), SiteMonitoringDao.class.getDeclaredMethod("saveSiteMonitoringAction", Integer.TYPE, String.class, SiteMonitoringAction.class, String.class).getAnnotation(Transactional.class), null);
    }

    private static final /* synthetic */ List findBySiteId_aroundBody0(SiteMonitoringDao this_, int siteId) {
        logger.debug((Object)("getting SiteMonitoring instance with siteId: " + siteId));
        ArrayList results = new ArrayList();
        try {
            List smList = this_.sessionFactory.getCurrentSession().createQuery("from com.ericsson.cms.sites.monitoring.SiteMonitoring as siteMonitoring where siteMonitoring.siteId = ? and siteMonitoring.associated = 'Y'").setInteger(0, siteId).list();
            logger.debug((Object)("findBySiteId successful, result size: " + smList.size()));
            results.addAll(smList);
            logger.debug((Object)("findBySiteId successful, returning results: " + results));
        }
        catch (RuntimeException re) {
            logger.error((Object)"get failed", (Throwable)re);
            throw re;
        }
        return results;
    }

    private static final /* synthetic */ Object findBySiteId_aroundBody1$advice(SiteMonitoringDao this_, int siteId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SiteMonitoringDao.findBySiteId_aroundBody0(this_, siteId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = SiteMonitoringDao.findBySiteId_aroundBody0(this_, siteId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ SiteMonitoring findBySiteIdAndMonitoringType_aroundBody2(SiteMonitoringDao this_, int siteId, String monitoringType) {
        logger.debug((Object)("getting SiteMonitoring instance with siteId: " + siteId + ", monitoringType: " + monitoringType));
        try {
            SiteMonitoring instance = (SiteMonitoring)this_.sessionFactory.getCurrentSession().createQuery("from com.ericsson.cms.sites.monitoring.SiteMonitoring as siteMonitoring where siteMonitoring.siteId = ? and siteMonitoring.monitoringType = ? and siteMonitoring.associated = 'Y'").setInteger(0, siteId).setString(1, monitoringType).uniqueResult();
            if (instance == null) {
                logger.debug((Object)"get successful, no instance found");
            } else {
                logger.debug((Object)"get successful, instance found");
            }
            return instance;
        }
        catch (RuntimeException re) {
            logger.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    private static final /* synthetic */ Object findBySiteIdAndMonitoringType_aroundBody3$advice(SiteMonitoringDao this_, int siteId, String monitoringType, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SiteMonitoringDao.findBySiteIdAndMonitoringType_aroundBody2(this_, siteId, monitoringType);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            SiteMonitoring object = SiteMonitoringDao.findBySiteIdAndMonitoringType_aroundBody2(this_, siteId, monitoringType);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List findAllMonitorable_aroundBody4(SiteMonitoringDao this_, boolean associated, boolean monitoringEnabled) {
        logger.debug((Object)("finding all latest SiteMonitoring instances by associated=" + associated + ", monitoringEnabled=" + monitoringEnabled));
        ArrayList results = new ArrayList();
        try {
            List smList = this_.sessionFactory.getCurrentSession().createQuery("from com.ericsson.cms.sites.monitoring.SiteMonitoring as siteMonitoring where siteMonitoring.associated = ? and siteMonitoring.monitoringEnabled = ?").setBoolean(0, associated).setBoolean(1, monitoringEnabled).list();
            logger.debug((Object)("findAllMonitorable successful, result size: " + smList.size()));
            results.addAll(smList);
            logger.debug((Object)("findAllMonitorable successful, returning results: " + results));
        }
        catch (RuntimeException re) {
            logger.error((Object)"findAllMonitorable failed", (Throwable)re);
            throw re;
        }
        return results;
    }

    private static final /* synthetic */ Object findAllMonitorable_aroundBody5$advice(SiteMonitoringDao this_, boolean associated, boolean monitoringEnabled, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SiteMonitoringDao.findAllMonitorable_aroundBody4(this_, associated, monitoringEnabled);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = SiteMonitoringDao.findAllMonitorable_aroundBody4(this_, associated, monitoringEnabled);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ SiteMonitoring findLatest_aroundBody6(SiteMonitoringDao this_, int siteId, String pluginId, String monitoringType) {
        logger.debug((Object)"finding latest SiteMonitoring instance by siteId and pluginId");
        SiteMonitoring result = null;
        try {
            List smList = this_.sessionFactory.getCurrentSession().createQuery("from com.ericsson.cms.sites.monitoring.SiteMonitoring as siteMonitoring where siteMonitoring.siteId = ? and siteMonitoring.pluginId = ? and siteMonitoring.monitoringType = ? order by siteMonitoring.updatedate desc").setInteger(0, siteId).setString(1, pluginId).setString(2, monitoringType).list();
            logger.debug((Object)("findLatest successful, result size: " + smList.size()));
            if (smList.size() > 0) {
                result = (SiteMonitoring)smList.get(0);
            }
            logger.debug((Object)("findLatest successful, returning result: " + result));
            return result;
        }
        catch (RuntimeException re) {
            logger.error((Object)"findLatest failed", (Throwable)re);
            throw re;
        }
    }

    private static final /* synthetic */ Object findLatest_aroundBody7$advice(SiteMonitoringDao this_, int siteId, String pluginId, String monitoringType, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SiteMonitoringDao.findLatest_aroundBody6(this_, siteId, pluginId, monitoringType);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            SiteMonitoring object = SiteMonitoringDao.findLatest_aroundBody6(this_, siteId, pluginId, monitoringType);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ SiteMonitoring saveSiteMonitoringAction_aroundBody8(SiteMonitoringDao this_, int siteId, String pluginId, SiteMonitoringAction action, String monitoringType) {
        logger.debug((Object)"Saving SiteMonitoring instance by siteId, pluginId and action");
        SiteMonitoring result = null;
        SiteMonitoring siteMonitoring = null;
        Date now = new Date();
        SiteMonitoring siteMonitoringLatest = this_.findLatest(siteId, pluginId, monitoringType);
        if (siteMonitoringLatest != null) {
            siteMonitoring = siteMonitoringLatest;
        } else {
            siteMonitoring = new SiteMonitoring();
            siteMonitoring.setSiteId(Integer.valueOf(siteId).intValue());
            siteMonitoring.setPluginId(pluginId);
            siteMonitoring.setAssociated(Boolean.valueOf(false));
            siteMonitoring.setMonitoringEnabled(Boolean.valueOf(false));
            siteMonitoring.setMonitoringType(monitoringType);
            siteMonitoring.setCreatedate(now);
        }
        if (SiteMonitoringAction.ASSOCIATE.equals((Object)action)) {
            siteMonitoring.setAssociated(Boolean.valueOf(true));
        } else if (SiteMonitoringAction.DISSOCIATE.equals((Object)action)) {
            siteMonitoring.setAssociated(Boolean.valueOf(false));
        } else if (SiteMonitoringAction.START_MONITORING.equals((Object)action)) {
            siteMonitoring.setMonitoringEnabled(Boolean.valueOf(true));
        } else if (SiteMonitoringAction.STOP_MONITORING.equals((Object)action)) {
            siteMonitoring.setMonitoringEnabled(Boolean.valueOf(false));
        }
        siteMonitoring.setUpdatedate(now);
        result = this_.merge(siteMonitoring);
        logger.debug((Object)("Saving SiteMonitoring instance by siteId, pluginId and action successful, returning result: " + result));
        return result;
    }

    private static final /* synthetic */ Object saveSiteMonitoringAction_aroundBody9$advice(SiteMonitoringDao this_, int siteId, String pluginId, SiteMonitoringAction action, String monitoringType, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SiteMonitoringDao.saveSiteMonitoringAction_aroundBody8(this_, siteId, pluginId, action, monitoringType);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            SiteMonitoring object = SiteMonitoringDao.saveSiteMonitoringAction_aroundBody8(this_, siteId, pluginId, action, monitoringType);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

