/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.scheduling;

import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.scheduler.ActionContext;
import com.ericsson.cms.scheduler.ExecutionContext;
import com.ericsson.cms.scheduler.IWOSchedulerClient;
import com.ericsson.cms.scheduler.Node;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.scheduling.TitleMetadataOptionProvider;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.title.search.entities.SiteType;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SitesWOSchedulerClient
implements IWOSchedulerClient {
    private static final String SITE = "Site";
    private static final String ID = "Id";
    private static final String NAME = "Name";
    private static final String FILTER_NAME_PREFIX = "$Title Metadata.";
    private static final String FILTER_NAME_SEPARATOR = ".";
    private static final String ASSET_TYPE_SEPARATOR = "/";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private ITitleSearchService searchService = (ITitleSearchService)InjectionUtil.injectInstance((String)"cms/TitleSearchServiceProxy/local", ITitleSearchService.class);

    public String getName() {
        return "Sites";
    }

    public String getDisplayName() {
        return "Sites";
    }

    public Map<Long, String> getAllEntities() {
        HashMap<Long, String> entities = new HashMap<Long, String>();
        List sites = this.getSiteManager().getAllDistributionSites();
        if (sites != null) {
            for (DistributionSite site : sites) {
                entities.put((long)site.getId(), site.getName());
            }
        }
        return entities;
    }

    public List<Node> getParametersForFilter() {
        ArrayList<Node> roots = new ArrayList<Node>();
        roots.add(new TitleMetadataOptionProvider().getJobRuleMenuOptions());
        return roots;
    }

    public List<Node> getParametersForWorkOrderMapping(boolean associatedWithTitles) {
        ArrayList<Node> roots = new ArrayList<Node>();
        Node root = new Node(SITE);
        roots.add(root);
        root.addChild(new Node(ID));
        root.addChild(new Node(NAME));
        return roots;
    }

    public Map<String, String> getParameterValuesForWorkOrderMapping(Long associatedEntityId) {
        HashMap<String, String> values = new HashMap<String, String>();
        Site site = this.getSiteManager().getSite(associatedEntityId.intValue());
        values.put("Site.Id", Integer.toString(site.getId()));
        values.put("Site.Name", site.getName());
        return values;
    }

    public ExecutionContext getExecutionContext(Long associatedEntityId, String filterName, Date filterValue) {
        ExecutionContext ec = new ExecutionContext();
        ec.setCommonWOParams(this.getParameterValuesForWorkOrderMapping(associatedEntityId));
        filterName = filterName.substring(FILTER_NAME_PREFIX.length());
        String[] filterNamePartsArray = filterName.split("\\.");
        int numFilterNameParts = filterNamePartsArray.length;
        String xpath = filterNamePartsArray[numFilterNameParts - 1];
        String assetType = filterNamePartsArray[0];
        for (int i = 1; i < numFilterNameParts - 1; ++i) {
            assetType = assetType + ASSET_TYPE_SEPARATOR + filterNamePartsArray[i];
        }
        ArrayList<String> metaValues = new ArrayList<String>();
        String metaValue = DATE_FORMAT.format(filterValue);
        metaValues.add(metaValue);
        PredicateRightValue metaCond = new PredicateRightValue(xpath, assetType, FieldType.ASSET, metaValues, LogicalOperator.EQUAL, Boolean.valueOf(false));
        ExpValue condition = new ExpValue((Predicate)metaCond);
        ArrayList<Integer> siteIds = new ArrayList<Integer>();
        siteIds.add(associatedEntityId.intValue());
        List titleIds = this.searchService.getSiteTitleIds((ExpNode)condition, siteIds, SiteType.DISTRIBUTION_SITE);
        if (titleIds != null) {
            for (Long titleId : titleIds) {
                ActionContext ac = new ActionContext();
                ac.setTitleId(titleId.longValue());
                ec.add(ac);
            }
        }
        return ec;
    }

    public String getAssociationDescription(List<Long> associatedEntityIds) {
        String associationDescription = this.getName() + ": [";
        ISiteManager siteManager = this.getSiteManager();
        int count = 0;
        for (Long associatedEntityId : associatedEntityIds) {
            ++count;
            Site site = siteManager.getSite(associatedEntityId.intValue());
            if (site == null) continue;
            if (count > 1) {
                associationDescription = associationDescription + ", ";
            }
            String siteName = site.getName();
            associationDescription = associationDescription + siteName;
        }
        associationDescription = associationDescription + "]";
        return associationDescription;
    }

    private ISiteManager getSiteManager() {
        return (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
    }
}

