/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.contentmgmt.titlelist.core;

import com.tandbergtv.cms.contentmgmt.titlelist.ejb.AssetListManager;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetList;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListAssetMap;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.TitleAssetId;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListManager;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleDeleteCallback;
import com.tandbergtv.watchpoint.pmm.title.TitleDeleteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class TitleDeleteCallback
implements ITitleDeleteCallback {
    private static final Logger logger = Logger.getLogger(TitleDeleteCallback.class);

    public void onBeforeDelete(Title title) throws TitleDeleteException {
        try {
            logger.debug((Object)("Title: [" + title + "] is being deleted." + " Attempting to delete all assets related in title lists."));
            IAssetListManager assetListManager = (IAssetListManager)InjectionUtil.injectInstance(AssetListManager.class, IAssetListManager.class);
            List assetLists = assetListManager.getAllAssetListsByTitleId(title.getId());
            for (AssetList assetList : assetLists) {
                ArrayList<TitleAssetId> titleAssetIdsToRemove = new ArrayList<TitleAssetId>();
                for (AssetListAssetMap alam : assetList.getAssetsMap()) {
                    if (!alam.getTitle().equals((Object)title)) continue;
                    titleAssetIdsToRemove.add(new TitleAssetId(alam.getTitle().getId(), Long.valueOf(alam.getAssetId())));
                }
                assetListManager.removeAssets(assetList.getId(), titleAssetIdsToRemove);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed to delete Title [" + title + "] due to problems updating the related asset lists"));
            throw new TitleDeleteException("AssetList_001", "Title [" + title + "] cannot be deleted due to problems updating the related title lists", (Throwable)e);
        }
    }

    public void onDelete(Title title) throws TitleDeleteException {
    }
}

