/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.contentmgmt.titlelist.core;

import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetList;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListAssetMap;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.TitleAssetId;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListManager;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistCallback;
import com.tandbergtv.watchpoint.pmm.title.TitlePersistException;
import java.util.ArrayList;
import java.util.List;

public class TitlePersistCallback
implements ITitlePersistCallback {
    public void onBeforePersist(Title title) throws TitlePersistException {
    }

    public void onPersist(Title title) throws TitlePersistException {
        try {
            IAssetListManager service = this.getAssetListManager();
            Long titleId = title.getId();
            List list = service.getAllAssetListsByTitleId(titleId);
            for (AssetList assetList : list) {
                List map = assetList.getAssetsMap();
                ArrayList<TitleAssetId> assetsToRemove = new ArrayList<TitleAssetId>();
                for (AssetListAssetMap mapEntry : map) {
                    long assetId;
                    if (!title.equals((Object)mapEntry.getTitle()) || title.getAsset(assetId = mapEntry.getAssetId()) != null) continue;
                    assetsToRemove.add(new TitleAssetId(titleId, Long.valueOf(assetId)));
                }
                if (assetsToRemove.size() <= 0) continue;
                service.removeAssets(assetList.getId(), assetsToRemove);
            }
        }
        catch (RuntimeException e) {
            throw new TitlePersistException("AssetList_002", "Title [" + title + "] cannot be persisted due to problems updating the related title lists.", (Throwable)e);
        }
    }

    private IAssetListManager getAssetListManager() {
        return (IAssetListManager)InjectionUtil.injectInstance((String)"cms/AssetListManager/local", IAssetListManager.class);
    }
}

