/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileEntryParser;

public class FTPListParseEngine {
    private List<String> entries = new LinkedList<String>();
    private ListIterator<String> _internalIterator = this.entries.listIterator();
    FTPFileEntryParser parser = null;

    public FTPListParseEngine(FTPFileEntryParser fTPFileEntryParser) {
        this.parser = fTPFileEntryParser;
    }

    public void readServerList(InputStream inputStream, String string) throws IOException {
        this.entries = new LinkedList<String>();
        this.readStream(inputStream, string);
        this.parser.preParse(this.entries);
        this.resetIterator();
    }

    public void readServerList(InputStream inputStream) throws IOException {
        this.readServerList(inputStream, null);
    }

    private void readStream(InputStream inputStream, String string) throws IOException {
        BufferedReader bufferedReader = string == null ? new BufferedReader(new InputStreamReader(inputStream)) : new BufferedReader(new InputStreamReader(inputStream, string));
        String string2 = this.parser.readNextEntry(bufferedReader);
        while (string2 != null) {
            this.entries.add(string2);
            string2 = this.parser.readNextEntry(bufferedReader);
        }
        bufferedReader.close();
    }

    public FTPFile[] getNext(int n) {
        LinkedList<FTPFile> linkedList = new LinkedList<FTPFile>();
        for (int i = n; i > 0 && this._internalIterator.hasNext(); --i) {
            String string = this._internalIterator.next();
            FTPFile fTPFile = this.parser.parseFTPEntry(string);
            linkedList.add(fTPFile);
        }
        return linkedList.toArray(new FTPFile[0]);
    }

    public FTPFile[] getPrevious(int n) {
        LinkedList<FTPFile> linkedList = new LinkedList<FTPFile>();
        for (int i = n; i > 0 && this._internalIterator.hasPrevious(); --i) {
            String string = this._internalIterator.previous();
            FTPFile fTPFile = this.parser.parseFTPEntry(string);
            linkedList.add(0, fTPFile);
        }
        return linkedList.toArray(new FTPFile[0]);
    }

    public FTPFile[] getFiles() throws IOException {
        LinkedList<FTPFile> linkedList = new LinkedList<FTPFile>();
        Iterator<String> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            FTPFile fTPFile = this.parser.parseFTPEntry(string);
            linkedList.add(fTPFile);
        }
        return linkedList.toArray(new FTPFile[0]);
    }

    public boolean hasNext() {
        return this._internalIterator.hasNext();
    }

    public boolean hasPrevious() {
        return this._internalIterator.hasPrevious();
    }

    public void resetIterator() {
        this._internalIterator = this.entries.listIterator();
    }
}

