/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.text.ParseException;
import java.util.List;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.parser.ConfigurableFTPFileEntryParserImpl;
import org.apache.commons.net.ftp.parser.UnixFTPEntryParser;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVSFTPEntryParser
extends ConfigurableFTPFileEntryParserImpl {
    static final int UNKNOWN_LIST_TYPE = -1;
    static final int FILE_LIST_TYPE = 0;
    static final int MEMBER_LIST_TYPE = 1;
    static final int UNIX_LIST_TYPE = 2;
    static final int JES_LEVEL_1_LIST_TYPE = 3;
    static final int JES_LEVEL_2_LIST_TYPE = 4;
    private int isType = -1;
    private UnixFTPEntryParser unixFTPEntryParser;
    static final String DEFAULT_DATE_FORMAT = "yyyy/MM/dd HH:mm";
    static final String FILE_LIST_REGEX = "\\S+\\s+\\S+\\s+\\S+\\s+\\S+\\s+\\S+\\s+[FV]\\S*\\s+\\S+\\s+\\S+\\s+(PS|PO|PO-E)\\s+(\\S+)\\s*";
    static final String MEMBER_LIST_REGEX = "(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+\\S+\\s+\\S+\\s*";
    static final String JES_LEVEL_1_LIST_REGEX = "(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*";
    static final String JES_LEVEL_2_LIST_REGEX = "(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+).*";

    public MVSFTPEntryParser() {
        super("");
        super.configure(null);
    }

    @Override
    public FTPFile parseFTPEntry(String string) {
        boolean bl = false;
        FTPFile fTPFile = new FTPFile();
        if (this.isType == 0) {
            bl = this.parseFileList(fTPFile, string);
        } else if (this.isType == 1) {
            bl = this.parseMemberList(fTPFile, string);
            if (!bl) {
                bl = this.parseSimpleEntry(fTPFile, string);
            }
        } else if (this.isType == 2) {
            bl = this.parseUnixList(fTPFile, string);
        } else if (this.isType == 3) {
            bl = this.parseJeslevel1List(fTPFile, string);
        } else if (this.isType == 4) {
            bl = this.parseJeslevel2List(fTPFile, string);
        }
        if (!bl) {
            fTPFile = null;
        }
        return fTPFile;
    }

    private boolean parseFileList(FTPFile fTPFile, String string) {
        if (this.matches(string)) {
            fTPFile.setRawListing(string);
            String string2 = this.group(2);
            String string3 = this.group(1);
            fTPFile.setName(string2);
            if ("PS".equals(string3)) {
                fTPFile.setType(0);
            } else if ("PO".equals(string3) || "PO-E".equals(string3)) {
                fTPFile.setType(1);
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean parseMemberList(FTPFile fTPFile, String string) {
        if (this.matches(string)) {
            fTPFile.setRawListing(string);
            String string2 = this.group(1);
            String string3 = new StringBuffer().append(this.group(2)).append(" ").append(this.group(3)).toString();
            fTPFile.setName(string2);
            fTPFile.setType(0);
            try {
                fTPFile.setTimestamp(super.parseTimestamp(string3));
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean parseSimpleEntry(FTPFile fTPFile, String string) {
        if (string != null && string.length() > 0) {
            fTPFile.setRawListing(string);
            String string2 = string.split(" ")[0];
            fTPFile.setName(string2);
            fTPFile.setType(0);
            return true;
        }
        return false;
    }

    private boolean parseUnixList(FTPFile fTPFile, String string) {
        fTPFile = this.unixFTPEntryParser.parseFTPEntry(string);
        return fTPFile != null;
    }

    private boolean parseJeslevel1List(FTPFile fTPFile, String string) {
        if (this.matches(string) && this.group(3).equalsIgnoreCase("OUTPUT")) {
            fTPFile.setRawListing(string);
            String string2 = this.group(2);
            fTPFile.setName(string2);
            fTPFile.setType(0);
            return true;
        }
        return false;
    }

    private boolean parseJeslevel2List(FTPFile fTPFile, String string) {
        if (this.matches(string) && this.group(4).equalsIgnoreCase("OUTPUT")) {
            fTPFile.setRawListing(string);
            String string2 = this.group(2);
            fTPFile.setName(string2);
            fTPFile.setType(0);
            return true;
        }
        return false;
    }

    @Override
    public List<String> preParse(List<String> list) {
        if (list != null && list.size() > 0) {
            String string = list.get(0);
            if (string.indexOf("Volume") >= 0 && string.indexOf("Dsname") >= 0) {
                this.setType(0);
                super.setRegex(FILE_LIST_REGEX);
            } else if (string.indexOf("Name") >= 0 && string.indexOf("Id") >= 0) {
                this.setType(1);
                super.setRegex(MEMBER_LIST_REGEX);
            } else if (string.indexOf("total") == 0) {
                this.setType(2);
                this.unixFTPEntryParser = new UnixFTPEntryParser();
            } else if (string.indexOf("Spool Files") >= 30) {
                this.setType(3);
                super.setRegex(JES_LEVEL_1_LIST_REGEX);
            } else if (string.indexOf("JOBNAME") == 0 && string.indexOf("JOBID") > 8) {
                this.setType(4);
                super.setRegex(JES_LEVEL_2_LIST_REGEX);
            } else {
                this.setType(-1);
            }
            if (this.isType != 3) {
                list.remove(0);
            }
        }
        return list;
    }

    void setType(int n) {
        this.isType = n;
    }

    @Override
    protected FTPClientConfig getDefaultConfiguration() {
        return new FTPClientConfig("MVS", DEFAULT_DATE_FORMAT, null, null, null, null);
    }
}

