/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.text.ParseException;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.parser.ConfigurableFTPFileEntryParserImpl;

public class NetwareFTPEntryParser
extends ConfigurableFTPFileEntryParserImpl {
    private static final String DEFAULT_DATE_FORMAT = "MMM dd yyyy";
    private static final String DEFAULT_RECENT_DATE_FORMAT = "MMM dd HH:mm";
    private static final String REGEX = "(d|-){1}\\s+\\[(.*)\\]\\s+(\\S+)\\s+(\\d+)\\s+(\\S+\\s+\\S+\\s+((\\d+:\\d+)|(\\d{4})))\\s+(.*)";

    public NetwareFTPEntryParser() {
        this((FTPClientConfig)null);
    }

    public NetwareFTPEntryParser(FTPClientConfig fTPClientConfig) {
        super(REGEX);
        this.configure(fTPClientConfig);
    }

    public FTPFile parseFTPEntry(String string) {
        FTPFile fTPFile = new FTPFile();
        if (this.matches(string)) {
            String string2 = this.group(1);
            String string3 = this.group(2);
            String string4 = this.group(3);
            String string5 = this.group(4);
            String string6 = this.group(5);
            String string7 = this.group(9);
            try {
                fTPFile.setTimestamp(super.parseTimestamp(string6));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (string2.trim().equals("d")) {
                fTPFile.setType(1);
            } else {
                fTPFile.setType(0);
            }
            fTPFile.setUser(string4);
            fTPFile.setName(string7.trim());
            fTPFile.setSize(Long.parseLong(string5.trim()));
            if (string3.indexOf("R") != -1) {
                fTPFile.setPermission(0, 0, true);
            }
            if (string3.indexOf("W") != -1) {
                fTPFile.setPermission(0, 1, true);
            }
            return fTPFile;
        }
        return null;
    }

    protected FTPClientConfig getDefaultConfiguration() {
        return new FTPClientConfig("NETWARE", DEFAULT_DATE_FORMAT, DEFAULT_RECENT_DATE_FORMAT, null, null, null);
    }
}

