/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.parser.VMSFTPEntryParser;
import org.apache.commons.net.net.sf.retrotranslator.runtime.java.util.regex._MatchResult;
import org.apache.commons.net.net.sf.retrotranslator.runtime.java.util.regex._Matcher;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMSVersioningFTPEntryParser
extends VMSFTPEntryParser {
    private Matcher _preparse_matcher_;
    private Pattern _preparse_pattern_;
    private static final String PRE_PARSE_REGEX = "(.*);([0-9]+)\\s*.*";

    public VMSVersioningFTPEntryParser() {
        this((FTPClientConfig)null);
    }

    public VMSVersioningFTPEntryParser(FTPClientConfig fTPClientConfig) {
        this.configure(fTPClientConfig);
        try {
            this._preparse_pattern_ = Pattern.compile(PRE_PARSE_REGEX);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException("Unparseable regex supplied:  (.*);([0-9]+)\\s*.*");
        }
    }

    @Override
    public List<String> preParse(List<String> list) {
        NameVersion nameVersion;
        NameVersion nameVersion2;
        String string;
        String string2;
        Object object;
        String string3;
        list = super.preParse(list);
        HashMap<String, NameVersion> hashMap = new HashMap<String, NameVersion>();
        ListIterator<String> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            string3 = listIterator.next().trim();
            object = null;
            this._preparse_matcher_ = this._preparse_pattern_.matcher(string3);
            if (!this._preparse_matcher_.matches()) continue;
            object = _Matcher.toMatchResult(this._preparse_matcher_);
            string2 = _MatchResult.group(object, 1);
            string = _MatchResult.group(object, 2);
            nameVersion2 = new NameVersion(string2, string);
            nameVersion = (NameVersion)hashMap.get(string2);
            if (null != nameVersion && nameVersion2.versionNumber < nameVersion.versionNumber) {
                listIterator.remove();
                continue;
            }
            hashMap.put(string2, nameVersion2);
        }
        while (listIterator.hasPrevious()) {
            string3 = listIterator.previous().trim();
            object = null;
            this._preparse_matcher_ = this._preparse_pattern_.matcher(string3);
            if (!this._preparse_matcher_.matches()) continue;
            object = _Matcher.toMatchResult(this._preparse_matcher_);
            string2 = _MatchResult.group(object, 1);
            string = _MatchResult.group(object, 2);
            nameVersion2 = new NameVersion(string2, string);
            nameVersion = (NameVersion)hashMap.get(string2);
            if (null == nameVersion || nameVersion2.versionNumber >= nameVersion.versionNumber) continue;
            listIterator.remove();
        }
        return list;
    }

    @Override
    protected boolean isVersioning() {
        return true;
    }

    private static class NameVersion {
        String name;
        int versionNumber;

        NameVersion(String string, String string2) {
            this.name = string;
            this.versionNumber = Integer.parseInt(string2);
        }
    }
}

