/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.net.sf.retrotranslator.runtime.java.util.regex;

import java.util.regex.Matcher;
import org.apache.commons.net.net.sf.retrotranslator.runtime.java.util.regex.MatchResult_;

public class _Matcher {
    public static String quoteReplacement(String s) {
        if (s.indexOf(92) < 0 && s.indexOf(36) < 0) {
            return s;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '$') {
                buffer.append('\\');
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static Object toMatchResult(Matcher matcher) {
        boolean available = true;
        int groupCount = matcher.groupCount();
        int[] starts = new int[groupCount + 1];
        int[] ends = new int[groupCount + 1];
        String[] groups = new String[groupCount + 1];
        try {
            for (int i = 0; i <= groupCount; ++i) {
                starts[i] = matcher.start(i);
                ends[i] = matcher.end(i);
                groups[i] = matcher.group(i);
            }
        }
        catch (IllegalStateException e) {
            available = false;
        }
        return new MatchResultImpl(available, groupCount, starts, ends, groups);
    }

    private static class MatchResultImpl
    implements MatchResult_ {
        private final boolean available;
        private final int groupCount;
        private final int[] starts;
        private final int[] ends;
        private final String[] groups;

        public MatchResultImpl(boolean available, int groupCount, int[] starts, int[] ends, String[] groups) {
            this.available = available;
            this.groupCount = groupCount;
            this.starts = starts;
            this.ends = ends;
            this.groups = groups;
        }

        public int start() {
            return this.start(0);
        }

        public int start(int group) {
            if (!this.available) {
                throw new IllegalStateException();
            }
            return this.starts[group];
        }

        public int end() {
            return this.end(0);
        }

        public int end(int group) {
            if (!this.available) {
                throw new IllegalStateException();
            }
            return this.ends[group];
        }

        public String group() {
            return this.group(0);
        }

        public String group(int group) {
            if (!this.available) {
                throw new IllegalStateException();
            }
            return this.groups[group];
        }

        public int groupCount() {
            return this.groupCount;
        }
    }
}

