/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SubnetUtils {
    private static final String IP_ADDRESS = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})";
    private static final String SLASH_FORMAT = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,3})";
    private static final Pattern addressPattern = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
    private static final Pattern cidrPattern = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,3})");
    private static final int NBITS = 32;
    private int netmask = 0;
    private int address = 0;
    private int network = 0;
    private int broadcast = 0;

    public SubnetUtils(String string) {
        this.calculate(string);
    }

    public SubnetUtils(String string, String string2) {
        this.calculate(this.toCidrNotation(string, string2));
    }

    public final SubnetInfo getInfo() {
        return new SubnetInfo();
    }

    private void calculate(String string) {
        Matcher matcher = cidrPattern.matcher(string);
        if (matcher.matches()) {
            this.address = this.matchAddress(matcher);
            int n = this.rangeCheck(Integer.parseInt(matcher.group(5)), 0, 31);
            for (int i = 0; i < n; ++i) {
                this.netmask |= 1 << 31 - i;
            }
        } else {
            throw new IllegalArgumentException("Could not parse [" + string + "]");
        }
        this.network = this.address & this.netmask;
        this.broadcast = this.network | ~this.netmask;
    }

    private int toInteger(String string) {
        Matcher matcher = addressPattern.matcher(string);
        if (matcher.matches()) {
            return this.matchAddress(matcher);
        }
        throw new IllegalArgumentException("Could not parse [" + string + "]");
    }

    private int matchAddress(Matcher matcher) {
        int n = 0;
        for (int i = 1; i <= 4; ++i) {
            int n2 = this.rangeCheck(Integer.parseInt(matcher.group(i)), 0, 255);
            n |= (n2 & 0xFF) << 8 * (4 - i);
        }
        return n;
    }

    private int[] toArray(int n) {
        int[] nArray = new int[4];
        for (int i = 3; i >= 0; --i) {
            int n2 = i;
            nArray[n2] = nArray[n2] | n >>> 8 * (3 - i) & 0xFF;
        }
        return nArray;
    }

    private String format(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            if (i == nArray.length - 1) continue;
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    private int rangeCheck(int n, int n2, int n3) {
        if (n >= n2 && n <= n3) {
            return n;
        }
        throw new IllegalArgumentException("Value out of range: [" + n + "]");
    }

    int pop(int n) {
        n -= n >>> 1 & 0x55555555;
        n = (n & 0x33333333) + (n >>> 2 & 0x33333333);
        n = n + (n >>> 4) & 0xF0F0F0F;
        n += n >>> 8;
        n += n >>> 16;
        return n & 0x3F;
    }

    private String toCidrNotation(String string, String string2) {
        return string + "/" + this.pop(this.toInteger(string2));
    }

    public final class SubnetInfo {
        private SubnetInfo() {
        }

        private int netmask() {
            return SubnetUtils.this.netmask;
        }

        private int network() {
            return SubnetUtils.this.network;
        }

        private int address() {
            return SubnetUtils.this.address;
        }

        private int broadcast() {
            return SubnetUtils.this.broadcast;
        }

        private int low() {
            return this.network() + 1;
        }

        private int high() {
            return this.broadcast() - 1;
        }

        public boolean isInRange(String string) {
            return this.isInRange(SubnetUtils.this.toInteger(string));
        }

        private boolean isInRange(int n) {
            return n - this.low() <= this.high() - this.low();
        }

        public String getBroadcastAddress() {
            return SubnetUtils.this.format(SubnetUtils.this.toArray(this.broadcast()));
        }

        public String getNetworkAddress() {
            return SubnetUtils.this.format(SubnetUtils.this.toArray(this.network()));
        }

        public String getNetmask() {
            return SubnetUtils.this.format(SubnetUtils.this.toArray(this.netmask()));
        }

        public String getAddress() {
            return SubnetUtils.this.format(SubnetUtils.this.toArray(this.address()));
        }

        public String getLowAddress() {
            return SubnetUtils.this.format(SubnetUtils.this.toArray(this.low()));
        }

        public String getHighAddress() {
            return SubnetUtils.this.format(SubnetUtils.this.toArray(this.high()));
        }

        public int getAddressCount() {
            return this.broadcast() - this.low();
        }

        public int asInteger(String string) {
            return SubnetUtils.this.toInteger(string);
        }

        public String getCidrSignature() {
            return SubnetUtils.this.toCidrNotation(SubnetUtils.this.format(SubnetUtils.this.toArray(this.address())), SubnetUtils.this.format(SubnetUtils.this.toArray(this.netmask())));
        }

        public String[] getAllAddresses() {
            String[] stringArray = new String[this.getAddressCount()];
            int n = this.low();
            int n2 = 0;
            while (n <= this.high()) {
                stringArray[n2] = SubnetUtils.this.format(SubnetUtils.this.toArray(n));
                ++n;
                ++n2;
            }
            return stringArray;
        }
    }
}

