/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.transfer.client.ftp;

import jfileupload.transfer.client.core.ProtocolListener;
import jfileupload.transfer.client.ftp.FTPTransfer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.MalformedServerReplyException;

public class CommandMonitor
extends Thread
implements ProtocolListener {
    private static final Log log = LogFactory.getLog((Class)(class$jfileupload$transfer$client$ftp$CommandMonitor == null ? (class$jfileupload$transfer$client$ftp$CommandMonitor = CommandMonitor.class$("jfileupload.transfer.client.ftp.CommandMonitor")) : class$jfileupload$transfer$client$ftp$CommandMonitor));
    public static final String FTP_NOOP = "NOOP";
    public static final String FTP_STAT = "STAT";
    private FTPTransfer client = null;
    private long period = -1L;
    private boolean completed = false;
    private long lastCommand = 0L;
    private int queue = 0;
    private int errQueue = 0;
    private String cmd = null;
    static /* synthetic */ Class class$jfileupload$transfer$client$ftp$CommandMonitor;

    public CommandMonitor(FTPTransfer fTPTransfer, long l, String string) {
        super("COMMANDMONITOR");
        this.client = fTPTransfer;
        this.period = l;
        this.cmd = string;
        if (this.cmd == null) {
            this.cmd = FTP_NOOP;
        } else if (!this.cmd.equalsIgnoreCase(FTP_STAT)) {
            this.cmd = FTP_NOOP;
        }
        fTPTransfer.addProtocolListener(this);
    }

    public void requestSent(Object object) {
        String string;
        this.lastCommand = System.currentTimeMillis();
        if (object != null && object instanceof String && (string = (String)object).startsWith("DISCONNECT")) {
            this.completed = true;
        }
    }

    public void responseReceived(Object object) {
    }

    public void run() {
        log.info((Object)(this.getName() + " started (" + this.period + " ms)"));
        while (!this.completed) {
            long l;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                log.error((Object)interruptedException);
            }
            if ((l = System.currentTimeMillis()) - this.lastCommand <= this.period) continue;
            if (this.client != null && !this.completed) {
                new Thread(){

                    public void run() {
                        CommandMonitor.this.queue++;
                        log.debug((Object)(CommandMonitor.this.cmd + " " + this.getName()));
                        try {
                            CommandMonitor.this.client.notifyProtocolListeners(new String[]{CommandMonitor.this.cmd}, false);
                            if (CommandMonitor.this.cmd.equalsIgnoreCase(CommandMonitor.FTP_STAT)) {
                                CommandMonitor.this.client.getClient().stat();
                            } else {
                                CommandMonitor.this.client.getClient().sendNoOp();
                            }
                            CommandMonitor.this.client.notifyProtocolListeners(CommandMonitor.this.client.getClient().getReplyStrings(), true);
                        }
                        catch (MalformedServerReplyException malformedServerReplyException) {
                            log.error((Object)malformedServerReplyException);
                            CommandMonitor.this.errQueue++;
                        }
                        catch (Exception exception) {
                            log.error((Object)exception);
                        }
                        log.debug((Object)(CommandMonitor.this.cmd + " Completed " + this.getName()));
                        CommandMonitor.this.queue--;
                    }
                }.start();
                this.lastCommand = l;
                continue;
            }
            this.completed = true;
        }
        log.info((Object)(this.getName() + " completed"));
        if (this.client != null) {
            this.client.removeProtocolListener(this);
        }
        this.client = null;
    }

    public void abort() {
        this.completed = true;
    }

    public int getQueueSize() {
        return this.queue;
    }

    public int getErrorQueueSize() {
        return this.errQueue;
    }

    public void removeError() {
        --this.errQueue;
    }

    public void addError() {
        ++this.errQueue;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

