/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.transfer.client.ftp;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import jfileupload.transfer.client.core.AbstractTransferController;
import jfileupload.transfer.client.core.ClientException;
import jfileupload.transfer.client.core.ProtocolListener;
import jfileupload.transfer.client.ftp.CommandMonitor;
import jfileupload.transfer.client.ftp.FtpClientFactory;
import jfileupload.transfer.client.mdesign.AuthenticationModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.MalformedServerReplyException;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;

public abstract class FTPTransfer
extends AbstractTransferController {
    private static final Log log = LogFactory.getLog((Class)(class$jfileupload$transfer$client$ftp$FTPTransfer == null ? (class$jfileupload$transfer$client$ftp$FTPTransfer = FTPTransfer.class$("jfileupload.transfer.client.ftp.FTPTransfer")) : class$jfileupload$transfer$client$ftp$FTPTransfer));
    public static String PASV = "pasv";
    public static String FTPSMODE = "ftpsmode";
    public static String FTPSPROT = "ftpsprot";
    public static String FTPSESSION = "ftpsession";
    public static String WEAKSSL = "weakssl";
    public static String DEPRECATEDUSERNAME = "username";
    public static String DEPRECATEDPASSWORD = "password";
    public static String DEPRECATEDURL = "url";
    public static String ACCOUNT = "account";
    public static String KEYFILE = "keyfile";
    public static String SITECOMMAND = "sitecommand";
    public static String DISABLEAUTH = "disableauth";
    public static String ACCOUNTCREATION = "accountcreation";
    public static String ACCOUNTCREATIONCHMOD = "accountcreationchmod";
    public static String ACCOUNTPWD = "accountpwd";
    public static String TRANSFERTYPE = "transfertype";
    public static String REMOTEVERIFICATION = "remoteverification";
    public static String DELETEFOLDER = "deletefolder";
    public static String COMMANDMONITOR = "commandmonitor";
    public static String FTPCOMMANDMONITOR = "ftpcommandmonitor";
    public static String FTPPOSITIVELOGIN = "ftppositivelogin";
    protected static String SFTPCLIENT = "jfileupload.transfer.client.sftp.SFTPClient";
    protected static String SCPCLIENT = "jfileupload.transfer.client.scp.SCPClient";
    private FTPClient client = null;
    protected String targetURL = null;
    protected String wd = null;
    protected CommandMonitor commandMonitor = null;
    protected boolean featCommand = false;
    static /* synthetic */ Class class$jfileupload$transfer$client$ftp$FTPTransfer;

    public void init() throws ClientException {
        String string;
        int n;
        long l;
        super.init();
        this.registerSSLSocketFactory();
        FtpClientFactory ftpClientFactory = FtpClientFactory.getInstance();
        ftpClientFactory.setConcurrency(this.getRawConf().getProperty("concurrency"));
        this.targetURL = null;
        this.wd = "";
        List list = this.getTarget();
        if (list == null || list.size() <= 0) {
            throw new ClientException("FTP url parameter is missing");
        }
        this.targetURL = (String)list.get(0);
        this.client = this.targetURL.toLowerCase().startsWith("ftps://") ? ftpClientFactory.getClient((String)this.getParameters(null).get(FTPSMODE), (String)this.getParameters(null).get(FTPSPROT)) : (this.targetURL.toLowerCase().startsWith("sftp://") ? ftpClientFactory.getClient(SFTPCLIENT) : (this.targetURL.toLowerCase().startsWith("scp://") ? ftpClientFactory.getClient(SCPCLIENT) : ftpClientFactory.getClient()));
        String string2 = this.getEncoding();
        if (string2 != null) {
            log.info((Object)("Control encoding: " + string2));
            if (string2.toUpperCase().startsWith("AUTO")) {
                if (!this.targetURL.toLowerCase().startsWith("sftp://") && !this.targetURL.toLowerCase().startsWith("scp://")) {
                    this.featCommand = true;
                    this.client.setControlEncoding("UTF-8");
                }
            } else {
                this.client.setControlEncoding(string2);
            }
        }
        if ((l = this.getTimeOut()) > 0L) {
            this.client.setDefaultTimeout((int)l);
        }
        if ((n = (int)this.getRawConf().getLong(this.getRawConf().getProperty("buffersize"))) > 0) {
            this.client.setBufferSize(n);
            log.info((Object)("FTP buffer size = " + n));
        }
        if ((string = (String)this.getParameters(null).get(REMOTEVERIFICATION)) != null && string.equalsIgnoreCase("false")) {
            this.client.setRemoteVerificationEnabled(false);
        }
        this.client.addProtocolCommandListener(new ProtocolCommandListener(){

            public void protocolCommandSent(ProtocolCommandEvent protocolCommandEvent) {
                String string = protocolCommandEvent.getMessage();
                if (protocolCommandEvent.getCommand().equalsIgnoreCase("PASS")) {
                    string = "PASS *****";
                }
                FTPTransfer.this.notifyProtocolCommandListeners(new String[]{string}, false);
            }

            public void protocolReplyReceived(ProtocolCommandEvent protocolCommandEvent) {
                FTPTransfer.this.notifyProtocolCommandListeners(new String[]{protocolCommandEvent.getMessage()}, true);
            }
        });
    }

    public void registerSSLSocketFactory() {
        String string;
        if (super.getParameters(null) != null && (string = (String)super.getParameters(null).get(WEAKSSL)) != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("dummy"))) {
            log.info((Object)"WeakSSL registered for FTPS");
        }
    }

    public FTPClient getClient() {
        return this.client;
    }

    protected void FTPConnect(HashMap hashMap) throws ClientException {
        if (hashMap.get(FTPSESSION) != null && hashMap.get(FTPSESSION).equals("true")) {
            if (this.getClient() != null) {
                if (!FtpClientFactory.getInstance().isSessionOpened(this.getClient())) {
                    this.connect(hashMap);
                    FtpClientFactory.getInstance().setSessionOpened(this.getClient(), true);
                } else {
                    try {
                        this.notifyProtocolListeners(new String[]{"NOOP"}, false);
                        this.getClient().noop();
                        this.notifyProtocolListeners(this.getClient().getReplyStrings(), true);
                    }
                    catch (FTPConnectionClosedException fTPConnectionClosedException) {
                        try {
                            this.notifyProtocolListeners(new String[]{"DISCONNECT"}, false);
                            this.getClient().disconnect();
                            this.notifyProtocolListeners(this.getClient().getReplyStrings(), true);
                        }
                        catch (IOException iOException) {
                            log.error((Object)"Cannot clean up", (Throwable)iOException);
                        }
                        this.connect(hashMap);
                        FtpClientFactory.getInstance().setSessionOpened(this.getClient(), true);
                    }
                    catch (IOException iOException) {
                        log.error((Object)"NOOP failed", (Throwable)iOException);
                    }
                }
            }
        } else {
            this.connect(hashMap);
            FtpClientFactory.getInstance().setSessionOpened(this.getClient(), true);
        }
    }

    protected void FTPDisconnect(HashMap hashMap, boolean bl) {
        if ((hashMap.get(FTPSESSION) == null || !hashMap.get(FTPSESSION).equals("true") || bl) && this.getClient() != null && this.getClient().isConnected()) {
            try {
                this.notifyProtocolListeners(new String[]{"DISCONNECT"}, false);
                this.getClient().disconnect();
                this.notifyProtocolListeners(this.getClient().getReplyStrings(), true);
                FtpClientFactory.getInstance().setSessionOpened(this.getClient(), false);
                log.info((Object)("Disconnected from " + this.targetURL));
            }
            catch (IOException iOException) {
                log.error((Object)iOException);
            }
        }
    }

    protected void FTPDisconnect(HashMap hashMap) {
        this.FTPDisconnect(hashMap, false);
    }

    protected void connect(HashMap hashMap) throws ClientException {
        block47: {
            try {
                String string;
                Object object;
                String string2;
                String string3;
                String string4 = (String)hashMap.get(DEPRECATEDURL);
                if (string4 != null && string4.startsWith("ftp")) {
                    this.targetURL = string4;
                }
                if ((string3 = this.targetURL).startsWith("ftps://")) {
                    string3 = "ftp://" + string3.substring(7, string3.length());
                } else if (string3.startsWith("sftp://")) {
                    string3 = "ftp://" + string3.substring(7, string3.length());
                } else if (string3.startsWith("scp://")) {
                    string3 = "ftp://" + string3.substring(6, string3.length());
                }
                URL uRL = new URL(string3);
                String string5 = uRL.getHost();
                int n = uRL.getPort();
                String string6 = (String)hashMap.get(DEPRECATEDUSERNAME);
                String string7 = (String)hashMap.get(DEPRECATEDPASSWORD);
                if (string6 == null) {
                    string6 = this.getUsername();
                }
                if (string7 == null) {
                    string7 = this.getPassword();
                }
                String string8 = (String)hashMap.get(ACCOUNT);
                String string9 = (String)hashMap.get(KEYFILE);
                String string10 = (String)hashMap.get(PASV);
                String string11 = (String)hashMap.get(SITECOMMAND);
                String string12 = (String)hashMap.get(DISABLEAUTH);
                String string13 = (String)hashMap.get(ACCOUNTCREATION);
                this.notifyProtocolListeners(new String[]{"CONNECT " + string5}, false);
                if (n > 0) {
                    this.getClient().connect(string5, n);
                } else {
                    this.getClient().connect(string5);
                }
                log.info((Object)("Connected to " + this.targetURL));
                log.info((Object)this.getClient().getReplyString());
                this.notifyProtocolListeners(this.getClient().getReplyStrings(), true);
                int n2 = this.getClient().getReplyCode();
                boolean bl = true;
                String string14 = (String)hashMap.get(FTPPOSITIVELOGIN);
                if (string14 != null && string14.equalsIgnoreCase("false")) {
                    bl = false;
                }
                if (!FTPReply.isPositiveCompletion((int)n2) && bl) {
                    this.notifyProtocolListeners(new String[]{"DISCONNECT"}, false);
                    this.getClient().disconnect();
                    this.notifyProtocolListeners(this.getClient().getReplyStrings(), true);
                    log.info((Object)"FTP server refused connection.");
                    throw new ClientException("Connection denied", String.valueOf(n2));
                }
                if (string10 != null) {
                    if (string10.equalsIgnoreCase("true")) {
                        this.notifyProtocolListeners(new String[]{"PASV"}, false);
                        this.getClient().enterLocalPassiveMode();
                        log.info((Object)"PASV enabled");
                    } else {
                        this.getClient().enterLocalActiveMode();
                        log.info((Object)"PASV disabled");
                    }
                }
                boolean bl2 = false;
                if (string6 != null && string7 != null && string12 == null) {
                    this.notifyProtocolListeners(new String[]{"USER " + string6 + " PASS ******"}, false);
                    bl2 = this.getClient().login(string6, string7, string9);
                    log.debug((Object)this.getClient().getReplyString());
                    this.notifyProtocolListeners(this.getClient().getReplyStrings(), true);
                }
                if (!bl2) {
                    if (this.getAuthentication() != null && this.getAuthentication().equalsIgnoreCase("auto")) {
                        int n3 = 0;
                        while (!bl2 && n3++ < 3) {
                            AuthenticationModel authenticationModel = new AuthenticationModel();
                            string2 = this.getServerUrl().getHost();
                            if (this.getServerUrl().getPort() > 0) {
                                string2 = string2 + ":" + this.getServerUrl().getPort();
                            }
                            authenticationModel.setServer(string2);
                            authenticationModel.setUsername(string6);
                            if (string7 != null) {
                                authenticationModel.setPassword(string7.toCharArray());
                            }
                            if ((object = this.authenticate(authenticationModel, n3)) == null) break;
                            string6 = ((PasswordAuthentication)object).getUserName();
                            string7 = new String(((PasswordAuthentication)object).getPassword());
                            hashMap.put(DEPRECATEDUSERNAME, string6);
                            hashMap.put(DEPRECATEDPASSWORD, string7);
                            this.notifyProtocolListeners(new String[]{"USER " + string6 + " PASS ******"}, false);
                            bl2 = this.getClient().login(string6, string7, string9);
                            log.debug((Object)this.getClient().getReplyString());
                            this.notifyProtocolListeners(this.getClient().getReplyStrings(), true);
                        }
                        if (!bl2) {
                            throw new ClientException("Invalid credentials");
                        }
                    } else {
                        throw new ClientException("Invalid credentials");
                    }
                }
                if (this.featCommand) {
                    String string15 = "FEAT";
                    this.notifyProtocolListeners(new String[]{string15}, false);
                    int n4 = this.getClient().sendCommand(string15);
                    string2 = this.getClient().getReplyString();
                    this.notifyProtocolListeners(this.getClient().getReplyStrings(), true);
                    if (FTPReply.isPositiveCompletion((int)n4) && string2 != null && string2.indexOf((String)(object = "UTF8")) != -1) {
                        String string16 = "OPTS " + (String)object + " ON";
                        this.notifyProtocolListeners(new String[]{string16}, false);
                        n4 = this.getClient().sendCommand(string16);
                        this.notifyProtocolListeners(this.getClient().getReplyStrings(), true);
                        if (FTPReply.isPositiveCompletion((int)n4)) {
                            log.debug((Object)"UTF-8 encoding enabled");
                        }
                    }
                }
                String string17 = (String)hashMap.get(FTPSPROT);
                if (this.getClient() instanceof FTPSClient && string17 != null) {
                    try {
                        log.info((Object)"PBSZ 0");
                        ((FTPSClient)this.getClient()).execPBSZ(0L);
                    }
                    catch (Exception exception) {
                        log.error((Object)exception.getMessage(), (Throwable)exception);
                    }
                    if (string17.equalsIgnoreCase("PROT_P")) {
                        log.info((Object)"PROT_P");
                        try {
                            ((FTPSClient)this.getClient()).execPROT("P");
                        }
                        catch (Exception exception) {
                            log.error((Object)exception.getMessage(), (Throwable)exception);
                        }
                    } else if (string17.equalsIgnoreCase("PROT_C")) {
                        log.info((Object)"PROT_C");
                        try {
                            ((FTPSClient)this.getClient()).execPROT("C");
                        }
                        catch (Exception exception) {
                            log.error((Object)exception.getMessage(), (Throwable)exception);
                        }
                    }
                }
                if (string11 != null) {
                    this.notifyProtocolListeners(new String[]{"SITE QUOTE " + string11}, false);
                    boolean bl3 = this.getClient().sendSiteCommand(string11);
                    if (!bl3) {
                        log.info((Object)("Custom SITE command failed : " + string11 + " (" + this.getClient().getReplyString() + ")"));
                    } else {
                        log.info((Object)("Custom SITE command succeeded : " + string11));
                    }
                    this.notifyProtocolListeners(this.getClient().getReplyStrings(), true);
                    if (string6 != null && string7 != null) {
                        this.notifyProtocolListeners(new String[]{"USER " + string6 + " PASS ******"}, false);
                        bl2 = this.getClient().login(string6, string7, string9);
                        this.notifyProtocolListeners(this.getClient().getReplyStrings(), true);
                        if (!bl2) {
                            log.info((Object)("Authentication after SITE failed : " + this.getClient().getReplyString()));
                            throw new ClientException("Invalid credentials");
                        }
                    }
                }
                if ((string = (String)hashMap.get(ACCOUNTPWD)) != null && string.equalsIgnoreCase("true")) {
                    this.notifyProtocolListeners(new String[]{"PWD "}, false);
                    this.wd = this.getClient().printWorkingDirectory();
                    if (this.wd == null) {
                        this.wd = "";
                    }
                    this.notifyProtocolListeners(this.getClient().getReplyStrings(), true);
                }
                if (string8 == null || string8.equals("")) break block47;
                string2 = this.normalizePath(this.wd + string8);
                this.notifyProtocolListeners(new String[]{"CWD " + string2}, false);
                boolean bl4 = this.getClient().changeWorkingDirectory(string2);
                this.notifyProtocolListeners(this.getClient().getReplyStrings(), true);
                if (bl4) break block47;
                if (string13 != null && string13.equalsIgnoreCase("true")) {
                    log.debug((Object)("Creating initial directory : " + string2));
                    boolean bl5 = this.makeAndChangeDirectory(this.getClient(), string2, true, (String)hashMap.get(ACCOUNTCREATIONCHMOD));
                    break block47;
                }
                throw new ClientException("Cannot change directory");
            }
            catch (MalformedURLException malformedURLException) {
                log.error((Object)malformedURLException);
                throw new ClientException((Throwable)malformedURLException);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                log.error((Object)iOException);
                throw new ClientException((Throwable)iOException);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean makeAndChangeDirectory(FTPClient fTPClient, String string, boolean bl, String string2) throws IOException, ClientException {
        boolean bl2 = false;
        boolean bl3 = false;
        int n = -1;
        if (string2 != null && string2.length() > 0) {
            n = (int)super.getLong(string2);
        }
        string = this.normalizePath(string);
        log.debug((Object)("Creating subfolder : " + string));
        this.notifyProtocolListeners(new String[]{"MKD " + string}, false);
        bl2 = fTPClient.makeDirectory(string);
        this.notifyProtocolListeners(fTPClient.getReplyStrings(), true);
        if (!bl2) {
            if (!bl) throw new ClientException("Cannot make directory");
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            while (stringTokenizer.hasMoreTokens()) {
                boolean bl4;
                String string3 = this.normalizePath(stringTokenizer.nextToken());
                this.notifyProtocolListeners(new String[]{"CWD " + string3}, false);
                bl3 = fTPClient.changeWorkingDirectory(string3);
                this.notifyProtocolListeners(fTPClient.getReplyStrings(), true);
                if (bl3) continue;
                this.notifyProtocolListeners(new String[]{"MKD " + string3}, false);
                bl2 = fTPClient.makeDirectory(string3);
                this.notifyProtocolListeners(fTPClient.getReplyStrings(), true);
                if (!bl2) {
                    throw new ClientException("Cannot make directory");
                }
                if (n != -1 && !(bl4 = this.chmod(this.getClient(), string, n))) {
                    log.error((Object)("Cannot chmod " + n + " on " + string));
                }
                this.notifyProtocolListeners(new String[]{"CWD " + string3}, false);
                bl3 = fTPClient.changeWorkingDirectory(string3);
                this.notifyProtocolListeners(fTPClient.getReplyStrings(), true);
                if (bl3) continue;
                throw new ClientException("Cannot change directory");
            }
            return bl2;
        } else {
            boolean bl5;
            if (n != -1 && !(bl5 = this.chmod(this.getClient(), string, n))) {
                log.error((Object)("Cannot chmod " + n + " on " + string));
            }
            this.notifyProtocolListeners(new String[]{"CWD " + string}, false);
            bl3 = fTPClient.changeWorkingDirectory(string);
            this.notifyProtocolListeners(fTPClient.getReplyStrings(), true);
            if (bl3) return bl2;
            throw new ClientException("Cannot change directory");
        }
    }

    protected boolean chmod(FTPClient fTPClient, String string, int n) throws IOException {
        boolean bl = false;
        if (string != null && fTPClient != null) {
            String string2 = "chmod " + n + " " + string;
            log.debug((Object)("Running: " + string2));
            this.notifyProtocolListeners(new String[]{"SITE QUOTE " + string2}, false);
            bl = fTPClient.sendSiteCommand(string2);
            this.notifyProtocolListeners(fTPClient.getReplyStrings(), true);
        }
        return bl;
    }

    protected void notifyProtocolListeners(String[] stringArray, boolean bl) {
    }

    protected void notifyProtocolCommandListeners(String[] stringArray, boolean bl) {
        if (stringArray != null && stringArray.length > 0) {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                string = stringArray[i];
                if (string == null) continue;
                if (!string.endsWith("\n")) {
                    string = string + "\n";
                }
                stringBuffer.append(string);
            }
            Iterator iterator = this.getProtocolListeners().iterator();
            while (iterator.hasNext()) {
                string = (ProtocolListener)iterator.next();
                if (bl) {
                    string.responseReceived((Object)stringBuffer.toString());
                    continue;
                }
                string.requestSent((Object)stringBuffer.toString());
            }
        }
    }

    protected void runCommandMonitor(HashMap hashMap) {
        long l = this.getLong((String)hashMap.get(COMMANDMONITOR));
        if (l > 0L) {
            this.commandMonitor = new CommandMonitor(this, l * 1000L, (String)hashMap.get(FTPCOMMANDMONITOR));
            this.commandMonitor.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeCommandMonitor(Exception exception) {
        if (this.commandMonitor != null) {
            this.commandMonitor.abort();
            if (exception != null && exception instanceof MalformedServerReplyException) {
                try {
                    log.info((Object)("Completing from COMMANDMONITOR transfer error: " + this.commandMonitor.getErrorQueueSize()));
                    this.client.completePendingCommand();
                }
                catch (IOException iOException) {
                    log.error((Object)iOException);
                    this.commandMonitor.addError();
                }
            }
            int n = 10;
            while (this.commandMonitor.getQueueSize() > 0) {
                try {
                    log.info((Object)("Waiting for COMMANDMONITOR threads: " + this.commandMonitor.getQueueSize()));
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    log.error((Object)interruptedException);
                }
                finally {
                    if (--n >= 0) continue;
                    log.info((Object)("Abort waiting for COMMANDMONITOR threads: " + this.commandMonitor.getQueueSize()));
                    break;
                }
            }
            n = 10;
            while (this.commandMonitor.getErrorQueueSize() > 0) {
                try {
                    log.info((Object)("Completing from COMMANDMONITOR error: " + this.commandMonitor.getErrorQueueSize()));
                    Thread.sleep(100L);
                    this.client.completePendingCommand();
                    this.commandMonitor.removeError();
                }
                catch (InterruptedException interruptedException) {
                    log.error((Object)interruptedException);
                }
                catch (IOException iOException) {
                    log.error((Object)iOException);
                    this.commandMonitor.addError();
                }
                finally {
                    if (--n >= 0) continue;
                    log.info((Object)("Abort completing for COMMANDMONITOR error: " + this.commandMonitor.getErrorQueueSize()));
                    break;
                }
            }
        }
    }

    public String normalizePath(String string) {
        String string2 = string;
        if (string2 != null) {
            string2 = string2.replaceAll("///", "/");
            string2 = string2.replaceAll("//", "/");
        }
        return string2;
    }

    public abstract void begin();

    public abstract void cancel();

    public abstract Object execute() throws ClientException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

