/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.transfer.client.ftp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import jfileupload.transfer.client.core.ClientException;
import jfileupload.transfer.client.core.TransferListener;
import jfileupload.transfer.client.core.TriggeredInputStream;
import jfileupload.transfer.client.ftp.FTPTransfer;
import jfileupload.transfer.client.util.Conf;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.MalformedServerReplyException;
import org.apache.commons.net.ftp.FTPFile;

public class FTPUploadTransfer
extends FTPTransfer
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)(class$jfileupload$transfer$client$ftp$FTPUploadTransfer == null ? (class$jfileupload$transfer$client$ftp$FTPUploadTransfer = FTPUploadTransfer.class$("jfileupload.transfer.client.ftp.FTPUploadTransfer")) : class$jfileupload$transfer$client$ftp$FTPUploadTransfer));
    public static String RELATIVEFILENAME = "relativefilename";
    public static String NOTIFYRELATIVEFILENAME = "notifyrelativefilename";
    public static String SELECTEDFULLFILENAME = "selectedfullfilename";
    public static String DELETEONFAIL = "deleteonfail";
    public static String CHMODAFTERUPLOAD = "chmodafterupload";
    public static String DELETEAFTERUPLOAD = "deleteafterupload";
    public static String RESUMECOMMAND = "resumecommand";
    public static String LISTCOMMAND = "listcommand";
    private boolean cancelled = false;
    private TriggeredInputStream tin = null;
    private ArrayList uploadedfiles = null;
    private File zip = null;
    private File processed = null;
    private String sfullfilename = null;
    private String rfilename = null;
    static /* synthetic */ Class class$jfileupload$transfer$client$ftp$FTPUploadTransfer;

    public void init() throws ClientException {
        super.init();
        this.setStatus(0);
    }

    public void begin() {
        this.setStatus(0);
        if (this.isThreaded()) {
            Thread thread = new Thread((Runnable)this, "FTPUPLOAD");
            thread.start();
        } else {
            log.info((Object)"Not threaded");
            this.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        Object object2;
        this.setStatus(1);
        this.cancelled = false;
        Iterator iterator = null;
        ArrayList arrayList = null;
        this.uploadedfiles = new ArrayList();
        try {
            arrayList = this.getAllowedSourceFiles();
            iterator = this.getTransferListeners().iterator();
            while (iterator.hasNext()) {
                object2 = (TransferListener)iterator.next();
                object2.transferTriggered((List)arrayList, 1);
            }
        }
        catch (ClientException clientException) {
            log.debug((Object)clientException);
            iterator = this.getTransferListeners().iterator();
            while (iterator.hasNext()) {
                object = (TransferListener)iterator.next();
                object.transferFailed(clientException);
            }
            log.info((Object)"Upload failed - Files requirements");
        }
        if (!this.cancelled && arrayList != null && arrayList.size() > 0) {
            this.zip = null;
            this.processed = null;
            try {
                object2 = (List)this.executeFilter(this.getSource(), "preprocessing");
                if (object2 != null) {
                    this.getSource().clear();
                    this.getSource().addAll(object2);
                }
                this.FTPConnect(this.getParameters(null));
                iterator = this.getSource().iterator();
                while (iterator.hasNext() && !this.cancelled) {
                    object = new File((String)iterator.next());
                    String string = ((File)object).getAbsolutePath().substring(0, ((File)object).getAbsolutePath().length() - ((File)object).getName().length());
                    this.setRootDir(string);
                    if (((File)object).isDirectory()) {
                        if (this.getZipFolder() != null && this.getZipFolder().equalsIgnoreCase("true")) {
                            this.process((File)object);
                            continue;
                        }
                        this.recurseProcess((File)object, 0L, this.getMaxDepth());
                        continue;
                    }
                    this.process((File)object);
                }
                iterator = this.getTransferListeners().iterator();
                while (iterator.hasNext()) {
                    object = (TransferListener)iterator.next();
                    object.transferDone((List)this.uploadedfiles);
                }
            }
            catch (ClientException clientException) {
                if (!this.cancelled) {
                    iterator = this.getTransferListeners().iterator();
                    while (iterator.hasNext()) {
                        object = (TransferListener)iterator.next();
                        if (clientException instanceof ClientException) {
                            object.transferFailed(clientException);
                            continue;
                        }
                        object.transferFailed(new ClientException((Throwable)clientException));
                    }
                    log.info((Object)"Upload failed");
                }
            }
            finally {
                try {
                    if (this.tin != null) {
                        this.tin.close();
                    }
                }
                catch (IOException iOException) {
                    log.error((Object)iOException);
                }
                this.deleteTmpZip();
                if (this.processed != null) {
                    this.cleanFilter();
                }
                this.FTPDisconnect(this.getParameters(null));
                this.cleanFilter("preprocessing");
            }
        }
        this.setStatus(2);
    }

    protected void process(File file) throws ClientException {
        String string;
        if (!this.isAllowed(file)) {
            return;
        }
        this.sfullfilename = file.getAbsolutePath();
        List list = this.getFilterIDs();
        if (list != null && list.size() > 0) {
            string = this.getFilterChain();
            boolean bl = false;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                this.processed = (File)this.executeFilter(file, string2);
                if (this.processed != null) {
                    this.processFile(this.processed);
                    if (string != null && string.equalsIgnoreCase("series")) {
                        file = this.processed;
                        continue;
                    }
                    this.cleanFilter(string2);
                    this.processed = null;
                    continue;
                }
                if (bl) continue;
                this.processFile(file);
                bl = true;
            }
        } else {
            this.processFile(file);
        }
        if (!Conf.SAFE && (string = (String)this.getParameters(null).get(DELETEAFTERUPLOAD)) != null && string.equalsIgnoreCase("true")) {
            file.delete();
        }
        this.rfilename = null;
        this.sfullfilename = null;
    }

    private void processFile(File file) throws ClientException {
        if (this.getZipOnFly() != null && !this.getZipOnFly().equalsIgnoreCase("false")) {
            this.zip = this.compress(file, this.getZipOnFly());
            if (this.zip != null) {
                if (!this.checkZipMaxSize(this.zip)) {
                    this.deleteTmpZip();
                    return;
                }
                file = this.zip;
            }
        }
        this.transferAndRetry(file, this.getParameters(null));
        this.deleteTmpZip();
    }

    private void deleteTmpZip() {
        if (this.zip != null) {
            log.debug((Object)("Deleting : " + this.zip.getAbsolutePath()));
            this.zip.delete();
            this.zip = null;
        }
    }

    private void recurseProcess(File file, long l, long l2) throws ClientException {
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    if (l2 > -1L) {
                        if (l + 1L > l2) continue;
                        this.recurseProcess(file2, l + 1L, l2);
                        continue;
                    }
                    this.recurseProcess(file2, l + 1L, l2);
                    continue;
                }
                this.process(file2);
            }
        }
    }

    protected void transferAndRetry(File file, HashMap hashMap) throws ClientException {
        if (this.getRetry() > 0) {
            int n = 0;
            boolean bl = false;
            while (!bl && n <= this.getRetry()) {
                try {
                    this.transfer(file, hashMap);
                    bl = true;
                }
                catch (ClientException clientException) {
                    if (this.cancelled || ++n > this.getRetry()) {
                        throw clientException;
                    }
                    log.info((Object)("Attempt " + n + "/" + this.getRetry()));
                    boolean bl2 = false;
                    while (!bl2) {
                        if (this.cancelled || n > this.getRetry()) {
                            throw clientException;
                        }
                        try {
                            if (this.getRetryDelay() > 0) {
                                Thread.sleep(this.getRetryDelay() * 1000);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            log.error((Object)interruptedException);
                        }
                        try {
                            this.FTPDisconnect(hashMap, true);
                            this.FTPConnect(hashMap);
                            bl2 = true;
                        }
                        catch (ClientException clientException2) {
                            log.error((Object)clientException2);
                            log.info((Object)("Cannot disconnect and reconnect " + n + "/" + this.getRetry()));
                            ++n;
                        }
                    }
                }
            }
        } else {
            this.transfer(file, hashMap);
        }
    }

    protected void transfer(File file, HashMap hashMap) throws ClientException {
        String string;
        String string2;
        Object object;
        Iterator iterator = null;
        iterator = this.getTransferListeners().iterator();
        while (iterator.hasNext()) {
            object = (TransferListener)iterator.next();
            object.transferStarted((Object)file, file.length());
        }
        log.info((Object)("Upload started : " + file.getAbsolutePath()));
        object = null;
        try {
            int n;
            boolean bl;
            Object object2;
            int n2;
            String string3;
            String string4;
            boolean bl2 = false;
            int n3 = 2;
            String string5 = "TYPE I";
            string2 = (String)hashMap.get(TRANSFERTYPE);
            if (string2 != null && string2.equalsIgnoreCase("ascii")) {
                n3 = 0;
                string5 = "TYPE A";
            }
            this.notifyProtocolListeners(new String[]{string5}, false);
            bl2 = this.getClient().setFileType(n3);
            this.notifyProtocolListeners(this.getClient().getReplyStrings(), true);
            String string6 = (String)hashMap.get(RELATIVEFILENAME);
            if (string6 != null && string6.equalsIgnoreCase("true")) {
                string4 = (String)hashMap.get(ACCOUNT);
                string4 = string4 != null && !string4.equals("") && !string4.equals("/") ? "/" + string4 : "/";
                string3 = this.normalizePath(this.wd + string4);
                this.notifyProtocolListeners(new String[]{"CWD " + string3}, false);
                boolean bl3 = this.getClient().changeWorkingDirectory(string3);
                this.notifyProtocolListeners(this.getClient().getReplyStrings(), true);
                if (!bl3) {
                    throw new ClientException("Cannot change directory");
                }
                String string7 = this.getRootDir();
                if (string7 != null && !string7.equals("")) {
                    String string8;
                    this.rfilename = string8 = this.getRelativeFilename(file, file.getName());
                    int n4 = string8.length();
                    if (n4 > (n2 = file.getName().length())) {
                        object2 = string8.substring(0, n4 - n2 - 1);
                        object2 = ((String)object2).replace(File.separatorChar, '/');
                        if (this.targetURL != null && this.targetURL.toLowerCase().startsWith("scp://")) {
                            object2 = this.wd + string4 + "/" + (String)object2;
                        }
                        object2 = this.normalizePath((String)object2);
                        this.notifyProtocolListeners(new String[]{"CWD " + (String)object2}, false);
                        bl3 = this.getClient().changeWorkingDirectory((String)object2);
                        this.notifyProtocolListeners(this.getClient().getReplyStrings(), true);
                        if (!bl3) {
                            bl = this.makeAndChangeDirectory(this.getClient(), (String)object2, true, null);
                        }
                    }
                }
            }
            string4 = file.getName();
            if (this.getTemplate() != null) {
                string4 = this.rename(string4, this.getTemplate(), 0);
                string3 = (String)hashMap.get(NOTIFYRELATIVEFILENAME);
                if (string3 != null && string3.equalsIgnoreCase("full")) {
                    this.rfilename = this.getRelativeFilename(file, string4);
                }
            }
            object = string4;
            long l = -1L;
            long l2 = -1L;
            String string9 = null;
            if (this.getResume() != null && !this.getResume().equalsIgnoreCase("false")) {
                this.notifyProtocolListeners(new String[]{"LIST " + (String)object}, false);
                FTPFile[] fTPFileArray = this.getClient().listFiles((String)object);
                this.notifyProtocolListeners(this.getClient().getReplyStrings(), true);
                if (fTPFileArray != null && fTPFileArray.length > 0) {
                    l2 = fTPFileArray[0].getSize();
                    if (l2 < file.length()) {
                        l = l2;
                        string9 = (String)hashMap.get(RESUMECOMMAND);
                    }
                } else {
                    l2 = -404L;
                }
            }
            if (this.getOverwrite() != null && !this.getOverwrite().equalsIgnoreCase("true") && l == -1L && l2 != -404L) {
                n2 = 1;
                while (true) {
                    object2 = null;
                    if (l2 < 0L) {
                        String string10 = (String)hashMap.get(LISTCOMMAND);
                        if (string10 != null && string10.equalsIgnoreCase("list")) {
                            this.notifyProtocolListeners(new String[]{"LIST " + (String)object}, false);
                            object2 = this.getClient().listFiles((String)object);
                        } else {
                            this.notifyProtocolListeners(new String[]{"NLST " + (String)object}, false);
                            object2 = this.getClient().listNames((String)object);
                        }
                        this.notifyProtocolListeners(this.getClient().getReplyStrings(), true);
                    }
                    if ((object2 == null || (object2).length <= 0) && l2 < 0L) break;
                    object = this.rename(string4, this.getTemplate(), n2);
                    if (object == null) {
                        return;
                    }
                    ++n2;
                    l2 = -1L;
                }
            }
            this.runCommandMonitor(hashMap);
            if (string2 != null) {
                this.notifyProtocolListeners(new String[]{string5}, false);
                this.getClient().setFileType(n3);
                this.notifyProtocolListeners(this.getClient().getReplyStrings(), true);
            }
            this.tin = this.getRawConf().getTriggeredInputStream((InputStream)new FileInputStream(file), this.getTransferListeners());
            if (l > 0L && l < file.length()) {
                this.tin.skip(l);
                this.notifyProtocolListeners(new String[]{"REST " + l}, false);
                this.getClient().rest(String.valueOf(l));
                this.notifyProtocolListeners(this.getClient().getReplyStrings(), true);
            }
            super.setResumeOffset(l);
            if (string9 != null && string9.equalsIgnoreCase("append")) {
                this.notifyProtocolListeners(new String[]{"APPE " + (String)object}, false);
                bl2 = this.getClient().appendFile((String)object, (InputStream)this.tin);
            } else {
                this.notifyProtocolListeners(new String[]{"STOR " + (String)object}, false);
                bl2 = this.getClient().storeFile((String)object, (InputStream)this.tin);
            }
            this.tin.close();
            this.tin = null;
            this.closeCommandMonitor(null);
            log.debug((Object)this.getClient().getReplyString());
            this.notifyProtocolListeners(this.getClient().getReplyStrings(), true);
            if (this.cancelled) {
                throw new IOException();
            }
            if (!bl2 && !this.cancelled) {
                this.tin = this.getRawConf().getTriggeredInputStream((InputStream)new FileInputStream(file), this.getTransferListeners());
                object = file.getName() + "." + System.currentTimeMillis();
                this.notifyProtocolListeners(new String[]{"STOR " + (String)object}, false);
                bl2 = this.getClient().storeFile((String)object, (InputStream)this.tin);
                this.tin.close();
                this.tin = null;
                this.closeCommandMonitor(null);
                log.debug((Object)this.getClient().getReplyString());
                this.notifyProtocolListeners(this.getClient().getReplyStrings(), true);
            }
            if (!bl2) {
                throw new ClientException("Transfer failed");
            }
            String string11 = (String)hashMap.get(CHMODAFTERUPLOAD);
            if (string11 != null && string11.length() > 0 && (n = (int)super.getLong(string11)) != -1 && !(bl = super.chmod(this.getClient(), (String)object, n))) {
                log.error((Object)("Cannot chmod " + n + " on " + (String)object));
            }
        }
        catch (IOException iOException) {
            String string12;
            log.error((Object)iOException);
            this.closeCommandMonitor(iOException);
            if (this.cancelled) {
                try {
                    this.getClient().completePendingCommand();
                    this.notifyProtocolListeners(new String[]{"ABOR"}, false);
                    this.getClient().abort();
                    this.notifyProtocolListeners(this.getClient().getReplyStrings(), true);
                }
                catch (IOException iOException2) {
                    log.debug((Object)iOException2);
                }
            }
            if ((string12 = (String)hashMap.get(DELETEONFAIL)) != null && string12.equalsIgnoreCase("true") && !(iOException instanceof MalformedServerReplyException)) {
                try {
                    boolean bl = false;
                    this.notifyProtocolListeners(new String[]{"NOOP"}, false);
                    this.getClient().noop();
                    this.notifyProtocolListeners(this.getClient().getReplyStrings(), true);
                    if (object != null) {
                        this.notifyProtocolListeners(new String[]{"DELE " + (String)object}, false);
                        bl = this.getClient().deleteFile((String)object);
                        this.notifyProtocolListeners(this.getClient().getReplyStrings(), true);
                    }
                    log.info((Object)("Deleting : " + (String)object + " : " + bl));
                }
                catch (IOException iOException3) {
                    log.error((Object)iOException3);
                }
            }
            if (this.cancelled) {
                Iterator iterator2 = this.getTransferListeners().iterator();
                while (iterator2.hasNext()) {
                    string2 = (TransferListener)iterator2.next();
                    string2.transferCancelled();
                }
                log.info((Object)"Upload Cancelled");
            }
            if (this.commandMonitor == null || !(iOException instanceof MalformedServerReplyException)) {
                throw new ClientException((Throwable)iOException);
            }
        }
        catch (Throwable throwable) {
            log.error((Object)throwable);
            throw new ClientException(throwable.getMessage());
        }
        String string13 = (String)hashMap.get(SELECTEDFULLFILENAME);
        if (string13 != null && (string13.equalsIgnoreCase("true") || string13.equalsIgnoreCase("initial"))) {
            log.debug((Object)("selectedfullfilename : " + string13));
            if (string13.equalsIgnoreCase("initial") && this.sfullfilename != null) {
                file = new File(this.sfullfilename);
            }
        } else {
            file = file.getParent().endsWith(File.separator) ? new File(file.getParent() + (String)object) : new File(file.getParent() + File.separator + (String)object);
        }
        if ((string = (String)hashMap.get(NOTIFYRELATIVEFILENAME)) != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("full"))) {
            log.debug((Object)("notifyrelativefilename : " + this.rfilename));
            if (this.rfilename != null) {
                this.uploadedfiles.add(new File(this.rfilename));
            }
        } else if (file != null) {
            this.uploadedfiles.add(file);
        }
        if (string13 != null && string13.equalsIgnoreCase("oncompleted") && this.sfullfilename != null) {
            file = new File(this.sfullfilename);
        }
        iterator = this.getTransferListeners().iterator();
        while (iterator.hasNext()) {
            TransferListener transferListener = (TransferListener)iterator.next();
            transferListener.transferCompleted((Object)file, null);
        }
        log.info((Object)"Upload completed");
    }

    protected String getRelativeFilename(File file, String string) {
        String string2 = file.getAbsolutePath().substring(this.getRootDir().length(), file.getAbsolutePath().length());
        int n = string2.lastIndexOf(File.separator);
        if (n > -1) {
            File file2;
            string2 = string2.substring(0, n + 1);
            if (this.getTemplate() != null && this.getTemplateScope() != null && this.getTemplateScope().equalsIgnoreCase("path") && (file2 = file.getParentFile()) != null) {
                File file3 = new File(this.getRootDir());
                String string3 = "";
                while (file2 != null && !file2.getAbsolutePath().equals(file3.getAbsolutePath())) {
                    string3 = this.rename(file2.getName(), this.getTemplate(), 0) + File.separator + string3;
                    file2 = file2.getParentFile();
                }
                string2 = string3;
            }
            string2 = string2 + string;
        } else {
            string2 = string;
        }
        return string2;
    }

    public void cancel() {
        this.cancelled = true;
        try {
            if (this.tin != null) {
                if (this.getClient().getClass().getName().equalsIgnoreCase(SFTPCLIENT)) {
                    this.getClient().abort();
                } else if (this.getClient().getClass().getName().equalsIgnoreCase(SCPCLIENT)) {
                    this.getClient().abort();
                }
                this.tin.close();
            }
        }
        catch (IOException iOException) {
            log.debug((Object)iOException);
        }
    }

    public Object execute() throws ClientException {
        throw new ClientException("Not implemented");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

