/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.transfer.client.ftp;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import jfileupload.transfer.client.ftp.CustomFTPFileEntryParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;

public class FtpClientFactory {
    private static final Log log = LogFactory.getLog((Class)(class$jfileupload$transfer$client$ftp$FtpClientFactory == null ? (class$jfileupload$transfer$client$ftp$FtpClientFactory = FtpClientFactory.class$("jfileupload.transfer.client.ftp.FtpClientFactory")) : class$jfileupload$transfer$client$ftp$FtpClientFactory));
    public static final String SSLCONNECTMODE = "SSL_CONNECT";
    public static final String AUTHSSLMODE = "AUTH_SSL";
    public static final String AUTHTLSMODE = "AUTH_TLS";
    public static final String PROTP = "PROT_P";
    public static final String PROTC = "PROT_C";
    public static final String PBSZ = "PBSZ 0";
    private static FtpClientFactory instance = null;
    private int concurrency = -1;
    private FTPClient ftpclient = null;
    private FTPSClient ftpsclient = null;
    private FTPClient sftpclient = null;
    private Map clientPool = new HashMap();
    private FTPFileEntryParserFactory parserFactory = new CustomFTPFileEntryParserFactory();
    static /* synthetic */ Class class$jfileupload$transfer$client$ftp$FtpClientFactory;

    private FtpClientFactory() {
    }

    public static synchronized FtpClientFactory getInstance() {
        if (instance == null) {
            instance = new FtpClientFactory();
        }
        return instance;
    }

    public FTPClient getClient() {
        if (this.concurrency > 0) {
            if (this.ftpclient == null) {
                this.ftpclient = new FTPClient();
                if (this.parserFactory != null) {
                    this.ftpclient.setParserFactory(this.parserFactory);
                }
                this.addToPool(this.ftpclient);
            }
            return this.ftpclient;
        }
        FTPClient fTPClient = new FTPClient();
        if (this.parserFactory != null) {
            fTPClient.setParserFactory(this.parserFactory);
        }
        this.addToPool(fTPClient);
        return fTPClient;
    }

    public FTPClient getClient(String string) {
        if (this.concurrency > 0) {
            if (this.sftpclient == null) {
                this.sftpclient = this.getFTPClientInstance(string);
                this.addToPool(this.sftpclient);
            }
            return this.sftpclient;
        }
        FTPClient fTPClient = this.getFTPClientInstance(string);
        this.addToPool(fTPClient);
        return fTPClient;
    }

    public FTPSClient getClient(String string, String string2) {
        String string3 = "TLS";
        boolean bl = false;
        if (string != null) {
            if (string.equalsIgnoreCase(AUTHTLSMODE)) {
                string3 = "TLS";
                bl = false;
            } else if (string.equalsIgnoreCase(AUTHSSLMODE)) {
                string3 = "SSL";
                bl = false;
            } else if (string.equalsIgnoreCase(SSLCONNECTMODE)) {
                string3 = "SSL";
                bl = true;
            }
        }
        X509KeyManager x509KeyManager = new X509KeyManager(){

            public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
                return null;
            }

            public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
                return null;
            }

            public X509Certificate[] getCertificateChain(String string) {
                return null;
            }

            public String[] getClientAliases(String string, Principal[] principalArray) {
                return null;
            }

            public PrivateKey getPrivateKey(String string) {
                return null;
            }

            public String[] getServerAliases(String string, Principal[] principalArray) {
                return null;
            }
        };
        X509TrustManager x509TrustManager = new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        if (this.concurrency > 0) {
            if (this.ftpsclient == null) {
                try {
                    this.ftpsclient = new FTPSClient(string3, bl);
                    if (this.parserFactory != null) {
                        this.ftpsclient.setParserFactory(this.parserFactory);
                    }
                    this.ftpsclient.setKeyManager((KeyManager)x509KeyManager);
                    this.ftpsclient.setTrustManager((TrustManager)x509TrustManager);
                    this.addToPool((FTPClient)this.ftpsclient);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    log.error((Object)noSuchAlgorithmException);
                }
            }
            return this.ftpsclient;
        }
        FTPSClient fTPSClient = null;
        try {
            fTPSClient = new FTPSClient(string3, bl);
            if (this.parserFactory != null) {
                fTPSClient.setParserFactory(this.parserFactory);
            }
            fTPSClient.setKeyManager((KeyManager)x509KeyManager);
            fTPSClient.setTrustManager((TrustManager)x509TrustManager);
            this.addToPool((FTPClient)fTPSClient);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            log.error((Object)noSuchAlgorithmException);
        }
        return fTPSClient;
    }

    private void addToPool(FTPClient fTPClient) {
        this.clientPool.put(fTPClient, Boolean.FALSE);
    }

    public boolean isSessionOpened(FTPClient fTPClient) {
        boolean bl = false;
        Boolean bl2 = (Boolean)this.clientPool.get(fTPClient);
        if (bl2 != null) {
            bl = bl2;
        }
        return bl;
    }

    public void setSessionOpened(FTPClient fTPClient, boolean bl) {
        Boolean bl2 = new Boolean(bl);
        this.clientPool.put(fTPClient, bl2);
    }

    public void closeSessions() {
        Iterator iterator = this.clientPool.keySet().iterator();
        while (iterator.hasNext()) {
            FTPClient fTPClient = (FTPClient)iterator.next();
            Boolean bl = (Boolean)this.clientPool.get(fTPClient);
            if (bl == null || !bl.booleanValue()) continue;
            try {
                fTPClient.disconnect();
            }
            catch (IOException iOException) {}
        }
    }

    public void reset() {
        this.clientPool.clear();
        this.ftpclient = null;
        this.ftpsclient = null;
        this.sftpclient = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setConcurrency(String string) {
        int n = this.concurrency;
        if (string == null || string.equals("")) return;
        try {
            this.concurrency = Integer.parseInt(string);
            log.info((Object)("Ftp simultaneous connections = " + this.concurrency));
            if (this.concurrency > 0 && this.concurrency == n) return;
        }
        catch (NumberFormatException numberFormatException) {
            log.info((Object)("Cannot parse concurrency" + numberFormatException.getMessage()));
        }
    }

    private FTPClient getFTPClientInstance(String string) {
        FTPClient fTPClient = null;
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                Class[] classArray = new Class[]{};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                fTPClient = (FTPClient)constructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                log.error((Object)exception);
            }
        }
        return fTPClient;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

