/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.transfer.client.core;

import java.awt.Container;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jfileupload.transfer.client.core.ChecksumListener;
import jfileupload.transfer.client.core.ClientException;
import jfileupload.transfer.client.core.CompressListener;
import jfileupload.transfer.client.core.FilterListener;
import jfileupload.transfer.client.core.ProtocolListener;
import jfileupload.transfer.client.core.SplitListener;
import jfileupload.transfer.client.core.TransferController;
import jfileupload.transfer.client.core.TransferFileFilter;
import jfileupload.transfer.client.core.TransferFilter;
import jfileupload.transfer.client.core.TransferListener;
import jfileupload.transfer.client.mdesign.AuthenticationModel;
import jfileupload.transfer.client.mdesign.AuthenticationPane;
import jfileupload.transfer.client.util.Conf;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractTransferController
implements TransferController {
    private static final Log log = LogFactory.getLog((Class)(class$jfileupload$transfer$client$core$AbstractTransferController == null ? (class$jfileupload$transfer$client$core$AbstractTransferController = AbstractTransferController.class$("jfileupload.transfer.client.core.AbstractTransferController")) : class$jfileupload$transfer$client$core$AbstractTransferController));
    public static int BUFFERSIZE = 4096;
    public static String ZIPEXTENSION = "zip";
    public static String GZIPEXTENSION = "gz";
    private ArrayList slisteners = null;
    private ArrayList tlisteners = null;
    private ArrayList clisteners = null;
    private ArrayList flisteners = null;
    private ArrayList plisteners = null;
    private ArrayList cslisteners = null;
    private List source = null;
    private List target = null;
    private Object ext = null;
    private String tmpDir = null;
    private long maxsize = -1L;
    private long fullmaxsize = -1L;
    private long minsize = -1L;
    private long maxfiles = -1L;
    private long maxdepth = -1L;
    private long chunksize = -1L;
    private long timeout = -1L;
    private int retrycount = 0;
    private int retrydelay = 2;
    private String whitelist = null;
    private String blacklist = null;
    private String zipignorelist = null;
    private String zipfolder = null;
    private long zipmaxsize = -1L;
    private String template = null;
    private String templateScope = null;
    private String overwrite = null;
    private String resume = null;
    private long resumeOffset = -1L;
    private String authentication = null;
    private String policy = null;
    private HashMap parameters = null;
    private HashMap metaProperties = null;
    private String metaScope = null;
    private String encoding = "ISO-8859-1";
    private String paramFile = "uploadfile";
    private String rootdir = null;
    private String hidden = null;
    private String ziponfly = null;
    private String username = null;
    private String password = null;
    private URL serverurl = null;
    private String preprocessingfilterimpl = null;
    private TransferFilter preprocessingfilter = null;
    private List filterIDs = new ArrayList();
    private HashMap filterimpl = new HashMap();
    private HashMap filter = new HashMap();
    private String filterchain = null;
    private Conf rawconf = null;
    private TransferFileFilter tff = null;
    private TransferFileFilter zipff = null;
    private Container parentContainer = null;
    private boolean threaded = true;
    private int status = 0;
    static /* synthetic */ Class class$jfileupload$transfer$client$core$AbstractTransferController;
    static /* synthetic */ Class class$jfileupload$transfer$client$util$Conf;

    public AbstractTransferController() {
        this.tlisteners = new ArrayList();
        this.slisteners = new ArrayList();
        this.clisteners = new ArrayList();
        this.flisteners = new ArrayList();
        this.plisteners = new ArrayList();
        this.cslisteners = new ArrayList();
    }

    public void init() throws ClientException {
        int n;
        boolean bl = false;
        String string = this.rawconf.getResource("filechooser.dialog.selectionmode");
        if (string != null && string.equalsIgnoreCase("writabledirectoriesonly")) {
            bl = true;
        }
        this.tff = new TransferFileFilter(this.blacklist, this.whitelist, this.maxsize, this.minsize, this.hidden, bl);
        if (this.zipignorelist != null && this.zipignorelist.length() > 0) {
            this.zipff = new TransferFileFilter(this.zipignorelist, null, this.maxsize, this.minsize, this.hidden, bl);
        }
        if ((n = (int)this.rawconf.getLong(this.rawconf.getProperty("buffersize"))) > 0) {
            BUFFERSIZE = n;
            log.debug((Object)("buffersize=" + BUFFERSIZE));
        }
        try {
            this.preprocessingfilter = this.getFilterInstance(this.preprocessingfilterimpl);
            if (this.preprocessingfilter != null) {
                log.info((Object)("Filter[preprocessing] instantiated: " + this.preprocessingfilterimpl));
                this.preprocessingfilter.init(this, "preprocessing");
            }
        }
        catch (Exception exception) {
            log.error((Object)exception);
        }
        Iterator iterator = this.filterIDs.iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String string2;
            String string3 = (String)iterator.next();
            if ("preprocessing".equalsIgnoreCase(string3)) {
                log.error((Object)("Reserved filter identifier: " + string3));
                continue;
            }
            if (this.filter.get(string3) != null || (string2 = (String)this.filterimpl.get(string3)) == null) continue;
            TransferFilter transferFilter = null;
            try {
                transferFilter = this.getFilterInstance(string2);
                if (transferFilter != null) {
                    this.filter.put(string3, transferFilter);
                }
            }
            catch (Exception exception) {
                log.error((Object)exception);
                arrayList.add(string3);
            }
            if (transferFilter == null) continue;
            log.info((Object)("Filter[" + string3 + "] instantiated: " + string2));
            transferFilter.init(this, string3);
        }
        this.filterIDs.removeAll(arrayList);
    }

    private TransferFilter getFilterInstance(String string) throws Exception {
        TransferFilter transferFilter = null;
        if (string != null) {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{class$jfileupload$transfer$client$util$Conf == null ? (class$jfileupload$transfer$client$util$Conf = AbstractTransferController.class$("jfileupload.transfer.client.util.Conf")) : class$jfileupload$transfer$client$util$Conf};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this.rawconf};
            transferFilter = (TransferFilter)constructor.newInstance(objectArray);
        }
        return transferFilter;
    }

    public abstract Object execute() throws ClientException;

    public abstract void begin();

    public abstract void cancel();

    protected ArrayList getAllowedSourceFiles() throws ClientException {
        Serializable serializable = new ArrayList<Serializable>();
        if (this.source != null && this.source.size() > 0) {
            Serializable serializable2;
            String string = this.rawconf.getResource("filechooser.dialog.selectionmode");
            Iterator iterator = this.source.iterator();
            while (iterator.hasNext()) {
                serializable2 = new File((String)iterator.next());
                if (((File)serializable2).isDirectory()) {
                    if (string != null && string.equalsIgnoreCase("filesonly")) {
                        throw new ClientException("directories not allowed", ((File)serializable2).getAbsolutePath());
                    }
                    this.recurse((File)serializable2, (ArrayList)serializable, 0L, this.maxdepth);
                    continue;
                }
                serializable.add(serializable2);
            }
            if (this.maxfiles >= 0L && (long)serializable.size() > this.maxfiles) {
                throw new ClientException("max files exceeded", String.valueOf(this.maxfiles));
            }
            serializable2 = new ArrayList();
            Iterator iterator2 = serializable.iterator();
            while (iterator2.hasNext()) {
                File file = (File)iterator2.next();
                boolean bl = this.isAllowed(file);
                if (!bl) continue;
                ((ArrayList)serializable2).add(file);
            }
            serializable = serializable2;
        }
        return serializable;
    }

    public boolean isAllowed(File file) throws ClientException {
        boolean bl = true;
        TransferFileFilter transferFileFilter = this.getTransferFileFilter();
        if (this.getPolicy() == null || this.getPolicy().equalsIgnoreCase("abort")) {
            if (!transferFileFilter.checkSize(file)) {
                throw new ClientException("max size exceeded", file.getAbsolutePath());
            }
            if (!transferFileFilter.checkMinSize(file)) {
                throw new ClientException("min size no reached", file.getAbsolutePath());
            }
            if (!transferFileFilter.checkWhitelist(file)) {
                throw new ClientException("extension not allowed", file.getAbsolutePath());
            }
            if (transferFileFilter.checkBlacklist(file)) {
                throw new ClientException("extension not allowed", file.getAbsolutePath());
            }
            if (!transferFileFilter.checkHidden(file)) {
                throw new ClientException("hidden file not allowed", file.getAbsolutePath());
            }
        } else {
            bl = transferFileFilter.checkSize(file) && transferFileFilter.checkMinSize(file) && transferFileFilter.checkWhitelist(file) && !transferFileFilter.checkBlacklist(file) && transferFileFilter.checkHidden(file);
        }
        return bl;
    }

    public boolean checkZipMaxSize(File file) throws ClientException {
        boolean bl = true;
        if (this.zipmaxsize > 0L && file.length() > this.zipmaxsize) {
            if (this.getPolicy() == null || this.getPolicy().equalsIgnoreCase("abort")) {
                throw new ClientException("compressed max size exceeded", file.getAbsolutePath());
            }
            bl = false;
        }
        return bl;
    }

    protected void recurse(File file, ArrayList arrayList, long l, long l2) {
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    if (l2 > -1L) {
                        if (l + 1L > l2) continue;
                        this.recurse(file2, arrayList, l + 1L, l2);
                        continue;
                    }
                    this.recurse(file2, arrayList, l + 1L, l2);
                    continue;
                }
                arrayList.add(file2);
            }
        }
    }

    protected long getChunks(File file) {
        if (this.chunksize > 0L && file.isFile()) {
            long l;
            long l2 = file.length();
            if (l2 - this.chunksize * (l = (l2 - l2 % this.chunksize) / this.chunksize) > 0L) {
                ++l;
            }
            return l;
        }
        return 1L;
    }

    protected long getLastChunkSize(File file) {
        if (this.chunksize > 0L && file.isFile()) {
            long l = file.length();
            long l2 = l % this.chunksize;
            return l2;
        }
        return 0L;
    }

    protected Object executeFilter(Object object) throws ClientException {
        return this.executeFilter(object, "");
    }

    protected Object executeFilter(Object object, String string) throws ClientException {
        Object object2 = null;
        if (string != null) {
            if (string.equals("preprocessing")) {
                if (this.preprocessingfilter != null) {
                    object2 = this.preprocessingfilter.execute(object);
                }
            } else {
                TransferFilter transferFilter = (TransferFilter)this.filter.get(string);
                if (transferFilter != null) {
                    object2 = transferFilter.execute(object);
                }
            }
        }
        return object2;
    }

    protected void cleanFilter(String string) {
        if (string != null) {
            if (string.equals("preprocessing")) {
                if (this.preprocessingfilter != null) {
                    this.preprocessingfilter.clean();
                }
            } else {
                TransferFilter transferFilter = (TransferFilter)this.filter.get(string);
                if (transferFilter != null) {
                    transferFilter.clean();
                }
            }
        }
    }

    protected void cleanFilter() {
        this.cleanFilter("");
    }

    protected File compress(File file) {
        return this.compress(file, "zip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File compress(File file, String string) {
        Object object;
        Object object2 = null;
        String string2 = ZIPEXTENSION;
        if (string != null && string.equalsIgnoreCase("gzip")) {
            string2 = GZIPEXTENSION;
        }
        if (file.isDirectory()) {
            object2 = this.compressFolder(file, new File(file.getAbsoluteFile() + "." + ZIPEXTENSION));
            return object2;
        }
        if (this.zipff != null && this.zipff.checkBlacklist(file.getName())) {
            return object2;
        }
        Iterator iterator = null;
        iterator = this.getCompressListeners().iterator();
        while (iterator.hasNext()) {
            object = (CompressListener)iterator.next();
            object.compressStarted(file, file.length());
        }
        object = null;
        String string3 = this.getTmpFolder();
        object = string3 != null ? new File(string3 + "/" + file.getName() + "." + string2) : new File(file.getAbsoluteFile() + "." + string2);
        if (!((File)object).exists()) {
            log.debug((Object)("Compressing : " + file.getAbsolutePath() + " (" + string2 + ")"));
            DeflaterOutputStream deflaterOutputStream = null;
            FileInputStream fileInputStream = null;
            byte[] byArray = new byte[BUFFERSIZE];
            try {
                fileInputStream = new FileInputStream(file);
                if (string2.equalsIgnoreCase(GZIPEXTENSION)) {
                    deflaterOutputStream = new GZIPOutputStream(new FileOutputStream((File)object));
                } else {
                    deflaterOutputStream = new ZipOutputStream(new FileOutputStream((File)object));
                    ((ZipOutputStream)deflaterOutputStream).putNextEntry(new ZipEntry(file.getName()));
                }
                int n = -1;
                while ((n = fileInputStream.read(byArray)) != -1) {
                    deflaterOutputStream.write(byArray, 0, n);
                    this.compressingNotification(n);
                }
                deflaterOutputStream.flush();
                if (string2.equalsIgnoreCase(ZIPEXTENSION)) {
                    ((ZipOutputStream)deflaterOutputStream).closeEntry();
                }
                deflaterOutputStream.close();
                deflaterOutputStream = null;
                fileInputStream.close();
                fileInputStream = null;
                object2 = object;
                iterator = this.getCompressListeners().iterator();
                while (iterator.hasNext()) {
                    CompressListener compressListener = (CompressListener)iterator.next();
                    compressListener.compressCompleted(object2, ((File)object2).length());
                }
            }
            catch (Exception exception) {
                log.info((Object)"Cannot create archive : ", (Throwable)exception);
                this.compressionFailedNotification(new ClientException(exception));
            }
            finally {
                if (deflaterOutputStream != null) {
                    try {
                        deflaterOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            log.debug((Object)"Compression completed");
        } else {
            log.info((Object)("Cannot compress : " + file.getAbsolutePath()));
            this.compressionFailedNotification(new ClientException("Cannot create archive"));
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File compressFolder(File file, File file2) {
        Object object;
        File file3 = null;
        if (file.isFile()) {
            return file3;
        }
        Iterator iterator = null;
        iterator = this.getCompressListeners().iterator();
        while (iterator.hasNext()) {
            object = (CompressListener)iterator.next();
            object.compressStarted(file, -1L);
        }
        if (!file2.exists()) {
            log.debug((Object)("Compressing folder : " + file.getAbsolutePath()));
            if (!file2.getParentFile().exists()) {
                file2.getParentFile().mkdirs();
            }
            object = null;
            try {
                byte[] byArray = new byte[BUFFERSIZE];
                object = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
                this.recursiveCompress((ZipOutputStream)object, file, file, byArray, 0L, this.getMaxDepth());
                file3 = file2;
                iterator = this.getCompressListeners().iterator();
                while (iterator.hasNext()) {
                    CompressListener compressListener = (CompressListener)iterator.next();
                    compressListener.compressCompleted(file3, -1L);
                }
            }
            catch (Exception exception) {
                log.info((Object)"Cannot create folder archive : ", (Throwable)exception);
                this.compressionFailedNotification(new ClientException(exception));
            }
            finally {
                try {
                    if (object != null) {
                        ((ZipOutputStream)object).close();
                    }
                }
                catch (IOException iOException) {}
            }
            log.debug((Object)"Folder compression completed");
        } else {
            log.info((Object)("Cannot compress folder : " + file.getAbsolutePath() + "to : " + file2.getAbsolutePath()));
            this.compressionFailedNotification(new ClientException("Cannot create archive"));
        }
        return file3;
    }

    protected void recursiveCompress(ZipOutputStream zipOutputStream, File file, File file2, byte[] byArray, long l, long l2) throws IOException {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            if (fileArray.length > 0) {
                for (int i = 0; i < fileArray.length; ++i) {
                    File file3 = fileArray[i];
                    if (file3.isFile()) {
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file3));
                        String string = file3.getAbsolutePath();
                        String string2 = file2.getAbsolutePath();
                        string = string.substring(string2.length() + 1);
                        string = file2.getName() + "/" + string;
                        string = string.replace('\\', '/');
                        ZipEntry zipEntry = new ZipEntry(string);
                        zipOutputStream.putNextEntry(zipEntry);
                        int n = -1;
                        while ((n = bufferedInputStream.read(byArray)) != -1) {
                            zipOutputStream.write(byArray, 0, n);
                        }
                        zipOutputStream.flush();
                        zipOutputStream.closeEntry();
                        bufferedInputStream.close();
                        bufferedInputStream = null;
                        continue;
                    }
                    if (l2 > -1L) {
                        if (l + 1L > l2) continue;
                        this.recursiveCompress(zipOutputStream, file3, file2, byArray, l + 1L, l2);
                        continue;
                    }
                    this.recursiveCompress(zipOutputStream, file3, file2, byArray, l + 1L, l2);
                }
            } else {
                String string = file.getAbsolutePath();
                String string3 = file2.getAbsolutePath();
                if (string.length() > string3.length()) {
                    string = string.substring(string3.length() + 1) + "/";
                    string = file2.getName() + "/" + string;
                } else {
                    string = file2.getName() + "/";
                }
                string = string.replace('\\', '/');
                ZipEntry zipEntry = new ZipEntry(string);
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.closeEntry();
            }
        }
    }

    protected void compressingNotification(int n) {
        Iterator iterator = this.getCompressListeners().iterator();
        while (iterator.hasNext()) {
            CompressListener compressListener = (CompressListener)iterator.next();
            compressListener.dataCompressed(n);
        }
    }

    protected void compressionFailedNotification(ClientException clientException) {
        Iterator iterator = this.getCompressListeners().iterator();
        while (iterator.hasNext()) {
            CompressListener compressListener = (CompressListener)iterator.next();
            compressListener.compressFailed(clientException);
        }
    }

    protected void checksumStartedNotification(String string) {
        Iterator iterator = this.getChecksumListeners().iterator();
        while (iterator.hasNext()) {
            ChecksumListener checksumListener = (ChecksumListener)iterator.next();
            checksumListener.checksumStarted(string);
        }
    }

    protected void checksumCompletedNotification(String string) {
        Iterator iterator = this.getChecksumListeners().iterator();
        while (iterator.hasNext()) {
            ChecksumListener checksumListener = (ChecksumListener)iterator.next();
            checksumListener.checksumCompleted(string);
        }
    }

    public String rename(String string, String string2, int n) {
        String string3 = null;
        String string4 = "";
        String string5 = "";
        String string6 = "";
        int n2 = string.lastIndexOf(".");
        if (n2 > 0) {
            string5 = string.substring(0, n2);
            string4 = string.substring(n2, string.length());
        } else {
            string5 = string;
        }
        int n3 = string.indexOf(".");
        string6 = n3 > 0 ? string.substring(0, n3) : string;
        if (n > 0) {
            if (this.getOverwrite().equalsIgnoreCase("false")) {
                Iterator iterator = this.getTransferListeners().iterator();
                while (iterator.hasNext()) {
                    TransferListener transferListener = (TransferListener)iterator.next();
                    transferListener.transferFailed(new ClientException("overwrite not allowed"));
                }
                log.info((Object)"Upload failed : Overwrite not allowed");
                string3 = null;
            } else if (this.getOverwrite().equalsIgnoreCase("indexrename")) {
                string3 = string5 + "_" + n + string4;
            } else if (this.getOverwrite().equalsIgnoreCase("indexrename2")) {
                string3 = string5 + "(" + n + ")" + string4;
            } else if (this.getOverwrite().equalsIgnoreCase("timerename")) {
                string3 = string5 + "_" + System.currentTimeMillis() + string4;
            }
        } else {
            String string7 = null;
            string3 = string;
            if (string2 != null && string2.length() > 0) {
                String string8;
                String string9 = ":regex=";
                String string10 = ":";
                String string11 = "|";
                int n4 = string2.indexOf(string11 + string9);
                if (n4 > 0) {
                    string7 = string2.substring(n4 + 1, string2.length());
                    string2 = string2.substring(0, n4);
                } else if (string2.startsWith(string9) && string2.endsWith(string10)) {
                    string7 = string2;
                    string2 = null;
                }
                if (string2 != null) {
                    string3 = string2;
                    if (string.indexOf("$") > -1) {
                        string = string.replaceAll("\\$", "\\\\\\$");
                    }
                    if (string4.indexOf("$") > -1) {
                        string4 = string4.replaceAll("\\$", "\\\\\\$");
                    }
                    if (string5.indexOf("$") > -1) {
                        string5 = string5.replaceAll("\\$", "\\\\\\$");
                    }
                    if (string6.indexOf("$") > -1) {
                        string6 = string6.replaceAll("\\$", "\\\\\\$");
                    }
                    if (string3.indexOf(":timestamp:") > -1) {
                        string3 = string3.replaceAll(":timestamp:", String.valueOf(System.currentTimeMillis()));
                    }
                    if (string3.indexOf(":identifier:") > -1) {
                        string3 = string3.replaceAll(":identifier:", String.valueOf(this.rawconf.getNextIdentifier()));
                    }
                    if (string3.indexOf(":filename:") > -1) {
                        string3 = string3.replaceAll(":filename:", string);
                    }
                    if (string3.indexOf(":extension:") > -1) {
                        string3 = string3.replaceAll(":extension:", string4);
                    }
                    if (string3.indexOf(":name:") > -1) {
                        string3 = string3.replaceAll(":name:", string5);
                    }
                    if (string3.indexOf(":shortname:") > -1) {
                        string3 = string3.replaceAll(":shortname:", string6);
                    }
                    if (string3.indexOf(":shortnameid:") > -1) {
                        string8 = string6.replaceAll("(\\D)(\\d)$", "$10$2");
                        string3 = string3.replaceAll(":shortnameid:", string8);
                    }
                }
                if (string7 != null && string7.startsWith(string9) && string7.endsWith(string10)) {
                    string8 = string7.substring(string9.length(), string7.length() - string10.length());
                    String string12 = "";
                    int n5 = string8.lastIndexOf(":");
                    if (n5 != -1) {
                        string12 = string8.substring(n5 + 1, string8.length());
                        string8 = string8.substring(0, n5);
                    }
                    string3 = string3.replaceAll(string8, string12);
                }
            }
        }
        return string3;
    }

    public long getCRC32(File file, long l) {
        long l2 = -1L;
        CRC32 cRC32 = new CRC32();
        this.checksumStartedNotification("CRC32");
        this.computeChecksum(file, l, cRC32);
        l2 = cRC32.getValue();
        this.checksumCompletedNotification(String.valueOf(l2));
        return l2;
    }

    public byte[] getMD5(File file, long l) {
        byte[] byArray = null;
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            this.checksumStartedNotification("MD5");
            this.computeChecksum(file, l, messageDigest);
            byArray = messageDigest.digest();
            this.checksumCompletedNotification(this.hexDump(byArray).toLowerCase());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            log.error((Object)noSuchAlgorithmException);
        }
        return byArray;
    }

    public String hexDump(byte[] byArray) {
        String string = null;
        byte by = 0;
        if (byArray != null && byArray.length > 0) {
            String[] stringArray = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
            StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
            for (int i = 0; i < byArray.length; ++i) {
                by = (byte)(byArray[i] & 0xF0);
                by = (byte)(by >>> 4);
                by = (byte)(by & 0xF);
                stringBuffer.append(stringArray[by]);
                by = (byte)(byArray[i] & 0xF);
                stringBuffer.append(stringArray[by]);
            }
            string = new String(stringBuffer);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeChecksum(File file, long l, Object object) {
        InputStream inputStream = null;
        if (l < 0L) {
            l = file.length() + 1L;
        }
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            byte[] byArray = new byte[1024];
            int n = -1;
            long l2 = 0L;
            while ((n = inputStream.read(byArray)) > 0) {
                if ((l2 += (long)n) < l) {
                    if (object instanceof CRC32) {
                        ((CRC32)object).update(byArray, 0, n);
                        continue;
                    }
                    if (!(object instanceof MessageDigest)) continue;
                    ((MessageDigest)object).update(byArray, 0, n);
                    continue;
                }
                if (object instanceof CRC32) {
                    ((CRC32)object).update(byArray, 0, n - (int)(l2 - l));
                } else if (object instanceof MessageDigest) {
                    ((MessageDigest)object).update(byArray, 0, n - (int)(l2 - l));
                }
                break;
            }
        }
        catch (IOException iOException) {
            log.error((Object)iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                    inputStream = null;
                }
            }
            catch (IOException iOException) {}
        }
    }

    public String getTmpFolder() {
        String string = this.getTmpDir();
        if (string != null) {
            if (string.equals("javatmpdir")) {
                string = System.getProperty("java.io.tmpdir");
            } else {
                boolean bl;
                File file = new File(string);
                if (!file.exists() && !(bl = file.mkdirs())) {
                    string = null;
                }
            }
            log.debug((Object)("Temporary folder : " + string));
        }
        return string;
    }

    public PasswordAuthentication authenticate(AuthenticationModel authenticationModel, int n) {
        PasswordAuthentication passwordAuthentication = null;
        AuthenticationPane authenticationPane = new AuthenticationPane(this.getRawConf());
        authenticationPane.setParent(this.getParentContainer());
        authenticationPane.setAuthenticationModel(authenticationModel);
        authenticationPane.setAttempt(n);
        int n2 = authenticationPane.popup();
        if (n2 == 100) {
            passwordAuthentication = new PasswordAuthentication(authenticationModel.getUsername(), authenticationModel.getPassword());
        }
        return passwordAuthentication;
    }

    public void addTransferListener(TransferListener transferListener) {
        if (transferListener != null) {
            this.tlisteners.add(transferListener);
        }
    }

    public void removeTransferListener(TransferListener transferListener) {
        if (transferListener != null) {
            this.tlisteners.remove(transferListener);
        }
    }

    public List getTransferListeners() {
        return this.tlisteners;
    }

    public void addSplitListener(SplitListener splitListener) {
        if (splitListener != null) {
            this.slisteners.add(splitListener);
        }
    }

    public void removeSplitListener(SplitListener splitListener) {
        if (splitListener != null) {
            this.slisteners.remove(splitListener);
        }
    }

    public List getSplitListeners() {
        return this.slisteners;
    }

    public void addCompressListener(CompressListener compressListener) {
        if (compressListener != null) {
            this.clisteners.add(compressListener);
        }
    }

    public void removeCompressListener(CompressListener compressListener) {
        if (compressListener != null) {
            this.clisteners.remove(compressListener);
        }
    }

    public List getCompressListeners() {
        return this.clisteners;
    }

    public void addFilterListener(FilterListener filterListener) {
        if (filterListener != null) {
            this.flisteners.add(filterListener);
        }
    }

    public void removeFilterListener(FilterListener filterListener) {
        if (filterListener != null) {
            this.flisteners.remove(filterListener);
        }
    }

    public List getFilterListeners() {
        return this.flisteners;
    }

    public void addProtocolListener(ProtocolListener protocolListener) {
        if (protocolListener != null) {
            this.plisteners.add(protocolListener);
        }
    }

    public void removeProtocolListener(ProtocolListener protocolListener) {
        if (protocolListener != null) {
            this.plisteners.remove(protocolListener);
        }
    }

    public List getProtocolListeners() {
        return this.plisteners;
    }

    public void addChecksumListener(ChecksumListener checksumListener) {
        if (checksumListener != null) {
            this.cslisteners.add(checksumListener);
        }
    }

    public void removeChecksumListener(ChecksumListener checksumListener) {
        if (checksumListener != null) {
            this.cslisteners.remove(checksumListener);
        }
    }

    public List getChecksumListeners() {
        return this.cslisteners;
    }

    public List getSource() {
        return this.source;
    }

    public String getTmpDir() {
        return this.tmpDir;
    }

    public List getTarget() {
        return this.target;
    }

    public void setSource(List list) {
        this.source = list;
    }

    public void setMaxSize(long l) {
        this.maxsize = l;
    }

    public long getMaxSize() {
        return this.maxsize;
    }

    public void setFullMaxSize(long l) {
        this.fullmaxsize = l;
    }

    public long getFullMaxSize() {
        return this.fullmaxsize;
    }

    public void setMinSize(long l) {
        this.minsize = l;
    }

    public long getMinSize() {
        return this.minsize;
    }

    public void setMaxFiles(long l) {
        this.maxfiles = l;
    }

    public long getMaxFiles() {
        return this.maxfiles;
    }

    public void setZipMaxSize(long l) {
        this.zipmaxsize = l;
    }

    public long getZipMaxSize() {
        return this.zipmaxsize;
    }

    public void setPolicy(String string) {
        this.policy = string;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setHidden(String string) {
        this.hidden = string;
    }

    public String getHidden() {
        return this.hidden;
    }

    public void setZipOnFly(String string) {
        this.ziponfly = string;
    }

    public String getZipOnFly() {
        this.ziponfly = this.rawconf.getProperty("ziponfly");
        return this.ziponfly;
    }

    public void setMaxDepth(long l) {
        this.maxdepth = l;
    }

    public long getMaxDepth() {
        return this.maxdepth;
    }

    public void setTimeOut(long l) {
        this.timeout = l;
    }

    public long getTimeOut() {
        return this.timeout;
    }

    public int getRetry() {
        return this.retrycount;
    }

    public void setRetry(int n) {
        this.retrycount = n;
    }

    public int getRetryDelay() {
        return this.retrydelay;
    }

    public void setRetryDelay(int n) {
        this.retrydelay = n;
    }

    public void setWhiteList(String string) {
        this.whitelist = string;
    }

    public String getWhiteList() {
        return this.whitelist;
    }

    public void setBlackList(String string) {
        this.blacklist = string;
    }

    public String getBlackList() {
        return this.blacklist;
    }

    public void setZipIgnoreList(String string) {
        this.zipignorelist = string;
    }

    public String getZipIgnoreList() {
        return this.zipignorelist;
    }

    public void setZipFolder(String string) {
        this.zipfolder = string;
    }

    public String getZipFolder() {
        return this.zipfolder;
    }

    public void setTemplate(String string) {
        this.template = string;
    }

    public String getTemplate() {
        this.template = this.rawconf.getProperty("template");
        return this.template;
    }

    public void setTemplateScope(String string) {
        this.templateScope = string;
    }

    public String getTemplateScope() {
        this.templateScope = this.rawconf.getProperty("templatescope");
        return this.templateScope;
    }

    public void setOverwrite(String string) {
        this.overwrite = string;
    }

    public String getOverwrite() {
        return this.overwrite;
    }

    public void setResume(String string) {
        this.resume = string;
    }

    public String getResume() {
        this.resume = this.rawconf.getProperty("resume");
        return this.resume;
    }

    public long getResumeOffset() {
        return this.resumeOffset;
    }

    protected void setResumeOffset(long l) {
        this.resumeOffset = l;
    }

    public void setAuthentication(String string) {
        this.authentication = string;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public void setTmpDir(String string) {
        this.tmpDir = string;
    }

    public void setTarget(List list) {
        this.target = list;
    }

    public HashMap getParameters(String string) {
        return this.parameters;
    }

    public void setParameters(HashMap hashMap) {
        this.parameters = hashMap;
    }

    public void setMetaProperties(HashMap hashMap) {
        this.metaProperties = hashMap;
    }

    public HashMap getMetaProperties() {
        return this.metaProperties;
    }

    public String getMetaScope() {
        return this.metaScope;
    }

    public void setMetaScope(String string) {
        this.metaScope = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getParamFile() {
        return this.paramFile;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setParamFile(String string) {
        this.paramFile = string;
    }

    public long getChunkSize() {
        return this.chunksize;
    }

    public void setChunkSize(long l) {
        this.chunksize = l;
    }

    public String getRootDir() {
        return this.rootdir;
    }

    public void setRootDir(String string) {
        this.rootdir = string;
    }

    public String getPassword() {
        this.password = this.rawconf.decodeBase64(this.rawconf.getProperty("password"));
        if (this.password == null) {
            this.password = this.rawconf.decodeBase64(this.rawconf.getResource("password"));
        }
        if (this.password != null) {
            this.password = this.rawconf.decodePBE(this.password);
        }
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getUsername() {
        this.username = this.rawconf.decodeBase64(this.rawconf.getProperty("username"));
        if (this.username == null) {
            this.username = this.rawconf.decodeBase64(this.rawconf.getResource("username"));
        }
        if (this.username != null) {
            this.username = this.rawconf.decodePBE(this.username);
        }
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public URL getServerUrl() {
        return this.serverurl;
    }

    public void setServerUrl(URL uRL) {
        this.serverurl = uRL;
    }

    public String getPreProcessingFilterImpl() {
        return this.preprocessingfilterimpl;
    }

    public void setPreProcessingFilterImpl(String string) {
        this.preprocessingfilterimpl = string;
    }

    public TransferFilter getPreProcessingFilter() {
        return this.preprocessingfilter;
    }

    public void setPreProcessingFilter(TransferFilter transferFilter) {
        this.preprocessingfilter = transferFilter;
    }

    public TransferFilter getFilter() {
        return this.getFilter("");
    }

    public TransferFilter getFilter(String string) {
        return (TransferFilter)this.filter.get(string);
    }

    public void setFilter(TransferFilter transferFilter) {
        this.setFilter(transferFilter, "");
    }

    public void setFilter(TransferFilter transferFilter, String string) {
        if (string != null && transferFilter != null) {
            this.filter.put(string, transferFilter);
        }
    }

    public String getFilterImpl() {
        return this.getFilterImpl("");
    }

    public String getFilterImpl(String string) {
        return (String)this.filterimpl.get(string);
    }

    public void setFilterImpl(String string) {
        this.setFilterImpl(string, "");
    }

    public void setFilterImpl(String string, String string2) {
        if (string2 != null && string != null) {
            this.filterimpl.put(string2, string);
        }
    }

    public List getFilterIDs() {
        return this.filterIDs;
    }

    public void setFilterIDs(List list) {
        this.filterIDs = list;
    }

    public String getFilterChain() {
        return this.filterchain;
    }

    public void setFilterChain(String string) {
        this.filterchain = string;
    }

    public Conf getRawConf() {
        return this.rawconf;
    }

    public void setRawConf(Conf conf) {
        this.rawconf = conf;
    }

    public TransferFileFilter getTransferFileFilter() {
        String string;
        boolean bl = false;
        String string2 = this.rawconf.getProperty("whitelist");
        if (string2 != null && !string2.equalsIgnoreCase(this.getWhiteList())) {
            if (string2.length() == 0) {
                string2 = null;
            }
            this.setWhiteList(string2);
            bl = true;
        }
        if ((string = this.rawconf.getProperty("blacklist")) != null && !string.equalsIgnoreCase(this.getBlackList())) {
            if (string.length() == 0) {
                string = null;
            }
            this.setBlackList(string);
            bl = true;
        }
        if (bl) {
            this.tff = new TransferFileFilter(this.getBlackList(), this.getWhiteList(), this.getMaxSize(), this.getMinSize(), this.getHidden(), this.tff.isWritableDirectoryOnly());
        }
        return this.tff;
    }

    public Object getExt() {
        return this.ext;
    }

    public void setExt(Object object) {
        this.ext = object;
    }

    public void setParentContainer(Container container) {
        this.parentContainer = container;
    }

    public Container getParentContainer() {
        return this.parentContainer;
    }

    public boolean isThreaded() {
        return this.threaded;
    }

    public void setThreaded(boolean bl) {
        this.threaded = bl;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public long getLong(String string) {
        long l = -1L;
        if (string != null) {
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                log.debug((Object)("Cannot parse " + string), (Throwable)numberFormatException);
            }
        }
        return l;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

