/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.transfer.client.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jfileupload.transfer.client.core.AbstractTransferController;
import jfileupload.transfer.client.core.ClientException;
import jfileupload.transfer.client.core.FilterListener;
import jfileupload.transfer.client.core.TransferController;
import jfileupload.transfer.client.core.TransferFilter;
import jfileupload.transfer.client.util.Conf;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArchiveFilter
implements TransferFilter {
    private static final String VERSION = "Archive Filter";
    private static final Log log = LogFactory.getLog((Class)(class$jfileupload$transfer$client$core$ArchiveFilter == null ? (class$jfileupload$transfer$client$core$ArchiveFilter = ArchiveFilter.class$("jfileupload.transfer.client.core.ArchiveFilter")) : class$jfileupload$transfer$client$core$ArchiveFilter));
    public static int BUFFERSIZE = 4096;
    public String ENTRIES_RENAMED = "entriesrenamed";
    public String ENTRIES_SKIPPED = "entriesskipped";
    private Conf conf = null;
    private TransferController controller = null;
    private File tmp = null;
    private long amount = 0L;
    private long amountRenamed = 0L;
    protected String identifier = null;
    protected Properties props = null;
    protected int level = -1;
    protected long maxsize = -1L;
    protected String comment = null;
    protected String extension = ".archive.zip";
    protected String fullname = null;
    protected String template = null;
    protected String countrenamed = null;
    protected String filesskipped = null;
    protected String hiddenEntry = null;
    protected List filesSkipped = null;
    protected boolean cancelled = false;
    static /* synthetic */ Class class$jfileupload$transfer$client$core$ArchiveFilter;

    public ArchiveFilter(Conf conf) {
        this.conf = conf;
    }

    public void init(TransferController transferController, String string) throws ClientException {
        this.identifier = string;
        if (this.identifier == null) {
            this.identifier = "preprocessing";
        }
        log.info((Object)("Initializing Archive Filter [" + this.identifier + "]"));
        this.controller = transferController;
        this.props = new Properties();
        this.loadParameters();
    }

    protected void loadParameters() {
        String string;
        String string2;
        for (int i = 1; i <= 16; ++i) {
            string2 = this.conf.getProperty(this.identifier + "filterparam" + i);
            string = this.conf.getProperty(this.identifier + "filtervalue" + i);
            if (string2 == null || string == null) continue;
            this.props.setProperty(string2, string);
        }
        this.maxsize = this.conf.getLong(this.props.getProperty("archivemaxsize"));
        this.level = (int)this.conf.getLong(this.props.getProperty("compressionlevel"));
        this.comment = this.props.getProperty("compressioncomment");
        String string3 = this.props.getProperty("archiveextension");
        if (string3 != null) {
            this.extension = string3;
        }
        if ((string2 = this.props.getProperty("archivefullname")) != null) {
            this.fullname = string2;
        }
        if ((string = this.props.getProperty("hiddenentry")) != null) {
            this.hiddenEntry = string;
        }
        this.template = this.props.getProperty("entrytemplate");
        this.countrenamed = this.props.getProperty("countrenamed");
        this.filesskipped = this.props.getProperty("filesskipped");
    }

    public Object execute(Object object) throws ClientException {
        this.cancelled = false;
        ArrayList<String> arrayList = null;
        if (object != null && object instanceof List && ((List)object).size() > 0) {
            this.tmp = null;
            this.amount = 0L;
            this.amountRenamed = 0L;
            this.loadParameters();
            this.filesSkipped = this.filesskipped != null && this.filesskipped.equalsIgnoreCase("true") ? new ArrayList() : null;
            File file = this.processCompress((List)object);
            if (file != null) {
                arrayList = new ArrayList<String>();
                arrayList.add(file.getAbsolutePath());
                if (this.countrenamed != null && this.countrenamed.equalsIgnoreCase("true") && this.controller.getParameters("dynamic") != null) {
                    this.controller.getParameters("dynamic").put(this.ENTRIES_RENAMED, String.valueOf(this.amountRenamed));
                }
                if (this.filesskipped != null && this.filesskipped.equalsIgnoreCase("true") && this.controller.getParameters("dynamic") != null) {
                    this.controller.getParameters("dynamic").put(this.ENTRIES_SKIPPED, this.serializeList(this.filesSkipped));
                }
                if (this.maxsize > 0L && file.length() > this.maxsize) {
                    throw new ClientException("max size exceeded");
                }
            }
        }
        return arrayList;
    }

    public void clean() {
        if (this.tmp != null) {
            boolean bl = this.tmp.delete();
            log.debug((Object)("Cleaned [" + this.identifier + "]: " + bl));
            this.tmp = null;
        }
    }

    protected File processCompress(List list) throws ClientException {
        File file = null;
        boolean bl = false;
        this.notifyOnStarting(list, null);
        Iterator iterator = list.iterator();
        String string = System.getProperty("java.io.tmpdir");
        if (string != null) {
            if (!(string = string.replace('\\', '/')).endsWith("/")) {
                string = string + "/";
            }
            if (Conf.PREFERENCESFOLDER != null && Conf.PREFERENCESFOLDER.length() > 0 && !(string = string + Conf.PREFERENCESFOLDER).endsWith("/")) {
                string = string + "/";
            }
            file = this.fullname == null ? new File(string + new File((String)list.get(0)).getName() + this.extension) : new File(string + this.fullname);
        } else {
            file = this.fullname == null ? new File((String)list.get(0) + this.extension) : new File(this.fullname);
        }
        this.tmp = file;
        log.info((Object)("Compression started : " + file.getAbsolutePath()));
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            if (this.level >= 0 && this.level <= 9) {
                zipOutputStream.setLevel(this.level);
            }
            if (this.comment != null) {
                zipOutputStream.setComment(this.comment);
            }
            byte[] byArray = new byte[BUFFERSIZE];
            while (iterator.hasNext()) {
                File file2 = new File((String)iterator.next());
                if (file2.isDirectory()) {
                    this.addFolder(zipOutputStream, file2, file2, byArray, 0L, this.controller.getMaxDepth());
                    continue;
                }
                this.addFile(file2, zipOutputStream, byArray);
            }
            zipOutputStream.flush();
            bl = true;
            log.info((Object)"Compression completed");
            this.notifyOnComplete(file, this.identifier);
        }
        catch (Exception exception) {
            log.error((Object)"Compression failed", (Throwable)exception);
            this.notifyOnFail(new ClientException(exception.getMessage(), this.identifier));
            throw new ClientException(exception);
        }
        finally {
            try {
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
            }
            catch (IOException iOException) {
                log.error((Object)iOException);
            }
        }
        if (!bl) {
            file = null;
        }
        return file;
    }

    protected void addFile(File file, ZipOutputStream zipOutputStream, byte[] byArray) throws IOException {
        if (file.isHidden() && this.hiddenEntry != null && this.hiddenEntry.equalsIgnoreCase("ignore")) {
            return;
        }
        if (!this.isAllowed(file)) {
            if (this.filesSkipped != null) {
                this.filesSkipped.add(file);
            }
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        String string = file.getName();
        if (this.template != null) {
            String string2 = ((AbstractTransferController)this.controller).rename(string, this.template, 0);
            if (!string2.equals(string)) {
                ++this.amountRenamed;
            }
            string = string2;
        }
        zipOutputStream.putNextEntry(new ZipEntry(string));
        int n = -1;
        while ((n = fileInputStream.read(byArray)) != -1) {
            zipOutputStream.write(byArray, 0, n);
            if (!this.cancelled) continue;
            throw new IOException();
        }
        zipOutputStream.flush();
        zipOutputStream.closeEntry();
        fileInputStream.close();
        fileInputStream = null;
        ++this.amount;
        this.notifyOnStarted(file, String.valueOf(this.amount));
    }

    protected void addFolder(ZipOutputStream zipOutputStream, File file, File file2, byte[] byArray, long l, long l2) throws IOException {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            if (fileArray.length > 0) {
                for (int i = 0; i < fileArray.length; ++i) {
                    File file3 = fileArray[i];
                    if (file3.isFile()) {
                        Object object;
                        if (file3.isHidden() && this.hiddenEntry != null && this.hiddenEntry.equalsIgnoreCase("ignore")) continue;
                        if (!this.isAllowed(file3)) {
                            if (this.filesSkipped == null) continue;
                            this.filesSkipped.add(file3);
                            continue;
                        }
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file3));
                        String string = file3.getAbsolutePath();
                        String string2 = file2.getAbsolutePath();
                        string = string.substring(string2.length() + 1);
                        if (this.template != null) {
                            object = ((AbstractTransferController)this.controller).rename(string, this.template, 0);
                            if (!((String)object).equals(string)) {
                                ++this.amountRenamed;
                            }
                            string = object;
                        }
                        string = file2.getName() + "/" + string;
                        string = string.replace('\\', '/');
                        object = new ZipEntry(string);
                        zipOutputStream.putNextEntry((ZipEntry)object);
                        int n = -1;
                        while ((n = bufferedInputStream.read(byArray)) != -1) {
                            zipOutputStream.write(byArray, 0, n);
                            if (!this.cancelled) continue;
                            throw new IOException();
                        }
                        zipOutputStream.flush();
                        zipOutputStream.closeEntry();
                        bufferedInputStream.close();
                        bufferedInputStream = null;
                        ++this.amount;
                        this.notifyOnStarted(file3, String.valueOf(this.amount));
                        continue;
                    }
                    if (l2 > -1L) {
                        if (l + 1L > l2) continue;
                        this.addFolder(zipOutputStream, file3, file2, byArray, l + 1L, l2);
                        continue;
                    }
                    this.addFolder(zipOutputStream, file3, file2, byArray, l + 1L, l2);
                }
            } else {
                Object object;
                Object object2 = file.getAbsolutePath();
                String string = file2.getAbsolutePath();
                if (((String)object2).length() > string.length()) {
                    object2 = ((String)object2).substring(string.length() + 1) + "/";
                    object2 = file2.getName() + "/" + (String)object2;
                } else {
                    object2 = file2.getName() + "/";
                }
                object2 = ((String)object2).replace('\\', '/');
                if (this.template != null) {
                    object = ((AbstractTransferController)this.controller).rename((String)object2, this.template, 0);
                    if (!((String)object).equals(object2)) {
                        ++this.amountRenamed;
                    }
                    object2 = object;
                }
                object = new ZipEntry((String)object2);
                zipOutputStream.putNextEntry((ZipEntry)object);
                zipOutputStream.closeEntry();
            }
        }
    }

    public void cancel() {
        this.cancelled = true;
    }

    protected void notifyOnStarting(Object object, String string) {
        List list;
        if (this.controller != null && (list = this.controller.getFilterListeners()) != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FilterListener filterListener = (FilterListener)iterator.next();
                filterListener.filterStarting(object, string, this);
            }
        }
    }

    protected void notifyOnStarted(File file, String string) {
        List list;
        if (this.controller != null && (list = this.controller.getFilterListeners()) != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FilterListener filterListener = (FilterListener)iterator.next();
                filterListener.filterStarted(file, string, this);
            }
        }
    }

    protected void notifyOnComplete(File file, String string) {
        List list;
        if (this.controller != null && (list = this.controller.getFilterListeners()) != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FilterListener filterListener = (FilterListener)iterator.next();
                filterListener.filterCompleted(file, string);
            }
        }
    }

    protected void notifyOnFail(ClientException clientException) {
        List list;
        if (this.controller != null && (list = this.controller.getFilterListeners()) != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FilterListener filterListener = (FilterListener)iterator.next();
                filterListener.filterFailed(clientException);
            }
        }
    }

    protected boolean isAllowed(File file) throws IOException {
        boolean bl = false;
        try {
            bl = ((AbstractTransferController)this.controller).isAllowed(file);
        }
        catch (ClientException clientException) {
            if (this.filesSkipped != null) {
                this.filesSkipped.add(file);
            }
            log.error((Object)clientException);
        }
        return bl;
    }

    protected String serializeList(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        if (list != null && list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                String string = file.getAbsolutePath();
                string = string.replace('\\', '/');
                stringBuffer.append(string);
                if (!iterator.hasNext()) continue;
                stringBuffer.append("|");
            }
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

