/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.transfer.client.core;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import jfileupload.transfer.client.core.TransferListener;

public class TriggeredInputStream
extends BufferedInputStream {
    protected List listeners = null;
    protected boolean notification = true;
    private long maxlength = -1L;
    private long bytesread = 0L;

    public TriggeredInputStream(InputStream inputStream, List list) {
        super(inputStream);
        this.listeners = list;
    }

    public TriggeredInputStream(InputStream inputStream, int n, List list) {
        super(inputStream, n);
        this.listeners = list;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.maxlength > 0L && this.bytesread >= this.maxlength) {
            return -1;
        }
        int n3 = super.read(byArray, n, n2);
        this.bytesread += (long)n3;
        if (this.maxlength > 0L && this.bytesread >= this.maxlength) {
            n3 = (int)(this.maxlength - (this.bytesread - (long)n3));
        }
        if (this.notification) {
            this.notifyListeners(n3);
        }
        return n3;
    }

    public int read() throws IOException {
        int n = super.read();
        if (this.notification) {
            this.notifyListeners(n);
        }
        return n;
    }

    public long skip(long l) throws IOException {
        long l2 = super.skip(l);
        if (this.notification && this.maxlength == -1L) {
            this.notifyListeners(l2);
        }
        return l2;
    }

    protected void notifyListeners(long l) {
        if (this.listeners != null) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                TransferListener transferListener = (TransferListener)iterator.next();
                transferListener.dataRead(l);
            }
        }
    }

    public void setMaxlength(long l) {
        this.maxlength = l;
    }
}

