/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.transfer.client.mdesign;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import jfileupload.transfer.client.mdesign.AuthenticationModel;
import jfileupload.transfer.client.util.Conf;

public class AuthenticationPane
extends JOptionPane {
    public static final int AUTH_CLOSED_OPTION = 99;
    public static final int AUTH_OK_OPTION = 100;
    public static final int AUTH_CANCEL_OPTION = 101;
    private Conf conf = null;
    private AuthenticationPanel message = null;
    private AuthenticationModel model = null;
    private JDialog dialog = null;
    private int attempt = 1;
    private Container parent = null;

    public AuthenticationPane(Conf conf) {
        this.conf = conf;
        this.message = new AuthenticationPanel();
    }

    public void setParent(Container container) {
        this.parent = container;
    }

    public void setAuthenticationModel(AuthenticationModel authenticationModel) {
        this.model = authenticationModel;
    }

    public AuthenticationModel getAuthenticationModel() {
        return this.model;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public void setAttempt(int n) {
        this.attempt = n;
    }

    public void setServerEditable(boolean bl) {
        this.message.getServerTextField().setVisible(bl);
        this.message.getServerLabelValue().setVisible(!bl);
    }

    protected void loadUI() {
        this.message.getServerLabelValue().setText(this.model.getServer());
        this.message.getServerTextField().setText(this.model.getServer());
        this.message.getRealmLabelValue().setText(this.model.getRealm());
        this.message.getSchemeLabelValue().setText(this.model.getScheme());
        this.message.getUsernameTextField().setText(this.model.getUsername());
        if (this.model.getPassword() != null) {
            this.message.getPasswordTextField().setText(new String(this.model.getPassword()));
        }
        this.message.getHostTextField().setText(this.model.getHost());
        this.message.getDomainTextField().setText(this.model.getDomain());
        if (!this.model.isNTLM()) {
            this.message.removeDomain();
            this.message.removeHost();
        } else if (this.model.getHost() != null && this.model.getHost().length() > 0) {
            this.message.removeHost();
        }
        if (!this.model.isHttp()) {
            this.message.removeScheme();
            this.message.removeRealm();
        }
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AuthenticationPane.this.setValue(new Integer(100));
                AuthenticationPane.this.dialog.dispose();
            }
        };
        this.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0, false), "AUTH_YES_OPTION");
        this.getActionMap().put("AUTH_YES_OPTION", abstractAction);
        final JButton jButton = new JButton(this.conf.getResource("authentication.confirm.yes"));
        jButton.addActionListener(abstractAction);
        String string = this.conf.getResource("authentication.username.empty");
        if (string == null || !string.equalsIgnoreCase("allowed")) {
            if (this.message.getUsernameTextField().getText().length() == 0) {
                jButton.setEnabled(false);
            }
            this.message.getUsernameTextField().addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent keyEvent) {
                    JTextField jTextField = (JTextField)keyEvent.getSource();
                    int n = jTextField.getText().length();
                    if (n <= 0) {
                        jButton.setEnabled(false);
                    } else {
                        jButton.setEnabled(true);
                    }
                }
            });
        }
        JButton jButton2 = new JButton(this.conf.getResource("authentication.confirm.no"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AuthenticationPane.this.setValue(new Integer(101));
                AuthenticationPane.this.dialog.dispose();
            }
        });
        Object[] objectArray = new Object[]{jButton, jButton2};
        this.setMessage(this.message);
        this.setOptions(objectArray);
        this.setMessageType(3);
        this.setOptionType(-1);
    }

    public int popup() {
        this.loadUI();
        int n = 99;
        String string = "";
        String string2 = "FTP";
        if (this.model.isHttp()) {
            string2 = "HTTP";
        }
        Object[] objectArray = new Object[]{string2, new Integer(this.attempt)};
        string = this.model.isProxy() ? MessageFormat.format(this.conf.getResource("authentication.title.proxy"), objectArray) : MessageFormat.format(this.conf.getResource("authentication.title"), objectArray);
        if (this.parent == null) {
            this.parent = this.getParent();
        }
        this.dialog = this.createDialog(this.parent, string);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setVisible(true);
        if (this.getValue() != null && this.getValue() instanceof Integer) {
            n = (Integer)this.getValue();
        }
        this.model.setUsername(this.message.getUsernameTextField().getText());
        this.model.setPassword(this.message.getPasswordTextField().getPassword());
        this.model.setDomain(this.message.getDomainTextField().getText());
        this.model.setHost(this.message.getHostTextField().getText());
        this.model.setServer(this.message.getServerTextField().getText());
        return n;
    }

    public class AuthenticationPanel
    extends JPanel {
        private JLabel domainLabel;
        private JTextField domainTextField;
        private JLabel hostLabel;
        private JTextField hostTextField;
        private JLabel passwordLabel;
        private JPasswordField passwordTextField;
        private JLabel realmLabel;
        private JLabel realmLabelValue;
        private JLabel schemeLabel;
        private JLabel schemeLabelValue;
        private JLabel serverLabel;
        private JLabel serverLabelValue;
        private JTextField serverTextField;
        private JLabel usernameLabel;
        private JTextField usernameTextField;

        public AuthenticationPanel() {
            this.initComponents();
        }

        public void removeScheme() {
            this.remove(this.schemeLabel);
            this.remove(this.schemeLabelValue);
        }

        public void removeRealm() {
            this.remove(this.realmLabel);
            this.remove(this.realmLabelValue);
        }

        public void removeDomain() {
            this.remove(this.domainLabel);
            this.remove(this.domainTextField);
        }

        public void removeHost() {
            this.remove(this.hostLabel);
            this.remove(this.hostTextField);
        }

        public JTextField getDomainTextField() {
            return this.domainTextField;
        }

        public JTextField getHostTextField() {
            return this.hostTextField;
        }

        public JPasswordField getPasswordTextField() {
            return this.passwordTextField;
        }

        public JLabel getRealmLabelValue() {
            return this.realmLabelValue;
        }

        public JLabel getSchemeLabelValue() {
            return this.schemeLabelValue;
        }

        public JLabel getServerLabelValue() {
            return this.serverLabelValue;
        }

        public JTextField getServerTextField() {
            return this.serverTextField;
        }

        public JTextField getUsernameTextField() {
            return this.usernameTextField;
        }

        public void setSchemeLabelValue(JLabel jLabel) {
            this.schemeLabelValue = jLabel;
        }

        public JLabel getServerLabel() {
            return this.serverLabel;
        }

        public void setServerLabel(JLabel jLabel) {
            this.serverLabel = jLabel;
        }

        public void setServerLabelValue(JLabel jLabel) {
            this.serverLabelValue = jLabel;
        }

        public JLabel getUsernameLabel() {
            return this.usernameLabel;
        }

        public void setUsernameLabel(JLabel jLabel) {
            this.usernameLabel = jLabel;
        }

        public void setUsernameTextField(JTextField jTextField) {
            this.usernameTextField = jTextField;
        }

        private void initComponents() {
            GridBagConstraints gridBagConstraints = null;
            this.serverLabel = new JLabel();
            this.serverLabelValue = new JLabel();
            this.serverTextField = new JTextField();
            this.schemeLabel = new JLabel();
            this.schemeLabelValue = new JLabel();
            this.usernameLabel = new JLabel();
            this.usernameTextField = new JTextField();
            this.passwordLabel = new JLabel();
            this.passwordTextField = new JPasswordField();
            this.hostLabel = new JLabel();
            this.hostTextField = new JTextField();
            this.domainLabel = new JLabel();
            this.domainTextField = new JTextField();
            this.realmLabel = new JLabel();
            this.realmLabelValue = new JLabel();
            this.setLayout(new GridBagLayout());
            this.serverLabel.setText(AuthenticationPane.this.conf.getResource("authentication.server"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 2, 2, 2);
            this.add((Component)this.serverLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 2, 2, 2);
            this.add((Component)this.serverLabelValue, gridBagConstraints);
            this.serverTextField.setVisible(false);
            this.add((Component)this.serverTextField, gridBagConstraints);
            this.schemeLabel.setText(AuthenticationPane.this.conf.getResource("authentication.scheme"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.add((Component)this.schemeLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.add((Component)this.schemeLabelValue, gridBagConstraints);
            String string = AuthenticationPane.this.conf.getResource("authentication.username");
            if (string != null) {
                this.usernameLabel.setText(string);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets = new Insets(12, 4, 4, 4);
                this.add((Component)this.usernameLabel, gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.insets = new Insets(12, 4, 4, 4);
                this.add((Component)this.usernameTextField, gridBagConstraints);
            }
            this.passwordLabel.setText(AuthenticationPane.this.conf.getResource("authentication.password"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            this.add((Component)this.passwordLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            this.add((Component)this.passwordTextField, gridBagConstraints);
            this.hostLabel.setText(AuthenticationPane.this.conf.getResource("authentication.host"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            this.add((Component)this.hostLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            this.add((Component)this.hostTextField, gridBagConstraints);
            this.domainLabel.setText(AuthenticationPane.this.conf.getResource("authentication.domain"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            this.add((Component)this.domainLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            this.add((Component)this.domainTextField, gridBagConstraints);
            this.realmLabel.setText(AuthenticationPane.this.conf.getResource("authentication.realm"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.add((Component)this.realmLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.add((Component)this.realmLabelValue, gridBagConstraints);
        }
    }
}

