/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.transfer.client.mdesign;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.color.ColorSpace;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import jfileupload.transfer.client.mdesign.FilePreview;
import jfileupload.transfer.client.util.Conf;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImagePreview
extends FilePreview
implements PropertyChangeListener {
    private static final Log log = LogFactory.getLog((Class)(class$jfileupload$transfer$client$mdesign$FilePreview == null ? (class$jfileupload$transfer$client$mdesign$FilePreview = ImagePreview.class$("jfileupload.transfer.client.mdesign.FilePreview")) : class$jfileupload$transfer$client$mdesign$FilePreview));
    public static final String SUBSAMPLESCALE = "subsample";
    public static final String FASTSCALE = "fast";
    public static final String DEFAULTSCALE = "default";
    public static final String AVERAGESCALE = "average";
    public static final String SMOOTHSCALE = "smooth";
    public static int DEFAULTWIDTH = 120;
    public static int DEFAULTHEIGHT = 120;
    public static int SAFEBORDER = 10;
    public static int LEFTBORDER = 5;
    protected ImageIcon thumbnail = null;
    protected File file = null;
    protected String previewScale = "subsample";
    protected int scaleLevel = -1;
    protected int previewWidth = DEFAULTWIDTH;
    protected int previewHeight = DEFAULTHEIGHT;
    protected boolean enabled = true;
    protected long maxsize = -1L;
    protected int imageWidth = -1;
    protected int imageHeight = -1;
    protected boolean forcergb = true;
    protected boolean disabledThumbnail = false;
    static /* synthetic */ Class class$jfileupload$transfer$client$mdesign$FilePreview;

    public ImagePreview() {
    }

    public ImagePreview(JFileChooser jFileChooser, Conf conf) {
        this.previewWidth = (int)conf.getLong(conf.getResource("filechooser.preview.image.width"));
        this.previewHeight = (int)conf.getLong(conf.getResource("filechooser.preview.image.height"));
        if (this.previewWidth <= 10) {
            this.previewWidth = DEFAULTWIDTH;
        }
        if (this.previewHeight <= 10) {
            this.previewHeight = DEFAULTHEIGHT;
        }
        this.setPreferredSize(new Dimension(this.previewWidth, this.previewHeight));
        this.setPreviewScale(conf.getResource("filechooser.preview.image.scale"));
        this.maxsize = conf.getLong(conf.getResource("filechooser.preview.image.maxsize"));
        String string = conf.getResource("filechooser.preview.image.forcergb");
        if (string != null && string.equalsIgnoreCase("false")) {
            this.forcergb = false;
        }
        if (jFileChooser != null) {
            jFileChooser.addPropertyChangeListener(this);
        }
        log.info((Object)("ImagePreview loaded - " + this.previewWidth + "x" + this.previewHeight + " - scaling=" + this.previewScale));
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setPreviewState(boolean bl) {
        this.enabled = bl;
        if (!this.enabled) {
            this.file = null;
            this.thumbnail = null;
            if (this.isShowing()) {
                this.repaint();
            }
        }
    }

    public boolean getPreviewState() {
        return this.enabled;
    }

    public void setPreviewScale(String string) {
        this.previewScale = string;
        if (this.previewScale == null) {
            this.previewScale = SUBSAMPLESCALE;
        }
        this.scaleLevel = this.previewScale.equalsIgnoreCase(FASTSCALE) ? 2 : (this.previewScale.equalsIgnoreCase(SMOOTHSCALE) ? 4 : (this.previewScale.equalsIgnoreCase(DEFAULTSCALE) ? 1 : (this.previewScale.equalsIgnoreCase(AVERAGESCALE) ? 16 : -1)));
    }

    public void setForceRGB(boolean bl) {
        this.forcergb = bl;
    }

    public boolean isDisabledThumbnail() {
        return this.disabledThumbnail;
    }

    public void setDisabledThumbnail(boolean bl) {
        this.disabledThumbnail = bl;
    }

    public String getPreviewScale() {
        return this.previewScale;
    }

    public void loadImage() {
        if (this.file == null || this.disabledThumbnail) {
            this.thumbnail = null;
            return;
        }
        if (this.maxsize > 0L && this.file.length() > this.maxsize) {
            this.thumbnail = null;
            return;
        }
        this.thumbnail = this.getThumbnail(this.file, this.previewWidth, this.previewHeight, this.scaleLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImageIcon getThumbnail(File file, int n, int n2, int n3) {
        ImageIcon imageIcon = null;
        if (n3 != -1) {
            ImageIcon imageIcon2 = new ImageIcon(file.getPath());
            if (imageIcon2 != null) {
                this.imageWidth = imageIcon2.getIconWidth();
                this.imageHeight = imageIcon2.getIconHeight();
                double d = this.getScale(imageIcon2.getIconWidth(), imageIcon2.getIconHeight(), n - SAFEBORDER, n2 - SAFEBORDER);
                if (d != 1.0) {
                    int n4 = (int)(d * (double)imageIcon2.getIconWidth());
                    int n5 = (int)(d * (double)imageIcon2.getIconHeight());
                    imageIcon = new ImageIcon(imageIcon2.getImage().getScaledInstance(n4, n5, n3));
                } else {
                    imageIcon = imageIcon2;
                }
            }
        } else {
            ImageInputStream imageInputStream = null;
            ImageReader imageReader = null;
            try {
                imageInputStream = ImageIO.createImageInputStream(file);
                if (imageInputStream != null) {
                    Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
                    if (!iterator.hasNext()) {
                        ImageIcon imageIcon3 = null;
                        return imageIcon3;
                    }
                    imageReader = iterator.next();
                    imageReader.setInput(imageInputStream);
                    ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
                    if (this.forcergb) {
                        ImageTypeSpecifier imageTypeSpecifier = null;
                        Iterator<ImageTypeSpecifier> iterator2 = imageReader.getImageTypes(0);
                        while (iterator2.hasNext()) {
                            ImageTypeSpecifier imageTypeSpecifier2 = iterator2.next();
                            ColorSpace colorSpace = imageTypeSpecifier2.getColorModel().getColorSpace();
                            if (imageTypeSpecifier == null && colorSpace.getType() == 6) break;
                            if (!colorSpace.isCS_sRGB()) continue;
                            imageTypeSpecifier = imageTypeSpecifier2;
                        }
                        if (imageTypeSpecifier != null) {
                            imageReadParam.setDestinationType(imageTypeSpecifier);
                        }
                    }
                    int n6 = imageReader.getWidth(0);
                    int n7 = imageReader.getHeight(0);
                    this.imageWidth = n6;
                    this.imageHeight = n7;
                    double d = this.getScale(n6, n7, n - SAFEBORDER, n2 - SAFEBORDER);
                    int n8 = Math.max(1, (int)Math.ceil(1.0 / d));
                    imageReadParam.setSourceSubsampling(n8, n8, 0, 0);
                    imageIcon = new ImageIcon(imageReader.read(0, imageReadParam));
                }
            }
            catch (IOException iOException) {
                log.debug((Object)"Unknown format", (Throwable)iOException);
            }
            finally {
                if (imageReader != null) {
                    imageReader.dispose();
                    imageReader = null;
                }
                try {
                    if (imageInputStream != null) {
                        imageInputStream.close();
                        imageInputStream = null;
                    }
                }
                catch (IOException iOException) {
                    log.debug((Object)"Cannot close image stream", (Throwable)iOException);
                }
            }
        }
        return imageIcon;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.enabled) {
            boolean bl = false;
            String string = propertyChangeEvent.getPropertyName();
            if ("directoryChanged".equals(string)) {
                this.file = null;
                bl = true;
            } else if ("SelectedFileChangedProperty".equals(string)) {
                this.file = (File)propertyChangeEvent.getNewValue();
                bl = true;
            }
            if (bl) {
                this.thumbnail = null;
                if (this.isShowing()) {
                    this.loadImage();
                    this.repaint();
                }
            }
        }
    }

    protected double getScale(int n, int n2, int n3, int n4) {
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        if (n > n3) {
            d = (double)n3 * 1.0 / (double)n * 1.0;
            int n5 = (int)((double)n2 * d);
            if (n5 > n4) {
                d2 = (double)n4 * 1.0 / (double)n2 * 1.0;
            }
        } else if (n2 > n4) {
            d2 = (double)n4 * 1.0 / (double)n2 * 1.0;
        }
        d3 = d < d2 ? d : d2;
        return d3;
    }

    protected void paintComponent(Graphics graphics) {
        if (this.thumbnail == null) {
            this.loadImage();
        }
        if (this.thumbnail != null) {
            int n = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
            int n2 = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
            if (n2 < 0) {
                n2 = 0;
            }
            if (n < LEFTBORDER) {
                n = LEFTBORDER;
            }
            this.thumbnail.paintIcon(this, graphics, n, n2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

