/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.transfer.client.mdesign;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import jfileupload.transfer.client.core.ClientException;
import jfileupload.transfer.client.core.CompressListener;
import jfileupload.transfer.client.core.FilterListener;
import jfileupload.transfer.client.core.ProtocolListener;
import jfileupload.transfer.client.core.SplitListener;
import jfileupload.transfer.client.core.TransferController;
import jfileupload.transfer.client.core.TransferListener;
import jfileupload.transfer.client.mdesign.ImageViewport;
import jfileupload.transfer.client.util.Conf;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InfoPanel
extends JPanel
implements TransferListener,
ProtocolListener,
SplitListener,
CompressListener,
FilterListener,
DropTargetListener,
KeyListener {
    private static final Log log = LogFactory.getLog((Class)(class$jfileupload$transfer$client$mdesign$InfoPanel == null ? (class$jfileupload$transfer$client$mdesign$InfoPanel = InfoPanel.class$("jfileupload.transfer.client.mdesign.InfoPanel")) : class$jfileupload$transfer$client$mdesign$InfoPanel));
    private JTextArea taskOutput = null;
    private TransferController controller = null;
    private Conf conf = null;
    private String splitinfo = null;
    private String zipinfo = null;
    private boolean protocolinfo = false;
    private long length = 0L;
    private int type = 1;
    private boolean lock = false;
    private String separator = null;
    protected Object preprocessingfilterid = null;
    protected long amount = -1L;
    static /* synthetic */ Class class$jfileupload$transfer$client$mdesign$InfoPanel;

    public InfoPanel(Conf conf) {
        super(new BorderLayout());
        Serializable serializable;
        Object object;
        Color color;
        Color color2;
        this.conf = conf;
        this.taskOutput = new JTextArea();
        this.splitinfo = this.conf.getResource("splitinfo");
        this.zipinfo = this.conf.getResource("zipinfo");
        this.separator = this.conf.getResource("taskoutput.separator");
        if (this.conf.getResource("taskoutput.linewrap") != null && this.conf.getResource("taskoutput.linewrap").equalsIgnoreCase("true")) {
            this.taskOutput.setLineWrap(true);
            this.taskOutput.setWrapStyleWord(true);
        }
        if (this.conf.getResource("taskoutput.protocol") != null && this.conf.getResource("taskoutput.protocol").equalsIgnoreCase("enabled")) {
            this.protocolinfo = true;
        }
        if ((color2 = this.conf.getColor(this.conf.getProperty("taskoutput.color.foreground"))) == null) {
            color2 = this.conf.getColor(this.conf.getResource("taskoutput.color.foreground"));
        }
        if ((color = this.conf.getColor(this.conf.getProperty("taskoutput.color.background"))) == null) {
            color = this.conf.getColor(this.conf.getResource("taskoutput.color.background"));
        }
        if (color2 != null) {
            this.taskOutput.setForeground(color2);
        }
        if (color != null) {
            this.taskOutput.setBackground(color);
        }
        this.taskOutput.setMargin(new Insets(5, 5, 5, 5));
        this.taskOutput.setEditable(false);
        this.taskOutput.setCursor(null);
        if (this.conf.getResource("taskoutput.usage") != null) {
            this.taskOutput.append(this.conf.getResource("taskoutput.usage") + Conf.CR);
            if (this.separator != null) {
                this.taskOutput.append(this.separator + Conf.CR);
            }
        }
        JScrollPane jScrollPane = new JScrollPane(this.taskOutput);
        String string = this.conf.getResource("taskoutput.scrollbar.vertical");
        if (string != null && string.equalsIgnoreCase("asneeded")) {
            jScrollPane.setVerticalScrollBarPolicy(20);
        } else {
            jScrollPane.setVerticalScrollBarPolicy(22);
        }
        String string2 = this.conf.getResource("taskoutput.image.background");
        if (string2 != null) {
            object = this.conf.loadIcon(string2);
            if (object != null) {
                log.debug((Object)("Background image : " + object + " width=" + ((ImageIcon)object).getIconWidth() + " height=" + ((ImageIcon)object).getIconHeight()));
                this.taskOutput.setOpaque(false);
                serializable = new ImageViewport((ImageIcon)object);
                ((JViewport)serializable).setView(this.taskOutput);
                jScrollPane.setViewport((JViewport)serializable);
            } else {
                log.info((Object)"Cannot load background image");
            }
        }
        this.add((Component)jScrollPane, "Center");
        object = this.conf.getResource("dnd");
        if (object != null && ((String)object).equalsIgnoreCase("disabled")) {
            log.info((Object)"DnD disabled");
        } else {
            serializable = new DropTarget(this.taskOutput, 1, this, true);
        }
        this.taskOutput.addKeyListener(this);
    }

    public void setController(TransferController transferController) {
        this.controller = transferController;
    }

    public JTextArea getTaskOutput() {
        return this.taskOutput;
    }

    public void updateCaretPosition() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.taskOutput.setCaretPosition(this.taskOutput.getDocument().getLength());
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    InfoPanel.this.taskOutput.setCaretPosition(InfoPanel.this.taskOutput.getDocument().getLength());
                }
            });
        }
    }

    public void appendText(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.taskOutput.append(string);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    InfoPanel.this.taskOutput.append(string);
                }
            });
        }
    }

    public void transferTriggered(List list, int n) {
        this.type = n;
        if (list != null) {
            this.amount = list.size();
            String string = this.conf.getResource("taskoutput.upload.triggered");
            if (string != null) {
                this.appendText(string + Conf.CR);
                this.updateCaretPosition();
            }
        }
    }

    public void transferDone(List list) {
        String string;
        this.lock = false;
        if (this.type == 1 && (string = this.conf.getResource("taskoutput.upload.done")) != null && list != null) {
            MessageFormat messageFormat = new MessageFormat(string);
            Object[] objectArray = new Object[]{new Integer(list.size())};
            string = messageFormat.format(objectArray);
            this.appendText(string + Conf.CR);
            if (this.separator != null) {
                this.appendText(this.separator + Conf.CR);
            }
            this.updateCaretPosition();
        }
    }

    public void transferStarted(Object object, long l) {
        if (this.type == 1) {
            this.lock = true;
            String string = this.conf.getResource("taskoutput.upload.info");
            String string2 = this.conf.getResource("taskoutput.upload.size");
            if (string != null && string2 != null) {
                if (object != null && object instanceof File) {
                    File file = (File)object;
                    MessageFormat messageFormat = new MessageFormat(string);
                    Object[] objectArray = new Object[]{file.getName()};
                    string = messageFormat.format(objectArray);
                    this.appendText(string + Conf.CR);
                    messageFormat = new MessageFormat(string2);
                    Object[] objectArray2 = new Object[]{new Long(l)};
                    string2 = messageFormat.format(objectArray2);
                    this.appendText(string2 + Conf.CR);
                }
                this.updateCaretPosition();
            }
            if (this.conf.getResource("taskoutput.upload.started") != null) {
                this.appendText(this.conf.getResource("taskoutput.upload.started"));
                this.updateCaretPosition();
            }
        }
    }

    public void dataRead(long l) {
    }

    public void transferCompleted(Object object, byte[] byArray) {
        if (this.type == 1 && this.conf.getResource("taskoutput.upload.completed") != null) {
            this.appendText(this.conf.getResource("taskoutput.upload.completed") + Conf.CR);
            if (this.separator != null) {
                this.appendText(this.separator + Conf.CR);
            }
            this.updateCaretPosition();
        }
    }

    public void transferCancelled() {
        if (this.type == 1) {
            this.lock = false;
            if (this.conf.getResource("taskoutput.upload.cancelled") != null) {
                this.appendText(this.conf.getResource("taskoutput.upload.cancelled") + Conf.CR);
                if (this.separator != null) {
                    this.appendText(this.separator + Conf.CR);
                }
                this.updateCaretPosition();
            }
        }
    }

    public void transferFailed(ClientException clientException) {
        if (this.type == 1) {
            this.lock = false;
            String string = this.conf.getErrorMessage(clientException);
            if (string != null) {
                this.appendText(string + Conf.CR);
                if (this.separator != null) {
                    this.appendText(this.separator + Conf.CR);
                }
                this.updateCaretPosition();
            }
        }
    }

    public void splitTriggered(Object object, long l, long l2, long l3, String string) {
        if (this.splitinfo == null || this.splitinfo.equalsIgnoreCase("enabled")) {
            String string2 = this.conf.getResource("taskoutput.split.info");
            String string3 = this.conf.getResource("taskoutput.split.size");
            if (string2 != null) {
                if (object != null && object instanceof File && string2 != null) {
                    File file = (File)object;
                    MessageFormat messageFormat = new MessageFormat(string2);
                    Object[] objectArray = new Object[]{file.getName()};
                    string2 = messageFormat.format(objectArray);
                    this.appendText(string2 + Conf.CR);
                    if (string3 != null) {
                        messageFormat = new MessageFormat(string3);
                        Object[] objectArray2 = new Object[]{new Long(l3), new Long(l2)};
                        string3 = messageFormat.format(objectArray2);
                        this.appendText(string3 + Conf.CR);
                    }
                }
                if (this.separator != null) {
                    this.appendText(this.separator + Conf.CR);
                }
                this.updateCaretPosition();
            }
        }
    }

    public void splitStarted(int n, long l) {
        String string;
        this.lock = true;
        if ((this.splitinfo == null || this.splitinfo.equalsIgnoreCase("enabled")) && (string = this.conf.getResource("taskoutput.split.chunk.started")) != null) {
            MessageFormat messageFormat = new MessageFormat(string);
            Object[] objectArray = new Object[]{new Integer(n)};
            string = messageFormat.format(objectArray);
            this.appendText(string);
        }
    }

    public void dataSplit(long l) {
    }

    public void splitCompleted(int n) {
        String string;
        this.lock = false;
        if ((this.splitinfo == null || this.splitinfo.equalsIgnoreCase("enabled")) && (string = this.conf.getResource("taskoutput.split.chunk.completed")) != null) {
            MessageFormat messageFormat = new MessageFormat(string);
            Object[] objectArray = new Object[]{new Integer(n)};
            string = messageFormat.format(objectArray);
            this.appendText(string + Conf.CR);
        }
    }

    public void splitFailed(int n, ClientException clientException) {
        String string;
        this.lock = false;
        if ((this.splitinfo == null || this.splitinfo.equalsIgnoreCase("enabled")) && (string = this.conf.getResource("taskoutput.split.chunk.failed")) != null) {
            MessageFormat messageFormat = new MessageFormat(string);
            Object[] objectArray = new Object[]{clientException.getMessage()};
            string = messageFormat.format(objectArray);
            this.appendText(string + Conf.CR);
        }
    }

    public void compressStarted(Object object, long l) {
        this.lock = true;
        if ((this.zipinfo == null || this.zipinfo.equalsIgnoreCase("enabled")) && object != null && object instanceof File) {
            File file = (File)object;
            this.length = l;
            String string = this.conf.getResource("taskoutput.compress.started");
            if (string != null) {
                MessageFormat messageFormat = new MessageFormat(string);
                Object[] objectArray = new Object[]{new String(file.getName())};
                string = messageFormat.format(objectArray);
                this.appendText(string);
            }
        }
    }

    public void dataCompressed(long l) {
    }

    public void compressCompleted(Object object, long l) {
        String string;
        this.lock = false;
        if ((this.zipinfo == null || this.zipinfo.equalsIgnoreCase("enabled")) && (string = this.conf.getResource("taskoutput.compress.completed")) != null) {
            MessageFormat messageFormat = new MessageFormat(string);
            Object[] objectArray = new Object[]{new Integer((int)Math.round(100.0 * (1.0 - (double)l * 1.0 / (double)this.length * 1.0)))};
            string = messageFormat.format(objectArray);
            this.appendText(string + Conf.CR);
        }
    }

    public void compressFailed(ClientException clientException) {
        String string;
        this.lock = false;
        if ((this.zipinfo == null || this.zipinfo.equalsIgnoreCase("enabled")) && (string = this.conf.getResource("taskoutput.compress.failed")) != null) {
            MessageFormat messageFormat = new MessageFormat(string);
            Object[] objectArray = new Object[]{clientException.getMessage()};
            string = messageFormat.format(objectArray);
            this.appendText(string + Conf.CR);
        }
    }

    public void compressCancelled() {
        this.lock = false;
    }

    public void filterStarting(Object object, String string, Object object2) {
        MessageFormat messageFormat;
        Object object3;
        this.lock = true;
        String string2 = this.conf.getResource("taskoutput.preprocessingfilter.starting");
        if (string2 != null && object != null && object instanceof List) {
            this.preprocessingfilterid = object2;
            if (this.controller != null && this.preprocessingfilterid == this.controller.getPreProcessingFilter()) {
                if (string == null) {
                    string = String.valueOf(this.amount);
                }
                object3 = new Object[]{string};
                messageFormat = new MessageFormat(string2);
                string2 = messageFormat.format(object3);
                this.appendText(string2);
            }
        }
        if ((object3 = this.conf.getResource("taskoutput.filter.starting")) != null && object != null && object instanceof File && object2 != this.controller.getPreProcessingFilter()) {
            messageFormat = new MessageFormat((String)object3);
            Object[] objectArray = new Object[]{((File)object).getName()};
            object3 = messageFormat.format(objectArray);
            this.appendText((String)object3 + Conf.CR);
        }
    }

    public void filterStarted(Object object, String string, Object object2) {
        Object object3;
        Object[] objectArray;
        String string2;
        this.lock = true;
        String string3 = this.conf.getResource("taskoutput.preprocessingfilter.started");
        if (string3 != null) {
            this.preprocessingfilterid = object2;
            if (this.controller != null && this.preprocessingfilterid == this.controller.getPreProcessingFilter()) {
                string2 = "";
                if (object != null && object instanceof File) {
                    string2 = ((File)object).getName();
                }
                objectArray = new Object[]{string, String.valueOf(this.amount), string2};
                object3 = new MessageFormat(string3);
                string3 = ((Format)object3).format(objectArray);
                this.appendText(string3);
            }
        }
        if ((string2 = this.conf.getResource("taskoutput.filter.started")) != null && object2 != this.controller.getPreProcessingFilter()) {
            objectArray = new MessageFormat(string2);
            object3 = new Object[]{string};
            string2 = objectArray.format(object3);
            this.appendText(string2);
        }
    }

    public void dataFiltered(long l) {
    }

    public void filterCompleted(Object object, String string) {
        String string2;
        this.lock = false;
        String string3 = this.conf.getResource("taskoutput.preprocessingfilter.completed");
        if (string3 != null) {
            if (this.controller != null && this.preprocessingfilterid == this.controller.getPreProcessingFilter()) {
                this.appendText(string3 + Conf.CR);
            }
            this.preprocessingfilterid = null;
        }
        if ((string2 = this.conf.getResource("taskoutput.filter.completed")) != null && !"preprocessing".equals(string)) {
            MessageFormat messageFormat = new MessageFormat(string2);
            Object[] objectArray = new Object[]{string};
            string2 = messageFormat.format(objectArray);
            this.appendText(string2 + Conf.CR);
        }
    }

    public void filterFailed(ClientException clientException) {
        MessageFormat messageFormat;
        Object object;
        this.lock = false;
        String string = clientException.getExtMessage();
        String string2 = this.conf.getResource("taskoutput.preprocessingfilter.failed");
        if (string2 != null) {
            if (this.preprocessingfilterid == this.controller.getPreProcessingFilter()) {
                object = new Object[]{clientException.getMessage()};
                messageFormat = new MessageFormat(string2);
                string2 = messageFormat.format(object);
                this.appendText(string2 + Conf.CR);
            }
            this.preprocessingfilterid = null;
        }
        if ((object = this.conf.getResource("taskoutput.filter.failed")) != null && !"preprocessing".equals(string)) {
            messageFormat = new MessageFormat((String)object);
            Object[] objectArray = new Object[]{clientException.getMessage()};
            object = messageFormat.format(objectArray);
            this.appendText((String)object + Conf.CR);
        }
    }

    public void requestSent(Object object) {
        if (this.protocolinfo && object != null && object instanceof String && this.conf.getResource("taskoutput.protocol.request") != null) {
            Object[] objectArray = new Object[]{object};
            this.displayProtocolInfo(MessageFormat.format(this.conf.getResource("taskoutput.protocol.request"), objectArray));
        }
    }

    public void responseReceived(Object object) {
        if (this.protocolinfo && object != null && object instanceof String) {
            Object[] objectArray = new Object[]{object};
            this.displayProtocolInfo(MessageFormat.format(this.conf.getResource("taskoutput.protocol.response"), objectArray));
        }
    }

    private void displayProtocolInfo(String string) {
        if (string.endsWith(Conf.CR)) {
            this.appendText(string);
        } else {
            this.appendText(string + Conf.CR);
        }
        this.updateCaretPosition();
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragOk(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragOk(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragOk(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        DataFlavor[] dataFlavorArray = dropTargetDropEvent.getCurrentDataFlavors();
        DataFlavor dataFlavor = null;
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (DataFlavor.javaFileListFlavor.equals(dataFlavorArray[i])) {
                dataFlavor = dataFlavorArray[i];
                break;
            }
            if (!DataFlavor.stringFlavor.equals(dataFlavorArray[i])) continue;
            dataFlavor = dataFlavorArray[i];
            break;
        }
        if (dataFlavor != null) {
            if ((dropTargetDropEvent.getSourceActions() & 1) == 0) {
                return;
            }
            dropTargetDropEvent.acceptDrop(1);
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                Object object = transferable.getTransferData(dataFlavor);
                this.processDrop(object);
            }
            catch (IOException iOException) {
                log.info((Object)"Drop error", (Throwable)iOException);
                dropTargetDropEvent.dropComplete(false);
                return;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                log.info((Object)"Drop error", (Throwable)unsupportedFlavorException);
                dropTargetDropEvent.dropComplete(false);
                return;
            }
            catch (Exception exception) {
                log.info((Object)"Drop error", (Throwable)exception);
                dropTargetDropEvent.dropComplete(false);
                return;
            }
            dropTargetDropEvent.dropComplete(true);
        }
    }

    protected boolean isDragOk(DropTargetDragEvent dropTargetDragEvent) {
        if (this.lock) {
            return false;
        }
        DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
        DataFlavor dataFlavor = null;
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (DataFlavor.javaFileListFlavor.equals(dataFlavorArray[i])) {
                dataFlavor = dataFlavorArray[i];
                break;
            }
            if (!DataFlavor.stringFlavor.equals(dataFlavorArray[i])) continue;
            dataFlavor = dataFlavorArray[i];
            break;
        }
        if (dataFlavor != null) {
            return (dropTargetDragEvent.getSourceActions() & 1) != 0;
        }
        return false;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 86 && (keyEvent.isControlDown() || keyEvent.isMetaDown()) && !this.lock) {
            this.paste();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void processDrop(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            if (list != null && list.size() > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    File file = (File)listIterator.next();
                    arrayList.add(file.getAbsolutePath());
                }
                this.controller.setSource(arrayList);
                this.controller.begin();
            }
        } else if (object instanceof String) {
            String string = (String)object;
            if (string.length() > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("line.separator"));
                while (stringTokenizer.hasMoreTokens()) {
                    Object object2;
                    String string2 = stringTokenizer.nextToken();
                    if (string2.startsWith("file://")) {
                        if ((string2 = string2.substring(7, string2.length())).endsWith("\r")) {
                            string2 = string2.substring(0, string2.length() - 1);
                        }
                        if ((object2 = (Object)string2.getBytes())[((Object)object2).length - 1] == false) {
                            string2 = string2.substring(0, string2.length() - 1);
                        }
                    }
                    if (string2.length() <= 0 || !((File)(object2 = new File(string2))).exists() || !((File)object2).canRead()) continue;
                    arrayList.add(((File)object2).getAbsolutePath());
                }
                if (arrayList.size() > 0) {
                    this.controller.setSource(arrayList);
                    this.controller.begin();
                }
            }
        } else {
            log.info((Object)"Unknown dropped objects");
        }
    }

    public void paste() {
        log.info((Object)"Paste from clipboard");
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable != null) {
            try {
                Object object = null;
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    object = transferable.getTransferData(DataFlavor.javaFileListFlavor);
                } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    object = transferable.getTransferData(DataFlavor.stringFlavor);
                }
                if (object != null) {
                    this.processDrop(object);
                } else {
                    log.info((Object)"Unsupported Flavor");
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                log.info((Object)"Paste error", (Throwable)unsupportedFlavorException);
            }
            catch (IOException iOException) {
                log.info((Object)"Paste error", (Throwable)iOException);
            }
        }
    }

    public boolean isLock() {
        return this.lock;
    }

    public void setLock(boolean bl) {
        this.lock = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

